/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : PrintSetDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/12
 *    Last                 : 2007/10/11
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"


#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_insert.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "culcfunc.h"
#include "MsgBox.h"
#include "sagcad.h"
#include "etc.h"
#include "global.h"
#define _PRINTSETDLG_
#include "PrintSetDlg.h"





/* -------------------------------------------------------------------
 * 印刷範囲 ボタン イベント
 */
void view_button_toggled(GtkWidget *widget, PRINTSET_DLG *printset_dlg)
{
	if (printset_dlg->toggle_frag == 0) {
		printset_dlg->toggle_frag = 1;
	}
	else { return; }

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);

	/* display_check */
	if (printset_dlg->display_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->display_check), FALSE);
	}
	/* drawing_check */
	if (printset_dlg->drawing_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->drawing_check), FALSE);
	}

	printset_dlg->toggle_frag = 0;
}





/* -------------------------------------------------------------------
 * 印刷範囲 ボタン イベント
 */
void orientation_button_toggled(GtkWidget *widget, PRINTSET_DLG *printset_dlg)
{
	if (printset_dlg->toggle_frag == 0) {
		printset_dlg->toggle_frag = 1;
	}
	else { return; }

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);

	/* display_check */
	if (printset_dlg->portrait_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->portrait_check), FALSE);
	}
	/* drawing_check */
	if (printset_dlg->landscape_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->landscape_check), FALSE);
	}

	printset_dlg->toggle_frag = 0;
}





/* -------------------------------------------------------------------
 * 用紙サイズ ボタン イベント
 */
void paper_button_toggled(GtkWidget *widget, PRINTSET_DLG *printset_dlg)
{

	if (printset_dlg->toggle_frag == 0) {
		printset_dlg->toggle_frag = 1;
	}
	else {
		return;
	}


//	g_print("paper_button_toggled\n");


	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);

	/* A4 */
	if (printset_dlg->A4_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->A4_check), FALSE);
	}

	/* A3 */
	if (printset_dlg->A3_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->A3_check), FALSE);
	}

	/* B5 */
	if (printset_dlg->B5_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->B5_check), FALSE);
	}

	/* B4 */
	if (printset_dlg->B4_check != widget) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->B4_check), FALSE);
	}

	if (printset_dlg->toggle_frag == 1) {
		printset_dlg->toggle_frag = 0;
	}

}





/* -------------------------------------------------------------------
 * Default に設定して終了
 */
void printset_dlg_default_set_pushed(GtkWidget *widget, PRINTSET_DLG *printset_dlg)
{
	printset_dlg->value = 2;
}



/* -------------------------------------------------------------------
 * CANCEL
 */
void printset_dlg_cancel_pushed(GtkWidget *widget, PRINTSET_DLG *printset_dlg)
{
	printset_dlg->value = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void printset_dlg_ok_pushed(GtkWidget *widget, PRINTSET_DLG *printset_dlg)
{
	char str[256];


	/* テキストエントリーから文字列を取得 */
	strcpy(str, gtk_entry_get_text(GTK_ENTRY(printset_dlg->up_scale_entry)));
	printset_dlg->up_scale = atof(str);

	strcpy(str, gtk_entry_get_text(GTK_ENTRY(printset_dlg->low_scale_entry)));
	printset_dlg->low_scale = atof(str);

	/* view */
	if (GTK_TOGGLE_BUTTON(printset_dlg->display_check)->active) {
		printset_dlg->view = DISPLAY_VIEW;
	}
	if (GTK_TOGGLE_BUTTON(printset_dlg->drawing_check)->active) {
		printset_dlg->view = DRAWING_VIEW;
	}

	/* Orientation */
	if (GTK_TOGGLE_BUTTON(printset_dlg->portrait_check)->active) {
		printset_dlg->orientation = PORTRAIT;
	}
	if (GTK_TOGGLE_BUTTON(printset_dlg->landscape_check)->active) {
		printset_dlg->orientation = LANDSCAPE;
	}

	/* Paper */
	if (GTK_TOGGLE_BUTTON(printset_dlg->A4_check)->active) {
		printset_dlg->paper = A4_PAPER;
	}
	if (GTK_TOGGLE_BUTTON(printset_dlg->A3_check)->active) {
		printset_dlg->paper = A3_PAPER;
	}
	if (GTK_TOGGLE_BUTTON(printset_dlg->B5_check)->active) {
		printset_dlg->paper = B5_PAPER;
	}
	if (GTK_TOGGLE_BUTTON(printset_dlg->B4_check)->active) {
		printset_dlg->paper = B4_PAPER;
	}

	printset_dlg->value = 1;
}



/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint printset_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, PRINTSET_DLG *printset_dlg)
{
//	g_print("sagcad.c : printset_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		printset_dlg_ok_pushed(widget, printset_dlg);
		gtk_main_quit();
	}
	return TRUE; 
}



/* -------------------------------------------------------------------
 * コピー【移動/複写】設定
 * 
 * 
 * printset_dlg->x_pitch && printset_dlg->x_pitch が 0 なら focus を
 * printset_dlg->x_pitch_entry にする
 * 
 * printset_dlg->x_pitch || printset_dlg->x_pitch が 0 以外なら focus を
 * printset_dlg->repeats_entry にする
 * 
 */
gint PrintSetDialog(PRINTSET_DLG *printset_dlg)
{
	char str[256];

//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *view_vbox;
//				GtkWidget *display_check;
//				GtkWidget *drawing_check;
			GtkWidget *scale_hbox;
				GtkWidget *label;
				GtkWidget *button;
//				GtkWidget *up_scale_entry;
				//GtkWidget *label;
//				GtkWidget *low_scale_entry;
			GtkWidget *paper_table;
				//GtkWidget *label;
//				GtkWidget *A4_check;
//				GtkWidget *A3_check;
//				GtkWidget *B5_check;
//				GtkWidget *B4_check;
				//GtkWidget *label;
//				GtkWidget *portrait_check;
//				GtkWidget *landscape_check;
			GtkWidget *separator;
			GtkWidget *action_hbox;
				GtkWidget *default_set_buttun;
				GtkWidget *cancel_buttun;
				GtkWidget *ok_buttun;


	printset_dlg->toggle_frag = 0;


	/* ダイアログ(printset_dlg->dialog)生成 */
	printset_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(printset_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(printset_dlg->dialog), _("Print Setting") );
	g_signal_connect( G_OBJECT(printset_dlg->dialog), "key_press_event",
						G_CALLBACK(printset_dlg_key_press_event), printset_dlg);



		/* パッキングボックス(main_vbox)を作成 */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(printset_dlg->dialog), main_vbox);
		gtk_container_set_border_width(GTK_CONTAINER(printset_dlg->dialog), 5);
		gtk_widget_show(main_vbox);

			/* パッキングボックス(view_vbox) を作成 */
			view_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), view_vbox, TRUE, TRUE, 0);
			gtk_widget_show(view_vbox);

				/* -----------------------------------------
				 * view_group 
				 */
				/* 画面 1 */
				printset_dlg->display_check = gtk_check_button_new_with_label( _("The range which is displayed in the screen") );
				gtk_box_pack_start( (GtkBox *)GTK_BOX(view_vbox), printset_dlg->display_check, TRUE, TRUE, 0);
				if (printset_dlg->view == 1) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->display_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->display_check), FALSE);
				}
				g_signal_connect (G_OBJECT(printset_dlg->display_check), 
									"toggled", 
									G_CALLBACK(view_button_toggled), 
									printset_dlg);
				gtk_widget_show(printset_dlg->display_check);

				/* 図面 0 */
				printset_dlg->drawing_check = gtk_check_button_new_with_label( _("Drawing Setting") );
				gtk_box_pack_start( (GtkBox *)GTK_BOX(view_vbox), printset_dlg->drawing_check, TRUE, TRUE, 0);
				if (printset_dlg->view == 0) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->drawing_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->drawing_check), FALSE);
				}
				g_signal_connect (G_OBJECT(printset_dlg->drawing_check), 
									"toggled", 
									G_CALLBACK(view_button_toggled), 
									printset_dlg);
				gtk_widget_show(printset_dlg->drawing_check);



			/* パッキングボックス(scale_hbox) を作成 */
			scale_hbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), scale_hbox, TRUE, TRUE, 0);
			gtk_widget_show(scale_hbox);

				label = gtk_label_new( _("Scale") );
//				gtk_widget_set_size_request(label, 100, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(scale_hbox), label, TRUE, TRUE, 0);
				gtk_widget_show(label);

				/* テキストエントリー生成 */
				printset_dlg->up_scale_entry = gtk_entry_new();
//				gtk_widget_set_size_request(printset_dlg->up_scale_entry, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(scale_hbox), printset_dlg->up_scale_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, printset_dlg->up_scale, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(printset_dlg->up_scale_entry), str);
				//g_signal_connect (G_OBJECT(entry), "activate", G_CALLBACK(entry_callback), NULL);
				gtk_widget_show(printset_dlg->up_scale_entry);

				label = gtk_label_new(" / ");
//				gtk_widget_set_size_request(label, 20, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(scale_hbox), label, TRUE, TRUE, 0);
				gtk_widget_show(label);

				/* テキストエントリー生成 */
				printset_dlg->low_scale_entry = gtk_entry_new();
//				gtk_widget_set_size_request(printset_dlg->low_scale_entry, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(scale_hbox), printset_dlg->low_scale_entry, TRUE, TRUE, 1);
				/* 初期値設定 */
				FloatOut_n(str, printset_dlg->low_scale, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(printset_dlg->low_scale_entry), str);
				//g_signal_connect (G_OBJECT(entry), "activate", G_CALLBACK(entry_callback), NULL);
				gtk_widget_show(printset_dlg->low_scale_entry);



			/* テーブルコンテナ作成 */
			paper_table = gtk_table_new(3, 3, TRUE);
			gtk_box_pack_start( GTK_BOX(main_vbox), paper_table, TRUE, TRUE, 0);
			gtk_widget_show(paper_table);

				/* -----------------------------------------
				 * paper_group 
				 */
				button = gtk_button_new_with_label( _("Paper Size") );
				//gtk_widget_set_size_request(label, 20, 20);
				gtk_table_attach_defaults(GTK_TABLE(paper_table), button, 0, 2, 0, 1);
				gtk_widget_show(button);


				/* A4 2048 */
				printset_dlg->A4_check = gtk_toggle_button_new_with_label("A4");
				gtk_table_attach_defaults(GTK_TABLE(paper_table), printset_dlg->A4_check, 0, 1, 1, 2);
				if (printset_dlg->paper == A4_PAPER) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->A4_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->A4_check), FALSE);
				}
				g_signal_connect (G_OBJECT(printset_dlg->A4_check), 
									"toggled", 
									G_CALLBACK(paper_button_toggled), 
									printset_dlg);
				gtk_widget_show(printset_dlg->A4_check);

				/* A3 1025 */
				printset_dlg->A3_check = gtk_toggle_button_new_with_label("A3");
				gtk_table_attach_defaults(GTK_TABLE(paper_table), printset_dlg->A3_check, 0, 1, 2, 3);
				if (printset_dlg->paper == A3_PAPER) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->A3_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->A3_check), FALSE);
				}
				g_signal_connect (G_OBJECT(printset_dlg->A3_check), 
									"toggled", 
									G_CALLBACK(paper_button_toggled), 
									printset_dlg);
				gtk_widget_show(printset_dlg->A3_check);

				/* B5 4098 */
				printset_dlg->B5_check = gtk_toggle_button_new_with_label("B5");
				gtk_table_attach_defaults(GTK_TABLE(paper_table), printset_dlg->B5_check, 1, 2, 1, 2);
				if (printset_dlg->paper == B5_PAPER) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->B5_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->B5_check), FALSE);
				}
				g_signal_connect (G_OBJECT(printset_dlg->B5_check), 
									"toggled", 
									G_CALLBACK(paper_button_toggled), 
									printset_dlg);
				gtk_widget_show(printset_dlg->B5_check);

				/* B4 2050 */
				printset_dlg->B4_check = gtk_toggle_button_new_with_label("B4");
				gtk_table_attach_defaults(GTK_TABLE(paper_table), printset_dlg->B4_check, 1, 2, 2, 3);
				if (printset_dlg->paper == B4_PAPER) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->B4_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->B4_check), FALSE);
				}
				g_signal_connect (G_OBJECT(printset_dlg->B4_check), 
									"toggled", 
									G_CALLBACK(paper_button_toggled), 
									printset_dlg);
				gtk_widget_show(printset_dlg->B4_check);



				/* -----------------------------------------
				 * orientation_group 
				 */
				button = gtk_button_new_with_label( _("Direction") );
				//gtk_widget_set_size_request(label, 20, 20);
				gtk_table_attach_defaults(GTK_TABLE(paper_table), button, 2, 3, 0, 1);
				gtk_widget_show(button);

				/* PORTRAIT 1 */
				printset_dlg->portrait_check = gtk_toggle_button_new_with_label( _("Portrait") );
				gtk_table_attach_defaults(GTK_TABLE(paper_table), printset_dlg->portrait_check, 2, 3, 1, 2);
				if (printset_dlg->orientation == PORTRAIT) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->portrait_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->portrait_check), FALSE);
				}
				g_signal_connect (G_OBJECT(printset_dlg->portrait_check), 
									"toggled", 
									G_CALLBACK(orientation_button_toggled), 
									printset_dlg);
				gtk_widget_show(printset_dlg->portrait_check);

				/* LANDSCAPE 0 */
				printset_dlg->landscape_check = gtk_toggle_button_new_with_label( _("Landscape") );
				gtk_table_attach_defaults(GTK_TABLE(paper_table), printset_dlg->landscape_check, 2, 3, 2, 3);
				if (printset_dlg->orientation == LANDSCAPE) {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->landscape_check), TRUE);
				}
				else {
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(printset_dlg->landscape_check), FALSE);
				}
				g_signal_connect (G_OBJECT(printset_dlg->landscape_check), 
									"toggled", 
									G_CALLBACK(orientation_button_toggled), 
									printset_dlg);
				gtk_widget_show(printset_dlg->landscape_check);



		/* セパレーター(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);



		/* パッキングボックス(action_hbox) */
		action_hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
		gtk_widget_show(action_hbox);

			/* -----------------------------------------------------
			 * パッキングボックス(action_hbox) に入れる
			 * ボタン(cancel_buttun & ok_buttun) を作成し
			 * 格納する
			 */




			/* Default Set ボタンの生成 */
			default_set_buttun = gtk_button_new_with_label( _("EnvSet Save & End") );
			gtk_widget_set_size_request(default_set_buttun, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), default_set_buttun, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(default_set_buttun), 
							   "clicked", G_CALLBACK(printset_dlg_ok_pushed), printset_dlg);
			g_signal_connect( G_OBJECT(default_set_buttun), 
							   "clicked", G_CALLBACK(printset_dlg_default_set_pushed), printset_dlg);
			g_signal_connect( G_OBJECT(default_set_buttun), 
							   "clicked", G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(default_set_buttun);

			/* CANCELボタンの生成 */
			cancel_buttun = gtk_button_new_with_label("CANCEL");
			gtk_widget_set_size_request(cancel_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
			g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(printset_dlg_cancel_pushed), printset_dlg);
			g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(cancel_buttun);

			/* OKボタンの生成 */
			ok_buttun = gtk_button_new_with_label("OK");
			gtk_widget_set_size_request(ok_buttun, 80, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(printset_dlg_ok_pushed), printset_dlg);
			g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
		//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
		//	  gtk_widget_grab_default(ok_buttun);
			gtk_widget_show(ok_buttun);





	/*  フォーカスを x_pitch_entry に設定 */
//	gtk_window_set_focus(GTK_WINDOW(printset_dlg->dialog), printset_dlg->x_pitch_entry);


	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(printset_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(printset_dlg->dialog), GTK_WINDOW(printset_dlg->parent));


	/* ダイアログを可視状態へ */
	gtk_widget_show(printset_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(printset_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : PrintSetDlg.c
 * ====================================================================
 */





