/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : OutsideProcess.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/05/25
 *    Last                 : 2007/10/15
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_insert.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "culcfunc.h"
#include "MsgBox.h"
#include "sagcad.h"
#include "global.h"
#include "etc.h"
#include "InputBox.h"
#include "Select.h"
#include "Mouse.h"
#include "Draw.h"
#include "Command.h"

#define _OUTSIDEPROCESS_
#include "OutsideProcess.h"





/* -------------------------------------------------------------------
 * outside_process
 * 
 * outside_process_on の状態で SELECT & RECT をうまく使う
 */
int os_process(void)
{
	FILE *stream;
	char str[256],path[256], tempfile[256];
	int Ret;

	/* outside_process がまだ実行されていないとき */
	if (outside_process_on == 0) {

		strcpy(str, TOOLDIR);
		strcat(str, "/");
//		strcat(str, "/NoName.ops");
		g_print("Tool path ---> [%s]\n", str);
		Ret = read_file_name_get(str);
		/* ファイルの選択をキャンセル */
		if (Ret == -1) {
			return 0;
		}

		strcpy(path, str);
		cutFileName(path);
		strcpy(outside_process.opsDir, path);
		chdir(path);
		
		strcpy(outside_process.opsFile, str);
		outside_process.now = 0;
		outside_process.index = 0;
		Ret = ops_read(&outside_process);
		if (Ret == 0) {
			g_print("ops Read Error !!\n");
			return 0;
		}


		/* osp_temp.txt があれば削除 */
		strcpy(tempfile, sagcad_user.ConfigPath);
		strcat(tempfile, "osp_temp.txt");
		if ((stream = fopen(tempfile, "r")) == NULL) {
			//g_print("osp_temp.txt がなかった\n");
		}
		else {
			fclose(stream);
			//g_print("osp_temp.txt があったから削除\n");
			sprintf(str, "rm %s", tempfile);
			system(str);
		}

		outside_process_on = 1;
		ops_next_go(&outside_process);

		return 1;
	}



	/* outside_process 実行中 */
	/* 
	 * SELECT,MANY の選択確定の合図
	 * 
	 * 
	 */
	else if (outside_process_on != 0 && outside_process.Work[outside_process.now].work == OPS_SELECT_MANY) {
		
		ops_select_output(&outside_process);
		return 1;
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ops File Read
 * 
 * 
 */
int ops_read(OUTSIDE_PROCESS *outside_process)
{
//#define OPS_READ
	char str[256], ret[256];
	FILE *stream;
	int debug = 0;


#ifdef OPS_READ
	debug = 1;
#endif


	/* ---------------------------------
	 * ファイルをオープン
	 */ 
	if ( (stream = fopen( outside_process->opsFile, "r" )) == NULL ){
		g_print ("ops File [%s] Not Open\n", outside_process->opsFile);
	}
	
	while(1){
		if (LineRead(stream, str) == 0) {
			fclose(stream);
			g_print ("ops FILE Data Error\n");
			return 0;
		}



		/* -------------------------------------------------
		 * COMMENT セクション
		 */
		if (str[0] == '#') {
			
		}


		/* -------------------------------------------------
		 * OPS_VERSION セクション
		 */
		else if (strstr(str, "OPS_VERSION") != NULL ) {
			/* Data check */
			if (split_word_num(str, ',') != 1) {
				g_print ("OPS_VERSION Format Error !\n");
				return 0;
			}

			LineDataSplit(str, ',', 2, ret);
			outside_process->version = atof(ret);
		}


		/* -------------------------------------------------
		 * MSGBAR セクション
		 */
		else if (strstr(str, "MSGBAR") != NULL ) {
			/* Data check */
			if (split_word_num(str, ',') != 1) {
				g_print ("MSGBAR Format Error !\n");
				return 0;
			}

			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_MSGBAR;

			LineDataSplit(str, ',', 2, ret);
			strcpy(outside_process->Work[outside_process->index].msg, ret);

			outside_process->Work[outside_process->index].sel_obj = 0;
			outside_process->Work[outside_process->index].Cut = 0;
			strcpy(outside_process->Work[outside_process->index].keyword, "");

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : MSGBAR = 1 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}
		}


		/* -------------------------------------------------
		 * MSGBOX セクション
		 */
		else if (strstr(str, "MSGBOX") != NULL ) {
			/* Data check */
			if (split_word_num(str, ',') != 1) {
				g_print ("MSGBOX Format Error !\n");
				return 0;
			}

			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_MSGBOX;

			LineDataSplit(str, ',', 2, ret);
			strcpy(outside_process->Work[outside_process->index].msg, ret);

			outside_process->Work[outside_process->index].sel_obj = 0;
			outside_process->Work[outside_process->index].Cut = 0;
			strcpy(outside_process->Work[outside_process->index].keyword, "");

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : MSGBOX = 2 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}
		}


		/* -------------------------------------------------
		 * INPUT セクション
		 */
		else if (strstr(str, "INPUT") != NULL ) {

			/* Data check */
			if (split_word_num(str, ',') != 2) {
				g_print ("INPUT Format Error !\n");
				return 0;
			}

			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_INPUT;

			LineDataSplit(str, ',', 2, ret);
			strcpy(outside_process->Work[outside_process->index].keyword, ret);

			LineDataSplit(str, ',', 3, ret);
			strcpy(outside_process->Work[outside_process->index].msg, ret);

			outside_process->Work[outside_process->index].sel_obj = 0;
			outside_process->Work[outside_process->index].Cut = 0;

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : INPUT = 4 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}

		}


		/* -------------------------------------------------
		 * SELECT_ONE セクション
		 */
		else if (strstr(str, "SELECT") != NULL && strstr(str, "ONE") != NULL) {
			/* Data check */
			if (split_word_num(str, ',') != 5) {
				g_print ("SELECT ONE Format Error !\n");
				return 0;
			}

			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_SELECT_ONE;

			LineDataSplit(str, ',', 3, ret);
			outside_process->Work[outside_process->index].sel_obj = atoi(ret);

			LineDataSplit(str, ',', 4, ret);
			strcpy(outside_process->Work[outside_process->index].keyword, ret);

			LineDataSplit(str, ',', 5, ret);
			strcpy(outside_process->Work[outside_process->index].msg, ret);

			LineDataSplit(str, ',', 6, ret);
			if (strstr(ret, "CUT") != NULL) {
				outside_process->Work[outside_process->index].Cut = 1;
			}
			else if (strstr(ret, "COPY") != NULL) {
				outside_process->Work[outside_process->index].Cut = 0;
			}
			else {
				outside_process->Work[outside_process->index].Cut = 0;
			}

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : SELECT_ONE = 8 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}
		}


		/* -------------------------------------------------
		 * SELECT_MANY セクション
		 */
		else if (strstr(str, "SELECT") != NULL && strstr(str, "MANY") != NULL) {
			/* Data check */
			if (split_word_num(str, ',') != 5) {
				g_print ("SELECT MANY Format Error !\n");
				return 0;
			}

			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_SELECT_MANY;

			LineDataSplit(str, ',', 3, ret);
			outside_process->Work[outside_process->index].sel_obj = atoi(ret);

			LineDataSplit(str, ',', 4, ret);
			strcpy(outside_process->Work[outside_process->index].keyword, ret);

			LineDataSplit(str, ',', 5, ret);
			strcpy(outside_process->Work[outside_process->index].msg, ret);

			LineDataSplit(str, ',', 6, ret);
			if (strstr(ret, "CUT") != NULL) {
				outside_process->Work[outside_process->index].Cut = 1;
			}
			else if (strstr(ret, "COPY") != NULL) {
				outside_process->Work[outside_process->index].Cut = 0;
			}
			else {
				outside_process->Work[outside_process->index].Cut = 0;
			}

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : SELECT_MANY = 16 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}
		}


		/* -------------------------------------------------
		 * OUT_FILE セクション
		 */
		else if (strstr(str, "OUT_FILE") != NULL ) {
			/* Data check */
			if (split_word_num(str, ',') != 1) {
				g_print ("OUT_FILE Format Error !\n");
				return 0;
			}

			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_OUT_FILE;

			LineDataSplit(str, ',', 2, ret);
			strcpy(outside_process->Work[outside_process->index].keyword, ret);

			strcpy(outside_process->Work[outside_process->index].msg, "");
			outside_process->Work[outside_process->index].sel_obj = 0;
			outside_process->Work[outside_process->index].Cut = 0;

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : OUT_FILE = 32 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}
		}


		/* -------------------------------------------------
		 * INP_FILE セクション
		 */
		else if (strstr(str, "INP_FILE") != NULL ) {
			/* Data check */
			if (split_word_num(str, ',') != 1) {
				g_print ("INP_FILE Format Error !\n");
				return 0;
			}

			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_INP_FILE;

			LineDataSplit(str, ',', 2, ret);
			strcpy(outside_process->Work[outside_process->index].keyword, ret);

			strcpy(outside_process->Work[outside_process->index].msg, "");
			outside_process->Work[outside_process->index].sel_obj = 0;
			outside_process->Work[outside_process->index].Cut = 0;

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : INP_FILE = 64 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}
		}


		/* -------------------------------------------------
		 * EXEC セクション
		 */
		else if (strstr(str, "EXEC") != NULL ) {
			/* Data check */
			if (split_word_num(str, ',') != 2) {
				g_print ("EXEC Format Error !\n");
				return 0;
			}

			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_EXEC;

			LineDataSplit(str, ',', 2, ret);
			strcpy(outside_process->Work[outside_process->index].keyword, ret);

			LineDataSplit(str, ',', 3, ret);
			strcpy(outside_process->Work[outside_process->index].msg, ret);

			outside_process->Work[outside_process->index].sel_obj = 0;
			outside_process->Work[outside_process->index].Cut = 0;

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : EXEC = 128 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}
		}


		/* -------------------------------------------------
		 * END セクション
		 */
		else if (strstr(str, "END") != NULL ) {
			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_END;

			strcpy(outside_process->Work[outside_process->index].msg, "");
			outside_process->Work[outside_process->index].sel_obj = 0;
			outside_process->Work[outside_process->index].Cut = 0;
			strcpy(outside_process->Work[outside_process->index].keyword, "");

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : END = 256 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}

			outside_process->now = 0;
			fclose(stream);
			return 1;
		}


		/* -------------------------------------------------
		 * LOOP セクション
		 */
		else if (strstr(str, "LOOP") != NULL ) {
			outside_process->index = outside_process->index + 1;
			outside_process->Work[outside_process->index].work = OPS_LOOP;

			/* sel_obj に戻る位置を指定 */
			LineDataSplit(str, ',', 2, ret);
			outside_process->Work[outside_process->index].sel_obj = atoi(ret);

			strcpy(outside_process->Work[outside_process->index].msg, "");
			outside_process->Work[outside_process->index].Cut = 0;
			strcpy(outside_process->Work[outside_process->index].keyword, "");

			if (debug > 0) {
				g_print ("%s\n", str);
				g_print ("  %d : END = 512 = [%d]   obj = [%d]   keyword -> [%s]   msg -> [%s]   cut = [%d]\n", 
						 outside_process->index, 
						 outside_process->Work[outside_process->index].work, 
						 outside_process->Work[outside_process->index].sel_obj, 
						 outside_process->Work[outside_process->index].keyword, 
						 outside_process->Work[outside_process->index].msg, 
						 outside_process->Work[outside_process->index].Cut);
			}

			outside_process->now = 0;
			fclose(stream);
			return 1;
		}
	}


	fclose(stream);
	return 0;
}





int ops_next_go(OUTSIDE_PROCESS *op)
{
	FILE *stream;
	char str[256], ret[256], tempfile[256];
	int Ret;
	


	op->now = op->now + 1;
	
	switch (op->Work[op->now].work) {

		/* メッセージをステータスバーで伝える */
		case OPS_MSGBAR:
			if (StatusMsg(op->Work[op->now].msg) == 0) {
				g_print ("MSGBAR error\n");
				SelectCancel(MainWindow);
				return 0;
			}
			ops_next_go(op);
			return 1;
			break;

		/* メッセージをダイアログボックスで伝える */
		case OPS_MSGBOX :
			MsgBox("Outside Process", op->Work[op->now].msg, "", NULL, NULL, "OK");
			ops_next_go(op);
			return 1;
			break;

		/* 数値入力ダイアログボックスによるデータ入力 */
		case OPS_INPUT :
			/* 数値入力ダイアログボックス表示 */
			strcpy(ret, "");
			Ret = InputBox("SagCAD Outside Process", op->Work[op->now].msg, op->Work[op->now].keyword, ret);
			if (Ret == -1) {
				g_print ("INPUT error\n");
				SelectCancel(MainWindow);
				return 0;
			}

			/* ファイルをオープン */ 
			strcpy(tempfile, sagcad_user.ConfigPath);
			strcat(tempfile, "osp_temp.txt");
			if ((stream = fopen(tempfile, "a")) == NULL) {
				g_print ( _("INPUT error : File [%s] could not opened.\n") , tempfile);
				SelectCancel(MainWindow);
				return 0;
			}

			sprintf(str, "INPUT,\"%s\",\"%s\"\n", op->Work[op->now].keyword, ret);
			fputs(str, stream);
			/* ファイルをクローズ */ 
			fclose(stream);
			ops_next_go(op);
			return 1;
			break;

		/*  */
		case OPS_SELECT_ONE :
			ReturnFunc = MouseRet_Select_ops;
			DcObj = outside_process.Work[outside_process.now].sel_obj;
			mode = 300;
			(*ReturnFunc)(drawing_area, 1, 0, 0);
			SelectChainFrag = 0;
			SelectColorFrag = 0;
			break;

		/*  */
		case OPS_SELECT_MANY :
			ReturnFunc = MouseRet_Select_ops;
			DcObj = outside_process.Work[outside_process.now].sel_obj;
			mode = 300;
			(*ReturnFunc)(drawing_area, 1, 0, 0);
			SelectChainFrag = 0;
			SelectColorFrag = 0;
			break;

		/* データを出力 (osp_temp.txt にためておいたファイルを指定ファイルに名変) */
		case OPS_OUT_FILE :
			ops_select_output_info(op);

			strcpy(tempfile, sagcad_user.ConfigPath);
			strcat(tempfile, "osp_temp.txt");

			sprintf(str, "mv %s %s", tempfile, op->Work[op->now].keyword);
			system(str);
			ops_next_go(op);
			return 1;
			break;

		/* データを取り込む */
		case OPS_INP_FILE :
			/* ファイルをオープン */
			sprintf(tempfile, "%s", op->Work[op->now].keyword);
//			strcpy(tempfile, op->Work[op->now].keyword);
			if ((stream = fopen(tempfile, "r")) == NULL) {
				g_print ( _("INPUT error : File [%s] could not opened.\n") , tempfile);
				SelectCancel(MainWindow);
				return 0;
			}

			Ret = ops_select_input(stream);

			/* ファイルをクローズ */ 
			fclose(stream);
			ops_next_go(op);
			return 1;
			break;

		/* 外部プログラムを起動する */
		case OPS_EXEC :
			/* shell */
			sprintf(str, "%s %s", op->Work[op->now].keyword, op->Work[op->now].msg);
			Ret = system(str);
			
			g_print ("Command : %s\n", str);

			ops_next_go(op);
			return 1;
			break;

		/* Outside Process を終了する */
		case OPS_END :
			Redraw();
			//MsgBox("SagCAD", "Outside Process", "処理が終了しました。", NULL, NULL, "OK");
			SelectCancel(MainWindow);
			StatusMsg( _(" [Outside Process] The processing ended.") );
			return 1;
			break;

		/* 最初から */
		case OPS_LOOP :
			Redraw();
			op->now = op->Work[op->now].sel_obj - 1;
			ops_next_go(op);
			return 1;
			break;
	}

	return 0;
}





int ops_select_output_info(OUTSIDE_PROCESS *op)
{
	FILE *stream;
	char tempfile[256], str[256], c = '\0';
	int i;


	/* 出力 */
	/* ファイルをオープン */ 
	strcpy(tempfile, sagcad_user.ConfigPath);
	strcat(tempfile, "osp_temp.txt");

	if ((stream = fopen(tempfile, "a")) == NULL) {
		g_print ( _("Outside Process error : Output File [%s] could not opened.\n") , tempfile);
		return 0;
	}

	/* NOW_LAYER */
	sprintf(str, "NOW_LAYER,%d\n", NowLayer);
	fputs(str, stream);

	/* NOW_COLOR */
	sprintf(str, "NOW_COLOR,%d\n", (int)NowColor);
	fputs(str, stream);

	/* NOW_STYLE */
	sprintf(str, "NOW_STYLE,%d\n", NowStyle);
	fputs(str, stream);

	/* LAYER_INFO */
	sprintf(str, "LAYER_INFO\n");
	fputs(str, stream);

	for (i = 0 ; i < 64 ; i++) {
		if (Layer[i].draw == 0)	c = '0';
		else if (Layer[i].draw == 1)	{
			if (NowLayer == i)	c = '5';
			else	c = '1';
		}
		str[i] = c;
	}
	str[64] = '\n';
	str[65] = '\0';
	fputs(str, stream );

	/* Layer 64 -> 127 */
	for (i = 64 ; i < 128 ; i++) {
		if (Layer[i].draw == 0) c = '0';
		else if (Layer[i].draw == 1) {
			if (NowLayer == i)	c = '5';
			else	c = '1';
		}
		str[i-64] = c;
	}
	str[64] = '\n';
	str[65] = '\0';
	fputs(str, stream );

	/* Layer 128 -> 191 */
	for (i = 128 ; i < 192 ; i++) {
		if (Layer[i].draw == 0)	c = '0';
		else if (Layer[i].draw == 1) {
			if (NowLayer == i)	c = '5';
			else	c = '1';
		}
		str[i-128] = c;
	}
	str[64] = '\n';
	str[65] = '\0';
	fputs(str, stream );

	/* Layer 192 -> 255 */
	for (i = 192 ; i < 256 ; i++) {
		if (Layer[i].draw == 0)	c = '0';
		else if (Layer[i].draw == 1) {
			if (NowLayer == i)	c = '5';
			else	c = '1';
		}
		str[i-192] = c;
	}
	str[64] = '\n';
	str[65] = '\0';
	fputs(str, stream );

	/* ファイルをクローズ */ 
	fclose(stream);

	return 1;
}





/* -------------------------------------------------------
 * 選択図形を出力する。
 * 
 * osp_temp.txt
 */
int ops_select_output(OUTSIDE_PROCESS *op)
{
	FILE *stream;
	char tempfile[256], str[256];
	SELECT_LIST *ps;


	/* 出力 */
	/* ファイルをオープン */ 
	strcpy(tempfile, sagcad_user.ConfigPath);
	strcat(tempfile, "osp_temp.txt");

	if ((stream = fopen(tempfile, "a")) == NULL) {
		g_print ( _("Outside Process error : Temp File [%s] could not opened.\n") , tempfile);
		SelectCancel(MainWindow);
		return 0;
	}

	/* START */
	sprintf(str, "START,\"%s\"\n", op->Work[op->now].keyword);
	fputs(str, stream);

	/* -----------------------------------------------------------------
	 * 選択図形
	 */
	if (select_list_info.head != NULL) {
		ps = select_list_info.head;
		while (ps != NULL) {
			ops_select_output_select(stream, ps->select);
			ps = ps->next;	/* ポインタを次のデータに移す */
		}
	}

	/* END */
	if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
		sprintf(str, "END,%f,%f\n", select_list_info.head->select->x, select_list_info.head->select->y);
	}
	else {
		sprintf(str, "END\n");
	}
	fputs(str, stream);

	/* ファイルをクローズ */ 
	fclose(stream);


	/* Cut なら削除 */
	/* SELECT_LIST をクリア */
	if (op->Work[op->now].Cut == 1) {
		SelectDelete(MainWindow);
	}


	/* 全リストを削除 */
	select_list_all_free();
	UpDate();

	mode = 0;
	ReturnFunc = MouseRet_Non;

	/* ops_next_go() */
	ops_next_go(op);

	return 0;
}





/* -------------------------------------------------------
 * 選択図形を出力する。
 * 
 * diagram_type
 *     CAD       : 2 or 4
 *     DIMENSION : 3
 *     POLYLINE  : 8
 *     ELLIPSE   : 16
 *     INSERT    : 32
 * 
 */
int ops_select_output_select(FILE *stream, SELECT *select)
{
	char str[256];
	VERTEX_LIST *pv;
	int i;


	/* 任意点 */
	if (select->index == 1) {
		/* ANY POINT (点) */
		sprintf(str, "POINT,%d,%d,%d,%f,%f\n", 
				NowLayer, 
				(int)NowColor, 
				NowStyle, 
				select->x, 
				select->y);
		fputs(str, stream);
	}


	/* CAD Data */
	else if (select->index == 2 || select->index == 4) {
		if (select->diagram_point.cad_point == NULL) {
			g_print("CAD Data is NULL !\n");
			return 0;
		}

		switch (select->diagram_point.cad_point->code) {
			/* POINT (点) */
			case 0:
				sprintf(str, "POINT,%d,%d,%d,%f,%f\n", 
						select->diagram_point.cad_point->layer, 
						(int)select->diagram_point.cad_point->color, 
						select->diagram_point.cad_point->style, 
						select->diagram_point.cad_point->sx, 
						select->diagram_point.cad_point->sy);
				fputs(str, stream);
				break;

			/* LINE (線) */
			case 1:
				sprintf(str, "LINE,%d,%d,%d,%f,%f,%f,%f\n", 
						select->diagram_point.cad_point->layer, 
						(int)select->diagram_point.cad_point->color, 
						select->diagram_point.cad_point->style, 
						select->diagram_point.cad_point->sx, 
						select->diagram_point.cad_point->sy, 
						select->diagram_point.cad_point->ex, 
						select->diagram_point.cad_point->ey);
				fputs(str, stream);
				break;

			/* ARC (円弧) */
			case 2:
				sprintf(str, "ARC,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f\n", 
						select->diagram_point.cad_point->layer, 
						(int)select->diagram_point.cad_point->color, 
						select->diagram_point.cad_point->style, 
						select->diagram_point.cad_point->cx, 
						select->diagram_point.cad_point->cy, 
						select->diagram_point.cad_point->r, 
						select->diagram_point.cad_point->sx, 
						select->diagram_point.cad_point->sy, 
						select->diagram_point.cad_point->ex, 
						select->diagram_point.cad_point->ey);
				fputs(str, stream);
				break;

			/* CIRCLE (円) */
			case 4:
				sprintf(str, "CIRCLE,%d,%d,%d,%f,%f,%f\n", 
						select->diagram_point.cad_point->layer, 
						(int)select->diagram_point.cad_point->color, 
						select->diagram_point.cad_point->style, 
						select->diagram_point.cad_point->cx, 
						select->diagram_point.cad_point->cy, 
						select->diagram_point.cad_point->r);
				fputs(str, stream);
				break;

		}
	}

	/* DIMENSION Data */
	else if (select->index == 3) {
		if (select->diagram_point.dimension_point == NULL) {
			g_print("Dimension Data is NULL !\n");
			return 0;
		}

		sprintf(str, "DIMENSION,%d,\"%s\",\"%s\",\"%s\",%d,%f,%f,%f,%f,%f,%d,%d,%d\n",
				select->diagram_point.dimension_point->Layer, 
				select->diagram_point.dimension_point->Text, 
				select->diagram_point.dimension_point->UpperText, 
				select->diagram_point.dimension_point->LowerText, 
				select->diagram_point.dimension_point->FontType, 
				select->diagram_point.dimension_point->FontHeight, 
				select->diagram_point.dimension_point->FontSpace, 
				select->diagram_point.dimension_point->Angle, 
				select->diagram_point.dimension_point->SearchPointX, 
				select->diagram_point.dimension_point->SearchPointY, 
				select->diagram_point.dimension_point->FitPointX, 
				select->diagram_point.dimension_point->FitPointY, 
				select->diagram_point.dimension_point->index);
		fputs(str, stream);

		if (select->diagram_point.dimension_point->index != 0 && select->diagram_point.dimension_point->AssistLine != NULL) {
			for ( i = 0 ; i < select->diagram_point.dimension_point->index ; i++ ) {
				sprintf (str, "  ASSISTLINE,%d,%f,%f,%f,%f,%f,%f,%f\n", 
						 select->diagram_point.dimension_point->AssistLine[i].defin, 
						 select->diagram_point.dimension_point->AssistLine[i].sx, 
						 select->diagram_point.dimension_point->AssistLine[i].sy, 
						 select->diagram_point.dimension_point->AssistLine[i].ex, 
						 select->diagram_point.dimension_point->AssistLine[i].ey, 
						 select->diagram_point.dimension_point->AssistLine[i].cx, 
						 select->diagram_point.dimension_point->AssistLine[i].cy, 
						 select->diagram_point.dimension_point->AssistLine[i].r);
				fputs(str, stream);
			}
		}
	}

	/* POLYLINE Data */
	else if (select->index == 8) {
		if (select->diagram_point.polyline_point == NULL) {
			g_print("PolyLine Data is NULL !\n");
			return 0;
		}
		sprintf(str, "POLYLINE,%d,%d,%d,%d,%d,%f,%d,%d\n", 
				select->diagram_point.ellipse_point->layer, 
				(int)select->diagram_point.polyline_point->color, 
				select->diagram_point.polyline_point->style, 
				select->diagram_point.polyline_point->code, 
				select->diagram_point.polyline_point->split, 
				select->diagram_point.polyline_point->pitch, 
				select->diagram_point.polyline_point->frag, 
				select->diagram_point.polyline_point->index);
		fputs(str, stream);

		pv = select->diagram_point.polyline_point->vertex_list_info.head;
		while (pv != NULL) {
			sprintf(str, "  VERTEX,%f,%f\n", pv->vertex->x, pv->vertex->y);
			fputs(str, stream);
			pv = pv->next;
		}
	}

	/* ELLIPSE Data */
	else if (select->index == 16) {
		if (select->diagram_point.ellipse_point == NULL) {
			g_print("ELLIPSE Data is NULL !\n");
			return 0;
		}

		sprintf(str, "ELLIPSE,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f\n", 
				select->diagram_point.ellipse_point->layer, 
				(int)select->diagram_point.ellipse_point->color, 
				select->diagram_point.ellipse_point->style, 
				select->diagram_point.ellipse_point->cx, 
				select->diagram_point.ellipse_point->cy, 
				select->diagram_point.ellipse_point->dx, 
				select->diagram_point.ellipse_point->dy, 
				select->diagram_point.ellipse_point->k, 
				select->diagram_point.ellipse_point->sa, 
				select->diagram_point.ellipse_point->ea);
		fputs(str, stream);
	}

	/* INSERT Data */
	else if (select->index == 32) {
		//
		return 0;
	}
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : OutsideProcess.c
 * ====================================================================
 */





int ops_select_input(FILE *stream)
{
	char str[256], ret[256];


//	g_print("ops_select_input() : in\n");

	/* 入力 */
	while(1){
		if (LineRead(stream, str) == 0) {
			fclose(stream);
			g_print("ops File Data Read Error\n");
			return 0;
		}

		/* -------------------------------------------------
		 * START セクション
		 */
		if (strstr(str, "START") != NULL && str[0] == 'S') {
			if ( opsStartSectionRead(stream) == 0 ) {
				fclose(stream);
				g_print("ops File Data Read Error (START SECTION)\n");
				return 0;
			}
		}

		/* -------------------------------------------------
		 * ERROR セクション
		 */
		if (strstr(str, "ERROR") != NULL && str[0] == 'E') {
			/* データ数をチェック */
			if (split_word_num(str, ',') != 1) {
				g_print ("[Input File] ERROR Format Error !\n");
				return 0;
			}
			LineDataSplit(str, ',', 2, ret);
			MsgBox("Outside Process", "ERROE", ret, NULL, NULL, "OK");
			
			return 0;
			break;
		}

		/* -------------------------------------------------
		 * EOF セクション
		 */
		if (strstr(str, "EOF") != NULL && str[0] == 'E') {
			return 1;
			break;
		}
	}

	return 0;
}





int opsStartSectionRead(FILE *stream)
{
	char str[256];
	int frag = 0;


//	g_print("opsStartSectionRead() : in\n");

	while(1) {
		if (LineRead(stream, str) == 0) return 0;

		/* END */
		if (strstr(str,"END") != NULL && str[0] == 'E') return 1;

		/* POINT */
		else if (strstr(str,"POINT") != NULL && str[0] == 'P') {
			if (frag == 0) {
				frag = 1;
				undo_index_plus();
			}
			ops_Point_read(str);
		}

		/* LINE */
		else if (strstr(str,"LINE") != NULL && str[0] == 'L') {
			if (frag == 0) {
				frag = 1;
				undo_index_plus();
			}
			ops_Line_read(str);
		}

		/* ARC */
		else if (strstr(str,"ARC") != NULL && str[0] == 'A') {
			if (frag == 0) {
				frag = 1;
				undo_index_plus();
			}
			ops_Arc_read(str);
		}

		/* CIRCLE */
		else if (strstr(str,"CIRCLE") != NULL && str[0] == 'C') {
			if (frag == 0) {
				frag = 1;
				undo_index_plus();
			}
			ops_Circle_read(str);
		}

		/* ELLIPSE */
		else if (strstr(str,"ELLIPSE") != NULL && str[0] == 'E') {
			if (frag == 0) {
				frag = 1;
				undo_index_plus();
			}
			ops_Ellipse_read(str);
		}

		/* DIMENSION */
		else if (strstr(str,"DIMENSION") != NULL && str[0] == 'D') {
			if (frag == 0) {
				frag = 1;
				undo_index_plus();
			}
			ops_Dimension_read(str, stream);
		}

		/* POLYLINE */
		else if (strstr(str,"POLYLINE") != NULL && str[0] == 'P') {
			if (frag == 0) {
				frag = 1;
				undo_index_plus();
			}
			ops_PolyLine_read(str, stream);
		}

	}

//	g_print("opsStartSectionRead() : out\n");
	return 0;
}


int ops_Point_read(char *str)
{
	char ret[255];
	CAD cad;


//	g_print("ops_select_input() : in\n");

	/* データ数をチェック */
	if (split_word_num(str, ',') != 5) {
		g_print ("OPS POINT Format Error !\n");
		return 0;
	}

	cad.code = 0;

	LineDataSplit(str, ',', 2, ret);
	cad.layer = atoi(ret);

	LineDataSplit(str, ',', 3, ret);
	cad.color = (long)atoi16(ret);

	LineDataSplit(str, ',', 4, ret);
	cad.style = atoi(ret);

	LineDataSplit(str, ',', 5, ret);
	cad.sx = atof(ret);
	LineDataSplit(str, ',', 6, ret);
	cad.sy = atof(ret);
	
	cad.ex = 0;
	cad.ey = 0;
	cad.cx = 0;
	cad.cy = 0;
	cad.r = 0;

	/* CAD Data をリストの最初に追加 */
	cad_list_add_first_with_undo(&cad, &cad_list_info);

	return 1;
}



int ops_Line_read(char *str)
{
	char ret[255];
	CAD cad;


	/* データ数をチェック */
	if (split_word_num(str, ',') != 7) {
		g_print ("OPS LINE Format Error !\n");
		return 0;
	}

	cad.code = 1;

	LineDataSplit(str, ',', 2, ret);
	cad.layer = atoi(ret);

	LineDataSplit(str, ',', 3, ret);
	cad.color = (long)atoi16(ret);

	LineDataSplit(str, ',', 4, ret);
	cad.style = atoi(ret);

	LineDataSplit(str, ',', 5, ret);
	cad.sx = atof(ret);
	LineDataSplit(str, ',', 6, ret);
	cad.sy = atof(ret);
	LineDataSplit(str, ',', 7, ret);
	cad.ex = atof(ret);
	LineDataSplit(str, ',', 8, ret);
	cad.ey = atof(ret);
	
	cad.cx = 0;
	cad.cy = 0;
	cad.r = 0;

	/* CAD Data をリストの最初に追加 */
	cad_list_add_first_with_undo(&cad, &cad_list_info);

	return 1;
}



int ops_Arc_read(char *str)
{
	char ret[255];
	CAD cad;


	/* データ数をチェック */
	if (split_word_num(str, ',') != 10) {
		g_print ("OPS ARC Format Error !\n");
		return 0;
	}

	cad.code = 2;

	LineDataSplit(str, ',', 2, ret);
	cad.layer = atoi(ret);

	LineDataSplit(str, ',', 3, ret);
	cad.color = (long)atoi16(ret);

	LineDataSplit(str, ',', 4, ret);
	cad.style = atoi(ret);

	LineDataSplit(str, ',', 5, ret);
	cad.cx = atof(ret);
	LineDataSplit(str, ',', 6, ret);
	cad.cy = atof(ret);
	LineDataSplit(str, ',', 7, ret);
	cad.r = atof(ret);

	LineDataSplit(str, ',', 8, ret);
	cad.sx = atof(ret);
	LineDataSplit(str, ',', 9, ret);
	cad.sy = atof(ret);
	LineDataSplit(str, ',', 10, ret);
	cad.ex = atof(ret);
	LineDataSplit(str, ',', 11, ret);
	cad.ey = atof(ret);

	/* CAD Data をリストの最初に追加 */
	cad_list_add_first_with_undo(&cad, &cad_list_info);

	return 1;
}



int ops_Circle_read(char *str)
{
	char ret[255];
	CAD cad;


	/* データ数をチェック */
	if (split_word_num(str, ',') != 6) {
		g_print ("OPS CIRCLE Format Error !\n");
		return 0;
	}

	cad.code = 4;

	LineDataSplit(str, ',', 2, ret);
	cad.layer = atoi(ret);

	LineDataSplit(str, ',', 3, ret);
	cad.color = (long)atoi16(ret);

	LineDataSplit(str, ',', 4, ret);
	cad.style = atoi(ret);

	LineDataSplit(str, ',', 5, ret);
	cad.cx = atof(ret);
	LineDataSplit(str, ',', 6, ret);
	cad.cy = atof(ret);
	LineDataSplit(str, ',', 7, ret);
	cad.r = atof(ret);

	cad.sx = 0;
	cad.sy = 0;
	cad.ex = 0;
	cad.ey = 0;

	/* CAD Data をリストの最初に追加 */
	cad_list_add_first_with_undo(&cad, &cad_list_info);

	return 1;
}



int ops_Ellipse_read(char *str)
{
	char ret[255];
	ELLIPSE ellipse;


	/* データ数をチェック */
	if (split_word_num(str, ',') != 10) {
		g_print ("OPS ELLIPSE Format Error !\n");
		return 0;
	}

	LineDataSplit(str, ',', 2, ret);
	ellipse.layer = atoi(ret);

	LineDataSplit(str, ',', 3, ret);
	ellipse.color = (long)atoi16(ret);

	LineDataSplit(str, ',', 4, ret);
	ellipse.style = atoi(ret);

	LineDataSplit(str, ',', 5, ret);
	ellipse.cx = atof(ret);
	LineDataSplit(str, ',', 6, ret);
	ellipse.cy = atof(ret);
	LineDataSplit(str, ',', 7, ret);
	ellipse.dx = atof(ret);
	LineDataSplit(str, ',', 8, ret);
	ellipse.dy = atof(ret);
	LineDataSplit(str, ',', 9, ret);
	ellipse.k  = atof(ret);
	LineDataSplit(str, ',', 10, ret);
	ellipse.sa = atof(ret);
	LineDataSplit(str, ',', 11, ret);
	ellipse.ea = atof(ret);
	
	if (sg(ellipse.sa, 3) == 0 && sg(ellipse.ea, 3) == 360) {
		ellipse.code = 0;
	}
	else ellipse.code = 1;

//	g_print ("Ellipse (%f,%f),(%f,%f),k[%f],sa[%f],ea[%f]\n", 
//			  ellipse.cx, ellipse.cy, 
//			  ellipse.dx, ellipse.dy, 
//			  ellipse.k, 
//			  ellipse.sa, ellipse.ea);


	/* ELLIPSE Data をリストの最初に追加 */
	ellipse_list_add_first_with_undo(&ellipse, &ellipse_list_info);

	return 1;
}



int ops_Dimension_read(char *str, FILE *stream)
{
	char ret[255];
	DIMENSION dimension;
	int i;


	/* データ数をチェック */
	if (split_word_num(str, ',') != 13) {
		g_print ("OPS DIMENSION Format Error !\n");
		return 0;
	}

	LineDataSplit(str, ',', 2, ret);
	dimension.Layer = atoi(ret);

	LineDataSplit(str, ',', 3, ret);
	strcpy(dimension.Text, ret);
	LineDataSplit(str, ',', 4, ret);
	strcpy(dimension.UpperText, ret);
	LineDataSplit(str, ',', 5, ret);
	strcpy(dimension.LowerText, ret);

	LineDataSplit(str, ',', 6, ret);
	dimension.FontType = atoi(ret);
	LineDataSplit(str, ',', 7, ret);
	dimension.FontHeight = atof(ret);
	LineDataSplit(str, ',', 8, ret);
	dimension.FontSpace = atof(ret);
	LineDataSplit(str, ',', 9, ret);
	dimension.Angle = atof(ret);
	LineDataSplit(str, ',', 10, ret);
	dimension.SearchPointX = atof(ret);
	LineDataSplit(str, ',', 11, ret);
	dimension.SearchPointY = atof(ret);
	LineDataSplit(str, ',', 12, ret);
	dimension.FitPointX = atoi(ret);
	LineDataSplit(str, ',', 13, ret);
	dimension.FitPointY = atoi(ret);
	LineDataSplit(str, ',', 14, ret);
	dimension.index = atoi(ret);

	if (dimension.index != 0) {

		/* データ (AssistLine) を書き込むための領域を確保する */
		dimension.AssistLine = (ASSISTANCE *)xmalloc(dimension.index * sizeof(ASSISTANCE));

		for (i = 0 ; i < dimension.index ; i++) {
			if (LineRead(stream, str) == 0) return 0;

			/* データ数をチェック */
			if (split_word_num(str, ',') != 8) {
				g_print ("OPS ASSISTLINE Format Error !\n");
				return 0;
			}

			LineDataSplit(str, ',', 1, ret);



			LineDataSplit(str, ',', 2, ret);
			dimension.AssistLine[i].defin = atoi(ret);

			LineDataSplit(str, ',', 3, ret);
			dimension.AssistLine[i].sx = atof(ret);

			LineDataSplit(str, ',', 4, ret);
			dimension.AssistLine[i].sy = atof(ret);

			LineDataSplit(str, ',', 5, ret);
			dimension.AssistLine[i].ex = atof(ret);

			LineDataSplit(str, ',', 6, ret);
			dimension.AssistLine[i].ey = atof(ret);

			LineDataSplit(str, ',', 7, ret);
			dimension.AssistLine[i].cx = atof(ret);

			LineDataSplit(str, ',', 8, ret);
			dimension.AssistLine[i].cy = atof(ret);

			LineDataSplit(str, ',', 9, ret);
			dimension.AssistLine[i].r	= atof(ret);
		}
	}

	/* DIMENSION Data をリストの最初に追加 */
	dimension_list_add_first_with_undo(&dimension, &dimension_list_info);

	return 1;
}



int ops_PolyLine_read(char *str, FILE *stream)
{
	char ret[255];
	POLYLINE polyline;
	VERTEX vertex;
	int i;


	/* データ数をチェック */
	if (split_word_num(str, ',') != 8) {
		g_print ("OPS DIMENSION Format Error !\n");
		return 0;
	}

	LineDataSplit(str, ',', 2, ret);
	polyline.layer = atoi(ret);

	LineDataSplit(str, ',', 3, ret);
	polyline.color = (long)atoi16(ret);

	LineDataSplit(str, ',', 4, ret);
	polyline.style = atoi(ret);

	LineDataSplit(str, ',', 5, ret);
	polyline.code = atoi(ret);

	LineDataSplit(str, ',', 6, ret);
	polyline.split = atoi(ret);

	LineDataSplit(str, ',', 7, ret);
	polyline.pitch = atof(ret);

	LineDataSplit(str, ',', 8, ret);
	polyline.frag = atoi(ret);

	LineDataSplit(str, ',', 9, ret);
	polyline.index = atoi(ret);

	polyline.vertex_list_info.head = NULL;
	polyline.vertex_list_info.tail = NULL;


	if (polyline.index != 0) {
		for (i = 0 ; i < polyline.index ; i++) {
			if (LineRead(stream, str) == 0) return 0;

			/* データ数をチェック */
			if (split_word_num(str, ',') != 8) {
				g_print ("OPS ASSISTLINE Format Error !\n");
				return 0;
			}

			LineDataSplit(str, ',', 1, ret);


			LineDataSplit(str, ',', 2, ret);
			vertex.x = atof(ret);

			LineDataSplit(str, ',', 3, ret);
			vertex.y = atof(ret);

			vertex_list_add_last(&vertex, &polyline.vertex_list_info);
		}
	}

	/* POLYLINE Data をリストの最初に追加 */
	polyline_list_add_first_with_undo(&polyline, &polyline_list_info);

	return 1;
}



