/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : NC_read.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2006 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2006/05/25
 * ====================================================================
 */
#ifndef __NC_READ_H__
#define __NC_READ_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */

#define NC_MAX 500

	// NC ǡ
	// ǡľ߸̡
	// Mode, GCode , SX , SY , EX , EY , CX , CY , R , SA , EA , IA
	struct NcDat {
		int Mode;
		int Gcode;
		double X;
		double Y;
		double CX;
		double CY;
		double R ;
		double I;
		double J;
		int Move;
	};



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _NC_READ_
#define   GLOBAL
/*  */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* ʬ̵ */
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL struct NcDat nc[NC_MAX];
	GLOBAL int NcData;
	GLOBAL char NcCode[NC_MAX][256];


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _NC_READ_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */

/* ǡɤ߹ */
int NcFileRead(void);
/* ǡ */
int NcMakeDraw(void);
/* 򥫥å */
int atension_cut(char *str);
/* ѥ᡼οͤ */
int ValueData(char *NcData, char *str);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __NC_READ_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : NC_read.h
 * ====================================================================
 */
