/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_cad.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2006 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2006/05/25
 * ====================================================================
 */
#ifndef __LIST_CAD_H__
#define __LIST_CAD_H__

//#include <>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef    _LIST_CAD_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL CAD_LIST *p_cad_list;
	GLOBAL CAD_LIST_INFO cad_list_info;

	GLOBAL CAD_LIST *StartData GLOBAL_VAL(0);


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef  _LIST_CAD_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int init_cad(CAD *cad);
CAD_LIST *r_cad_list_add_first(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data ꥹȤκǽɲ */
CAD_LIST *cad_list_add_first(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data ꥹȤκǽɲäơ Undo Baffer ˽ */
CAD_LIST *cad_list_add_first_with_undo(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);

/* CAD Data ꥹȤκǸɲ */
CAD_LIST *cad_list_add_last(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data ꥹȤκǸɲá Undo Baffer ˽ */
CAD_LIST *cad_list_add_last_with_undo(CAD *add_cad, CAD_LIST_INFO *p_cad_list_info);

/* CAD Data κǽ (κǤϤʤ) */
int cad_list_delete(CAD_LIST *del_List, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data κǽ (κǤϤʤUndo Buffer ذܤ) */
int cad_list_delete_Undo(CAD_LIST *del_List, CAD_LIST_INFO *p_cad_list_info);

/* CAD Data ѹ */
CAD_LIST *cad_list_edit(CAD_LIST *point, CAD *change_cad, CAD_LIST_INFO *p_cad_list_info);
/* CAD Data ѹ롢 Undo Baffer ˽ */
CAD_LIST *cad_list_edit_with_undo(CAD_LIST *point, CAD *change_cad, CAD_LIST_INFO *p_cad_list_info);

/* ꥹȤĴ٤ */
long cad_list_num(CAD_LIST_INFO *p_cad_list_info);
/* n ܤΥǡθ */
CAD_LIST *cad_search_num(long search_number, CAD_LIST_INFO *p_cad_list_info);
/* ǡθ(CAD *p_cad  CAD_LIST ) */
CAD_LIST *cad_search_cad(CAD *p_cad, CAD_LIST_INFO *p_cad_list_info);
/* ǡθ(CAD *p_cad  Data No.  long ͤ) */
long cad_search_cad_to_num(CAD *p_cad, CAD_LIST_INFO *p_cad_list_info);


/* CAD Data ꥹȤ */
int cad_list_free(CAD_LIST *del_List, CAD_LIST_INFO *p_cad_list_info);
/* ꥹȤ */
void cad_list_all_free(CAD_LIST_INFO *p_cad_list_info);

/* CAD ꥹȤɽ */
void cad_list_print(CAD_LIST_INFO *p_cad_list_info);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_CAD_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_cad.h
 * ====================================================================
 */
