/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_PolyLine.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2006 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/05
 *    Last                 : 2006/05/25
 * ====================================================================
 */

#ifndef __LIST_POLYLINE_H__
#define __LIST_POLYLINE_H__

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _LIST_POLYLINE_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL POLYLINE_LIST *p_polyline_list;
	GLOBAL POLYLINE_LIST_INFO polyline_list_info;

	GLOBAL POLYLINE_LIST *PolyLineStartData GLOBAL_VAL(0);


#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _LIST_POLYLINE_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int init_polyline(POLYLINE *polyline);
/*  */
POLYLINE_LIST *r_polyline_list_add_first(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data ꥹȤκǽɲ */
POLYLINE_LIST *polyline_list_add_first(POLYLINE *add_PolyLine, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data ꥹȤκǽɲäơ Undo Baffer ˽ */
POLYLINE_LIST *polyline_list_add_first_with_undo(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);

/* POLYLINE Data ꥹȤκǸɲ */
POLYLINE_LIST *polyline_list_add_last(POLYLINE *add_PolyLine, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data ꥹȤκǸɲá Undo Baffer ˽ */
POLYLINE_LIST *polyline_list_add_last_with_undo(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);

/* POLYLINE Data κǽ (κǤϤʤ) */
int polyline_list_delete(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data κǽ (κǤϤʤUndo Buffer ذܤ) */
int polyline_list_delete_Undo(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info);

/* POLYLINE Data ѹ */
POLYLINE_LIST *polyline_list_edit(POLYLINE_LIST *point, POLYLINE *change_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data ѹ롢 Undo Baffer ˽ */
POLYLINE_LIST *polyline_list_edit_with_undo(POLYLINE_LIST *point, POLYLINE *change_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);

/* ꥹȤĴ٤ */
long polyline_list_num(POLYLINE_LIST_INFO *p_polyline_list_info);
/* n ܤΥǡθ */
POLYLINE_LIST *polyline_search_num(long search_number, POLYLINE_LIST_INFO *p_polyline_list_info);
/* ǡθ(POLYLINE *p_PolyLine  POLYLINE_LIST ) */
POLYLINE_LIST *polyline_search_polyline(POLYLINE *p_PolyLine, POLYLINE_LIST_INFO *p_polyline_list_info);
/* ǡθ(POLYLINE *p_PolyLine  Data No.  long ͤ) */
long polyline_search_polyline_to_num(POLYLINE *p_PolyLine, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data ꥹȤ */
int polyline_list_free(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info);
/* ꥹȤ */
void polyline_list_all_free(POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE_LIST Υǡ log */
void polyline_list_log(POLYLINE_LIST_INFO *p_polyline_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_POLYLINE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2006 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_PolyLine.h
 * ====================================================================
 */
