/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Ellipse.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/22
 *    Last                 : 2007/10/24
 * ====================================================================
 */
#ifndef __ELLIPSE_H__
#define __ELLIPSE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

/* Ellipse.c を単体でテスト */
#ifdef MAIN_TEST
struct _SAG_POINT {
	double x;
	double y;
};
typedef struct _SAG_POINT SAG_POINT;



struct _ELLIPSE {
	int layer;
	long color;
	int style;

	double cx;		/* 中心Ｘ */
	double cy;		/* 中心Ｙ */
	double dx;		/* 長軸の位置Ｘ(中心からの相対位置) */
	double dy;		/* 長軸の位置Ｙ(中心からの相対位置) */
	double k;		/* 短軸の％ */
	double sa;		/* 開始角 */
	double ea;		/* 終了角 */
};
typedef struct _ELLIPSE ELLIPSE;
#endif






/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _ELLIPSE_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _ELLIPSE_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* a */
double get_ellipse_a(ELLIPSE ellipse);
/* b */
double get_ellipse_b(ELLIPSE ellipse);
/* 傾き */
double get_ellipse_angle(ELLIPSE ellipse);
/* 始点 終点 */
int get_ellipse_se_point(ELLIPSE ellipse, SAG_POINT *s_point, SAG_POINT *e_point);
/* 焦点 */
int get_ellipse_focus(ELLIPSE ellipse, SAG_POINT *focus1, SAG_POINT *focus2);

/* 点 (px, py) は、楕円上の点であるかの判定 */
int point_on_ellipse (ELLIPSE *ellipse, double px, double py);
/* 点が楕円の中にあるか外にあるかの判定 */
int point_in_ellipse (ELLIPSE *ellipse, double px, double py, double value);

/* 楕円と角度で楕円上の点を求める */
int get_ellipse_point_from_angle (ELLIPSE ellipse, double angle, SAG_POINT *point);
/* 楕円と点で楕円上の角度を求める */
double get_ellipse_angle_from_point (ELLIPSE ellipse, SAG_POINT point);


/* 点から楕円の接線 */
int pel(struct RtnDat *a, ELLIPSE ellipse);
/* 楕円と線の交点 */
int lep(struct RtnDat *rtn, ELLIPSE ellipse, int degits);

/* 楕円上の点(angle)での接線を求める */
int ellipse_tangent(struct RtnDat *rtn, ELLIPSE ellipse, double angle);

/* cc_check : ２円の位置関係を調べる */
int cc_check(struct RtnDat *rtn);

/* 楕円と楕円の交点 */
int ellipse_on_ellipse(struct RtnDat *rtn, ELLIPSE ellipseA, ELLIPSE ellipseB);
/* 楕円Ａと楕円Ｂの交点となる、楕円Ａの角度の範囲 */
int ellipse_on_ellipse_point(ELLIPSE ellipseA, ELLIPSE ellipseB, double *sa, double *ea, double angle_degits, double last_degits );


/* 楕円から楕円(円)の接線 */
int ellipse_to_ellipse(struct RtnDat *rtn, ELLIPSE ellipseA, ELLIPSE ellipseB);
int ellipse_to_ellipse_search (ELLIPSE ellipseA, ELLIPSE ellipseB, double *sp, double *ep, SAG_POINT *point, double angle_degits, double last_degits);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __ELLIPSE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Ellipse.h
 * ====================================================================
 */
