/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : DrawArea.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/07
 *    Last                 : 2007/10/24
 * ====================================================================
 */
#ifndef __DRAWAREA_H__
#define __DRAWAREA_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
#define PICTURE_WIDTH  600
#define PICTURE_HEIGHT 500

#define MOUSE_MOTION_NOTIFY   1
#define MOUSE_PRESS           2
#define MOUSE_RELEASE         4
#define MOUSE_WHEEL_UP         8
#define MOUSE_WHEEL_DOWN       16


/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _DRAWAREA_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _DRAWAREA_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int configure_event(GtkWidget *widget, GdkEventConfigure *event);
gint scroll_event(GtkWidget *widget, GdkEventScroll *event, gpointer data);
int expose_event(GtkWidget *widget, GdkEventExpose *event);
int motion_notify_event(GtkWidget *widget, GdkEventMotion *event);
int button_press_event(GtkWidget *widget, GdkEventButton *event);
//void draw_charactor(GtkWidget *widget, double x, double y);
GtkWidget *create_drawing_area(void);

gint Pan(GtkWidget *widget, gint event, gint Button, gint WithButton, gint x, gint y);
gint MouseEvent(GtkWidget *widget, GdkEvent *event, gint i_event, gint Button, gint WithButton, gint x, gint y);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DRAWAREA_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : DrawArea.h
 * ====================================================================
 */
