/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Dimension.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2007/10/14
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DRAW
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "List_font.h"
#include "global.h"
#include "culcfunc.h"
#include "Select.h"
#include "Draw.h"
#include "etc.h"
#include "MsgBox.h"

#include "Assistance.h"
#include "font.h"
#include "Select.h"
#define _DIMENSION_
#include "Dimension.h"





/* -------------------------------------------------------------------
 * 寸法描画 (HWND)
 *	
 * TextFrag 
 *		0:描かない				   1:描く				2:セレクトカラー
 *	   10:MouseMove のとき使用	  11:MouseMove のとき使用
 * draw() 以外から描画するときに使用
 * #define SCD_ORG		0
 * #define SCD_SELECT	1
 * #define SCD_HIDE		2
 * #define SCD_CAM		3
 */
int DimensionDraw(GtkWidget *widget, DIMENSION *a, int TextFrag)
{
	if (a == NULL) {
		MsgBox("SagCAD error", "DIMENSION Data is NULL !", "DimensionDraw error", NULL, NULL, "OK");
		return 0;
	}

	Dimension_Text_Basic(widget, a, TextFrag);
	Dimension_Line_Basic(widget, a, TextFrag);

	return 1;
}





/* -------------------------------------------------------------------
 * 寸法描画 線 (HDC)
 *	
 * TextFrag = 0:描かない	1:描く	  2:セレクトカラー
 *	
 */
int Dimension_Line_Basic(GtkWidget *widget, DIMENSION *a, int TextFrag)
{
	int i;
	long color = sagcad_color.Dimension;

//g_print("Dimension.c : Dimension_Line_Basic() : in\n");


	if (TextFrag == SCD_HIDE)
		color = sagcad_color.Back;
	else if (TextFrag == SCD_SELECT)
		color = sagcad_color.Select;


	/* サーチ点 */
	/* ディスプレイ */
	if (DrawObject == 0)
		SearchPointDraw(widget, a->SearchPointX, a->SearchPointY, color);

	if (a->index > 0 && a->AssistLine != NULL) {
		for (i = 0 ; i < a->index ; i++) {
			if (&a->AssistLine[i] == NULL) {
				g_print("AssistLine is null.\n");
				return 0;
			}
			
			switch (a->AssistLine[i].defin) {
				/* 点 */
				case 0:
					PointDraw(widget, a->AssistLine[i].sx, a->AssistLine[i].sy, 1, color);
					break;
				/* 線 */
				case 1:
					LineDraw(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
									a->AssistLine[i].ex, a->AssistLine[i].ey, 1, color);
					break;
				/* 円弧 */
				case 2:
					ArcDraw(widget,	a->AssistLine[i].cx, a->AssistLine[i].cy, a->AssistLine[i].r, 
									a->AssistLine[i].sx, a->AssistLine[i].sy, 
									a->AssistLine[i].ex, a->AssistLine[i].ey, 1, color);
					break;
				/* 円 */
				case 4:
					CircleDraw(widget, a->AssistLine[i].cx, a->AssistLine[i].cy, a->AssistLine[i].r, 1, color);
					break;
				/* 終点に矢印(線) */
				case 10:
					LineEndArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 0, a->DrawType, color);
					break;
				/* 終点に矢印(線) */
				case 11:
					LineEndArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 1, a->DrawType, color);
					break;
				/* 両端に矢印(線) */
				case 20:
					LineBothArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 0, a->DrawType, color);
					break;
				/* 両端に矢印(線) */
				case 21:
					LineBothArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 1, a->DrawType, color);
					break;
				/* 両端に逆矢印(線) */
				case 30:
					LineBothConverseArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
												a->AssistLine[i].ex, a->AssistLine[i].ey, 0, a->DrawType, color);
					break;
				/* 両端に逆矢印(線) */
				case 31:
					LineBothConverseArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
												a->AssistLine[i].ex, a->AssistLine[i].ey, 1, a->DrawType, color);
					break;
				/* 始点に矢印(円弧) */
	//			case 40:
				/* 終点に矢印(円弧) */
	//			case 50:
				/* 両端に矢印(円弧) */
				case 60:
					ArcBothArrow(widget,	a->AssistLine[i].cx, a->AssistLine[i].cy, a->AssistLine[i].r, 
										a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 0, a->DrawType, color);
					break;
				/* 両端に矢印(円弧) */
				case 61:
					ArcBothArrow(widget,	a->AssistLine[i].cx, a->AssistLine[i].cy, a->AssistLine[i].r, 
										a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 1, a->DrawType, color);
					break;
				/* 補助線 */
				case 70:
					AssistanceLine(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, a->DrawType, color);
					break;
				/* (矢印)補助線の延長 */
				case 80:
					LineEndExtension(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
											a->AssistLine[i].ex, a->AssistLine[i].ey, a->DrawType, color);
					break;
			}
		}
	}
	else if (a->index > 0 && a->AssistLine == NULL) {
		OneShotLog("寸法線で index > 0 なのに AssistLine が NULL です。\n");
	}

//g_print("Dimension.c : Dimension_Line_Basic() : out\n");

	return 1;
}





/* -------------------------------------------------------------------
 * 寸法描画 線 (HDC)
 *	
 * TextFrag = 0:描かない	1:描く	  2:セレクトカラー
 *	
 */
int Dimension_Text_Basic(GtkWidget *widget, DIMENSION *a, int TextFrag)
{
	long color = sagcad_color.Dimension;


//g_print("Dimension.c : Dimension_Text_Basic() : in\n");

	if (TextFrag == SCD_HIDE)
		color = sagcad_color.Back;
	else if (TextFrag == SCD_SELECT)
		color = sagcad_color.Select;


	DrawTextVector (widget,	a, color);

//g_print("Dimension.c : Dimension_Text_Basic() : out\n");

	return 1;
}





/* -------------------------------------------------------------------
 * 水平寸法 (計算)
 * -------------------------------------------------------------------
 *	
 * (X[1],Y[1]) , (X[2],Y[2]) , (X[3],Y[3]) から計算
 *	
 *	
 *	
 *				   (X[4],Y[4])				 (X[5],Y[5])
 *						   l		 (X[3],Y[3])		  l
 * (X[6],Y[6]) +---->+<----------------+--------------->+<----+(X[6],Y[6])
 *						   l								  l
 *						   l								  l
 *						   l								  l
 *						   l								  l
 *						   l								  l
 *						   l								  l
 *						   +								  +
 *				   (X[1],Y[1])				 (X[2],Y[2])
 *	
 *	
 *	
 * Save Data   (X[1],Y[1]) , (X[2],Y[2]) , (X[3],Y[3])
 * -------------------------------------------------------------------
 */
int Dimension_X_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	struct RtnDat PAPH;
	double X[4], Y[4];


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	/* マウスで読み取った座標を取り込む */
	X[1] = PicPoint.X[1];
	Y[1] = PicPoint.Y[1];
	X[2] = PicPoint.X[2];
	Y[2] = PicPoint.Y[2];
	a->SearchPointX = PicPoint.X[3];
	a->SearchPointY = PicPoint.Y[3];


	/* X[1] < X[2] にする。*/
	if (X[1] > X[2]) {
		Swap_double(&X[1], &X[2]);
		Swap_double(&Y[1], &Y[2]);
	}

	/* 寸法値を求めて a->Text に入れる */
	if (a->Text != '\0')
//		FloatOut(a->Text, sg(X[2] - X[1], sagcad_dimension.dimension_figure), 0);
		FloatOut_n(a->Text, X[2] - X[1], sagcad_dimension.dimension_figure, 0);





	/* a->SearchPointX が X[2] よりも大きいとき、寸法値は右側に来る。
	 * 寸法値の位置は、a->SearchPointX でいい。
	 * 矢印は外に開くので、寸法値の反対がわを矢印の長さだけ伸ばす。
	 */
	if (X[2] < a->SearchPointX) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* (矢印)補助線の延長 : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = X[1];
		a->AssistLine[2].ey = a->SearchPointY;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* 両端に逆矢印 : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = X[1];
		a->AssistLine[3].sy = a->SearchPointY;
		a->AssistLine[3].ex = X[2];
		a->AssistLine[3].ey = a->SearchPointY;
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->Angle = 0;
		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* a->SearchPointX が X[1] よりも小さいとき、寸法値は左側に来る。
	 * 寸法値の位置は、a->SearchPointX でいい。
	 * 矢印は外に開くので、寸法値の反対がわを矢印の長さだけ伸ばす。
	 * その座標が (X[6],Y[6])
	 */
	else if ( X[1] > a->SearchPointX) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* 線 : 1 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = X[2];
		a->AssistLine[2].ey = a->SearchPointY;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* 両端に逆矢印 : 32 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = X[1];
		a->AssistLine[3].sy = a->SearchPointY;
		a->AssistLine[3].ex = X[2];
		a->AssistLine[3].ey = a->SearchPointY;
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->Angle = 0;
		a->StartPoint = 0;
		a->FitPointX = 0;
		a->FitPointY = 1;
	}

	/* a->SearchPointX が X[1] と X[2] の間にあるとき、寸法値は真中に来る。
	 * 寸法値の位置は、a->SearchPointX を真中に計算して修正。
	 * (X[6],Y[6]) は使わない。
	 */
	else {
		if (a->AssistLine == NULL) {
			a->index = 3;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 3;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		PAPH.sx[1] = X[1];
		PAPH.sy[1] = a->SearchPointY;
		PAPH.ex[1] = X[2];
		PAPH.ey[1] = a->SearchPointY;
		PAPH.sx[2] = 1;
		PAPH.ex[2] = 1;
		ppp(&PAPH);

		/* 両端に矢印 : 16 */
		a->AssistLine[2].defin = 21;
		a->AssistLine[2].sx = X[1];
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = X[2];
		a->AssistLine[2].ey = a->SearchPointY;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;

		a->Angle = 0;
		a->SearchPointX = PAPH.sx[3];
		a->SearchPointY = PAPH.sy[3];
		a->StartPoint = 1;
		a->FitPointX = 1;
		a->FitPointY = 1;
	}


	/* -----------------------------------------------------
	 * 補助線 1 : 70 
	 */
	/* 点 (X[1],Y[1]) から垂直線を引く */
	/* PAP	始点と角度と距離で直線の終点を求める */
	PAPH.l = a->SearchPointY - Y[1];
	/* a->SearchPointY-Y[1] が正なら、90度 */
	if (PAPH.l >= 0) {
		PAPH.angle = 90;
	}
	/* a->SearchPointY-Y[1] が負なら、-90度で長さは正にする */
	else if ( PAPH.l < 0) {
		PAPH.angle = -90;
		PAPH.l = (-1 * PAPH.l);
	}
	/* 補助線 */
	PAPH.l = PAPH.l;
	PAPH.sx[1] = X[1];
	PAPH.sy[1] = Y[1];
	pap(&PAPH);

	a->AssistLine[0].defin = 70;
	a->AssistLine[0].sx = X[1];
	a->AssistLine[0].sy = Y[1];
	a->AssistLine[0].ex = PAPH.ex[1];
	a->AssistLine[0].ey = PAPH.ey[1];
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;


	/* -----------------------------------------------------
	 * 補助線 2 : 70 
	 */
	/* 点 (X[2],Y[2]) から垂直線を引く */
	PAPH.l = a->SearchPointY - Y[2];
	/* a->SearchPointY-Y[2] が正なら、90度 */
	if (PAPH.l >= 0) {
		PAPH.angle = 90;
	}
	/* a->SearchPointY-Y[2] が負なら、-90度で長さは正にする */
	else if ( PAPH.l < 0) {
		PAPH.angle = -90;
		PAPH.l = -1 * PAPH.l;
	}
	/* 補助線 */
	PAPH.l = PAPH.l;
	PAPH.sx[1] = X[2];
	PAPH.sy[1] = Y[2];
	pap(&PAPH);

	a->AssistLine[1].defin = 70;
	a->AssistLine[1].sx = X[2];
	a->AssistLine[1].sy = Y[2];
	a->AssistLine[1].ex = PAPH.ex[1];
	a->AssistLine[1].ey = PAPH.ey[1];
	a->AssistLine[1].cx = 0;
	a->AssistLine[1].cy = 0;
	a->AssistLine[1].r = 0;

	return 1;
}





/* -------------------------------------------------------------------
 * 垂直寸法 (計算)
 * -------------------------------------------------------------------
 *	
 * (X[1],Y[1]) , (X[2],Y[2]) , (X[3],Y[3]) から計算
 * Save Data   (X[1],Y[1]) , (X[2],Y[2]) , (X[3],Y[3])
 * -------------------------------------------------------------------
 */
int Dimension_Y_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	struct RtnDat PAPH;
	double X[4], Y[4];


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	/* マウスで読み取った座標を取り込む */
	X[1] = PicPoint.X[1];
	Y[1] = PicPoint.Y[1];
	X[2] = PicPoint.X[2];
	Y[2] = PicPoint.Y[2];
	a->SearchPointX = PicPoint.X[3];
	a->SearchPointY = PicPoint.Y[3];


	/* Y[1] < Y[2] にする。*/
	if (Y[1] > Y[2]) {
		Swap_double(&X[1], &X[2]);
		Swap_double(&Y[1], &Y[2]);
	}


	/* 寸法値を求めて a->Text に入れる */
	if (a->Text != '\0')
		FloatOut_n(a->Text, Y[2] - Y[1], sagcad_dimension.dimension_figure, 0);
//		FloatOut(a->Text, sg(Y[2] - Y[1], sagcad_dimension.dimension_figure), 0);





	/* a->SearchPointY が Y[2] よりも大きいとき、寸法値は下側に来る。
	 * 寸法値の位置は、a->SearchPointY でいい。
	 * 矢印は外に開くので、寸法値の反対がわを矢印の長さだけ伸ばす。
	 */
	if (Y[2] < a->SearchPointY) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* (矢印)補助線の延長 : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = a->SearchPointX;
		a->AssistLine[2].ey = Y[1];
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* 両端に逆矢印 : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = a->SearchPointX;
		a->AssistLine[3].sy = Y[2];
		a->AssistLine[3].ex = a->SearchPointX;
		a->AssistLine[3].ey = Y[1];
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->Angle = 90;
		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* a->SearchPointY が Y[1] よりも小さいとき、寸法値は上側に来る。
	 * 寸法値の位置は、a->SearchPointY でいい。
	 * 矢印は外に開くので、寸法値の反対がわを矢印の長さだけ伸ばす。
	 * その座標が (X[6],Y[6])
	 */
	else if ( Y[1] > a->SearchPointY) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* (矢印)補助線の延長 : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = a->SearchPointX;
		a->AssistLine[2].ey = Y[2];
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* 両端に逆矢印 : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = a->SearchPointX;
		a->AssistLine[3].sy = Y[1];
		a->AssistLine[3].ex = a->SearchPointX;
		a->AssistLine[3].ey = Y[2];
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->Angle = 90;
		a->StartPoint = 0;
		a->FitPointX = 0;
		a->FitPointY = 1;
	}

	/* a->SearchPointY が Y[1] と Y[2] の間にあるとき、寸法値は真中に来る。
	 * 寸法値の位置は、a->SearchPointY を真中に計算して修正。
	 * (X[6],Y[6]) は使わない。
	 */
	else {
		if (a->AssistLine == NULL) {
			a->index = 3;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 3;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		PAPH.sx[1] = a->SearchPointX;
		PAPH.sy[1] = Y[1];
		PAPH.ex[1] = a->SearchPointX;
		PAPH.ey[1] = Y[2];
		PAPH.sx[2] = 1;
		PAPH.ex[2] = 1;
		ppp(&PAPH);

		/* 両端に矢印 : 16 */
		a->AssistLine[2].defin = 21;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = Y[1];
		a->AssistLine[2].ex = a->SearchPointX;
		a->AssistLine[2].ey = Y[2];
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;

		a->Angle = 90;
		a->SearchPointX = PAPH.sx[3];
		a->SearchPointY = PAPH.sy[3];
		a->StartPoint = 1;
		a->FitPointX = 1;
		a->FitPointY = 1;
	}





	/* -----------------------------------------------------
	 * 補助線 1 : 70 
	 */
	/* 点 (X[1],Y[1]) から垂直線を引く*/
	PAPH.l = a->SearchPointX - X[1];
	/* a->SearchPointX-X[1] が正なら、0度 */
	if (PAPH.l >= 0) {
		PAPH.angle = 0;
	}
	/* a->SearchPointX-XY[1] が負なら、180度で長さは正にする */
	else if ( PAPH.l < 0) {
		PAPH.angle = 180;
		PAPH.l = (-1 * PAPH.l);
	}
	/* 引出線延長 */
	PAPH.l = PAPH.l;
	PAPH.sx[1] = X[1];
	PAPH.sy[1] = Y[1];
	pap(&PAPH);

	a->AssistLine[0].defin = 70;
	a->AssistLine[0].sx = X[1];
	a->AssistLine[0].sy = Y[1];
	a->AssistLine[0].ex = PAPH.ex[1];
	a->AssistLine[0].ey = PAPH.ey[1];
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;


	/* -----------------------------------------------------
	 * 補助線 2 : 70 
	 */
	/* 点 (X[2],Y[2]) から垂直線を引く。*/
	PAPH.l = a->SearchPointX - X[2];
	/* a->SearchPointX-X[2] が正なら、0度 */
	if (PAPH.l >= 0) {
		PAPH.angle = 0;
	}
	/* a->SearchPointX-X[2] が負なら、180度で長さは正にする */
	else if ( PAPH.l < 0) {
		PAPH.angle = 180;
		PAPH.l = (-1 * PAPH.l);
	}
	/* 引出線延長 */
	PAPH.l = PAPH.l;
	PAPH.sx[1] = X[2];
	PAPH.sy[1] = Y[2];
	pap(&PAPH);
	a->AssistLine[1].defin = 70;
	a->AssistLine[1].sx = X[2];
	a->AssistLine[1].sy = Y[2];
	a->AssistLine[1].ex = PAPH.ex[1];
	a->AssistLine[1].ey = PAPH.ey[1];
	a->AssistLine[1].cx = 0;
	a->AssistLine[1].cy = 0;
	a->AssistLine[1].r = 0;


	return 1;
}





/* -------------------------------------------------------------------
 * 距離寸法 (計算)
 *	
 *	
 */
int Dimension_P_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
//#define DIMENSION_P_CULC_TEST
#ifdef DIMENSION_P_CULC_TEST
	char str[256];
#endif

	struct RtnDat PPH, PLLH, LAH, PAPH, LLPH, PPPH;
	double P1X, P1Y, P2X, P2Y;
	double X[4], Y[4];


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	/* マウスで読み取った座標を取り込む */
	X[1] = PicPoint.X[1];
	Y[1] = PicPoint.Y[1];
	X[2] = PicPoint.X[2];
	Y[2] = PicPoint.Y[2];
	a->SearchPointX = PicPoint.X[3];
	a->SearchPointY = PicPoint.Y[3];

	/* X[1] < X[2] にする */
	if (X[1] > X[2]) {
		Swap_double(&X[1], &X[2]);
		Swap_double(&Y[1], &Y[2]);
	}
	else if (X[1] == X[2] && Y[1] > Y[2]) {
		Swap_double(&X[1], &X[2]);
		Swap_double(&Y[1], &Y[2]);
	}

	/* -------------------------------------------
	 * 点１と点２の距離を求めて、 寸法値 a->Text に入れる。
	 */
	PPH.sx[1] = X[1];
	PPH.sy[1] = Y[1];
	PPH.ex[1] = X[2];
	PPH.ey[1] = Y[2];
	pp(&PPH);

	/* 寸法値を求めて a->Text に入れる */
	if (a->Text != '\0')
		FloatOut_n(a->Text, PPH.l, sagcad_dimension.dimension_figure, 0);
//		FloatOut(a->Text, sg(PPH.l, sagcad_dimension.dimension_figure), 0);

	/* -------------------------------------------
	 * 点3 を通って、点1 から点2 までの線に平行な直線3 を求める
	 * (PLL	点を通り、直線に平行な直線)
	 */
	PLLH.sx[1] = a->SearchPointX;
	PLLH.sy[1] = a->SearchPointY;
	PLLH.sx[2] = X[1];
	PLLH.sy[2] = Y[1];
	PLLH.ex[2] = X[2];
	PLLH.ey[2] = Y[2];
	pll(&PLLH);


	/* -------------------------------------------
	 * 点１から点２までの線1,2の角度を求める。
	 * (LA	  直線の角度)
	 */
	LAH.sx[1] = X[1];
	LAH.sy[1] = Y[1];
	LAH.ex[1] = X[2];
	LAH.ey[1] = Y[2];
	la(&LAH);

	/* 寸法文字の角度 */
	a->Angle = (float) sg(LAH.angle, 3);





	/* 点 (P1X,P1Y)4 & (P2X,P2Y)5 を求める */

	/* (P1X,P1Y)4 */

	/* -------------------------------------------
	 * 点１から線１と直交する角度の線と、線３との交点１を求める
	 * (PAP	始点と角度と距離で直線の終点を求める)
	 */
	PAPH.sx[1] = X[1];
	PAPH.sy[1] = Y[1];
	PAPH.angle = LAH.angle + 90;
	PAPH.l = 50;
	pap(&PAPH);

	/* LLP	 ２直線の交点 */
	LLPH.sx[1] = X[1];
	LLPH.sy[1] = Y[1];
	LLPH.ex[1] = PAPH.ex[1];
	LLPH.ey[1] = PAPH.ey[1];
	LLPH.sx[2] = PLLH.sx[3];
	LLPH.sy[2] = PLLH.sy[3];
	LLPH.ex[2] = PLLH.ex[3];
	LLPH.ey[2] = PLLH.ey[3];
	llp(&LLPH);
	P1X = sg(LLPH.sx[3], 6);
	P1Y = sg(LLPH.sy[3], 6);

#ifdef DIMENSION_P_CULC_TEST
	sprintf(str, "Dimension_P_Culc 1 : LINE 1 (%f , %f)-(%f , %f)\n", LLPH.sx[1], LLPH.sy[1], LLPH.ex[1], LLPH.ey[1]);
	OneShotLog(str);
	sprintf(str, "Dimension_P_Culc 1 : LINE 2 (%f , %f)-(%f , %f)\n", LLPH.sx[2], LLPH.sy[2], LLPH.ex[2], LLPH.ey[2]);
	OneShotLog(str);
	sprintf(str, "Dimension_P_Culc 1 : CROSS POINT (%f , %f)\n", LLPH.sx[3], LLPH.sy[3]);
	OneShotLog(str);
#endif


	/* (P2X,P2Y)5 */

	/* -------------------------------------------
	 * 点２から線１と直交する角度の線と、線３との交点２を求める
	 * (PAP	始点と角度と距離で直線の終点を求める)
	 */
	PAPH.sx[1] = X[2];
	PAPH.sy[1] = Y[2];
	PAPH.angle = LAH.angle + 90;
	PAPH.l = 50;
	pap(&PAPH);

	/* LLP	 ２直線の交点 */
	LLPH.sx[1] = X[2];
	LLPH.sy[1] = Y[2];
	LLPH.ex[1] = PAPH.ex[1];
	LLPH.ey[1] = PAPH.ey[1];
	LLPH.sx[2] = PLLH.sx[3];
	LLPH.sy[2] = PLLH.sy[3];
	LLPH.ex[2] = PLLH.ex[3];
	LLPH.ey[2] = PLLH.ey[3];
	llp(&LLPH);
	P2X = sg(LLPH.sx[3], 6);
	P2Y = sg(LLPH.sy[3], 6);

#ifdef DIMENSION_P_CULC_TEST
	sprintf(str, "Dimension_P_Culc 2 : LINE 1 (%f , %f)-(%f , %f)\n", LLPH.sx[1], LLPH.sy[1], LLPH.ex[1], LLPH.ey[1]);
	OneShotLog(str);
	sprintf(str, "Dimension_P_Culc 2 : LINE 2 (%f , %f)-(%f , %f)\n", LLPH.sx[2], LLPH.sy[2], LLPH.ex[2], LLPH.ey[2]);
	OneShotLog(str);
	sprintf(str, "Dimension_P_Culc 2 : CROSS POINT (%f , %f)\n", LLPH.sx[3], LLPH.sy[3]);
	OneShotLog(str);
#endif





	/* 点 3 & 6 を求める */

	/* 寸法値が右側に来るとき */
	/* a->SearchPointX が X[5] よりも大きいとき、寸法値は右側に来る。
	 * 寸法値の位置は、a->SearchPointX でいい。
	 * 矢印は外に開くので、寸法値の反対がわを矢印の長さだけ伸ばす。
	 * その座標が (X[6],Y[6])
	 */
	if ((X[1] != X[2] && P2X < a->SearchPointX) || (X[1] == X[2] && P2Y < a->SearchPointY)) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* (矢印)補助線の延長 : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = P1X;
		a->AssistLine[2].ey = P1Y;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* 両端に逆矢印 : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = P1X;
		a->AssistLine[3].sy = P1Y;
		a->AssistLine[3].ex = P2X;
		a->AssistLine[3].ey = P2Y;
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* 寸法値が左側に来るとき */
	/* a->SearchPointX が X[4] よりも大きいとき、寸法値は左側に来る。
	 * 寸法値の位置は、a->SearchPointX でいい。
	 * 矢印は外に開くので、寸法値の反対がわを矢印の長さだけ伸ばす。
	 * その座標が (X[6],Y[6])
	 */
	else if ((X[1] != X[2] && P1X > a->SearchPointX) || (X[1] == X[2] && P1Y > a->SearchPointY)) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* (矢印)補助線の延長 : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = P2X;
		a->AssistLine[2].ey = P2Y;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* 両端に逆矢印 : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = P1X;
		a->AssistLine[3].sy = P1Y;
		a->AssistLine[3].ex = P2X;
		a->AssistLine[3].ey = P2Y;
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->StartPoint = 0;
		a->FitPointX = 0;
		a->FitPointY = 1;
	}


	/* 交点１と交点２の中点を (a->SearchPointX,a->SearchPointY) にする */
	else {
		if (a->AssistLine == NULL) {
			a->index = 3;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 3;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		PPPH.sx[1] = P1X;
		PPPH.sy[1] = P1Y;
		PPPH.ex[1] = P2X;
		PPPH.ey[1] = P2Y;
		PPPH.sx[2] = 1;
		PPPH.ex[2] = 1;
		ppp(&PPPH);

		a->SearchPointX = sg(PPPH.sx[3], 3);
		a->SearchPointY = sg(PPPH.sy[3], 3);


		/* 両端に矢印 : 16 */
		a->AssistLine[2].defin = 21;
		a->AssistLine[2].sx = P1X;
		a->AssistLine[2].sy = P1Y;
		a->AssistLine[2].ex = P2X;
		a->AssistLine[2].ey = P2Y;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;

		a->StartPoint = 1;
		a->FitPointX = 1;
		a->FitPointY = 1;
	}


	a->AssistLine[0].defin = 70;
	a->AssistLine[0].sx = X[1];
	a->AssistLine[0].sy = Y[1];
	a->AssistLine[0].ex = P1X;
	a->AssistLine[0].ey = P1Y;
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;

	a->AssistLine[1].defin = 70;
	a->AssistLine[1].sx = X[2];
	a->AssistLine[1].sy = Y[2];
	a->AssistLine[1].ex = P2X;
	a->AssistLine[1].ey = P2Y;
	a->AssistLine[1].cx = 0;
	a->AssistLine[1].cy = 0;
	a->AssistLine[1].r = 0;


	DimensionAngleCH(&a->Angle, &a->StartPoint);
	if (a->StartPoint > 9) {
		a->FitPointY = 4;
		a->FitPointX = a->StartPoint - 10;
	}
	else {
		a->FitPointX = a->StartPoint;
		a->FitPointY = 1;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 半径寸法 (計算)
 *	
 * CX,CY   円の中心点
 * a->SearchPointX,a->SearchPointY	 クリック点
 * R		   半径
 */
int Dimension_R_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	char str[256];
	struct RtnDat LAH, LCPH, PPH;
	double LL, CX, CY, R, SA, EA, ArrowPointX = 0, ArrowPointY = 0;

//MsgBox("TEST", "Dimension_R_Culc : in");

	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	/* マウスで読み取った座標を取り込む */
	CX = PicPoint.X[1];
	CY = PicPoint.Y[1];
	R = PicPoint.X[3];
	SA = PicPoint.X[4];
	EA = PicPoint.Y[4];
	a->SearchPointX = PicPoint.X[2];
	a->SearchPointY = PicPoint.Y[2];

//sprintf (str, "%f", R);
//MsgBox("Dimension_R_Culc", str);

	/* 寸法値を求めて a->Text に入れる */
	if (a->Text != '\0') {
//		FloatOut(str, R, 0);
		FloatOut_n(str, R * 1, sagcad_dimension.dimension_figure, 0);
		sprintf(a->Text, "R%s", str);
	}


	/* -------------------------------------------
	 * 円の中心からクリック点の線の角度がＳＡ＆ＥＡの範囲か調べる。
	 * LA	  直線の角度
	 */
	LAH.sx[1] = CX;
	LAH.sy[1] = CY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);
	
	if (SA < EA) {
		if (LAH.angle < SA || LAH.angle > EA) {
			a->index = 0;
			a->AssistLine = NULL;
			a->Angle = 0;
			strcpy(a->Text, "NOT DRAW");
			return 0;
		}
	}
	else if ( SA > EA) {
		if (LAH.angle < SA && LAH.angle > EA) {
			a->index = 0;
			a->AssistLine = NULL;
			a->Angle = 0;
			strcpy(a->Text, "NOT DRAW");
			return 0;
		}
	}
	a->Angle = (float) LAH.angle;

	/* ---------------------------------
	 * 見つけた円弧と、円弧の中心からクリック点までの線との交点を求める。
	 * LCP 直線と円の交点	 初めてのグラフィックス P126
	 */
	LCPH.sx[1] = CX;
	LCPH.sy[1] = CY;
	LCPH.ex[1] = a->SearchPointX;
	LCPH.ey[1] = a->SearchPointY;
	LCPH.cx[1] = CX;
	LCPH.cy[1] = CY;
	LCPH.r[1] = R;
	lcp(&LCPH);

	/* ---------------------------------
	 * クリック点と近い方の交点を求める。
	 * PP	  ２点間の距離
	 */
	PPH.sx[1] = a->SearchPointX;
	PPH.sy[1] = a->SearchPointY;
	PPH.ex[1] = LCPH.sx[2];
	PPH.ey[1] = LCPH.sy[2];
	pp(&PPH);
	LL = PPH.l;

	PPH.sx[1] = a->SearchPointX;
	PPH.sy[1] = a->SearchPointY;
	PPH.ex[1] = LCPH.sx[3];
	PPH.ey[1] = LCPH.sy[3];
	pp(&PPH);

	if (LL < PPH.l) {
		ArrowPointX = LCPH.sx[2];
		ArrowPointY = LCPH.sy[2];
	}
			
	if (LL > PPH.l) {
		ArrowPointX = LCPH.sx[3];
		ArrowPointY = LCPH.sy[3];
	}

	/* ---------------------------------
	 * 円の中心からクリック点の距離が半径より大きいか小さいか。
	 * PP	  ２点間の距離
	 */
	PPH.sx[1] = CX;
	PPH.sy[1] = CY;
	PPH.ex[1] = a->SearchPointX;
	PPH.ey[1] = a->SearchPointY;
	pp(&PPH);


	/* クリック点が円の中 */
	if (PPH.l < R) {
		if (a->AssistLine == NULL) {
			a->index = 1;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 1;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		a->AssistLine[0].defin = 11;
		a->AssistLine[0].sx = CX;
		a->AssistLine[0].sy = CY;
		a->AssistLine[0].ex = ArrowPointX;
		a->AssistLine[0].ey = ArrowPointY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

//		a->SearchPointX = CX;
//		a->SearchPointY = CY;
		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* クリック点が円の外 */
	if (PPH.l > R) {
		if (a->AssistLine == NULL) {
			a->index = 2;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 2;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		a->AssistLine[0].defin = 1;
		a->AssistLine[0].sx = CX;
		a->AssistLine[0].sy = CY;
		a->AssistLine[0].ex = a->SearchPointX;
		a->AssistLine[0].ey = a->SearchPointY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

		a->AssistLine[1].defin = 10;
		a->AssistLine[1].sx = a->SearchPointX;
		a->AssistLine[1].sy = a->SearchPointY;
		a->AssistLine[1].ex = ArrowPointX;
		a->AssistLine[1].ey = ArrowPointY;
		a->AssistLine[1].cx = 0;
		a->AssistLine[1].cy = 0;
		a->AssistLine[1].r = 0;

		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}
//MsgBox("TEST", "Dimension_R_Culc : out");
	DimensionAngleCH(&a->Angle, &a->StartPoint);
	if (a->StartPoint > 9) {
		a->FitPointY = 4;
		a->FitPointX = a->StartPoint - 10;
	}
	else {
		a->FitPointX = a->StartPoint;
		a->FitPointY = 1;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 直径寸法 (計算)
 *	
 */
int Dimension_D_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	char str[256];
	struct RtnDat LAH, LCPH, PPH;
	double LL, CX, CY, R, ArrowPointX_Pic = 0, ArrowPointY_Pic = 0, ArrowPointX = 0, ArrowPointY = 0;


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	CX = PicPoint.X[1];
	CY = PicPoint.Y[1];
	R = PicPoint.X[6];
	a->SearchPointX = PicPoint.X[2];
	a->SearchPointY = PicPoint.Y[2];


	/* 寸法値を求めて a->Text に入れる */
	if (a->Text != '\0') {
		FloatOut_n(str, R * 2, sagcad_dimension.dimension_figure, 0);
//		FloatOut(str, sg(R * 2, 3), 0);
		sprintf(a->Text, "φ%s", str);
	}


	/* 寸法値の角度 */
	/* LA	  直線の角度 */
	LAH.sx[1] = CX;
	LAH.sy[1] = CY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);
	a->Angle = (float) LAH.angle;


	/* 見つけた円と、円の中心からクリック点までの線との交点を求める。 */
	/* LCP 直線と円の交点	 初めてのグラフィックス P126 */
	LCPH.sx[1] = CX;
	LCPH.sy[1] = CY;
	LCPH.ex[1] = a->SearchPointX;
	LCPH.ey[1] = a->SearchPointY;
	LCPH.cx[1] = CX;
	LCPH.cy[1] = CY;
	LCPH.r[1] = R;
	lcp(&LCPH);


	/* クリック点と近い方の交点を(X[3],Y[3])求める。 */
	/* PP	  ２点間の距離 */
	/* 交点１ */
	PPH.sx[1] = a->SearchPointX;
	PPH.sy[1] = a->SearchPointY;
	PPH.ex[1] = LCPH.sx[2];
	PPH.ey[1] = LCPH.sy[2];
	pp(&PPH);
	LL = PPH.l;

	/* 交点２ */
	PPH.sx[1] = a->SearchPointX;
	PPH.sy[1] = a->SearchPointY;
	PPH.ex[1] = LCPH.sx[3];
	PPH.ey[1] = LCPH.sy[3];
	pp(&PPH);

	if (LL <= PPH.l) {
		ArrowPointX_Pic = LCPH.sx[2];
		ArrowPointY_Pic = LCPH.sy[2];
		ArrowPointX 	= LCPH.sx[3];
		ArrowPointY 	= LCPH.sy[3];
	}
	else if (LL > PPH.l) {
		ArrowPointX_Pic = LCPH.sx[3];
		ArrowPointY_Pic = LCPH.sy[3];
		ArrowPointX 	= LCPH.sx[2];
		ArrowPointY 	= LCPH.sy[2];
	}


	/* 円の中心からクリック点の距離が半径より大きいか小さいか。 */
	/* PP	  ２点間の距離 */
	PPH.sx[1] = CX;
	PPH.sy[1] = CY;
	PPH.ex[1] = a->SearchPointX;
	PPH.ey[1] = a->SearchPointY;
	pp(&PPH);

	/* クリック点が円の中 */
	if (PPH.l < R) {
		if (a->AssistLine == NULL) {
			a->index = 1;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 1;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* 両端に矢印(線) */
		a->AssistLine[0].defin = 21;
		a->AssistLine[0].sx = ArrowPointX_Pic;
		a->AssistLine[0].sy = ArrowPointY_Pic;
		a->AssistLine[0].ex = ArrowPointX;
		a->AssistLine[0].ey = ArrowPointY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* クリック点が円の外 */
	if (PPH.l > R) {
		if (a->AssistLine == NULL) {
			a->index = 2;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 2;
			/* データ (AssistLine) を書き込むための領域を確保する */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* 両端に矢印(線) */
		a->AssistLine[0].defin = 21;
		a->AssistLine[0].sx = ArrowPointX_Pic;
		a->AssistLine[0].sy = ArrowPointY_Pic;
		a->AssistLine[0].ex = ArrowPointX;
		a->AssistLine[0].ey = ArrowPointY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

		a->AssistLine[1].defin = 1;
		a->AssistLine[1].sx = ArrowPointX_Pic;
		a->AssistLine[1].sy = ArrowPointY_Pic;
		a->AssistLine[1].ex = a->SearchPointX;
		a->AssistLine[1].ey = a->SearchPointY;
		a->AssistLine[1].cx = 0;
		a->AssistLine[1].cy = 0;
		a->AssistLine[1].r = 0;

		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}
	DimensionAngleCH(&a->Angle, &a->StartPoint);
	if (a->StartPoint > 9) {
		a->FitPointY = 4;
		a->FitPointX = a->StartPoint - 10;
	}
	else {
		a->FitPointX = a->StartPoint;
		a->FitPointY = 1;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 角度寸法 (計算)
 *	
 *	
 * (X[1],Y[1])		中心
 * (X[2],Y[2])		点１
 * (X[3],Y[3])		点２
 * (X[4],Y[4])		クリック点
 */
int Dimension_A_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	struct RtnDat PPH, LAH, PAPH;
	double ctX, ctY, saX, saY, eaX, eaY, SA = 0, EA = 0, EX1, EY1, EX2, EY2;
	double DUMY, L, Ang1, Ang2, AngK;
	char str[256];


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	ctX = PicPoint.X[1];
	ctY = PicPoint.Y[1];
	saX = PicPoint.X[2];
	saY = PicPoint.Y[2];
	eaX = PicPoint.X[3];
	eaY = PicPoint.Y[3];
	a->SearchPointX = PicPoint.X[4];
	a->SearchPointY = PicPoint.Y[4];


	/* 中心とクリック点の距離 */
	/* PP	  ２点間の距離 */
	PPH.sx[1] = ctX;
	PPH.sy[1] = ctY;
	PPH.ex[1] = a->SearchPointX;
	PPH.ey[1] = a->SearchPointY;
	pp(&PPH);
	L = PPH.l;

	/* 中心点からクリック点の線の角度 AngK を求める。 */
	/* LA	  直線の角度 */
	LAH.sx[1] = ctX;
	LAH.sy[1] = ctY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);
	AngK = LAH.angle;

	/* 中心点から点１の線の角度 Ang1 を求める。 */
	/* LA	  直線の角度 */
	LAH.sx[1] = ctX;
	LAH.sy[1] = ctY;
	LAH.ex[1] = saX;
	LAH.ey[1] = saY;
	la(&LAH);
	Ang1 = LAH.angle;
	if (Ang1 > 360) Ang1 = Ang1 - 360;

	/* 中心点から点２の線の角度 Ang2 を求める。 */
	/* LA	  直線の角度 */
	LAH.sx[1] = ctX;
	LAH.sy[1] = ctY;
	LAH.ex[1] = eaX;
	LAH.ey[1] = eaY;
	la(&LAH);
	Ang2 = LAH.angle;
	if (Ang2 > 360) Ang2 = Ang2 - 360;


	/* Ang2 よりも Ang1 の方が大きい場合
	 * Ang2 の方が大きくなるようにデータをいれかえる
	 */
	if (Ang1 > Ang2) {
		Swap_double(&Ang1, &Ang2);
		Swap_double(&saX, &eaX);
		Swap_double(&saY, &eaY);
	}


	/* -----------------------------------------------------
	 * AngK が Ang1 よりも大きく、Ang2 よりも小さいとき
	 * 
	 * 点１が始点
	 */
	if (Ang1 < AngK && AngK < Ang2) {
		SA = Ang1;
		EA = Ang2;
		DUMY = Ang2 - Ang1;

		/* 寸法値を求めて a->Text に入れる */
		if (a->Text != '\0') {
			FloatOut_n(str, DUMY, sagcad_dimension.dimension_figure, 0);
//			FloatOut(str, sg(DUMY, sagcad_dimension.dimension_figure), 0);
			sprintf(a->Text, "%s°", str);
		}


		DUMY = Ang1 + (DUMY / 2);
		/* PAP	始点と角度と距離で直線の終点を求める */
		PAPH.sx[1] = ctX;
		PAPH.sy[1] = ctY;
		PAPH.angle = DUMY;
		PAPH.l = L;
		pap(&PAPH);
		a->SearchPointX = PAPH.ex[1];
		a->SearchPointY = PAPH.ey[1];
	}


	/* -----------------------------------------------------
	 * AngK が Ang2 よりも小さく、Ang1 よりも大きいとき
	 * 
	 * 点２が始点
	 */
	if (Ang2 < AngK || Ang1 > AngK) {
		SA = Ang2;
		EA = Ang1;
		DUMY = sg((360 - Ang2) + Ang1, 3);


		/* 寸法値を求めて a->Text に入れる */
		if (a->Text != '\0') {
			FloatOut_n(str, DUMY, sagcad_dimension.dimension_figure, 0);
//			FloatOut(str, sg(DUMY, sagcad_dimension.dimension_figure), 0);
			sprintf(a->Text, "%s°", str);
		}


		DUMY = Ang2 + (DUMY / 2);
		/* PAP	始点と角度と距離で直線の終点を求める */
		PAPH.sx[1] = ctX;
		PAPH.sy[1] = ctY;
		PAPH.angle = DUMY;
		PAPH.l = L;
		pap(&PAPH);
		a->SearchPointX = PAPH.ex[1];
		a->SearchPointY = PAPH.ey[1];
	}



	/* PAP	始点と角度と距離で直線の終点を求める */
	PAPH.sx[1] = ctX;
	PAPH.sy[1] = ctY;
	PAPH.angle = SA;
	PAPH.l = L;  /* + bow(a->DrawType); */
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = ctX;
	PAPH.sy[1] = ctY;
	PAPH.angle = EA;
	PAPH.l = L;  /* + bow(a->DrawType); */
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];


	/* LA	  直線の角度 */
	LAH.sx[1] = ctX;
	LAH.sy[1] = ctY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);

	a->Angle = (float) LAH.angle + 90;



	if (a->AssistLine == NULL) {
		a->index = 3;
		/* データ (AssistLine) を書き込むための領域を確保する */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}
	else {
		xfree(a->AssistLine);
		a->index = 3;
		/* データ (AssistLine) を書き込むための領域を確保する */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}

	/* 両端に矢印(線) */
	a->AssistLine[0].defin = 70;
	a->AssistLine[0].sx = ctX;
	a->AssistLine[0].sy = ctY;
	a->AssistLine[0].ex = EX1;
	a->AssistLine[0].ey = EY1;
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;

	a->AssistLine[1].defin = 70;
	a->AssistLine[1].sx = ctX;
	a->AssistLine[1].sy = ctY;
	a->AssistLine[1].ex = EX2;
	a->AssistLine[1].ey = EY2;
	a->AssistLine[1].cx = 0;
	a->AssistLine[1].cy = 0;
	a->AssistLine[1].r = 0;

	a->AssistLine[2].defin = 61;
	a->AssistLine[2].sx = EX1;
	a->AssistLine[2].sy = EY1;
	a->AssistLine[2].ex = EX2;
	a->AssistLine[2].ey = EY2;
	a->AssistLine[2].cx = ctX;
	a->AssistLine[2].cy = ctY;
	a->AssistLine[2].r	= L;

	a->StartPoint = 1;
	a->FitPointX = 1;
	a->FitPointY = 1;

	DimensionAngleCH(&a->Angle, &a->StartPoint);
	if (a->StartPoint > 9) {
		a->FitPointY = 4;
		a->FitPointX = a->StartPoint - 10;
	}
	else {
		a->FitPointX = a->StartPoint;
		a->FitPointY = 1;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 引出寸法 (計算)
 *	
 *	
 */
int Dimension_HD_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	struct RtnDat PAPH;
	double SX, SY, ESX, ESY, Width;


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	if (a->AssistLine == NULL) {
		a->index = 2;
		/* データ (AssistLine) を書き込むための領域を確保する */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}
	else {
		xfree(a->AssistLine);
		a->index = 2;
		/* データ (AssistLine) を書き込むための領域を確保する */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}





	if (PicPoint.X[3] == 0 && PicPoint.Y[3] == 0) {
		SX = PicPoint.X[1];
		SY = PicPoint.Y[1];
		a->SearchPointX = PicPoint.X[2];
		a->SearchPointY = PicPoint.Y[2];

//		if (a->FontType == 0)
//			Width = DrawTextTrue (NULL, a->Text, a->UpperText, a->LowerText, a->Type, a->FontHeight, a->FontSpace, a->Angle, a->DrawType, a->StartPoint, a->SearchPointX, a->SearchPointY, 0, 0);
//		else 
			Width = CulcTextVector (NULL, a);


		if (SX <= a->SearchPointX) {
			/* PAP	始点と角度と距離で直線の終点を求める */
			PAPH.sx[1] = a->SearchPointX;
			PAPH.sy[1] = a->SearchPointY;
			PAPH.angle = 0;
			PAPH.l = Width;
			pap(&PAPH);    // ( PAPH.ex[1] , PAPH.ey[1] )

			/* 終点に矢印 */
			a->AssistLine[0].defin = 11;
			a->AssistLine[0].sx = a->SearchPointX;
			a->AssistLine[0].sy = a->SearchPointY;
			a->AssistLine[0].ex = SX;
			a->AssistLine[0].ey = SY;
			a->AssistLine[0].cx = 0;
			a->AssistLine[0].cy = 0;
			a->AssistLine[0].r = 0;

			/* 寸法がのる線 */
			a->AssistLine[1].defin = 1;
			a->AssistLine[1].sx = a->SearchPointX;
			a->AssistLine[1].sy = a->SearchPointY;
			a->AssistLine[1].ex = PAPH.ex[1];
			a->AssistLine[1].ey = PAPH.ey[1];
			a->AssistLine[1].cx = 0;
			a->AssistLine[1].cy = 0;
			a->AssistLine[1].r = 0;

			a->Angle = 0;
			a->StartPoint = 2;
			a->FitPointX = 2;
			a->FitPointY = 1;
			a->SearchPointX = PAPH.ex[1];
			a->SearchPointY = PAPH.ey[1];

			return 1;
		}

		else if (SX > a->SearchPointX) {
			/* PAP	始点と角度と距離で直線の終点を求める */
			PAPH.sx[1] = a->SearchPointX;
			PAPH.sy[1] = a->SearchPointY;
			PAPH.angle = 180;
			PAPH.l = Width;
			pap(&PAPH);    // ( PAPH.ex[1] , PAPH.ey[1] )
			
			/* 終点に矢印 */
			a->AssistLine[0].defin = 11;
			a->AssistLine[0].sx = a->SearchPointX;
			a->AssistLine[0].sy = a->SearchPointY;
			a->AssistLine[0].ex = SX;
			a->AssistLine[0].ey = SY;
			a->AssistLine[0].cx = 0;
			a->AssistLine[0].cy = 0;
			a->AssistLine[0].r = 0;

			/* 寸法がのる線 */
			a->AssistLine[1].defin = 1;
			a->AssistLine[1].sx = a->SearchPointX;
			a->AssistLine[1].sy = a->SearchPointY;
			a->AssistLine[1].ex = PAPH.ex[1];
			a->AssistLine[1].ey = PAPH.ey[1];
			a->AssistLine[1].cx = 0;
			a->AssistLine[1].cy = 0;
			a->AssistLine[1].r = 0;

			a->Angle = 0;
			a->StartPoint = 0;
			a->FitPointX = 0;
			a->FitPointY = 1;
			a->SearchPointX = PAPH.ex[1];
			a->SearchPointY = PAPH.ey[1];

			return 1;
		}
	}





	else {
		SX = PicPoint.X[1];
		SY = PicPoint.Y[1];
		ESX = PicPoint.X[2];
		ESY = PicPoint.Y[2];
		a->SearchPointX = PicPoint.X[3];
		a->SearchPointY = PicPoint.Y[3];


		if (ESX <= a->SearchPointX) {
			a->StartPoint = 2;
			a->FitPointX = 2;
			a->FitPointY = 1;
		}
		else if (ESX > a->SearchPointX) {
			a->StartPoint = 0;
			a->FitPointX = 0;
			a->FitPointY = 1;
		}

		/* 終点に矢印 */
		a->AssistLine[0].defin = 11;
		a->AssistLine[0].sx = ESX;
		a->AssistLine[0].sy = ESY;
		a->AssistLine[0].ex = SX;
		a->AssistLine[0].ey = SY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

		/* 寸法がのる線 */
		a->AssistLine[1].defin = 1;
		a->AssistLine[1].sx = ESX;
		a->AssistLine[1].sy = ESY;
		a->AssistLine[1].ex = a->SearchPointX;
		a->AssistLine[1].ey = ESY;//a->SearchPointY;
		a->AssistLine[1].cx = 0;
		a->AssistLine[1].cy = 0;
		a->AssistLine[1].r = 0;

		a->SearchPointY = ESY;
		a->Angle = 0;
	}

	return 1;
}





/* -------------------------------------------------------------------
 * 座標寸法 (計算)
 *	
 */
int Dimension_PT_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	char strX[256], strY[256];
	struct RtnDat LAH;
	double PX, PY;


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	PX = PicPoint.X[1];
	PY = PicPoint.Y[1];
	a->SearchPointX = PicPoint.X[2];
	a->SearchPointY = PicPoint.Y[2];


	/* 寸法値を求めて a->Text に入れる */
	if (a->Text != '\0') {
		FloatOut_n(strX, PX, sagcad_dimension.dimension_figure, 0);
		FloatOut_n(strY, PY, sagcad_dimension.dimension_figure, 0);
//		FloatOut(strX, sg(PX, sagcad_dimension.dimension_figure), 0);
//		FloatOut(strY, sg(PY, sagcad_dimension.dimension_figure), 0);
		sprintf(a->Text, "(%s,%s)", strX, strY);
	}

	a->Angle = 0;


	LAH.sx[1] = PX;
	LAH.sy[1] = PY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);
	if ( (LAH.angle > 180) && (LAH.angle < 360) ) {
		a->StartPoint = 11;
		a->FitPointX = 1;
		a->FitPointY = 4;
	}
	else {
		a->StartPoint = 1;
		a->FitPointX = 1;
		a->FitPointY = 1;
	}


	if (a->AssistLine == NULL) {
		a->index = 1;
		/* データ (AssistLine) を書き込むための領域を確保する */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}
	else {
		xfree(a->AssistLine);
		a->index = 1;
		/* データ (AssistLine) を書き込むための領域を確保する */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}

	/* 終点に矢印(線) */
	a->AssistLine[0].defin = 11;
	a->AssistLine[0].sx = a->SearchPointX;
	a->AssistLine[0].sy = a->SearchPointY;
	a->AssistLine[0].ex = PX;
	a->AssistLine[0].ey = PY;
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;

	return 1;
}





/* -------------------------------------------------------------------
 * 寸法文字の角度を SagCAD のスタイルの角度に変換
 *	
 * 角度の限定  270 < Angle <= 360	0 =< Angle <= 90
 */
int DimensionAngleCH (float *angle, int *point)
{

	/* まず、角度を  0-360 の範囲内にする */
	while(*angle < 0) {
		*angle = *angle + 360;
	}
	while (*angle > 360) {
		*angle = *angle - 360;
	}


	/* 角度の限定  270 < Angle <= 360	0 =< Angle <= 90 */
	if (*angle > 90 && *angle <= 270) {
		*angle = *angle - 180;
		if (*point == 0) *point = 2;
		else if (*point == 2) *point = 0;
		else if (*point == 10) *point = 12;
		else if (*point == 12) *point = 10;
	}


	/* 最後にまた、角度を  0-360 の範囲内にする */
	while(*angle < 0) {
		*angle = *angle + 360;
	}
	while (*angle > 360) {
		*angle = *angle - 360;
	}

	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Dimension.c
 * ====================================================================
 */
