/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : DXF_read.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/12/24
 *    Last                 : 2007/10/24
 * ====================================================================
 */

#ifndef __DXF_READ_H__
#define __DXF_READ_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _DXF_READ_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL char DxfVersion[256];
	GLOBAL int DxfLayerIndex;


#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _DXF_READ_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int DxfFileOpen(char *OpenFileName, double x, double y);

/* ヘッダーセクション */
int header_section_read(FILE *stream);

/* クラスセクション */
int classes_section_read(FILE *stream);

/* テーブルセクション */
int tables_section_read(FILE *stream);
int table_read(FILE *stream);
int table_read_layer(FILE *stream);

/* ブロックセクション */
int blocks_section_read(FILE *stream);
int blocks_read(FILE *stream);

/* エンティティセクション */
int entities_section_read(FILE *stream, double x, double y);
/* エンティティ */
int entitie_read(FILE *stream, double x, double y);

int DxfPointRead(FILE *stream, CAD *cad);
int DxfLineRead(FILE *stream, CAD *cad);
int DxfArcRead(FILE *stream, CAD *cad);
int DxfCircleRead(FILE *stream, CAD *cad);
int DxfTextRead(FILE *stream, DIMENSION *dimension);
int DxfSplineRead(FILE *stream, POLYLINE *polyline);
int DxfPolyLineRead(FILE *stream, POLYLINE *polyline);
int DxfVertexRead(FILE *stream, VERTEX *vertex);
int DxfSolidRead(FILE *stream, POLYLINE *polyline);
int DxfEllipseRead(FILE *stream, ELLIPSE *ellipse);
int DxfInsertRead(FILE *stream, INSERT *insert);
int DxfEtcRead(FILE *stream);

/* オブジェクトセクション */
int objects_section_read(FILE *stream);

long DxfColorCh(long DxfColor);
int DxfStyleCh(char *Style);
int LayerCh(char *Lay);
void DXF_Info(void);

/* インサートデータを各要素に分解 */
int split_insert(INSERT *insert,  CAD_LIST_INFO *p_cad_list_info, 
				 DIMENSION_LIST_INFO *p_dimension_list_info, 
				 POLYLINE_LIST_INFO *p_polyline_list_info, 
				 ELLIPSE_LIST_INFO *p_ellipse_list_info, 
				 double x, 
				 double y
				 );

/* CAD_LIST_INFO_1 を CAD_LIST_INFO_2 にコピー */
int copy_cad_list_info(CAD_LIST_INFO *org_cad_list_info, CAD_LIST_INFO *cpy_cad_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DXF_READ_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : DXF_read.h
 * ====================================================================
 */
