/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CopyDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/19
 *    Last                 : 2007/10/14
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "culcfunc.h"
#define _COPYDLG_
#include "CopyDlg.h"





static gint copy_dlg_delete_event(GtkWidget *widget, GdkEventAny *event, gpointer data)
{
	return TRUE;
}

static gint copy_dlg_focus_out(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
#ifdef G_OS_WIN32
	gtk_window_present(GTK_WINDOW(widget));
#endif
	return FALSE;
}

/* -------------------------------------------------------------------
 * CANCEL
 */
void copy_dlg_cancel_pushed(GtkWidget *widget, COPY_DLG *copy_dlg)
{
	copy_dlg->x_pitch = 0;
	copy_dlg->y_pitch = 0;
	copy_dlg->repeats = 0;
	copy_dlg->value = -1;
}



/* -------------------------------------------------------------------
 * OK
 */
void copy_dlg_ok_pushed(GtkWidget *widget, COPY_DLG *copy_dlg)
{
	char str[256];


	/* テキストエントリーから文字列を取得 */
	if (copy_dlg->x_pitch_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(copy_dlg->x_pitch_entry)));
		copy_dlg->x_pitch = atof(str);
	}

	if (copy_dlg->y_pitch_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(copy_dlg->y_pitch_entry)));
		copy_dlg->y_pitch = atof(str);
	}

	if (copy_dlg->repeats_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(copy_dlg->repeats_entry)));
		copy_dlg->repeats = atoi(str);
	}
	copy_dlg->value = 0;
}



/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint copy_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, COPY_DLG *copy_dlg)
{
//	g_print("sagcad.c : copy_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		/* フォーカス x_pitch_entry で Enter ならフォーカスを y_pitch_entry に移す */
		if (GTK_WIDGET( copy_dlg->x_pitch_entry) == GTK_WINDOW(copy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(copy_dlg->dialog), copy_dlg->y_pitch_entry);
			gtk_editable_select_region(  GTK_EDITABLE(copy_dlg->y_pitch_entry), 0, 
									 GTK_ENTRY(copy_dlg->y_pitch_entry)->text_length);
		}
		/* フォーカス y_pitch_entry で Enter ならフォーカスを repeats_entry に移す */
		else if (GTK_WIDGET(copy_dlg->y_pitch_entry) == GTK_WINDOW(copy_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(copy_dlg->dialog), copy_dlg->repeats_entry);
			gtk_editable_select_region( GTK_EDITABLE(copy_dlg->repeats_entry), 0, 
									 GTK_ENTRY(copy_dlg->repeats_entry)->text_length);
		}
		/* フォーカス repeats_entry で Enter なら終わり */
		else if (GTK_WIDGET(copy_dlg->repeats_entry) == GTK_WINDOW(copy_dlg->dialog)->focus_widget) {
			copy_dlg_ok_pushed(widget, copy_dlg);
			gtk_main_quit();
		}
	}
	return FALSE; 
}



/* -------------------------------------------------------------------
 * コピー【移動/複写】設定
 * 
 * 
 * copy_dlg->x_pitch && copy_dlg->x_pitch が 0 なら focus を
 * copy_dlg->x_pitch_entry にする
 * 
 * copy_dlg->x_pitch || copy_dlg->x_pitch が 0 以外なら focus を
 * copy_dlg->repeats_entry にする
 * 
 */
gint CopyDialog(COPY_DLG *copy_dlg)
{
	char str[256];

//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *hbox;
				GtkWidget *label_vbox;
					GtkWidget *x_pitch_label;
					GtkWidget *y_pitch_label;
					GtkWidget *repeats_label;
				GtkWidget *entry_vbox;
//					GtkWidget *x_pitch_entry;
//					GtkWidget *y_pitch_entry;
//					GtkWidget *repeats_entry;
			GtkWidget *separator;
			GtkWidget *action_hbox;
				GtkWidget *cancel_buttun;
				GtkWidget *ok_buttun;


	/* ダイアログ(copy_dlg->dialog)生成 */
	copy_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(copy_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(copy_dlg->dialog), 
				_("Parallel [Move/Copy] Setting") );
	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(copy_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(copy_dlg->dialog), GTK_WINDOW(copy_dlg->parent));
		g_signal_connect(G_OBJECT(copy_dlg->dialog), "delete_event",
			 G_CALLBACK(copy_dlg_delete_event), NULL);
		g_signal_connect( G_OBJECT(copy_dlg->dialog), "key_press_event",
				G_CALLBACK(copy_dlg_key_press_event), copy_dlg);
		g_signal_connect(G_OBJECT(copy_dlg->dialog), "focus_out_event",
				 G_CALLBACK(copy_dlg_focus_out), NULL);



		/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(copy_dlg->dialog), main_vbox);
		gtk_container_set_border_width(GTK_CONTAINER(copy_dlg->dialog), 5);
		gtk_widget_show(main_vbox);

		/* -----------------------------------------------------
		 * パッキングボックス(main_vbox) に入れる
		 * パッキングボックス(hbox & action_hbox) を作成し
		 * 格納する
		 */
		/* パッキングボックス(hbox) */
		hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
							hbox, TRUE, TRUE, 0);
		gtk_widget_show(hbox);


			/* -----------------------------------------------------
			 * パッキングボックス(hbox) に入れる
			 * パッキングボックス(label_vbox & entry_vbox) を作成し
			 * 格納する
			 */
			/* パッキングボックス(label_vbox) */
			label_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
			gtk_widget_show(label_vbox);

				/* -----------------------------------------------------
				 * パッキングボックス(label_vbox) に入れる
				 * ラベル(x_pitch_label & y_pitch_label & repeats_label) を作成し
				 * 格納する
				 */
				x_pitch_label = gtk_label_new( _("Pitch X") );
				gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), x_pitch_label, TRUE, TRUE, 0);
				gtk_widget_show(x_pitch_label);

				y_pitch_label = gtk_label_new( _("Pitch Y") );
				gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), y_pitch_label, TRUE, TRUE, 0);
				gtk_widget_show(y_pitch_label);

				repeats_label = gtk_label_new( _("Number of times") );
				gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), repeats_label, TRUE, TRUE, 0);
				gtk_widget_show(repeats_label);

			/* パッキングボックス(entry_vbox) */
			entry_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), entry_vbox, TRUE, TRUE, 0);
			gtk_widget_show(entry_vbox);

				/* -----------------------------------------------------
				 * パッキングボックス(entry_vbox) に入れる
				 * テキストエントリー
				 * copy_dlg->x_pitch_entry & 
				 * copy_dlg->y_pitch_entry & 
				 * copy_dlg->repeats_entry) 
				 * を作成し,格納する
				 */
				/* テキストエントリー生成 */
				/* x_pitch_entry */
				copy_dlg->x_pitch_entry = gtk_entry_new();
				/* 初期値設定 */
				FloatOut_n(str, copy_dlg->x_pitch, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(copy_dlg->x_pitch_entry), str);
				
				gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), 
							copy_dlg->x_pitch_entry, TRUE, TRUE, 1);
				gtk_widget_show(copy_dlg->x_pitch_entry);

				/* y_pitch_entry */
				copy_dlg->y_pitch_entry = gtk_entry_new();
				/* 初期値設定 */
				FloatOut_n(str, copy_dlg->y_pitch, 6, 0);
				gtk_entry_set_text(GTK_ENTRY(copy_dlg->y_pitch_entry), str);
				gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), 
							copy_dlg->y_pitch_entry, TRUE, TRUE, 1);
				gtk_widget_show(copy_dlg->y_pitch_entry);

				/* repeats_entry */
				copy_dlg->repeats_entry = gtk_entry_new();
				/* 初期値設定 */
				sprintf(str, "%d", copy_dlg->repeats);
				gtk_entry_set_text(GTK_ENTRY(copy_dlg->repeats_entry), str);
				gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), 
							copy_dlg->repeats_entry, TRUE, TRUE, 1);
				gtk_widget_show(copy_dlg->repeats_entry);

		/* セパレーター(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);

		/* パッキングボックス(action_hbox) */
		action_hbox = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
		gtk_widget_show(action_hbox);

			/* -----------------------------------------------------
			 * パッキングボックス(action_hbox) に入れる
			 * ボタン(cancel_buttun & ok_buttun) を作成し
			 * 格納する
			 */
			/* CANCELボタンの生成 */
			cancel_buttun = gtk_button_new_with_label("CANCEL");
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
			g_signal_connect( G_OBJECT(cancel_buttun), "clicked", 
						G_CALLBACK(copy_dlg_cancel_pushed), copy_dlg);
			g_signal_connect( G_OBJECT(cancel_buttun), "clicked", 
						G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(cancel_buttun);

			/* OKボタンの生成 */
			ok_buttun = gtk_button_new_with_label("OK");
			gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
			g_signal_connect(G_OBJECT(ok_buttun), "clicked", 
						G_CALLBACK(copy_dlg_ok_pushed), copy_dlg);
			g_signal_connect(G_OBJECT(ok_buttun), "clicked", 
						G_CALLBACK(gtk_main_quit), NULL);
			gtk_widget_show(ok_buttun);

	/*  フォーカスを x_pitch_entry に設定 */
//	if (copy_dlg->x_pitch == 0 && copy_dlg->x_pitch == 0) {
//		gtk_window_set_focus(GTK_WINDOW(copy_dlg->dialog), copy_dlg->x_pitch_entry);
//		gtk_editable_select_region( GTK_EDITABLE(copy_dlg->x_pitch_entry), 0, 
//								 GTK_ENTRY(copy_dlg->x_pitch_entry)->text_length);
//	}
	/*  フォーカスを repeats_entry に設定 */
//	else if (copy_dlg->x_pitch != 0 || copy_dlg->repeats_entry != 0) {
//		gtk_window_set_focus(GTK_WINDOW(copy_dlg->dialog), copy_dlg->repeats_entry);
//		gtk_editable_select_region( GTK_EDITABLE(copy_dlg->repeats_entry), 0, 
//								 GTK_ENTRY(copy_dlg->repeats_entry)->text_length);
//	}

	/* ダイアログを可視状態へ */
	gtk_widget_show(copy_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(copy_dlg->dialog);
	return copy_dlg->value; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CopyDlg.c
 * ====================================================================
 */
