/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : Command.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2007/10/24
 * ====================================================================
 */
#ifndef __COMMAND_H__
#define __COMMAND_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
struct _MenuItem
{
	int ID;
//	void *func;
	void (*func)();
};



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _COMMAND_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _COMMAND_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */

/* テスト用 key 't' に設定 */
void test(void);

/* 外部処理 (Outside Proces) */
void cmd_outside_process(void);
/* 楕円作図 */
void cmd_Ellipse_Draw(void);
/* 印刷設定 */
void cmd_print_set(void);
/* 印刷 */
void cmd_print(void);
/* 連続線 */
void cmd_polyline(void);
/* レイヤー設定 */
void cmd_LayerSet(void);
/* Help 表示 */
void cmd_help(void);
/* 環境設定 */
void cmd_env_set(void);
/* まだできてない表示 */
void not_make(void);
/* SagCAD の終了 */
void cmd_end(void);
/* 倍率(Mag)の設定 */
void mag_box_click(GtkWidget *widget, GtkWidget *data);
/* filletRC の設定 */
void fillet_box_click(GtkWidget *widget, GtkWidget *data);
/* length の設定 */
void length_box_click(GtkWidget *widget, GtkWidget *data);
/* ScrollPitch の設定 */
void scroll_pitch_box_click(GtkWidget *widget, GtkWidget *data);
/* モードキャンセル */
void cmd_all_cancel(void);
/* バージョン情報 */
void cmd_version(void);
/* 保存データファイル名の選択 */
int save_file_name_get(char *save_filename);
/* 読み込みデータファイル名の選択 */
int read_file_name_get(char *read_filename);
/* 図面ファイルを開く */
void cmd_open(void);
/* 図面に名前を付けてファイルに保存 */
void cmd_rename(void);
/* 上書き保存 */
void cmd_save(void);
/* 選択図形削除 */ 
void cmd_delete(void);
/* 選択図形キャンセル */ 
void cmd_cancel(void);
/* レイヤー移動 */ 
void cmd_layer_move(void);
/* レイヤー複写 */ 
void cmd_layer_copy(void);
/* 線種変更 */ 
void cmd_line_style_change(void);
/* New */
void cmd_New(void);

/* View */
int cmd_view(GtkWidget *widget, GdkEventButton *event, gint i);
/* View 0 - 5 の制御 */
void view_func(int save0_or_view1, int number);

/* 中心設定 */
void cmd_center(void);

/* 選択 */
void cmd_select(void);
/* 範囲選択 */
void cmd_rect_select(void);

/* 作図 */
void cmd_draw(void);
/* 片方トリム */
void cmd_trim(void);
/* 両方トリム */
void cmd_both_trim(void);
/* 分割 */
void cmd_split(void) ;
/* フィレット */
void cmd_fillet(void) ;
/* Ｃ面取り */
void cmd_Chamfering(void);
/* 連続線 */
void cmd_cont_line(void);
/* ３点で円 */
void cmd_3point(void);
/* ３辺で円 */
void cmd_3line(void);
/* 点座標入力 */
void cmd_point(void);

/* 再描画 */
void cmd_redraw(void);

/* 平行 */
void cmd_parallel_copy(void);
/* 回転 */
void cmd_turn(void);
/* 対称 */
void cmd_mirr(void);
/* スケーリング */
void cmd_scaling(void);
/* 行列複写 */
void cmd_grid_copy(void);


/* 寸法 X */
void cmd_x_dimension(void);
/* 寸法 Y */
void cmd_y_dimension(void);
/* 寸法 距離 */
void cmd_p_dimension(void);
/* 寸法 半径 */
void cmd_r_dimension(void);
/* 寸法 直径 */
void cmd_d_dimension(void);
/* 寸法 角度 */
void cmd_a_dimension(void);
/* 寸法 座標 */
void cmd_pt_dimension(void);
/* 寸法 引出 */
void cmd_hd_dimension(void);
/* 寸法 注釈 */
void cmd_at_dimension(void);
/* 寸法 編集 */
void cmd_edt_dimension(void);



/* チェイン */
void cmd_select_chain(void);
/* 一筆チェイン */
void cmd_select_chain2(void);
/* カラー */
void cmd_select_color(void);

/* Undo */
void cmd_Undo(void);
/* Redo */
void cmd_Redo(void);
/* カット */
void cmd_cut(void);
/* コピー */
void cmd_copy(void);
/* ペースト */
void cmd_paste(void);
/* 部品図挿入 */
void cmd_parts_in(void);

/* CAM Profile */
void cmd_profile(void);

/* NC 作図 */
void cmd_NcDraw(void);


#ifdef AFTER
void select_list_log(void);
void undo_list_log(void);
void CommandMenu(HWND hWnd, int MenuID);
int Dimension_List_Log(char *filename, char *msg);
#endif



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __COMMAND_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Source               : Command.h
 * ====================================================================
 */
