/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CamProfile.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2007/10/31
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "types.h"
#include "MemoryLeak.h"
#include "List_cam.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Select.h"
#include "global.h"
#include "culcfunc.h"
#include "Draw.h"
#include "sagcad.h"
#include "MsgBox.h"
#include "etc.h"

#ifdef G_OS_WIN32
#  include <windows.h>
#endif

#define _CAMPROFILE_
#include "CamProfile.h"



/* -------------------------------------------------------------------
 * 倍精度 (double) データの入れ替え
 *	
 */
int Swap(double *a, double *b)
{
	double dumy;

	dumy = *a;
	*a = *b;
	*b = dumy;
	return 1;
}





/* -------------------------------------------------------------------
 * セレクトされているデータを LIST の CAM データに読み込む
 *	
 * frag : 最初の図形の向き
 *	   1 : 正
 *	   2 : 逆
 */
int CamDataRead(int frag)
{
	SELECT_LIST *p;
	CAM cam;
	struct RtnDat LAH;


	if (select_list_info.head == NULL) return 0;
	/* 全リストを削除 */
	cam_list_all_free();

	p = select_list_info.head;
	while (p != NULL) {
		/* 図形データ */
		if (p->select->index == 2 || p->select->index == 4) {
			/* 線と円弧データのみ (点と円は無視) */
			if (p->select->diagram_point.cad_point->code == 1 || p->select->diagram_point.cad_point->code == 2) {
				cam.code = p->select->diagram_point.cad_point->code;
				cam.gcode = p->select->diagram_point.cad_point->code;
				cam.sx = p->select->diagram_point.cad_point->sx;
				cam.sy = p->select->diagram_point.cad_point->sy;
				cam.ex = p->select->diagram_point.cad_point->ex;
				cam.ey = p->select->diagram_point.cad_point->ey;
				cam.cx = p->select->diagram_point.cad_point->cx;
				cam.cy = p->select->diagram_point.cad_point->cy;
				cam.r = p->select->diagram_point.cad_point->r;

				/* 円弧のときは、とりあえず向きはそのままで gcode = 3 */
				if (cam.gcode == 2 || cam.gcode == 4) {
					cam.gcode = 3;

					/* SA を求める */
					LAH.sx[1] = p->select->diagram_point.cad_point->cx;
					LAH.sy[1] = p->select->diagram_point.cad_point->cy;
					LAH.ex[1] = p->select->diagram_point.cad_point->sx;
					LAH.ey[1] = p->select->diagram_point.cad_point->sy;
					la(&LAH);
					cam.sa = LAH.angle;

					/* EA を求める */
					LAH.sx[1] = p->select->diagram_point.cad_point->cx;
					LAH.sy[1] = p->select->diagram_point.cad_point->cy;
					LAH.ex[1] = p->select->diagram_point.cad_point->ex;
					LAH.ey[1] = p->select->diagram_point.cad_point->ey;
					la(&LAH);
					cam.ea = LAH.angle;

					/* IA を求める */
					if (cam.sa < cam.ea) {
						cam.ia = cam.ea - cam.sa;
					}
					else {
						cam.ia = cam.ea + (360 - cam.sa);
					}
				}

				/* 最初のデータの向きが逆(frag = 4) のとき */
				if (frag == 4 && p == select_list_info.head) {
					/* 線データ */
					if (cam.gcode == 1){
						Swap(&cam.sx, &cam.ex);
						Swap(&cam.sy, &cam.ey);
					}
					/* 円弧データ */
					else if (cam.gcode == 3){
						cam.gcode = 2;
						Swap(&cam.sx, &cam.ex);
						Swap(&cam.sy, &cam.ey);
						Swap(&cam.sa, &cam.ea);
						cam.ia = -1 * cam.ia;
					}
				}
				/* CAM Data をリストの最後に追加 */
				cam_list_add_last(&cam);
			}
		}

		/* 寸法データ */
		if (p->select->index == 3) {
			/* 無視 */
		}
		else {
			/* 無視 */
		}


		/* 次のセレクトデータを処理 */
		p = p->next;
	}

	return 1;
}





/* -------------------------------------------------------------------
 * Hitohude
 *	
 * 最初のデータだけは決めておく。(当然最初にあり、向きも決めておく)
 *	
 *	
 * 最初のデータからつながっているデータを並べる。
 *	
 * 1:決定したデータの終点と同じ点を持つデータを探す。
 * 2:データが見つかったならば、決定したデータの次に来るように並び替える。
 * 3:見つかったデータが、始点ならそのままだけど、終点ならば、次の処理をする。
 *	   ・線ならば、始点と終点を入れ替える。
 *	   ・円弧ならば、始点と終点、開始角と終了角、を入れ替え、IA を負(-) にする。
 * 4:データが全てつながらない場合は、エラーとする。
 *	
 */
int Hitohude(int CamCheck)
{
	CAM_LIST *p_i, *p_j;
	CAM *cam_dumy;
	int K;
	char Txt[256];
	double DX, DY;



	/* 開始図形を描いて、OK かどうかの確認！ */
	if (cam_list_info.head->cam->gcode == 1) {
		LineDraw (drawing_area, cam_list_info.head->cam->sx, cam_list_info.head->cam->sy, 
								cam_list_info.head->cam->ex, cam_list_info.head->cam->ey, 
								1, sagcad_color.Cam);
	}
	else if ( cam_list_info.head->cam->gcode == 3) {
		ArcDraw (drawing_area, cam_list_info.head->cam->cx, cam_list_info.head->cam->cy, cam_list_info.head->cam->r, 
							   cam_list_info.head->cam->sx, cam_list_info.head->cam->sy, 
							   cam_list_info.head->cam->ex, cam_list_info.head->cam->ey, 1, sagcad_color.Cam);
	}
	else if ( cam_list_info.head->cam->gcode == 2) {
		ArcDraw(drawing_area, cam_list_info.head->cam->cx, cam_list_info.head->cam->cy, cam_list_info.head->cam->r, 
							  cam_list_info.head->cam->ex, cam_list_info.head->cam->ey, 
							  cam_list_info.head->cam->sx, cam_list_info.head->cam->sy, 1, sagcad_color.Cam);
	}



	if (MsgBox("SagCAD", "CAM Check", _("Does it check a movement?") , "Yes", "No", NULL) == 1) {
		CamCheck = 1;
	}
	else {
		CamCheck = 0;
	}



	/* 確認 */
	if (CamCheck == 1) {
		MsgBox("SagCAD", "CAM", "Check OK ?", NULL, NULL, "OK");
	}

	/* データが１個だけなら終わり */
	if (cam_list_info.head->next == NULL) return 1;

	/* CAM DATA を最初から最後の1個前まで */
	p_i = cam_list_info.head;
	while (p_i->next != NULL) {
		/* なかった フラグ をたてる */
		K = 0;

		/* CAM DATA を i の次から最後まで */
		p_j = p_i->next;
		while (p_j != NULL) {
			/* ---------------------------------------------
			 * 始点と一致
			 * 
			 * i の終点と j の始点が一致
			 */
//			if (	sg(p_i->cam->ex, compa_digits) == sg(p_j->cam->sx, compa_digits) 
//					&& 
//					sg(p_i->cam->ey, compa_digits) == sg(p_j->cam->sy, compa_digits)) {
			if (	(p_i->cam->ex + (1/pow(10, compa_digits)) > p_j->cam->sx) 
					&& 
					(p_i->cam->ex - (1/pow(10, compa_digits)) < p_j->cam->sx) 
					&& 
					(p_i->cam->ey + (1/pow(10, compa_digits)) > p_j->cam->sy) 
					&& 
					(p_i->cam->ey - (1/pow(10, compa_digits)) < p_j->cam->sy) )
			{
				/* 順番を入れ替える */
				/* CAM Data のリストの並びを置換 */
				cam_dumy = p_i->next->cam;
				p_i->next->cam = p_j->cam;
				p_j->cam = cam_dumy;

				/* 見つけた図形の色を変える */
				if (p_i->next->cam->gcode == 1) {
					LineDraw(drawing_area,	p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Back);
					LineDraw(drawing_area,	p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Cam);
					p_i->cam->code = 0;
					K = 1;
					break;
				}
				else if ( p_i->next->cam->gcode == 3) {
					ArcDraw(drawing_area,	p_i->next->cam->cx, p_i->next->cam->cy, 
											p_i->next->cam->r, 
											p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Back);
					ArcDraw(drawing_area,	p_i->next->cam->cx, p_i->next->cam->cy, 
											p_i->next->cam->r, 
											p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Cam);
					p_i->cam->code = 0;
					K = 1;
					break;
				}
			}



			/* ---------------------------------------------
			 * 終点と一致
			 * 
			 * i の終点と j の終点が一致
			 * 
			 * 終点と一致した場合は、IA がマイナスで G02 になる
			 *	   G02になる
			 *	   IA がマイナスになる
			 *	   始点(sx,sy) と終点(ex,ey) が入れ替わる
			 * G03->G02   IA->-IA	 sx,sy,-> ex,ey
			 * 
			 */
//			else if (	sg(p_i->cam->ex, 3) == sg(p_j->cam->ex, 3) 
//						&& 
//						sg(p_i->cam->ey, 3) == sg(p_j->cam->ey, 3)) {
			else if (	(p_i->cam->ex + (1/pow(10, compa_digits)) > p_j->cam->ex) 
						&& 
						(p_i->cam->ex - (1/pow(10, compa_digits)) < p_j->cam->ex) 
						&& 
						(p_i->cam->ey + (1/pow(10, compa_digits)) > p_j->cam->ey) 
						&& 
						(p_i->cam->ey - (1/pow(10, compa_digits)) < p_j->cam->ey) )
			{

				/* 順番を入れ替える */
				/* CAM Data のリストの並びを置換 */
				cam_dumy = p_i->next->cam;
				p_i->next->cam = p_j->cam;
				p_j->cam = cam_dumy;

				Swap(&p_i->next->cam->sx, &p_i->next->cam->ex);
				Swap(&p_i->next->cam->sy, &p_i->next->cam->ey);
				Swap(&p_i->next->cam->sa, &p_i->next->cam->ea);
				p_i->next->cam->ia = -1 * (p_i->next->cam->ia);

				/* 見つけた図形の色を変える */
				if (p_i->next->cam->gcode == 1) {
					LineDraw(drawing_area,	p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Back);
					LineDraw(drawing_area,	p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Cam);
					p_i->cam->code = 0;
					K = 1;
					break;
				}
				else if ( p_i->next->cam->gcode == 3) {
					p_i->next->cam->gcode = 2;
					/* IA が負なら G02 */
					ArcDraw(drawing_area,	p_i->next->cam->cx, p_i->next->cam->cy, p_i->next->cam->r, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											p_i->next->cam->sx, p_i->next->cam->sy, 1, sagcad_color.Back);
					ArcDraw(drawing_area,	p_i->next->cam->cx, p_i->next->cam->cy, p_i->next->cam->r, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											p_i->next->cam->sx, p_i->next->cam->sy, 1, sagcad_color.Cam);
					p_i->cam->code = 0;
					K = 1;
					break;
				}
			}
			p_j = p_j->next;
		} /* <for j> */





		if (K == 0) {
			MsgBox("SagCAD", "CAM Check", _("Can't connect.") , NULL, NULL, "OK");
			return 0;
		}

		/* CamCheck が On なら1個1個止める */
		if (CamCheck == 1) {
			MsgBox("SagCAD", "CAM Check", "Check OK ?", NULL, NULL, "OK");
			//MessageBox(NULL , "Check OK ?", (LPCSTR)"ＣＡＭ ！" , MB_OK);
		}
		UpDate();
	
		p_i = p_i->next;
	} /* <for i> */

	DX = sg(cam_list_info.tail->cam->ex - cam_list_info.head->cam->sx, 3);
	DY = sg(cam_list_info.tail->cam->ey - cam_list_info.head->cam->sy, 3);

	/* CamCheck が On なら1個1個止める */
	if (CamCheck == 1) {
		sprintf(Txt, "DX = %f  DY = %f", DX, DY);
		MsgBox("SagCAD", _("Connected") , Txt, NULL, NULL, "OK");
	}
	return 1;
}





/* -------------------------------------------------------------------
 * NcOut
 * 
 * AbsInc
 *    0 : G90
 *    1 : G91
 * Heel
 *    0 : エンドミル
 *    1 : ヘール G03+
 *    2 : ヘール G02+
 * Modal
 *    0 : モーダル
 *    1 : 毎回
 * RIJ
 *    0 : R 指令
 *    1 : IJ 指令
 * 
 * NC 用の構造体を作成しよう。
 */
int NcOut(CAM_ENV CamProperty)
{
	CAM_LIST *p;
	int modal_0 = 0;
//	int len, j;
	char path[256];
	char *command;

	double G91X = 0, G91Y = 0, G91C = 0;
	double x = 0, y = 0;
//	int i;
	char DumyStr[256], str[256], FileName[256];
	char XCode[256], YCode[256], NcCode[256], NcMode[256];
	char CCode[256], DCode[256], ECode[256], GK[256];
	FILE *stream;
	

	if ( strstr(sagcad_user.NcPath, "CADPATH") != NULL )
		sprintf(FileName, "%s/NoName.NC", sagcad_user.CadPath);
	else sprintf(FileName, "%s/NoName.NC", sagcad_user.NcPath);



	/* ファイルをオープン */ 
	if((stream = fopen(FileName, "w")) == NULL) {
		g_print( _("The file could not be opened. [%s]\n") , FileName);
		return 0;
	}


	/* -----------------------------------------------------
	 * 行頭注釈行をファイルに書き込む
	 */
	sprintf(str, "(SAGCAD OUTPUT NC FILE)\n");
	write_locale_from_utf8(str, stream, CHARSET_UTF8);

	if(CamProperty.AbsInc == 1)
		sprintf(str, "G91");
	else if( CamProperty.AbsInc == 0)
		sprintf(str, "G90");
	if(CamProperty.Heel == 0)
		strcat(str, " PROFILE MODE");
	else if( CamProperty.Heel == 1)
		strcat(str, " HEEL [G03 +] FOR FNC MODE");
	else if( CamProperty.Heel == 2)
		strcat(str, " HEEL [G02 +] FOR BN MODE");
	sprintf(NcMode, "(%s)\n", str);
	/* ファイルに書き込む */
	write_locale_from_utf8(NcMode, stream, CHARSET_UTF8);



	/* -----------------------------------------------------
	 * 開始条件をファイルに書き込む
	 */
	if (CamProperty.StartStr[0] != '\0') {
#ifdef TEST
		len = strlen(CamProperty.StartStr);
		j = 0;
		for (i = 0 ; i < len ; i++) {
			if (CamProperty.StartStr[i] != '\r') {
				str[j] = CamProperty.StartStr[i];
				j++;
			}
		}
		str[j] = '\0';
#endif
		/* ファイルに書き込む */
		write_locale_from_utf8(CamProperty.StartStr, stream, CHARSET_UTF8);
	}





	/* -----------------------------------------------------
	 * CAM DATA を最初から最後まで 
	 * 
	 */
	p = cam_list_info.head;
	while (p != NULL) {
		/* -------------------------------------------------
		 * G01 
		 * 
		 */
		if(p->cam->gcode == 1) {
			/* インクリメント指令 */
			if (CamProperty.AbsInc == 1) {
				x = sg(sg(p->cam->ex, sagcad_digits.cam_digits) - sg(p->cam->sx, sagcad_digits.cam_digits), sagcad_digits.cam_digits);
				y = sg(sg(p->cam->ey, sagcad_digits.cam_digits) - sg(p->cam->sy, sagcad_digits.cam_digits), sagcad_digits.cam_digits);
				G91X = sg((G91X + x), sagcad_digits.cam_digits);
				G91Y = sg((G91Y + y), sagcad_digits.cam_digits);
			}
			/* アブソリュート指令 */
			if (CamProperty.AbsInc == 0) {
				x = sg(p->cam->ex, sagcad_digits.cam_digits);
				y = sg(p->cam->ey, sagcad_digits.cam_digits);
			}

			/* X Code */
			FloatOut_n(str, x, sagcad_digits.cam_digits, 1);
			sprintf(XCode, "X%s", str);
			/* Y Code */
			FloatOut_n(str, y, sagcad_digits.cam_digits, 1);
			sprintf(YCode, "Y%s", str);

			/* G01 のモーダル */
			sprintf(GK, "G01");
			if (p != cam_list_info.head && CamProperty.Modal == 1 && modal_0 == 1) {
				strcpy(GK, "");
			}

			/* G90 & G91 のモーダル */
			if (CamProperty.AbsInc == 1 && (p == cam_list_info.head || CamProperty.Modal == 0)) {
				strcat(GK, "G91");
			}
			if (CamProperty.AbsInc == 0 && (p == cam_list_info.head || CamProperty.Modal == 0)) {
				strcat(GK, "G90");
			}
			/* ファイルに書き込む */
			sprintf(NcCode, "%s%s%s\n", GK, XCode, YCode);
			write_locale_from_utf8(NcCode, stream, CHARSET_UTF8);
			
			modal_0 = 1;
		}





		/* -------------------------------------------------
		 * G02 & G03 
		 * 
		 */
		if (p->cam->gcode == 2 || p->cam->gcode == 3) {
			/* インクリメント指令 */
			if (CamProperty.AbsInc == 1) {
				x = sg(sg(p->cam->ex, sagcad_digits.cam_digits) - sg(p->cam->sx, sagcad_digits.cam_digits), sagcad_digits.cam_digits);
				y = sg(sg(p->cam->ey, sagcad_digits.cam_digits) - sg(p->cam->sy, sagcad_digits.cam_digits), sagcad_digits.cam_digits);
				G91X = sg((G91X + x), sagcad_digits.cam_digits);
				G91Y = sg((G91Y + y), sagcad_digits.cam_digits);
			}
			/* アブソリュート指令 */
			if (CamProperty.AbsInc == 0) {
				x = sg(p->cam->ex, sagcad_digits.cam_digits);
				y = sg(p->cam->ey, sagcad_digits.cam_digits);
			}
			G91C = sg(G91C + p->cam->ia, sagcad_digits.cam_digits);
			/* X Code */
			FloatOut_n(str, x, sagcad_digits.cam_digits, 1);
			sprintf(XCode, "X%s", str);
			/* Y Code */
			FloatOut_n(str, y, sagcad_digits.cam_digits, 1);
			sprintf(YCode, "Y%s", str);

			/* C Code */
			if (CamProperty.Heel == 1) {
				FloatOut_n(str, p->cam->ia, sagcad_digits.cam_digits, 1);
				sprintf(CCode, "C%s", str);
			}
			else if (CamProperty.Heel == 2) {
				p->cam->ia = -1 * p->cam->ia;
				FloatOut_n(str, p->cam->ia, sagcad_digits.cam_digits, 1);
				sprintf(CCode, "C%s", str);
			}
			else if (CamProperty.Heel == 0) CCode[0] = '\0';

			/* NC(IJ) */
			if (CamProperty.RIJ == 1) {
				/* D Code (I) */
				FloatOut_n(str, p->cam->cx - p->cam->sx, sagcad_digits.cam_digits, 1);
				sprintf(DCode, "I%s", str);
				/* E Code (J) */
				FloatOut_n(str, p->cam->cy - p->cam->sy, sagcad_digits.cam_digits, 1);
				sprintf(ECode, "J%s", str);
			}

			/* NC(R) */
			if (CamProperty.RIJ == 0) {
				/* D Code (I) */
				FloatOut_n(str, p->cam->r, sagcad_digits.cam_digits, 1);
				if (p->cam->ia > 180 || p->cam->ia < -180) {
					sprintf(DCode, "R-%s", str);
				}
				else sprintf(DCode, "R%s", str);
				/* E Code (J) */
				ECode[0] = '\0';
			}


			/* [ G02 G03 NCOUT ] */
			if (p->cam->gcode == 3) 
				sprintf(GK, "G03");
			else if(p->cam->gcode == 2) 
				sprintf(GK, "G02");

			/* G02 & G03 のモーダル */
			if (p != cam_list_info.head && CamProperty.Modal == 1 && modal_0 == p->cam->gcode) 
				GK[0] = '\0';
			/* G90 & G91 のモーダル */
			if (CamProperty.AbsInc == 1 && (p == cam_list_info.head || CamProperty.Modal == 0)) 
				strcat(GK, "G91");
			else if(CamProperty.AbsInc == 0 && (p == cam_list_info.head || CamProperty.Modal == 0)) 
				strcat(GK, "G90");

			/* ファイルに書き込む */
			/* G02-X--Y--C--IR-J- */
			sprintf(NcCode, "%s%s%s%s%s%s\n", GK, XCode, YCode, DCode, ECode, CCode);
			write_locale_from_utf8(NcCode, stream, CHARSET_UTF8);

			modal_0 = p->cam->gcode;
		}
		p = p->next;
	}





	/* G90 プログラムが開始点と終了点が同じかどうかのチェック */
	if (CamProperty.AbsInc == 0) {
		/* ファイルに書き込む */
		FloatOut_n(str, cam_list_info.head->cam->sx, sagcad_digits.cam_digits, 1);
		FloatOut_n(DumyStr, cam_list_info.head->cam->sy, sagcad_digits.cam_digits, 1);
		sprintf(NcCode, "(START X%s Y%s)\n", str, DumyStr);
		write_locale_from_utf8(NcCode, stream, CHARSET_UTF8);

		/* ファイルに書き込む */
		FloatOut_n(str, cam_list_info.tail->cam->ex, sagcad_digits.cam_digits, 1);
		FloatOut_n(DumyStr, cam_list_info.tail->cam->ey, sagcad_digits.cam_digits, 1);
		sprintf(NcCode, "(END X%s Y%s)\n", str, DumyStr);
		write_locale_from_utf8(NcCode, stream, CHARSET_UTF8);

		if (sg(cam_list_info.tail->cam->ex - cam_list_info.head->cam->sx, sagcad_digits.cam_digits) != 0 
				|| sg(cam_list_info.tail->cam->ey - cam_list_info.head->cam->sy, sagcad_digits.cam_digits) != 0)
			/* ファイルに書き込む */
			write_locale_from_utf8("(START-END NO RETURN)\n", stream, CHARSET_UTF8);
		if (sg(cam_list_info.tail->cam->ex - cam_list_info.head->cam->sx, sagcad_digits.cam_digits) == 0 
				&& sg(cam_list_info.tail->cam->ey - cam_list_info.head->cam->sy, sagcad_digits.cam_digits) == 0)
			/* ファイルに書き込む */
			write_locale_from_utf8("(START-END 0 RETURN OK)\n", stream, CHARSET_UTF8);
	}


	/* G91 プログラムが開始点と終了点が同じかどうかのチェック */
	if (CamProperty.AbsInc == 1) {
		FloatOut_n(str, G91X, sagcad_digits.cam_digits, 1);
		FloatOut_n(DumyStr, G91Y, sagcad_digits.cam_digits, 1);
		sprintf(NcCode, "(START-END X%s Y%s)\n", str, DumyStr);
		write_locale_from_utf8(NcCode, stream, CHARSET_UTF8);

		if (sg(G91X, sagcad_digits.cam_digits) != 0 || sg(G91Y, sagcad_digits.cam_digits) != 0)
			write_locale_from_utf8("(X-Y NO RETURN)\n", stream, CHARSET_UTF8);
		if (sg(G91X, sagcad_digits.cam_digits) == 0 && sg(G91Y, sagcad_digits.cam_digits) == 0)
			write_locale_from_utf8("(X-Y 0 RETURN OK)\n", stream, CHARSET_UTF8);
	}

	/* Heel Mode で 1周して 360度で終わっているかをチェック */
	if (CamProperty.Heel > 0) {
		/* 開始から終了までの角度 */
		FloatOut_n(str, G91C, sagcad_digits.cam_digits, 1);
		sprintf(NcCode, "(1 CYCLE %s)\n", str);
		write_locale_from_utf8(NcCode, stream, CHARSET_UTF8);

		if (sg(G91C, sagcad_digits.cam_digits) != 360 && sg(G91C, sagcad_digits.cam_digits) != -360)
			write_locale_from_utf8("(C-NOT 360 RETURN)\n", stream, CHARSET_UTF8);
		if (sg(G91C, sagcad_digits.cam_digits) == 360 || sg(G91C, sagcad_digits.cam_digits) == -360)
			write_locale_from_utf8("(C-360 RETURN OK)\n", stream, CHARSET_UTF8);
	}


	/* -----------------------------------------------------
	 * 終了条件をファイルに書き込む
	 */
	if (CamProperty.EndStr[0] != '\0') {
#ifdef TEST
		len = strlen(CamProperty.EndStr);
		j =0;
		for (i=0 ; i<len ; i++) {
			if (CamProperty.EndStr[i] != '\r') {
				str[j] = CamProperty.EndStr[i];
				j++;
			}
		}
		str[j] = '\0';
#endif
		/* ファイルに書き込む */
		write_locale_from_utf8(CamProperty.EndStr, stream, CHARSET_UTF8);
	}

	/* ファイルをクローズ */ 
	fclose(stream);

	/* Editor command */

#ifdef G_OS_WIN32
	strcpy(path, FileName);
	command = g_locale_from_utf8(path, -1, NULL, NULL, NULL);
	ShellExecute(0, "Open", command, "", "", 1); 	
	g_free(command);
#else
	strcpy(path, sagcad_user.editor_command);
	replace(path, "&", "");
	replace(path, "%s", FileName);
	
	command = g_locale_from_utf8(path, -1, NULL, NULL, NULL);
	system(command);
	g_free(command);
#endif
	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CamProfile.c
 * ====================================================================
 */
