<?php

/**
 * Sabel_View_Location
 *
 * @abstract
 * @category   View
 * @package    org.sabel.view
 * @author     Ebine Yutaka <ebine.yutaka@sabel.jp>
 * @copyright  2004-2008 Mori Reo <mori.reo@sabel.jp>
 * @license    http://www.opensource.org/licenses/bsd-license.php  BSD License
 */
abstract class Sabel_View_Location extends Sabel_Object
{
  protected $baseDir = "";
  protected $viewDir = "";
  protected $name    = "";
  
  abstract public function isValid();
  abstract public function getContents();
  abstract public function create($body = "");
  abstract public function delete();
  
  public function __construct($viewDir, $baseDir = "")
  {
    if ($baseDir === "") {
      if (defined("MODULES_DIR_PATH")) {
        $this->baseDir = MODULES_DIR_PATH;
      } else {
        $message = "must define MODULES_DIR_PATH for base directory.";
        throw new Sabel_Exception_Runtime(__METHOD__ . "() $message");
      }
    } else {
      $this->baseDir = $baseDir;
    }
    
    $this->viewDir = $viewDir;
  }
  
  public function name($name = null)
  {
    if ($name === null) {
      return $this->name;
    } elseif (is_string($name)) {
      $this->name = $name . TPL_SUFFIX;
    } else {
      $message = "argument must be a string.";
      throw new Sabel_Exception_InvalidArgument($message);
    }
  }
  
  public function getPath()
  {
    return $this->baseDir . DS . $this->viewDir . $this->name;
  }
}
