<?php
// $Id: rpc_client.php,v 1.1 2004/07/11 10:28:46 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: i-Tech (Half-Dead)
// Author Website : http://www.i-Technology.NET
// License Type   : LGPL: See /manual/LICENSES/LGPL.txt
// ------------------------------------------------------------------------- //

//------------------------------------------------------------------------------------------//
/**
* Sends xml data a remote host and passes the result to the decoder.
* @author Half-Dead
* @copyright 2002 {@link http://www.e-xoops.com www.e-xoops.com} :: {@link http://www.topsite-toplist.com www.topsite-toplist.com}
* @version 1.2b
* @package phpRPC
*/
class rpc_Client {

	var $host;
	var $port;
	var $url;

	var $username;
	var $password;

/**
* Holds the data to send, so we can dump it later.
*
* ie. echo $rpc_client->sent
* @var string
*/
	var $sent;

/**
* Holds the recieved data, so we can dump it later.
*
* ie. echo $rpc_client->recieved
* @var string
*/
	var $recieved;


//------------------------------------------------------------------------------------------//
/**
* Sets up the client for sending data to a remote server.
* Usage:
* $rpc_client = new rpc_Client($host, $url, $port);
* If port is 80, then you may ommit it.
* @param string	$host	Hosname ie. www.somehost.com
* @param string	$url	End url ie. /test/server.php
* @param integer	$port	Host port ie. 80
*/
	function rpc_Client($host, $url, $port=80) {

	$this->host = $host;
	$this->url  = $url;
	$this->port = $port;
	}


//------------------------------------------------------------------------------------------//
/**
* Set server username
*
* $rpc_client->username($user);
* @param string $username Username: if htaccess protected page
*/
function username($user) {
	$this->username = $user;
}


//------------------------------------------------------------------------------------------//
/**
* Set server password
*
* $rpc_client->password($pass);
* @param string $password Password: if htaccess protected page
*/
function password($pass) {
	$this->password = $pass;
}


//------------------------------------------------------------------------------------------//
/**
* Sends the actual data to the remote server.
* Usage:
* $result = $rpc_client->send($data);
* @param string $data Sends the data from rpc_encoder a distant server.
* @return array Returns an array of result data.
*/
function send($data) {
global $rpc_decoder;

$header  = "POST " . $this->url . " HTTP/1.0\n";
$header .= "User-Agent: phpRPC\n";
$header .= "Host: " . $this->host  . "\n";
if ($this->username != '') {
$header .= "Authorization: Basic " . base64_encode($this->username . ":" . $this->password) . "\n";
}
$header .= "Content-Type: text/xml\n";
$header .= "Content-Length: " . strlen($data) . "\n\n";
$this->sent = $header.$data;

//echo $this->sent; exit();
//echo $data; exit();
$fp = fsockopen($this->host, $this->port, $errno, $errstr, 15);

if (!$fp) {
	trigger_error("Fsocks error: $errno, $errstr", E_USER_ERROR);
} else {
	fputs($fp, $this->sent, strlen($this->sent));
		while (!feof($fp)) {
			$this->recieved .= fgets($fp, 4096);
		}
	fclose($fp);
}

//echo $this->recieved; exit();
$data = explode("<methodResponse>", $this->recieved);
$data = '<methodResponse>'.$data[1];

//echo $data; exit();
$result = $rpc_decoder->decode($data);
return $result;
}
//-----------------------------------------------------------------------------------------//
}
?>
