<?php
// $Id: index.php,v 1.1 2004/07/11 10:28:38 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: The Xoops Project
// Author Website : http://www.xoops.org
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

include_once("admin_header.php");
include_once(XOOPS_ROOT_PATH."/class/xoopstopic.php");
include_once(XOOPS_ROOT_PATH."/modules/".$xoopsModule->dirname()."/class/class.newsstory.php");
include_once(XOOPS_ROOT_PATH."/class/module.errorhandler.php");
include_once(XOOPS_ROOT_PATH."/modules/".$xoopsModule->dirname()."/cache/config.php");

//---------------------------------------------------------------------------------------//
/**
* Show new submissions
*
* @param type $var description
* @return type description
*/
function newSubmissions() {
global $xoopsConfig, $db;

$storyarray = NewsStory::getAllSubmitted();

if ( count($storyarray) > 0 ) {
	OpenTable();
	echo "<div style='text-align: center;'><b>"._AM_NEWSUB."</b><br /><table width='100%' border='1'><tr class='bg2'><td align='center'>"._AM_TITLE."</td><td align='center'>"._AM_POSTED."</td><td align='center'>"._AM_POSTER."</td><td align='center'>"._ACTION."</td></tr>";
	foreach ($storyarray as $newstory) {
		echo "<tr><td>";
		$title = $newstory->title();
		if ( !isset($title) || ($title == "") ) {
			echo "<a href='index.php?op=edit&amp;storyid=".$newstory->storyid()."'>"._AD_NOSUBJECT."</a>";
			} else {
				echo "&nbsp;<a href='index.php?op=edit&amp;storyid=".$newstory->storyid()."'>".$title."</a>";
			}
		echo "</td><td align='center'>".formatTimestamp($newstory->created())."</td><td align='center'><a href='".XOOPS_URL."/userinfo.php?uid=".$newstory->uid()."'>".$newstory->uname()."</a></td><td align='right'><a href='index.php?op=delete&amp;storyid=".$newstory->storyid()."'>"._DELETE."</a></td></tr>";
	}
	echo "</table></div>";
	CloseTable();
	echo "<br />";
}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
/*
 * Shows automated stories
 */
function autoStories() {
global $db, $xoopsConfig, $xoopsModule;

$storyarray = NewsStory::getAllAutoStory();

if ( count($storyarray) > 0 ) {
	OpenTable();
	echo "
		<div style='text-align: center;'><b>"._AM_AUTOARTICLES."</b><br />
		<table border='1' width='100%'><tr class='bg2'><td align='center'>"._AM_STORYID."</td><td align='center'>"._AM_TITLE."</td><td align='center'>"._AM_TOPIC."</td><td align='center'>"._AM_POSTER."</td><td align='center'>"._AM_PROGRAMMED."</td><td align='center'>"._ACTION."</td></tr>";
	foreach ($storyarray as $autostory) {
		$topic = $autostory->topic();
		echo "
		<tr>
		<td align='center'><b>".$autostory->storyid()."</b></td>
		<td align='left'><a href='".XOOPS_URL."/modules/".$xoopsModule->dirname()."/article.php?storyid=".$autostory->storyid()."'>".$autostory->title()."</a></td>
		<td align='center'>".$topic->topic_title()."</td>
		<td align='center'><a href='".XOOPS_URL."/userinfo.php?uid=".$autostory->uid()."'>".$autostory->uname()."</a></td><td align='center'>".formatTimestamp($autostory->published())."</td><td align='center'><a href='index.php?op=edit&amp;storyid=".$autostory->storyid()."'>"._EDIT."</a>-<a href='index.php?op=delete&amp;storyid=".$autostory->storyid()."'>"._DELETE."</a></td>
		</tr>";
	}
	echo "</table></div>";
	CloseTable();
	echo "<br />";
}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
/*
 * Shows last 10 published stories
 */
function lastStories() {
global $db, $xoopsConfig, $xoopsModule;

OpenTable();
echo "<div style='text-align: center;'><b>"._AM_LAST10ARTS."</b><br />";
$storyarray = NewsStory::getAllPublished(10, 0, 0, 1);
echo "<table border='1' width='100%'><tr class='bg2'><td align='center'>"._AM_STORYID."</td><td align='center'>"._AM_TITLE."</td><td align='center'>"._AM_TOPIC."</td><td align='center'>"._AM_POSTER."</td><td align='center'>"._AM_PUBLISHED."</td><td align='center'>"._ACTION."</td></tr>";

foreach ($storyarray as $eachstory) {
	$published = formatTimestamp($eachstory->published());
	$topic = $eachstory->topic();
	echo "
	<tr>
	<td align='center'><b>".$eachstory->storyid()."</b></td>
	<td align='left'><a href='".XOOPS_URL."/modules/".$xoopsModule->dirname()."/article.php?storyid=".$eachstory->storyid()."'>".$eachstory->title()."</a></td>
	<td align='center'>".$topic->topic_title()."</td>
	<td align='center'><a href='".XOOPS_URL."/userinfo.php?uid=".$eachstory->uid()."'>".$eachstory->uname()."</a></td><td align='center'>".$published."</td><td align='center'><a href='index.php?op=edit&amp;storyid=".$eachstory->storyid()."'>"._EDIT."</a>-<a href='index.php?op=delete&amp;storyid=".$eachstory->storyid()."'>"._DELETE."</a></td>
	</tr>";
}
echo "
</table><br />
<form action='index.php' method='post'>
"._AM_STORYID." <input type='text' class='text' name='storyid' size='10' />
<select class='select' name='op'>
<option value='edit' selected='selected'>"._EDIT."</option>
<option value='delete'>"._DELETE."</option>
</select>
<input type='submit' class='button' value='"._GO."' />
</form></div>";

CloseTable();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function topicsmanager() {
global $db, $xoopsConfig, $xoopsModule;

xoops_cp_header();
$xt = new XoopsTopic($db->prefix("topics"));

// Add a New Main Topic
OpenTable();
echo "<form method='post' action='index.php'>";
echo "<h4>"._AM_ADDMTOPIC."</h4><br />";
echo "<b>"._AM_TOPICNAME."</b> "._AM_MAX40CHAR."<br /><input type='text' class='text' name='topic_title' size='20' maxlength='20' /><br />";
echo "<br />";
echo "<input type='hidden' name='topic_pid' value='0' />";
echo "<input type='hidden' name='op' value='addTopic' />";
echo "<input type='submit' class='button' value="._ADD." /><br /></form>";
CloseTable();
echo "<br />";

// Add a New Sub-Topic
$result = $db->query("SELECT COUNT(*) FROM ".$db->prefix("topics")."");
list($numrows) = $db->fetch_row($result);

if ($numrows>0) {
	OpenTable();
	echo "<form method='post' action='index.php'>";
	echo "<h4>"._AM_ADDSUBTOPIC."</h4><br />";
	echo "<b>"._AM_TOPICNAME."</b> "._AM_MAX40CHAR."<br /><input type='text' class='text' name='topic_title' size='20' maxlength='40' /> "._AM_IN." ";
	$xt->makeTopicSelBox(0, 0, "topic_pid");
	echo "<br /><br />";
	echo "<input type='hidden' name='op' value='addTopic' />";
	echo "<input type='submit' class='button' value='"._ADD."' /><br /></form>";
	CloseTable();
	echo "<br />";

// Modify Topic
	OpenTable();
	echo "
	<form method='post' action='index.php'>
	<h4>"._AM_MODIFYTOPIC."</h4><br />";
	echo "<b>"._AM_TOPIC."</b><br />";
	$xt->makeTopicSelBox();
	echo "<br /><br />";
	echo "<input type='hidden' name='op' value='modTopic' />";
	echo "<input type='submit' class='button' value='"._MODIFY."' />";
	echo "</form>";
	CloseTable();
}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function modTopic() {
global $db, $xoopsConfig, $newsConfig, $xoopsModule, $HTTP_POST_VARS, $HTTP_GET_VARS;

$topic_id = $HTTP_POST_VARS['topic_id'] ? $HTTP_POST_VARS['topic_id'] : $HTTP_GET_VARS['topic_id'];

$xt = new XoopsTopic($db->prefix("topics"), $topic_id);
xoops_cp_header();
OpenTable();

?>
<h4><?php echo _AM_MODIFYTOPIC;?></h4>
<?php
if ($xt->topic_imgurl()) {
	echo "<br /><div style='text-align: right;'><img src='".formatURL(XOOPS_URL."/modules/".$xoopsModule->dirname()."/cache/topics/", $xt->topic_imgurl())."'></div>";
}
?>
<form action="index.php" method="post" enctype="multipart/form-data">
<b><?php echo _AM_TOPICNAME;?></b> <?php echo _AM_MAX40CHAR;?><br />
<input type="text" class="text" name="topic_title" size="30" maxlength="40" value="<?php echo $xt->topic_title();?>" />

<br /><br /><b><?php echo _AM_TOPICIMG;?></b><br />
<input type="text" class="text" name="topic_imgurl" size="30" maxlength="255" value="<?php echo $xt->topic_imgurl();?>" /> :: <input type="file" class="file" name="image" /><br />
<?php printf(_AM_IMGLOCATION, "modules/".$xoopsModule->dirname()."/cache/topics/");?>

<br /><br /><b><?php echo _AM_PARENTTOPIC;?><b><br />
<?php $xt->makeTopicSelBox(1, $xt->topic_pid(), "topic_pid");?>

<br /><br />
<input type="hidden" name="topic_id" value="<?php echo $xt->topic_id();?>" />
<input type="hidden" name="op" value="modTopicS" />
<input type="submit" class="button" value="<?php echo _SAVE;?>" />
<input type="button" class="button" value="<?php echo _DELETE;?>" onclick="location='index.php?topic_pid=<?php echo $xt->topic_pid();?>&amp;topic_id=<?php echo $xt->topic_id();?>&amp;op=delTopic'" />
<input type="button" class="button" value="<?php echo _CANCEL;?>" onclick="javascript:history.go(-1)" />
</form>
<?php

CloseTable();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function modTopicS() {
global $db, $HTTP_POST_VARS, $HTTP_POST_FILES;

$xt = new XoopsTopic($db->prefix("topics"), $HTTP_POST_VARS['topic_id']);

if ( $HTTP_POST_VARS['topic_pid'] == $HTTP_POST_VARS['topic_id'] ) {
	echo "ERROR: Cannot select this topic for parent topic!";
	exit();
}

$xt->setTopicPid($HTTP_POST_VARS['topic_pid']);
$xt->setTopicTitle($HTTP_POST_VARS['topic_title']);
$xt->setTopicImgurl($HTTP_POST_VARS['topic_imgurl']);

if ( !empty($HTTP_POST_FILES['image']['name']) ) {
	include_once(XOOPS_ROOT_PATH."/class/fileupload.php");
	$upload = new fileupload();
	$upload->set_upload_dir(XOOPS_ROOT_PATH."/modules/news/cache/topics/", 'image');
	$upload->set_accepted("gif|jpg|png", 'image');
	$upload->set_overwrite(2, 'image');
	$upload->set_basename($HTTP_POST_VARS['topic_id'], 'image');
	$result = $upload->upload();
	if ($result['image']['filename']) {
		$xt->setTopicImgurl($result['image']['filename']);
		} else {
			redirect_header("index.php?op=topicsmanager", 3, $upload->errors());
			exit();
		}
}

$xt->store();
redirect_header("index.php?op=topicsmanager", 1, _UPDATED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delTopic() {
global $db, $HTTP_POST_VARS, $HTTP_GET_VARS, $xoopsConfig, $xoopsModule;

if ( $HTTP_GET_VARS['ok'] != 1 ) {
	xoops_cp_header();
	OpenTable();
	echo "<h4 style='color: #ff0000'>";
	echo ""._AM_WAYSYWTDTTAL."</h4>";
	echo "<table><tr><td>";
	echo myTextForm("index.php?op=delTopic&topic_id=".$HTTP_GET_VARS['topic_id']."&ok=1",_YES);
	echo "</td><td>";
	echo myTextForm("index.php?op=topicsmanager", _NO);
	echo "</td></tr></table>";
	echo "<br /><br />";
	CloseTable();
	} else {
		$xt = new XoopsTopic($db->prefix("topics"), $HTTP_GET_VARS['topic_id']);
		//get all subtopics under the specified topic
		$topic_arr = $xt->getAllChildTopics();
		array_push($topic_arr, $xt);
		foreach ($topic_arr as $eachtopic) {
			//get all stories in each topic
			$story_arr = NewsStory::getByTopic($eachtopic->topic_id());
			@unlink(XOOPS_ROOT_PATH."/modules/".$xoopsModule->dirname()."/cache/topics/".basename($eachtopic->topic_imgurl()));
			foreach($story_arr as $eachstory) {
				$eachstory->delete();
			}
			//all stories for each topic is deleted, now delete the topic data
			$eachtopic->delete();
		}
		build_rss();
		redirect_header("index.php?op=topicsmanager", 1, _UPDATED);
		exit();
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function addTopic() {
global $db, $HTTP_POST_VARS, $HTTP_POST_FILES;

$xt = new XoopsTopic($db->prefix("topics"));
$xt->setTopicPid($HTTP_POST_VARS['topic_pid']);
$xt->setTopicTitle($HTTP_POST_VARS['topic_title']);

$xt->store();
redirect_header("index.php?op=modTopic&topic_id=".$xt->topic_id(), 1, _UPDATED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function newsConfig() {
global $xoopsConfig, $xoopsModule, $newsConfig;

xoops_cp_header();
OpenTable();

?>
<h4><?php echo _AM_GENERALCONF;?></h4><br />
<form action="index.php" method="post">
<table width="100%" border="0"><tr>

<td nowrap><?php echo _AM_STORYHOME;?></td>
<td width="100%">
<select class="select" name="storyhome">
<option value="<?php echo $newsConfig["storyhome"];?>" selected="selected"><?php echo $newsConfig["storyhome"];?></option>
<option value="1">1</option>
<option value="2">2</option>
<option value="3">3</option>
<option value="5">5</option>
<option value="10">10</option>
<option value="15">15</option>
<option value="20">20</option>
<option value="25">25</option>
<option value="30">30</option>
</select>
</td>

</tr><tr>

<td nowrap><?php echo _AM_ANONSUBMIT;?></td>
<td>
<?php
$chk1 = ""; $chk2 = "";
$chk = ($newsConfig['anonsubmit'] == 1) ?  $chk1 = "checked='checked'" : $chk2 = "checked='checked'";
?>
<input type="radio" class="radio" name="anonsubmit" value="1" <?php echo $chk1;?> /><?php echo _YES;?>
<input type="radio" class="radio" name="anonsubmit" value="0" <?php echo $chk2;?> /><?php echo _NO;?>
</td>

</tr><tr>

<td nowrap><?php echo _AM_NOTIFYSUBMIT;?></td>
<td>
<?php
$chk1 = ""; $chk2 = "";
$chk = ($newsConfig["notifysubmit"] == 1) ?  $chk1 = "checked='checked'" : $chk2 = "checked='checked'";
?>
<input type="radio" class="radio" name="notifysubmit" value="1" <?php echo $chk1;?> /><?php echo _YES;?>
<input type="radio" class="radio" name="notifysubmit" value="0" <?php echo $chk2;?> /><?php echo _NO;?>
</td>

</tr><tr>

<td nowrap><?php echo _AM_DISPLAYNAV;?></td>
<td>
<?php
$chk1 = ""; $chk2 = "";
($newsConfig["displaynav"] == 1) ? $chk1 = "checked='checked'" : $chk2 = "checked='checked'";
?>
<input type="radio" class="radio" name="displaynav" value="1" <?php echo $chk1;?> /><?php echo _YES;?>
<input type="radio" class="radio" name="displaynav" value="0" <?php echo $chk2;?> /><?php echo _NO;?>
</td>

</tr><tr>
<td colspan=2><hr /></td>
</tr><tr>

<?php
$chk1 = ""; $chk2 = "";
($newsConfig["rss_enable"] == 1) ? $chk1 = " checked='checked'" : $chk0 = " checked='checked'";
?>
<td nowrap><?php echo _AM_RSS_ENABLE;?></td>
<td>
<input type="radio" class="radio" name="rss_enable" value="1"<?php echo $chk1;?> /> <?php echo _YES;?>
<input type="radio" class="radio" name="rss_enable" value="0"<?php echo $chk0;?> /> <?php echo _NO;?>
</td>

</tr><tr>

<td nowrap><?php echo _AM_RSS_MAXITEMS;?></td>
<td>
<select class="select" name="rss_maxitems">
<option value="<?php echo $newsConfig["rss_maxitems"];?>" selected="selected"><?php echo $newsConfig["rss_maxitems"];?></option>
<option value="5">5</option>
<option value="10">10</option>
<option value="15">15</option>
<option value="20">20</option>
<option value="25">25</option>
<option value="30">30</option>
</select>
</td>

</tr><tr>

<td nowrap><?php echo _AM_RSS_MAXDESCRIPTION;?></td>
<td>
<select class="select" name="rss_maxdescription">
<option value="<?php echo $newsConfig["rss_maxdescription"];?>" selected="selected"><?php echo $newsConfig["rss_maxdescription"];?></option>
<option value="50">50</option>
<option value="100">100</option>
<option value="150">150</option>
<option value="200">200</option>
<option value="250">250</option>
<option value="300">300</option>
</select>
</td>

</tr></table>
<input type="hidden" name="op" value="newsConfigS" />
<input type="submit" class="button" value="<?php echo _SAVE;?>" />
<input type="button" class="button" value="<?php echo _CANCEL;?>" onclick="javascript:history.go(-1)" />
</form>
<?php

CloseTable();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function newsConfigS() {
global $HTTP_POST_VARS;

$content .= "<?php\n";
$content .= "\$newsConfig['anonsubmit']         = ".intval($HTTP_POST_VARS['anonsubmit']).";\n";
$content .= "\$newsConfig['storyhome']          = ".intval($HTTP_POST_VARS['storyhome']).";\n";
$content .= "\$newsConfig['notifysubmit']       = ".intval($HTTP_POST_VARS['notifysubmit']).";\n";
$content .= "\$newsConfig['displaynav']         = ".intval($HTTP_POST_VARS['displaynav']).";\n";
$content .= "\$newsConfig['rss_enable']         = ".intval($HTTP_POST_VARS['rss_enable']).";\n";
$content .= "\$newsConfig['rss_maxitems']       = ".intval($HTTP_POST_VARS['rss_maxitems']).";\n";
$content .= "\$newsConfig['rss_maxdescription'] = ".intval($HTTP_POST_VARS['rss_maxdescription']).";\n";
$content .= "?>";

$filename = "../cache/config.php";
if ( $file = fopen($filename, "w") ) {
	fwrite($file, $content);
	fclose($file);
	} else {
		redirect_header("index.php?op=newsConfig", 1, _NOTUPDATED);
		exit();
	}

redirect_header("index.php", 1, _UPDATED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function build_rss() {
global $db, $newsConfig;

if ($newsConfig['rss_enable'] == 1) {

$SQL = "SELECT title, storyid, hometext FROM ".$db->prefix("stories")." WHERE published>0 AND published<".(time()+10)." ORDER BY published DESC";

$query = $db->query($SQL, $newsConfig['rss_maxitems']);

if ($query) {
	include_once(XOOPS_ROOT_PATH . "/class/xml-rss.php");
	$rss = new xml_rss('../cache/news.xml');
	$rss->channel_title .= " :: "._MI_NEWS_NAME;
	$rss->image_title   .= " :: "._MI_NEWS_NAME;
	$rss->max_items            = $newsConfig['rss_maxitems'];
	$rss->max_item_description = $newsConfig['rss_maxdescription'];

	while ( list($title, $link, $description) = $db->fetch_row($query) ) {
		$link = XOOPS_URL . '/modules/news/article.php?storyid=' . $link;
		$rss->build($title, $link, $description);
		}
$rss->save();
	}
}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
$op = !empty($HTTP_POST_VARS['op']) ? $HTTP_POST_VARS['op'] : $HTTP_GET_VARS['op'];

switch($op) {

case "edit":
	xoops_cp_header();
	OpenTable();
	echo "<h4>"._AM_EDITARTICLE."</h4>";
	$story         = new NewsStory($storyid);
	$title         = $story->title("Edit");
	$hometext      = $story->hometext("Edit");
	$bodytext      = $story->bodytext("Edit");
	$allow_html    = intval($story->allow_html());
	$allow_smileys = intval($story->allow_smileys());
	$allow_bbcode  = intval($story->allow_bbcode());
	$ihome         = intval($story->ihome());
	$topicid       = intval($story->topicid());
	$published     = $story->published();
	$type          = $story->type();
	$topicdisplay  = $story->topicdisplay();
	$topicalign    = $story->topicalign(false);
	$isedit        = 1;
	include_once("storyform.inc.php");
	CloseTable();
	break;

case "newarticle":
	xoops_cp_header();
	newSubmissions();
	autoStories();
	lastStories();
	echo "<br />";
	OpenTable();
	echo "<h4>"._AM_POSTNEWARTICLE."</h4>";
	$type = 'admin';
	include_once("storyform.inc.php");
	CloseTable();
	break;

case "preview":
	xoops_cp_header();
	if (isset($storyid)) {
		$story = new NewsStory($storyid);
		$published = $story->published();
		} else {
			$story = new NewsStory();
		}
	$story->setTitle($HTTP_POST_VARS['title']);
	$story->setHomeText($HTTP_POST_VARS['hometext']);
	$story->setBodyText($HTTP_POST_VARS['bodytext']);
	$story->setHtml($HTTP_POST_VARS['allow_html']);
	$story->setSmileys($HTTP_POST_VARS['allow_smileys']);
	$story->setBBcode($HTTP_POST_VARS['allow_bbcode']);
	$story->setTopicalign($HTTP_POST_VARS['topicalign']);
	$story->setType($HTTP_POST_VARS['type']);
	$story->setTopicdisplay(intval($HTTP_POST_VARS['topicdisplay']));
	$autohour   = $HTTP_POST_VARS['autohour'];
	$automin    = $HTTP_POST_VARS['automin'];
	$automonth  = $HTTP_POST_VARS['automonth'];
	$autoday    = $HTTP_POST_VARS['autoday'];
	$autoyear   = $HTTP_POST_VARS['autoyear'];
	$xt         = new XoopsTopic($db->prefix("topics"));
	$p_title    = $story->title("Preview");
	$p_hometext = $story->hometext("Preview");
	$p_bodytext = $story->bodytext("Preview");
	$title      = $story->title("InForm");
	$hometext   = $story->hometext("InForm");
	$bodytext   = $story->bodytext("InForm");
	OpenTable();
	OpenTable("70%");
	if ($topicdisplay) {
		if ($topicalign == "L") {
			$align = "left";
			} else {
				$align = "right";
			}
		if ( empty($topicid) ) {
			$warning = "<div style='text-align: center;'><blink><b>"._AR_SELECTTOPIC."</b></blink></div>";
			$timage  = "";
			} else {
				$xt      = new XoopsTopic($db->prefix("topics"), $topicid);
				$warning = "";
				if ($xt->topic_imgurl()) {
					$timage  = "<img src='".formatURL(XOOPS_URL."/modules/news/cache/topics/", $xt->topic_imgurl())."' align='$align' border='0' hspace='10' vspace=10' alt='".$xt->topic_title("P")."' />";
				}
			}
		} else {
			$timage = "";
		}
	if ( !empty($p_bodytext) ) {
		echo "<b>".$p_title."</b><br /><br />".$timage."".$p_hometext."<br /><br />".$p_bodytext."<br /><br />";
		} else {
			echo "<b>".$p_title."</b><br /><br />".$timage."".$p_hometext."<br /><br />";
		}
	echo $warning;
	CloseTable();
	include_once("storyform.inc.php");
	CloseTable();
	break;

case "save":
	if ( empty($storyid) ) {
		$story = new NewsStory();
		$story->setUid($xoopsUser->uid());
		if ( $autodate ) {
			$pubdate   = mktime($HTTP_POST_VARS['autohour'], $HTTP_POST_VARS['automin'], 0, $HTTP_POST_VARS['automonth'], $HTTP_POST_VARS['autoday'], $HTTP_POST_VARS['autoyear']);
			$offset    = $xoopsUser->timezone() - $xoopsConfig['server_TZ'];
			$pubdate   = ($pubdate - ($offset * 3600));
			$story->setPublished($pubdate);
			} else {
				$story->setPublished(time());
			}
		$story->setType($HTTP_POST_VARS['type']);
		$story->setHostname(_REMOTE_ADDR);
		} else {
			$story = new NewsStory($storyid);
			if ( !empty($autodate) ) {
				$pubdate = mktime($autohour, $automin, 0, $automonth, $autoday, $autoyear);
				$offset  = $xoopsUser->timezone();
				$offset  = ($offset - $xoopsConfig['server_TZ']);
				$pubdate = ($pubdate - ($offset * 3600));
				$story->setPublished($pubdate);
				} elseif ( ($story->published() == 0) && ($approve == 1) ) {
					$story->setPublished(time());
					$isnew = 1;
					} else {
						if ( !empty($movetotop) ) {
							$story->setPublished(time());
						}
					}
		}
	$story->setApproved($HTTP_POST_VARS['approve']);
	$story->setTopicId($HTTP_POST_VARS['topicid']);
	$story->setTitle($HTTP_POST_VARS['title']);
	$story->setHometext($HTTP_POST_VARS['hometext']);
	$story->setBodytext($HTTP_POST_VARS['bodytext']);
	$story->setHtml($HTTP_POST_VARS['allow_html']);
	$story->setSmileys($HTTP_POST_VARS['allow_smileys']);
	$story->setBBcode($HTTP_POST_VARS['allow_bbcode']);
	$story->setIhome($HTTP_POST_VARS['ihome']);
	$story->setTopicalign($HTTP_POST_VARS['topicalign']);
	$story->setTopicdisplay(intval($HTTP_POST_VARS['topicdisplay']));
	$story->store();
	if ( !empty($isnew) && $story->notifypub() && $story->uid() != 0 ) {
		$poster   = new XoopsUser($story->uid());
		$subject  = _AM_ARTPUBLISHED;
		$message  = sprintf(_AM_HELLO, $poster->uname());
		$message .= "\n\n"._AM_YOURARTPUB."\n\n";
		$message .= _AM_TITLEC.$story->title()."\n"._AM_URLC.XOOPS_URL."/modules/".$xoopsModule->dirname()."/article.php?storyid=".$story->storyid()."\n"._AM_PUBLISHEDC.formatTimestamp($story->published(),"m",0)."\n\n";
		$message .= $meta['title']."\n".XOOPS_URL."";

		$xoopsMailer =& getMailer();
		$xoopsMailer->useMail();
		$xoopsMailer->setToEmails($poster->getVar("email"));
		$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
		$xoopsMailer->setFromName($meta['title']);
		$xoopsMailer->setSubject($subject);
		$xoopsMailer->setBody($message);
		$xoopsMailer->send();
	}
	build_rss();
	redirect_header("index.php?op=newarticle", 1, _UPDATED);
	exit();
	break;

case "delete":
	if ( $ok ) {
		$story = new NewsStory($storyid);
		$story->delete();
		build_rss();
		redirect_header("index.php?op=newarticle", 1, _UPDATED);
		exit();
		} else {
			xoops_cp_header();
			OpenTable();
			echo "<h4 style='color:#ff0000'>"._AM_RUSUREDEL."</h4>";
			echo "<table><tr><td>";
			echo myTextForm("index.php?op=delete&storyid=".$storyid."&ok=1" , _YES);
			echo "</td><td>";
			echo myTextForm("javascript:history.go(-1)" , _NO);
			echo "</td></tr></table>";
			CloseTable();
		}
	break;

case "topicsmanager":
	topicsmanager();
	break;

case "addTopic":
	addTopic();
	break;

case "delTopic":
	delTopic();
	break;

case "modTopic":
	modTopic();
	break;

case "modTopicS":
	modTopicS();
	break;

case "newsConfig":
	newsConfig();
	break;

case "newsConfigS":
	newsConfigS();
	break;

default:
	xoops_cp_header();
	OpenTable();
	echo " - <b><a href='index.php?op=newsConfig'>"._AM_GENERALCONF."</a></b><br /><br />";
	echo " - <b><a href='index.php?op=topicsmanager'>"._AM_TOPICSMNGR."</a></b>";
	echo "<br /><br />";
	echo " - <b><a href='index.php?op=newarticle'>"._AM_PEARTICLES."</a></b>";
	CloseTable();
	break;
}

xoops_cp_footer();
?>
