<?php
// $Id: index.php,v 1.1 2004/07/11 10:28:10 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: James Knickelbein
// Author Website : http://www.journeymilwaukee.com
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

include_once("admin_header.php");

$eh     = new ErrorHandler(0);
$mytree = new XoopsTree($db->prefix("mydownloads_cat"), "cid", "pid");

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function mydownloads() {
global $db;

xoops_cp_header();
OpenTable();

// Temporarily 'homeless' downloads (to be revised in index.php breakup)
$result = $db->query("SELECT COUNT(*) FROM ".$db->prefix("mydownloads_broken")."");
list($totalbrokendownloads) = $db->fetch_row($result);
if ($totalbrokendownloads > 0) {
	$totalbrokendownloads = "<span style='font-weight: bold'>$totalbrokendownloads</span>";
}

$result2 = $db->query("SELECT COUNT(*) FROM ".$db->prefix("mydownloads_mod")."");
list($totalmodrequests) = $db->fetch_row($result2);
if ($totalmodrequests > 0) {
	$totalmodrequests = "<span style='font-weight: bold'>$totalmodrequests</span>";
}

$result3 = $db->query("SELECT COUNT(*) FROM ".$db->prefix("mydownloads_downloads")." WHERE status=0");
list($totalnewdownloads) = $db->fetch_row($result3);
if ($totalnewdownloads > 0) {
	$totalnewdownloads = "<span style='font-weight: bold'>$totalnewdownloads</span>";
}

?>
- <a href="index.php?op=mydownloadsConfigAdmin"><?php echo _MD_GENERALSET;?></a>
<br /><br />
- <a href="index.php?op=downloadsConfigMenu"><?php echo _MD_ADDMODDELETE;?></a>
<br /><br />
- <a href="index.php?op=listNewDownloads"><?php echo _MD_DLSWAITING;?> (<?php echo $totalnewdownloads;?>)</a>
<br /><br />
- <a href="index.php?op=listBrokenDownloads"><?php echo _MD_BROKENREPORTS;?> (<?php echo $totalbrokendownloads;?>)</a>
<br /><br />
- <a href="index.php?op=listModReq"><?php echo _MD_MODREQUESTS;?> (<?php echo $totalmodrequests;?>)</a>
<?php

$result = $db->query("SELECT COUNT(*) FROM ".$db->prefix("mydownloads_downloads")." WHERE status>0");
list($numrows) = $db->fetch_row($result);
echo "<br /><br /><div align='center'>";
printf(_MD_THEREARE, $numrows);
echo "</div>";

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function listNewDownloads() {
global $db, $myts, $eh, $mytree, $xoopsConfig;

// List downloads waiting for validation
$result  = $db->query("SELECT lid, cid, title, description, url, homepage, version, size, platform, logourl, submitter FROM ".$db->prefix("mydownloads_downloads")." WHERE status=0 ORDER BY date DESC");
$numrows = $db->num_rows($result);

xoops_cp_header();
OpenTable();

echo "<h4><a href='index.php'>"._MAIN."</a>: "._MD_DLSWAITING." ($numrows)</h4><br />";

if ($numrows > 0) {
	while (list($lid, $cid, $title, $description, $url, $homepage, $version, $size, $platform, $logourl, $uid) = $db->fetch_row($result)) {
		$title       = $myts->makeTboxData4Edit($title);
		$url         = $myts->makeTboxData4Edit($url);
		$homepage    = $myts->makeTboxData4Edit($homepage);
		$version     = $myts->makeTboxData4Edit($version);
		$size        = $myts->makeTboxData4Edit($size);
		$platform    = $myts->makeTboxData4Edit($platform);
		$description = $myts->makeTboxData4Edit($description);
		if ($uid != 0) {
			$submitter = XoopsUser::getUnameFromId($uid);
			$submitter = $myts->makeTboxData4Show($submitter);
			} else {
				$submitter = $myts->makeTboxData4Show($xoopsConfig['anonymous']);
			}

?>
<form action="index.php" method="post">
<table width="100%">
<tr><td nowrap><?php echo _MD_SUBMITTER;?></td>
<td><a href="<?php echo XOOPS_URL;?>/userinfo.php?uid=<?php echo $uid;?>"><?php echo $submitter;?></a></td>
</tr><tr>
<td nowrap><?php echo _MD_FILETITLE;?></td>
<td><input type="text" class="text" name="title" size="50" maxlength="100" value="<?php echo $title;?>"></td>
</tr><tr>
<td nowrap><?php echo _MD_DLURL;?></td>
<td><input type="text" class="text" name="url" size="50" maxlength="255" value="<?php echo $url;?>"> [ <a href="<?php echo formatURL(XOOPS_URL."/modules/mydownloads/cache/files/", $url);?>" target="_blank"><?php echo _MD_DOWNLOAD;?></a> ]</td>
</tr><tr>
<td nowrap><?php echo _MD_CATEGORYC;?></td>
<td><?php $mytree->makeMySelBox("title", "title", $cid);?></td>
</tr><tr>
<td nowrap><?php echo _MD_SITEURL;?></td>
<td><input type="text" class="text" name="homepage" size="50" maxlength="255" value="<?php echo $homepage;?>"> [ <a href="<?php echo $homepage;?>" target="_blank"><?php echo _MD_VISIT;?></a> ]</td>
</tr><tr>
<td><?php echo _MD_VERSIONC;?></td>
<td><input type="text" class="text" name="version" size="10" maxlength="10" value="<?php echo $version;?>"></td>
</tr><tr>
<td><?php echo _MD_FILESIZEC;?></td>
<td><input type="text" class="text" name="size" size="10" maxlength="8" value="<?php echo $size;?>"> <?php echo _BYTES;?></td>
</tr><tr>
<td><?php echo _MD_PLATFORMC;?></td>
<td><input type="text" class="text" name="platform" size="45" maxlength="50" value="<?php echo $platform;?>"></td>
</tr><tr>
<td valign="top" nowrap><?php echo _MD_DESCRIPTIONC;?></td>
<td>
<?php
$desc = new XoopsFormDhtmlTextArea('', 'filedesc', $description, 10, 50);
echo $desc->render();
?>
</td>
</tr><tr>
<td align="right">
<input type="hidden" name="op" value="approve">
<input type="hidden" name="lid" value="<?php echo $lid;?>">
<input type="submit" class="button" value="<?php echo _MD_APPROVE;?>">
</form></td>
<td align="left"><?php echo myTextForm("index.php?op=delNewDownload&lid=$lid", _DELETE);?></td>
</tr></table>
<?php

	}
	} else {
		echo _MD_NOSUBMITTED;
	}

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function downloadsConfigMenu() {
global $db, $myts, $eh, $mytree;

xoops_cp_header();

$result=$db->query("SELECT COUNT(*) FROM ".$db->prefix("mydownloads_cat")."");
list($numrows) = $db->fetch_row($result);

if ($numrows > 0) {
	OpenTable();
	// If there is a category, add a New Download

$upload = new fileupload();

?>
<form method="post" action="index.php" enctype="multipart/form-data">
<h4><a href="index.php"><?php echo _MAIN;?></a>: <?php echo _MD_ADDNEWFILE;?></h4><br />
<table width="100%"><tr>
<td><?php echo _MD_FILETITLE;?></td>
<td><input type="text" class="text" name="title" size="50" maxlength="100" /></td>
</tr><tr>
<td valign="top" nowrap><?php echo _MD_DLURL;?></td>
<td>
<input type="text" class="text" name="url" size="50" maxlength="255" />
<?php
echo "<br />";
$upload->render(1, "download");
?>
</td>
</tr><tr>
<td>&nbsp;</td>
<td><?php printf(_MD_FILE, "modules/mydownloads/cache/files/");?></td>
</tr><tr>
<td nowrap><?php echo _MD_CATEGORYC;?></td>
<td><?php $mytree->makeMySelBox("title", "title");?></td>
</tr><tr>
<td nowrap><?php echo _MD_SITEURL;?></td>
<td><input type="text" class="text" name="homepage" size="50" maxlength="255" value="http://"></td>
</tr><tr>
<td><?php echo _MD_VERSIONC;?></td>
<td><input type="text" class="text" name="version" size="10" maxlength="10"></td>
</tr><tr>
<td><?php echo _MD_FILESIZEC;?></td>
<td><input type="text" class="text" name="size" size="10" maxlength="100"> <?php echo _BYTES;?></td>
</tr><tr>
<td><?php echo _MD_PLATFORMC;?></td>
<td><input type="text" class="text" name="platform" size="45" maxlength="60"></td>
</tr><tr>
<td valign="top" nowrap><?php echo _MD_DESCRIPTIONC;?></td>
<td>
<?php
$desc = new XoopsFormDhtmlTextArea('', 'filedesc', '', 10, 50);
echo $desc->render();
?>
</td>
</tr><tr>
<td valign="top" nowrap><?php echo _MD_SHOTIMAGE;?></td>
<td>
<input type="text" class="text" name="logourl" size="50" maxlength="255">
<?php
echo "<br />";
$upload->render(1, "image");
?>
</td>
</tr><tr>
<td>&nbsp;</td>
<td><?php printf(_MD_SHOT, "modules/mydownloads/cache/images/shots/");?></td>
</tr></table>
<br />
<input type="hidden" name="op" value="addDownload" />
<input type="submit" class="button" value="<?php echo _ADD;?>" />
</form>
<?php

CloseTable();
echo "<br />";
OpenTable();
// Modify Download

?>
<form method="post" action="index.php">
<h4><?php echo _MD_MODDL;?></h4>
<?php echo _MD_FILEID;?>
<input type="text" class="text" name="lid" size="12" maxlength="11">
<input type="hidden" name="fct" value="mydownloads">
<input type="hidden" name="op" value="modDownload">
<input type="submit" class="button" value="<?php echo _MD_MODIFY;?>">
</form>
<?php

CloseTable();
echo "<br />";
OpenTable();
// Modify Category

?>
<form method="post" action="index.php">
<h4><?php echo _MD_MODCAT;?></h4>
<?php echo _MD_CATEGORYC;?>
<?php $mytree->makeMySelBox("title", "title");?>
<input type="hidden" name="op" value="modCat">
<input type="submit" class="button" value="<?php echo _MD_MODIFY;?>">
</form>
<?php

CloseTable();
echo "<br />";
OpenTable();
// Add a New Sub-Category

?>
<form method="post" action="index.php">
<h4><?php echo _MD_ADDSUB;?></h4>
<?php echo _MD_TITLEC;?>
<input type="text" class="text" name="title" size="30" maxlength="50">
<?php echo _MD_IN;?>
<?php $mytree->makeMySelBox("title", "title");?>
<input type="hidden" name="op" value="addCat">
<input type="submit" class="button" value="<?php echo _ADD;?>">
</form>
<?php

CloseTable();
echo "<br />";
}

// Add a New Main Category
OpenTable();

?>
<form method="post" action="index.php">
<h4><?php echo _MD_ADDMAIN;?></h4>
<?php echo _MD_TITLEC;?>
<input type="text" class="text" name="title" size="30" maxlength="50">
<input type="hidden" name="op" value="addCat">
<input type="submit" class="button" value="<?php echo _ADD;?>">
</form>
<?php

CloseTable();
xoops_cp_footer();
}



//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delVote() {
global $db, $HTTP_GET_VARS, $eh;

$rid = intval($HTTP_GET_VARS['rid']);
$lid = intval($HTTP_GET_VARS['lid']);

$query = "DELETE FROM ".$db->prefix("mydownloads_votedata")." WHERE ratingid=$rid";
$db->query($query) or $eh->show("0013");

updaterating($lid);
redirect_header("index.php", 1, _MD_VOTEDELETED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function listBrokenDownloads() {
global $db, $myts, $eh, $xoopsConfig;

$result = $db->query("SELECT reportid, lid, sender, ip FROM ".$db->prefix("mydownloads_broken")." ORDER BY reportid");
$totalbrokendownloads = $db->num_rows($result);

xoops_cp_header();
OpenTable();
echo "<h4><a href='index.php'>"._MAIN."</a>: "._MD_BROKENREPORTS." ($totalbrokendownloads)</h4><br />";

if ($totalbrokendownloads == 0) {
	echo _MD_NOBROKEN;
	} else {
		$colorswitch = "bg1";
		?>
		<center><?php echo _MD_IGNOREDESC;?><br /><?php echo _MD_DELETEDESC;?></center>
		<br /><br /><br />
		<table align="center" width="90%"><tr>
		<td><b><?php echo _MD_FILETITLE;?></b></td>
		<td><b><?php echo _MD_REPORTER;?></b></td>
		<td><b><?php echo _MD_FILESUBMITTER;?></b></td>
		<td><b><?php echo _MD_IGNORE;?></b></td>
		<td><b><?php echo _EDIT;?></b></td>
		<td><b><?php echo _DELETE;?></b></td>
		</tr>
		<?php

while (list($reportid, $lid, $senderid, $ip) = $db->fetch_row($result)) {
	$result2 = $db->query("SELECT title, url, submitter FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid");
	list($title, $url, $ownerid) = $db->fetch_row($result2);
	$title = $myts->makeTboxData4Show($title);

	if ($senderid != 0) {
		$sender = XoopsUser::getUnameFromId($senderid);
		$sender = $myts->makeTboxData4Show($sender);
		} else {
			$sender = $myts->makeTboxData4Show($xoopsConfig['anonymous']);
		}

	if ($ownerid != 0) {
		$owner = XoopsUser::getUnameFromId($ownerid);
		$owner = $myts->makeTboxData4Show($owner);
		} else {
			$owner = $myts->makeTboxData4Show($xoopsConfig['anonymous']);
		}

	echo "
	<tr>
	<td class='$colorswitch'><a href='".formatURL(XOOPS_URL."/modules/mydownloads/cache/files/", $url)."' target='_blank'>$title</a></td>
	<td class='$colorswitch'><a href='".XOOPS_URL."/userinfo.php?uid=$senderid' target='_blank'>$sender</a> ($ip)</td>
	<td class='$colorswitch'><a href='".XOOPS_URL."/userinfo.php?uid=$ownerid' target='_blank'>$owner</a></td>
	<td class='$colorswitch' align='center'>";

	echo myTextForm("index.php?op=ignoreBrokenDownloads&lid=$lid" , "X");
	echo "</td><td class='$colorswitch' align='center'>";
	echo myTextForm("index.php?op=modDownload&lid=$lid" , "X");
	echo "</td><td class='$colorswitch' align='center'>";
	echo myTextForm("index.php?op=delBrokenDownloads&lid=$lid" , "X");
	echo "</td></tr>";
	if ($colorswitch == "bg1") {
		$colorswitch = "bg3";
		} else {
			$colorswitch="bg1";
		}
	}
	echo "</table>";
}

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delBrokenDownloads() {
global $db, $HTTP_GET_VARS, $eh;

$lid = intval($HTTP_GET_VARS['lid']);

$query = "DELETE FROM ".$db->prefix("mydownloads_broken")." WHERE lid=$lid";
$db->query($query) or $eh->show("0013");

$query  = "SELECT url, logourl FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid";
$result = $db->query($query);
list($url, $logourl) = $db->fetch_row($result);
@unlink("../cache/files/" . basename($url));
@unlink("../cache/shots/" . basename($logourl));

$query = "DELETE FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid";
$db->query($query) or $eh->show("0013");

build_rss();
redirect_header("./index.php?op=listBrokenDownloads", 1, _MD_FILEDELETED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function ignoreBrokenDownloads() {
global $db, $HTTP_GET_VARS, $eh;

$lid   = intval($HTTP_GET_VARS['lid']);
$query = "DELETE FROM ".$db->prefix("mydownloads_broken")." WHERE lid=$lid";
$db->query($query) or $eh->show("0013");

redirect_header("./index.php?op=listBrokenDownloads", 1, _MD_BROKENDELETED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function listModReq() {
global $db, $myts, $eh, $mytree, $mydownloadsConfig;

xoops_cp_header();
OpenTable();

$sql_mod = $db->query("SELECT requestid, lid, cid, title, description, url, homepage, version, size, platform, modifysubmitter FROM ".$db->prefix("mydownloads_mod")." ORDER BY requestid");

$totalmodrequests = $db->num_rows($sql_mod);
echo "<h4><a href='index.php'>"._MAIN."</a>: "._MD_USERMODREQ." ($totalmodrequests)</h4><br />";

if ($totalmodrequests > 0) {
	while (list($requestid, $lid, $cid, $title, $description, $url, $homepage, $version, $size, $platform, $modifysubmitter) = $db->fetch_row($sql_mod)) {
		$cidtitle      = $mytree->getNicePathFromId($cid, "title", XOOPS_URL."/modules/mydownloads/viewcat.php?");
		$cidtitle      = substr($cidtitle, 0, -2);
		$title         = $myts->makeTboxData4Show($title);
		$url           = formatURL(XOOPS_URL."/modules/mydownloads/cache/files/", $myts->makeTboxData4Show($url));
		$homepage      = $myts->makeTboxData4Show($homepage);
		$version       = $myts->makeTboxData4Show($version);
		$size          = $myts->makeTboxData4Show($size);
		$platform      = $myts->makeTboxData4Show($platform);
		$description   = $myts->makeTareaData4Show($description);
		if ($modifysubmitter != 0) {
			$submittername = XoopsUser::getUnameFromId($modifysubmitter);
			$submittername = $myts->makeTareaData4Show($submittername);
		}

		$sql_original = $db->query("SELECT cid, title, description, url, homepage, version, size, platform, submitter FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid");
		list($origcid, $origtitle, $origdescription, $origurl, $orighomepage, $origversion, $origsize, $origplatform, $owner) = $db->fetch_row($sql_original);
		$origcidtitle    = $mytree->getNicePathFromId($origcid, "title", XOOPS_URL."/modules/mydownloads/viewcat.php?");
		$origcidtitle    = substr($origcidtitle, 0, -2);
		$origtitle       = $myts->makeTboxData4Show($origtitle);
		$origurl         = formatURL(XOOPS_URL."/modules/mydownloads/cache/files/", $myts->makeTboxData4Show($origurl));
		$orighomepage    = $myts->makeTboxData4Show($orighomepage);
		$origversion     = $myts->makeTboxData4Show($origversion);
		$origsize        = $myts->makeTboxData4Show($origsize);
		$origplatform    = $myts->makeTboxData4Show($origplatform);
		$origdescription = $myts->makeTareaData4Show($origdescription);
		if ($owner != 0) {
			$ownername       = XoopsUser::getUnameFromId($owner);
			$ownername       = $myts->makeTareaData4Show($ownername);
		}

?>
<hr align="center" size="1" noshade="noshade" />
<table width="100%" cellspacing="0" cellpadding="0"><tr>

<td valign="top"><small><?php echo _MD_REQUESTID;?></small></td>
<td valign="top"><b><?php echo $requestid;?></b></td>
</tr><tr>
<td valign="top"><b><?php echo _MD_PROPOSED;?></b></td>
<td width="50%" rowspan="8" valign="top"><?php echo _MD_DESCRIPTIONC;?><br /><?php echo $description;?></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_FILETITLE;?> <?php echo $title;?></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_DLURL;?> <a href="<?php echo $url;?>" target="_blank"><?php echo $url;?></a></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_CATEGORYC;?> <?php echo $cidtitle;?></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_SITEURL;?> <a href="<?php echo $homepage;?>" target="_blank"><?php echo $homepage;?></a></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_VERSIONC;?> <?php echo $version;?></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_FILESIZEC;?> <?php echo $size;?></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_PLATFORMC;?> <?php echo $platform;?></small></td>
</tr><tr>

<td colspan="2">&nbsp;</td>
</tr><tr>

<td valign="top"><b><?php echo _MD_ORIGINAL;?></b></td>
<td width="50%" rowspan="8" valign="top"><?php echo _MD_DESCRIPTIONC;?><br /><?php echo $origdescription;?></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_FILETITLE;?> <?php echo $origtitle;?></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_DLURL;?> <a href="<?php echo $origurl;?>" target="_blank"><?php echo $origurl;?></a></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_CATEGORYC;?> <?php echo $origcidtitle;?></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_SITEURL;?> <a href="<?php echo $orighomepage;?>" target="_blank"><?php echo $orighomepage;?></a></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_VERSIONC;?> <?php echo $origversion;?></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_FILESIZEC;?> <?php echo $origsize;?></small></td>
</tr><tr>
<td valign="top"><small><?php echo _MD_PLATFORMC;?> <?php echo $origplatform;?></small></td>
</tr><tr align="center">

<td colspan="2">
<br />
<table width="100%" border="0" cellspacing="0" cellpadding="0"><tr>
<td valign="top" width="35%"><small><?php echo _MD_SUBMITTER;?> <a href="<?php echo XOOPS_URL;?>/userinfo.php?uid=<?php echo $modifysubmitter;?>" target="_blank"><?php echo $submittername;?></a></small></td>
<td valign="top" width="35%"><small><?php echo _MD_OWNER;?> <a href="<?php echo XOOPS_URL;?>/userinfo.php?uid=<?php echo $owner;?>" target="_blank"><?php echo $ownername;?></a></small></td>

<td valign="top" width="5%"><?php echo myTextForm("index.php?op=changeModReq&requestid=$requestid" , _MD_APPROVE);?></td>
<td valign="top" width="5%"><?php echo myTextForm("index.php?op=modDownload&lid=$lid" , _EDIT);?></td>
<td valign="top" width="5%"><?php echo myTextForm("index.php?op=ignoreModReq&requestid=$requestid", _MD_IGNORE);?></td>
</tr></table>
</td>
</tr></table>
<?php

	}
	} else {
		echo _MD_NOMODREQ;
	}

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function changeModReq() {
global $db, $HTTP_GET_VARS, $eh, $myts;

$requestid = intval($HTTP_GET_VARS['requestid']);

$sql = "SELECT
	lid,
	cid,
	title,
	url,
	homepage,
	version,
	size,
	platform,
	description
	FROM ".$db->prefix("mydownloads_mod")."
	WHERE requestid=$requestid";

$result = $db->query($sql);
list($lid, $cid, $title, $url, $homepage, $version, $size, $platform, $description) = $db->fetch_row($result);
$title       = $myts->oopsAddSlashesRT($title);
$url         = $myts->oopsAddSlashesRT($url);
$homepage    = $myts->oopsAddSlashesRT($homepage);
$description = $myts->oopsAddSlashesRT($description);
$platform    = $myts->oopsAddSlashesRT($platform);


$sql = "UPDATE ".$db->prefix("mydownloads_downloads")." SET
	cid=$cid,
	title='$title',
	description='$description',
	url='$url',
	homepage='$homepage',
	version='$version',
	size='$size',
	platform='$platform',
	status=2,
	date=".time()."
	WHERE lid=$lid";
$db->query($sql) or $eh->show("0013");


$db->query("DELETE FROM ".$db->prefix("mydownloads_mod")." WHERE requestid=$requestid") or $eh->show("0013");
redirect_header("index.php?op=listModReq", 1, _UPDATED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function ignoreModReq() {
global $db, $HTTP_GET_VARS, $eh;

$requestid = intval($HTTP_GET_VARS['requestid']);
$query     = "DELETE FROM ".$db->prefix("mydownloads_mod")." WHERE requestid=$requestid";
$db->query($query) or $eh->show("0013");

redirect_header("./index.php?op=listModReq", 1, _MD_MODREQDELETED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delDownload() {
global $db, $HTTP_GET_VARS, $eh;

$lid = intval($HTTP_GET_VARS['lid']);

$query  = "SELECT url, logourl FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid";
$result = $db->query($query);
list($url, $logourl) = $db->fetch_row($result);
@unlink("../cache/files/" . basename($url));
@unlink("../cache/shots/" . basename($logourl));

$query = "DELETE FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid";
$db->query($query) or $eh->show("0013");

$query = "DELETE FROM ".$db->prefix("mydownloads_votedata")." WHERE lid=$lid";
$db->query($query) or $eh->show("0013");

build_rss();
redirect_header("index.php", 1, _MD_FILEDELETED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function modCat() {
global $db, $xoopsModule, $HTTP_POST_VARS, $HTTP_GET_VARS, $myts, $eh, $mytree;

$cid = !empty($HTTP_POST_VARS["cid"]) ? intval($HTTP_POST_VARS["cid"]) : intval($HTTP_GET_VARS["cid"]);

xoops_cp_header();
OpenTable();
echo "<h4><a href='index.php'>"._MAIN."</a>: "._MD_MODCAT."</h4><br />";

$result = $db->query("SELECT pid, title, imgurl, description FROM ".$db->prefix("mydownloads_cat")." WHERE cid=$cid");

global $desc;
list($pid, $title, $imgurl, $description) = $db->fetch_row($result);
$title  = $myts->makeTboxData4Edit($title);
$imgurl = $myts->makeTboxData4Edit($imgurl);
$desc   = $myts->makeTboxData4Edit($description);

?>
<form action="./index.php" method="post" enctype="multipart/form-data">
<?php echo _MD_TITLEC;?><br />
<input type="text" class="text" name="title" value="<?php echo $title;?>" size="51" maxlength="50">

<br /><br />
<input type="text" class="text" name="imgurl" value="<?php echo $imgurl;?>" size="51" maxlength="255"><br />
<?php
$upload = new fileupload();
$upload->set_basename($cid, 'image');
$upload->render(1, 'image');
echo "<br />".sprintf(_AM_IMGLOCATION, "modules/".$xoopsModule->dirname()."/cache/logos/");
?>

<br /><br />
<?php echo _MD_DESCRIPTION;?>:<br />
<?php
$desc = new XoopsFormDhtmlTextArea('', 'desc', $desc, 10, 50);
echo $desc->render();
?>
<br /><br />
<?php echo _MD_PARENT;?><br />
<?php $mytree->makeMySelBox("title", "title", $pid, 1, "pid");?>
<br /><br />
<input type="hidden" name="cid" value="<?php echo $cid;?>" />
<input type="hidden" name="op" value="modCatS" /><br />
<input type="submit" class="button" value="<?php echo _SAVE;?>" />
<input type="button" class="button" value="<?php echo _DELETE;?>" onclick="location='index.php?pid=<?php echo $pid;?>&cid=<?php echo $cid;?>&op=delCat';" />
<input type="button" class="button" value="<?php echo _CANCEL;?>" onclick="location='index.php';" />
</form>
<?php

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function modCatS() {
global $db, $myts, $HTTP_POST_VARS, $HTTP_POST_FILES;

$cid         = intval($HTTP_POST_VARS['cid']);
$pid         = intval($HTTP_POST_VARS['pid']);
$imgurl      = $myts->makeTboxData4Save($HTTP_POST_VARS['imgurl']);
$title       = $myts->makeTboxData4Save($HTTP_POST_VARS['title']);
$description = $myts->makeTboxData4Save($HTTP_POST_VARS['desc']);

if ( !empty($HTTP_POST_FILES['image']['name']) ) {
	$upload = new fileupload();
	$upload->set_upload_dir("../cache/logos/");
	$upload->set_accepted("gif|jpg|png");
	$upload->set_overwrite(2);
	$result = $upload->upload();
	if ($result['image']) {
		$imgurl = $result['image']['filename'];
		} else {
			redirect_header("index.php?op=modCat&cid=$cid", 3, $upload->errors());
			exit();
		}
}

$db->query("UPDATE ".$db->prefix("mydownloads_cat")." SET title='$title', imgurl='$imgurl', pid='$pid', description='$description' WHERE cid=$cid");

build_rss();
redirect_header("index.php?op=modCat&cid=$cid", 1, _UPDATED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function addCat() {
global $db, $HTTP_POST_VARS, $myts, $eh;

$pid   = intval($HTTP_POST_VARS['cid']);
$title = $myts->makeTboxData4Save($HTTP_POST_VARS["title"]);

$newid = $db->genId($db->prefix("mydownloads_cat")."_cid_seq");
$query = $db->query("INSERT INTO ".$db->prefix("mydownloads_cat")." SET cid='$newid', pid='$pid', title='$title'") or $eh->show("0013");

if ($newid == 0) {
	$newid = $db->insert_id($query);
}

redirect_header("index.php?op=modCat&cid=$newid", 1, _MD_NEWCATADDED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delCat() {
global $db, $HTTP_GET_VARS, $mytree;

$cid = intval($HTTP_GET_VARS['cid']);

if ($HTTP_GET_VARS['ok'] == 1) {
	//get all subcategories under the specified category
	$arr  = $mytree->getAllChildId($cid);

	$size = count($arr);
	for ($i=0; $i<$size; $i++) {
		//get all downloads in each subcategory
		$result = $db->query("SELECT lid, url, logourl FROM ".$db->prefix("mydownloads_downloads")." WHERE cid=".$arr[$i]."");

		//now for each download, delete the text data and vote ata associated with the download
		while (list($lid, $url, $logourl) = $db->fetch_row($result)) {
			@unlink("../cache/files/" . basename($url));
			@unlink("../cache/shots/" . basename($logourl));
			$db->query("DELETE FROM ".$db->prefix("mydownloads_votedata")." WHERE lid=$lid");
			$db->query("DELETE FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid");
		}

		//all downloads for each subcategory is deleted, now delete the subcategory data
		$result = $db->query("SELECT imgurl FROM ".$db->prefix("mydownloads_cat")." WHERE cid=".$arr[$i]."");
		list($imgurl) = $db->fetch_row($result);
		@unlink("../cache/logos/" . basename($imgurl));
		$db->query("DELETE FROM ".$db->prefix("mydownloads_cat")." WHERE cid=".$arr[$i]."");
	}

	//all subcategory and associated data are deleted, now delete category data and its associated data
	$result = $db->query("SELECT lid, url, logourl FROM ".$db->prefix("mydownloads_downloads")." WHERE cid=$cid");
	while (list($lid, $url, $logourl) = $db->fetch_row($result)) {
		@unlink("../cache/files/" . basename($url));
		@unlink("../cache/shots/" . basename($logourl));
		$db->query("DELETE FROM ".$db->prefix("mydownloads_votedata")." WHERE lid=$lid");
		$db->query("DELETE FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid");
	}

	$result = $db->query("SELECT imgurl FROM ".$db->prefix("mydownloads_cat")." WHERE cid=$cid");
	list($imgurl) = $db->fetch_row($result);
	@unlink("../cache/logos/" . basename($imgurl));
	$db->query("DELETE FROM ".$db->prefix("mydownloads_cat")." WHERE cid=$cid");

	build_rss();
	redirect_header("index.php", 1, _MD_CATDELETED);
	exit();

	} else {
		xoops_cp_header();
		OpenTable();
		echo "<h4>"._MD_WARNING."</h4><br /><table><tr><td>";
		echo myTextForm("index.php?op=delCat&cid=$cid&ok=1", _YES);
		echo "</td><td>";
		echo myTextForm("index.php", _NO);
		echo "</td></tr></table>";
		CloseTable();
		xoops_cp_footer();
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function addDownload() {
global $db, $myts, $xoopsUser, $eh, $HTTP_POST_FILES, $HTTP_POST_VARS;

$homepage    = formatURL($myts->makeTboxData4Save($HTTP_POST_VARS["homepage"]));
$url         = $myts->makeTboxData4Save($HTTP_POST_VARS["url"]);
$logourl     = $myts->makeTboxData4Save($HTTP_POST_VARS["logourl"]);
$title       = $myts->makeTboxData4Save($HTTP_POST_VARS["title"]);
$version     = $myts->makeTboxData4Save($HTTP_POST_VARS["version"]);
$size        = $myts->makeTboxData4Save($HTTP_POST_VARS["size"]);
$platform    = $myts->makeTboxData4Save($HTTP_POST_VARS["platform"]);
$description = $myts->makeTboxData4Save($HTTP_POST_VARS["filedesc"]);
$submitter   = intval($xoopsUser->uid());

$result        = $db->query("SELECT COUNT(*) FROM ".$db->prefix("mydownloads_downloads")." WHERE url='$url'");
list($numrows) = $db->fetch_row($result);

// Check if Download exist
if ($numrows > 0) {
	redirect_header("index.php?op=downloadsConfigMenu", 3, _MD_ERROREXIST);
	exit();
}

// Check if Title is empty
if ( empty($title) ) {
	redirect_header("index.php?op=downloadsConfigMenu", 3, _MD_ERRORTITLE);
	exit();
}

// Check if Description is empty
if ( empty($description) ) {
	redirect_header("index.php?op=downloadsConfigMenu", 3, _MD_ERRORDESC);
	exit();
}

if ( empty($size) || !is_numeric($size) ) {
	$size = 0;
}

if ( !empty($HTTP_POST_VARS['cid']) ) {
	$cid = intval($HTTP_POST_VARS['cid']);
	} else {
		$cid = 0;
	}

if ( !empty($HTTP_POST_FILES['download']['name']) ) {
	$upload = new fileupload();
	$upload->set_upload_dir("../cache/files/", "download");
	$upload->set_upload_dir("../cache/shots/", "image");
	$upload->set_overwrite(2);
	$result = $upload->upload();

	if ($result['download']) {
		$url  = $result['download']['filename'];
		$size = $result['download']['size'];
		} else {
			redirect_header("index.php?op=downloadsConfigMenu", 3, $upload->errors());
			exit();
		}

if ( !empty($HTTP_POST_FILES['image']['name']) ) {
	if ($result['image']) {
		$logourl = $result['image']['filename'];
		} else {
			redirect_header("index.php?op=downloadsConfigMenu", 3, $upload->errors());
			exit();
		}
	}
}

// Check if URL is empty
if ( empty($url) ) {
	redirect_header("index.php?op=downloadsConfigMenu", 3, _MD_ERRORURL);
	exit();
}

$newid = $db->genId($db->prefix("mydownloads_downloads")."_lid_seq");
$sql   = "
	INSERT INTO ".$db->prefix("mydownloads_downloads")." SET
	lid=$newid,
	cid=$cid,
	title='$title',
	description='$description',
	url='$url',
	homepage='$homepage',
	version='$version',
	size='$size',
	platform='$platform',
	logourl='$logourl',
	submitter=$submitter,
	status=1,
	date=".time().",
	hits=0,
	rating=0,
	votes=0,
	comments=0";

$db->query($sql) or $eh->show("0013");

build_rss();
redirect_header("index.php", 1, _MD_NEWDLADDED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function delNewDownload() {
global $db, $HTTP_GET_VARS;

$lid   = intval($HTTP_GET_VARS['lid']);

$query  = "SELECT url, logourl FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid";
$result = $db->query($query);
list($url, $logourl) = $db->fetch_row($result);
@unlink("../cache/files/" . basename($url));
@unlink("../cache/shots/" . basename($logourl));

$query = "DELETE FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid";
$db->query($query);

redirect_header("./index.php?op=listNewDownloads", 1, _MD_FILEDELETED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function modDownload() {
global $db, $HTTP_GET_VARS, $HTTP_POST_VARS, $myts, $eh, $mytree;

$lid= !empty($HTTP_POST_VARS['lid']) ? intval($HTTP_POST_VARS['lid']) : intval($HTTP_GET_VARS['lid']);

$result = $db->query("SELECT cid, title, description, url, homepage, version, size, platform, logourl FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid") or $eh->show("0013");
list($cid, $title, $description, $url, $homepage, $version, $size, $platform, $logourl) = $db->fetch_row($result);
$homepage    = $myts->makeTboxData4Edit($homepage);
$title       = $myts->makeTboxData4Edit($title);
$description = $myts->makeTboxData4Edit($description);
$url         = $myts->makeTboxData4Edit($url);
$version     = $myts->makeTboxData4Edit($version);
$size        = $myts->makeTboxData4Edit($size);
$platform    = $myts->makeTboxData4Edit($platform);
$logourl     = $myts->makeTboxData4Edit($logourl);

xoops_cp_header();
OpenTable();

?>
<form method="post" action="index.php" enctype="multipart/form-data">
<h4><a href="index.php"><?php echo _MAIN;?></a>: <?php echo _MD_MODDL;?></h4><br />
<table width="100%"><tr>
<td><?php echo _MD_FILEID;?></td>
<td><b><?php echo $lid;?></b></td>
</tr><tr>
<td><?php echo _MD_FILETITLE;?></td>
<td><input type="text" class="text" name="title" value="<?php echo $title;?>" size="50" maxlength="100" /></td>
</tr><tr>
<td valign="top"><?php echo _MD_DLURL;?></td>
<td>
<input type="text" class="text" name="url" value="<?php echo $url;?>" size="50" maxlength="255" /> [ <a href="<?php echo formatURL(XOOPS_URL."/modules/mydownloads/cache/files/", $url);?>" target="_blank"><?php echo _MD_DOWNLOAD;?></a> ]
<br /><input type="file" class="file" name="download">
</td>
</tr><tr>
<td>&nbsp;</td>
<td><?php printf(_MD_FILE, "modules/mydownloads/cache/files/");?></td>
</tr><tr>
<td><?php echo _MD_CATEGORYC;?></td>
<td><?php $mytree->makeMySelBox("title", "title", $cid);?></td>
</tr><tr>
<td><?php echo _MD_SITEURL;?></td>
<td><input type="text" class="text" name="homepage" value="<?php echo $homepage;?>" size="50" maxlength="255" /></td>
</tr><tr>
<td><?php echo _MD_VERSIONC;?></td>
<td><input type="text" class="text" name="version" value="<?php echo $version;?>" size="10" maxlength="10" /></td>
</tr><tr>
<td><?php echo _MD_FILESIZEC;?></td>
<td><input type="text" class="text" name="size" value="<?php echo $size;?>" size="10" maxlength="100" /> <?php echo _BYTES;?></td>
</tr><tr>
<td><?php echo _MD_PLATFORMC;?></td>
<td><input type="text" class="text" name="platform" value="<?php echo $platform;?>" size="45" maxlength="60" /></td>
</tr><tr>
<td valign="top"><?php echo _MD_DESCRIPTIONC;?></td>
<td>
<?php
$desc = new XoopsFormDhtmlTextArea('', 'filedesc', $description, 10, 50);
echo $desc->render();
?>
</td>
</tr><tr>
<td valign="top"><?php echo _MD_SHOTIMAGE;?></td>
<td>
<input type="text" class="text" name="logourl" value="<?php echo $logourl;?>" size="50" maxlength="255" />
<br /><input type="file" class="file" name="image">
</td>
</tr><tr>
<td>&nbsp;</td>
<td><?php printf(_MD_SHOT, "modules/mydownloads/cache/images/shots/");?></td>
</tr><tr>
<td>
<input type="hidden" name="lid" value="<?php echo $lid;?>" />
<input type="hidden" name="op" value="modDownloadS" />
<input type="submit" class="button" value="<?php echo _SUBMIT;?>" />
</form>
</td>
<td>
<table><tr>
<td><?php echo myTextForm("index.php?op=delDownload&lid=$lid" , _DELETE);?></td>
<td><?php echo myTextForm("index.php?op=downloadsConfigMenu", _CANCEL);?></td>
</tr></table>
</td>
</tr></table><hr />
<?php

$result5 = $db->query("SELECT COUNT(*) FROM ".$db->prefix("mydownloads_votedata")."");
list($totalvotes) = $db->num_rows($result5);

echo "<table valign='top' width='100%'><tr><td colspan='7'><b>";
printf(_MD_DLRATINGS, $totalvotes);
echo "</b><br /><br /></td></tr>";

// Show Registered Users Votes
$result5 = $db->query("SELECT ratingid, ratinguser, rating, ratinghostname, ratingtimestamp FROM ".$db->prefix("mydownloads_votedata")." WHERE lid = $lid AND ratinguser != 0 ORDER BY ratingtimestamp DESC");
$votes   = $db->num_rows($result5);

echo "<tr><td colspan='7'><br /><br /><b>";
printf(_MD_REGUSERVOTES, $votes);
echo "
</b><br /><br /></td>
</tr><tr>
<td><b>"._MD_USER."</b></td>
<td><b>"._MD_IP."</b></td>
<td><b>"._MD_RATING."</b></td>
<td><b>"._MD_USERAVG."</b></td>
<td><b>"._MD_TOTALRATE."</b></td>
<td><b>"._MD_DATE."</b></td>
<td align='center'><b>"._DELETE."</b></td>
</tr>";

if ($votes == 0) {
	echo "<tr><td align='center' colspan='7'>"._MD_NOREGVOTES."<br /></td></tr>";
}

$x=0;
$colorswitch = "bg1";
while (list($ratingid, $ratinguser, $rating, $ratinghostname, $ratingtimestamp)=$db->fetch_row($result5)) {
	$formatted_date = formatTimestamp($ratingtimestamp, "s");
	$result2        = $db->query("SELECT rating FROM ".$db->prefix("mydownloads_votedata")." WHERE ratinguser=$ratinguser");
	$uservotes      = $db->num_rows($result2);
	$useravgrating  = 0;

	while (list($rating2) = $db->fetch_row($result2)) {
		$useravgrating = ($useravgrating + $rating2);
	}

	$useravgrating = ($useravgrating / $uservotes);
	$useravgrating = number_format($useravgrating, 1);
	$ratinguname   = XoopsUser::getUnameFromId($ratinguser);

	echo "
	<tr>
	<td class='$colorswitch'>$ratinguname</td>
	<td class='$colorswitch'>$ratinghostname</td>
	<td class='$colorswitch'>$rating</td>
	<td class='$colorswitch'>$useravgrating</td>
	<td class='$colorswitch'>$uservotes</td>
	<td class='$colorswitch'>$formatted_date</td>
	<td class='$colorswitch' align='center'>";
	echo myTextForm("index.php?op=delVote&lid=$lid&rid=$ratingid", "X");
	echo "</td></tr>";

	$x++;
	if ($colorswitch == "bg1") {
		$colorswitch = "bg3";
		} else {
			$colorswitch = "bg1";
		}
}

// Show Unregistered Users Votes
$result5 = $db->query("SELECT ratingid, rating, ratinghostname, ratingtimestamp FROM ".$db->prefix("mydownloads_votedata")." WHERE lid = $lid AND ratinguser = 0 ORDER BY ratingtimestamp DESC");
$votes   = $db->num_rows($result5);

echo "<tr><td colspan='7'><br /><br /><b>";
printf(_MD_ANONUSERVOTES, $votes);
echo "
</b><br /><br /></td>
</tr><tr>
<td colspan='2'><b>"._MD_IP."</b></td>
<td colspan='3'><b>"._MD_RATING."</b></td>
<td><b>"._MD_DATE."</b></b></td>
<td align='center'><b>"._DELETE."</b></td>
</tr>";

if ($votes == 0) {
	echo "<tr><td colspan='7' align='center'>"._MD_NOUNREGVOTES."</td></tr>";
}

$x=0;
$colorswitch = "bg1";
while (list($ratingid, $rating, $ratinghostname, $ratingtimestamp) = $db->fetch_row($result5)) {
	$formatted_date = formatTimestamp($ratingtimestamp, "s");
	echo "
	<td colspan='2' class='$colorswitch'>$ratinghostname</td>
	<td colspan='3' class='$colorswitch'>$rating</td>
	<td class='$colorswitch'>$formatted_date</td>
	<td class='$colorswitch' align='center'>";
	echo myTextForm("index.php?op=delVote&lid=$lid&rid=$ratingid", "X");
	echo "</td></tr>";
	$x++;

	if ($colorswitch == "bg1") {
		$colorswitch = "bg3";
		} else {
			$colorswitch="bg1";
		}
}

echo "<tr><td colspan='6'>&nbsp;</td></tr></table>";

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function modDownloadS() {
global $db, $myts, $eh, $HTTP_POST_VARS, $HTTP_POST_FILES;

$cid         = intval($HTTP_POST_VARS['cid']);
$lid         = intval($HTTP_POST_VARS['lid']);
$homepage    = formatURL($myts->makeTboxData4Save($HTTP_POST_VARS["homepage"]));
$url         = $myts->makeTboxData4Save($HTTP_POST_VARS["url"]);
$logourl     = $myts->makeTboxData4Save($HTTP_POST_VARS["logourl"]);
$title       = $myts->makeTboxData4Save($HTTP_POST_VARS["title"]);
$version     = $myts->makeTboxData4Save($HTTP_POST_VARS["version"]);
$platform    = $myts->makeTboxData4Save($HTTP_POST_VARS["platform"]);
$description = $myts->makeTboxData4Save($HTTP_POST_VARS["filedesc"]);
$size        = intval($HTTP_POST_VARS['size']);

// Check if Title is empty
if ( empty($title) ) {
	redirect_header("index.php?op=modDownload&lid=$lid", 3, _MD_ERRORTITLE);
	exit();
}

// Check if Description is empty
if ( empty($description) ) {
	redirect_header("index.php?op=modDownload&lid=$lid", 3, _MD_ERRORDESC);
	exit();
}

if ( empty($size) || !is_numeric($size) ) {
	$size = 0;
}

if ( !empty($HTTP_POST_FILES['download']['name']) || !empty($HTTP_POST_FILES['image']['name']) ) {
	$upload = new fileupload();

	$upload->set_upload_dir('../cache/files/', 'download');
	$upload->set_overwrite(1, 'download');

	$upload->set_upload_dir('../cache/shots/', 'image');
	$upload->set_basename($lid, 'image');
	$upload->set_overwrite(2, 'image');

	$result = $upload->upload();
	if (!empty($HTTP_POST_FILES['download']['name'])) {
		if ($result['download']['filename']) {
			$url  = $result['download']['filename'];
			$size = $result['download']['size'];
			} else {
				redirect_header("index.php?op=modDownload&lid=$lid", 3, $upload->errors());
				exit();
			}
	}

	if ( !empty($HTTP_POST_FILES['image']['name']) ) {
		if ($result['image']['filename']) {
			$logourl = $result['image']['filename'];
			} else {
				redirect_header("index.php?op=modDownload&lid=$lid", 3, $upload->errors());
				exit();
			}
		}
}

// Check if URL is empty
if ( empty($url) ) {
	redirect_header("index.php?op=modDownload&lid=$lid", 3, _MD_ERRORURL);
	exit();
}

$sql = "
	UPDATE ".$db->prefix("mydownloads_downloads")." SET
	cid=$cid,
	title='$title',
	description='$description',
	url='$url',
	homepage='$homepage',
	version='$version',
	size='$size',
	platform='$platform',
	logourl='$logourl',
	status=2,
	date=".time()."
	WHERE lid=$lid";

$db->query($sql) or $eh->show("0013");

build_rss();
redirect_header("index.php", 1, _UPDATED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function approve() {
global $xoopsConfig, $db, $HTTP_POST_VARS, $myts, $eh, $meta;

$lid = intval($HTTP_POST_VARS['lid']);
$cid = intval($HTTP_POST_VARS['cid']);

if ( empty($cid) ) {
	$cid = 0;
}

$homepage    = formatURL($myts->makeTboxData4Save($HTTP_POST_VARS["homepage"]));
$url         = $myts->makeTboxData4Save($HTTP_POST_VARS["url"]);
$logourl     = $myts->makeTboxData4Save($HTTP_POST_VARS["logourl"]);
$title       = $myts->makeTboxData4Save($HTTP_POST_VARS["title"]);
$version     = $myts->makeTboxData4Save($HTTP_POST_VARS["version"]);
$size        = $myts->makeTboxData4Save($HTTP_POST_VARS["size"]);
$platform    = $myts->makeTboxData4Save($HTTP_POST_VARS["platform"]);
$description = $myts->makeTboxData4Save($HTTP_POST_VARS["filedesc"]);

$query = "
	UPDATE
	".$db->prefix("mydownloads_downloads")."
	SET
	cid=$cid,
	title='$title',
	description='$description',
	url='$url',
	homepage='$homepage',
	version='$version',
	size='$size',
	platform='$platform',
	logourl='$logourl',
	status=1,
	date=".time()."
	WHERE
	lid=$lid";

$db->query($query) or $eh->show("0013");

$result = $db->query("SELECT submitter FROM ".$db->prefix("mydownloads_downloads")." WHERE lid=$lid");
list($submitter) = $db->fetch_row($result);

$submitter = new XoopsUser($submitter);
$subject   = sprintf(_MD_YOURFILEAT, $meta['title']);
$message   = sprintf(_MD_HELLO, $submitter->uname());
$message  .= "\n\n"._MD_WEAPPROVED."\n\n";
$siteurl   = XOOPS_URL."/modules/mydownloads/";
$message  .= sprintf(_MD_VISITAT, $siteurl);
$message  .= "\n\n"._MD_THANKSSUBMIT."\n\n".$meta['title']."\n".XOOPS_URL."\n".$xoopsConfig['adminmail']."";

$xoopsMailer =& getMailer();
$xoopsMailer->useMail();
$xoopsMailer->setToEmails($submitter->getVar("email"));
$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
$xoopsMailer->setFromName($meta['title']);
$xoopsMailer->setSubject($subject);
$xoopsMailer->setBody($message);
$xoopsMailer->send();

build_rss();
redirect_header("./index.php?op=listNewDownloads", 1, _MD_NEWDLADDED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function mydownloadsConfigAdmin() {
global $myts, $mydownloadsConfig;

xoops_cp_header();
OpenTable();

?>
<h4><a href="index.php"><?php echo _MAIN;?></a>: <?php echo _MD_GENERALSET;?></h4><br />
<form action="index.php" method="post">
<table width="100%" border="0"><tr>

<td nowrap><?php echo _MD_DLSPERPAGE;?></td>
<td width="100%">
<select class="select" name="perpage">
<option value="<?php echo $mydownloadsConfig['perpage'];?>" selected="selected"><?php echo $mydownloadsConfig['perpage'];?></option>
<option value="10">10</option>
<option value="15">15</option>
<option value="20">20</option>
<option value="25">25</option>
<option value="30">30</option>
<option value="50">50</option>
</select>
</td>

</tr><tr>

<td nowrap><?php echo _MD_HITSPOP;?></td>
<td width="100%">
<select class="select" name="popular">
<option value="<?php echo $mydownloadsConfig['popular'];?>" selected="selected"><?php echo $mydownloadsConfig['popular'];?></option>
<option value="10">10</option>
<option value="20">20</option>
<option value="50">50</option>
<option value="100">100</option>
<option value="500">500</option>
<option value="1000">1000</option>
</select>
</td>

</tr><tr>

<td nowrap><?php echo _MD_DLSNEW;?></td>
<td width="100%">
<select class="select" name="newdownloads">
<option value="<?php echo $mydownloadsConfig['newdownloads'];?>" selected="selected"><?php echo $mydownloadsConfig['newdownloads'];?></option>
<option value="10">10</option>
<option value="15">15</option>
<option value="20">20</option>
<option value="25">25</option>
<option value="30">30</option>
<option value="50">50</option>
</select>
</td>

</tr><tr>

<?php
$chk1 = ''; $chk0 = '';
($mydownloadsConfig['useshots'] == 1) ? $chk1 = " checked='checked'" : $chk0 = " checked='checked'";
?>
<td nowrap><?php echo _MD_USESHOTS;?></td>
<td width="100%">
<input type="radio" class="radio" name="useshots" value="1"<?php echo $chk1;?> /> <?php echo _YES;?>
<input type="radio" class="radio" name="useshots" value="0"<?php echo $chk0;?> /> <?php echo _NO;?>
</td>

</tr><tr>

<td nowrap><?php echo _MD_IMGWIDTH;?></td>
<td width="100%">
<input type="text" class="text" size="10" name="shotwidth" value="<?php echo $mydownloadsConfig['shotwidth'];?>" />
</td>

</tr><tr>

<?php
$chk1 = ''; $chk0 = '';
($mydownloadsConfig['anon_add'] == 1) ? $chk1 = " checked='checked'" : $chk0 = " checked='checked'";
?>
<td nowrap><?php echo _AM_ANON_ADD;?></td>
<td width="100%">
<input type="radio" class="radio" name="anon_add" value="1"<?php echo $chk1;?> /> <?php echo _YES;?>
<input type="radio" class="radio" name="anon_add" value="0"<?php echo $chk0;?> /> <?php echo _NO;?>
</td>

</tr><tr>

<?php
$chk1 = ''; $chk0 = '';
($mydownloadsConfig['check_external'] == 1) ? $chk1 = " checked='checked'" : $chk0 = " checked='checked'";
?>
<td nowrap><?php echo _AM_CHECK_EXTERNAL;?></td>
<td width="100%">
<input type="radio" class="radio" name="check_external" value="1"<?php echo $chk1;?> /> <?php echo _YES;?>
<input type="radio" class="radio" name="check_external" value="0"<?php echo $chk0;?> /> <?php echo _NO;?>
</td>

</tr><tr>
<td colspan="2"><hr /></td>
</tr><tr>

<?php
$chk1 = ''; $chk0 = '';
($mydownloadsConfig['rss_enable'] == 1) ? $chk1 = " checked='checked'" : $chk0 = " checked='checked'";
?>
<td nowrap><?php echo _AM_RSS_ENABLE;?></td>
<td width="100%">
<input type="radio" class="radio" name="rss_enable" value="1"<?php echo $chk1;?> /> <?php echo _YES;?>
<input type="radio" class="radio" name="rss_enable" value="0"<?php echo $chk0;?> /> <?php echo _NO;?>
</td>

</tr><tr>

<td nowrap><?php echo _AM_RSS_MAXITEMS;?></td>
<td width="100%">
<select class="select" name="rss_maxitems">
<option value="<?php echo $mydownloadsConfig['rss_maxitems'];?>" selected="selected"><?php echo $mydownloadsConfig['rss_maxitems'];?></option>
<option value="5">5</option>
<option value="10">10</option>
<option value="15">15</option>
<option value="20">20</option>
<option value="25">25</option>
<option value="30">30</option>
</select>
</td>

</tr><tr>

<td nowrap><?php echo _AM_RSS_MAXDESCRIPTION;?></td>
<td width="100%">
<select class="select" name="rss_maxdescription">
<option value="<?php echo $mydownloadsConfig['rss_maxdescription'];?>" selected="selected"><?php echo $mydownloadsConfig['rss_maxdescription'];?></option>
<option value="50">50</option>
<option value="100">100</option>
<option value="150">150</option>
<option value="200">200</option>
<option value="250">250</option>
<option value="300">300</option>
</select>
</td>

</tr><tr>
<td colspan="2"><hr /></td>
</tr><tr>

<?php
$chk1 = ''; $chk0 = '';
($mydownloadsConfig['allow_upload'] == 1) ? $chk1 = " checked='checked'" : $chk0 = " checked='checked'";
?>
<td nowrap><?php echo _UPLOADENABLE;?></td>
<td width="100%">
<input type="radio" class="radio" name="allow_upload" value="1"<?php echo $chk1;?> /> <?php echo _YES;?>
<input type="radio" class="radio" name="allow_upload" value="0"<?php echo $chk0;?> /> <?php echo _NO;?>
</td>

</tr><tr>

<td nowrap><?php echo _UPLOADACCEPTED;?></td>
<td width="100%">
<input type="text" class="text" size="30" name="accepted_files" value="<?php echo $mydownloadsConfig['accepted_files'];?>" />
</td>

</tr><tr>

<td nowrap><?php echo _UPLOADLIMIT;?></td>
<td width="100%">
<input type="text" class="text" size="10" name="upload_limit" value="<?php echo $mydownloadsConfig['upload_limit'];?>" /> <?php echo _BYTES;?>
</td>

</tr><tr>
<td colspan="2"><hr /></td>
</tr><tr>

<td valign="top" nowrap><?php echo _AM_DISCLAIMER;?></td>
<td width="100%">
<?php
$disclaimer = join('', file("../cache/disclaimer.php"));
$disclaimer = $myts->makeTboxData4PreviewInForm($disclaimer);
$desc       = new XoopsFormDhtmlTextArea('', 'disclaimer', $disclaimer, 10, 50);
echo $desc->render();
?>
</td>

</tr><tr>
<td colspan="2"><hr /></td>
</tr><tr>

<td colspan="2">
<input type="hidden" name="op" value="mydownloadsConfigChange">
<input type="submit" class="button" value="<?php echo _SAVE;?>">
<input type="button" class="button" value="<?php echo _CANCEL;?>" onclick="javascript:history.go(-1)">
</td>

</tr></table>
</form>
<?php

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function mydownloadsConfigChange() {
global $HTTP_POST_VARS, $myts;

$content  = "<?php\n";
$content .= "\$mydownloadsConfig['popular']            = ".intval($HTTP_POST_VARS['popular']).";\n";
$content .= "\$mydownloadsConfig['newdownloads']       = ".intval($HTTP_POST_VARS['newdownloads']).";\n";
$content .= "\$mydownloadsConfig['perpage']            = ".intval($HTTP_POST_VARS['perpage']).";\n";
$content .= "\$mydownloadsConfig['useshots']           = ".intval($HTTP_POST_VARS['useshots']).";\n";
$content .= "\$mydownloadsConfig['shotwidth']          = ".intval($HTTP_POST_VARS['shotwidth']).";\n";
$content .= "\$mydownloadsConfig['anon_add']           = ".intval($HTTP_POST_VARS['anon_add']).";\n";
$content .= "\$mydownloadsConfig['check_external']     = ".intval($HTTP_POST_VARS['check_external']).";\n";
$content .= "\$mydownloadsConfig['rss_enable']         = ".intval($HTTP_POST_VARS['rss_enable']).";\n";
$content .= "\$mydownloadsConfig['rss_maxitems']       = ".intval($HTTP_POST_VARS['rss_maxitems']).";\n";
$content .= "\$mydownloadsConfig['rss_maxdescription'] = ".intval($HTTP_POST_VARS['rss_maxdescription']).";\n";
$content .= "\$mydownloadsConfig['allow_upload']       = ".intval($HTTP_POST_VARS['allow_upload']).";\n";
$content .= "\$mydownloadsConfig['accepted_files']     = '".$HTTP_POST_VARS['accepted_files']."';\n";
$content .= "\$mydownloadsConfig['upload_limit']       = ".intval($HTTP_POST_VARS['upload_limit']).";\n";
$content .= "?>";

$filename = "../cache/config.php";
if ( $file = fopen($filename, "w") ) {
	fwrite($file, $content);
	fclose($file);
	} else {
		redirect_header("index.php", 1, _NOTUPDATED);
		exit();
	}

$filename = "../cache/disclaimer.php";
if ( $file = fopen($filename, "wb") ) {
	$disclaimer = $myts->oopsStripSlashesGPC($HTTP_POST_VARS['disclaimer']);
	fwrite($file, $disclaimer);
	fclose($file);
	} else {
		redirect_header("index.php", 1, _NOTUPDATED);
		exit();
	}

redirect_header("index.php", 1, _UPDATED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function build_rss() {
global $db, $mydownloadsConfig;

if ($mydownloadsConfig['rss_enable'] == 1) {

$SQL= "SELECT title, lid, version, description FROM ".$db->prefix("mydownloads_downloads")." WHERE status !=0 ORDER BY date DESC";

$query = $db->query($SQL, $mydownloadsConfig['rss_maxitems']);

if ($query) {
	$rss = new xml_rss(XOOPS_ROOT_PATH . '/modules/mydownloads/cache/downloads.xml');
	$rss->channel_title       .= " :: " . _MI_MYDOWNLOADS_NAME;
	$rss->image_title         .= " :: " . _MI_MYDOWNLOADS_NAME;
	$rss->max_items            = $mydownloadsConfig['rss_maxitems'];
	$rss->max_item_description = $mydownloadsConfig['rss_maxdescription'];

	while ( list($title, $link, $version, $description) = $db->fetch_row($query) ) {
		$link = XOOPS_URL . '/modules/mydownloads/singlefile.php?lid=' . $link;
		if ( !empty($version) ) { $title .= " - ".$version; }
		$rss->build($title, $link, $description);
	}
	$rss->save();
	}
}
}

//---------------------------------------------------------------------------------------//
$op = !empty($HTTP_POST_VARS['op']) ? $HTTP_POST_VARS['op'] : $HTTP_GET_VARS['op'];

switch($op) {

case "delNewDownload":
	delNewDownload();
	break;

case "approve":
	approve();
	break;

case "addCat":
	addCat();
	break;

case "addSubCat":
	addSubCat();
	break;

case "addDownload":
	addDownload();
	break;

case "listBrokenDownloads":
	listBrokenDownloads();
	break;

case "delBrokenDownloads":
	delBrokenDownloads();
	break;

case "ignoreBrokenDownloads":
	ignoreBrokenDownloads();
	break;

case "listModReq":
	listModReq();
	break;

case "changeModReq":
	changeModReq();
	break;

case "ignoreModReq":
	ignoreModReq();
	break;

case "delCat":
	delCat();
	break;

case "modCat":
	modCat();
	break;

case "modCatS":
	modCatS();
	break;

case "modDownload":
	modDownload();
	break;

case "modDownloadS":
	modDownloadS();
	break;

case "delDownload":
	delDownload();
	break;

case "delVote":
	delVote();
	break;

case "mydownloadsConfigAdmin":
	mydownloadsConfigAdmin();
	break;

case "mydownloadsConfigChange":
	mydownloadsConfigChange();
	break;

case "downloadsConfigMenu":
	downloadsConfigMenu();
	break;

case "listNewDownloads":
	listNewDownloads();
	break;

default:
	mydownloads();
	break;
}
?>
