<?php
// $Id: addcat.php,v 1.1 2004/07/11 10:27:51 Farsus Exp $
// ------------------------------------------------------------------------- //
//               E-Xoops: Content Management for the Masses                  //
//                       < http://www.e-xoops.com >                          //
// ------------------------------------------------------------------------- //
// Original Author: Nobse, Bama
// Author Website : http://www.e-xoops.de, http://service.bama-webdesign.de
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

include_once("admin_header.php");
include_once(XOOPS_ROOT_PATH."/class/xoopstree.php");
include_once(XOOPS_ROOT_PATH."/class/xoopsform/formdhtmltextarea.php");
$mytree = new XoopsTree($db->prefix('ecal_cat'), "cid", "pid");


//---------------------------------------------------------------------------------------//
/**
* Description
* Karegorie Menue
* @param type $var description
* @return type description
*/
function myaddcat() {
global $xoopsConfig, $myts, $mytree;

xoops_cp_header();
OpenTable();
echo "<h4><a href='index.php'>"._MAIN."</a>: "._ADDCAT."</h4><br />";
closetable();
echo "</center><br />";

OpenTable();
// Modify Category
?>

<form method="post" action="addcat.php">
<h4><?php echo _CAL_MODCAT;?></h4>
<?php echo _CAL_CATEGORY;?>
<?php $mytree->makeMySelBox("title", "title");?>
<input type="hidden" name="op" value="myeditcat" />
<input type="submit" class="button" value="<?php echo _MODIFY;?>" />
</form>
<?php

CloseTable();
echo "<br />";
OpenTable();
// Add a New Sub-Category

?>
<form method="post" action="addcat.php">
<h4><?php echo _CAL_ADDSUB;?></h4>
<?php echo _CAL_SUBTITLE;?>
<input type="text" class="text" name="title" size="30" maxlength="50" />
<?php echo _CAL_IN;?>
<?php $mytree->makeMySelBox("title", "title");?>
<input type="hidden" name="op" value="myaddcatsave" />
<input type="submit" class="button" value="<?php echo _ADD;?>" />
</form>
<?php

CloseTable();
echo "<br />";


OpenTable();
// Add a New Main Category

?>
<form method="post" action="addcat.php">
<h4><?php echo _CAL_ADDMAIN;?></h4>
<?php echo _CAL_CATEGORY;?>
<input type="text" class="text" name="title" size="30" maxlength="50" />
<input type="hidden" name="cid" value="0" />
<input type="hidden" name="op" value="myaddcatsave" />
<input type="submit" class="button" value="<?php echo _ADD;?>" />
</form>
<?php

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
* Kategorie speichern
* @param type $var description
* @return type description
*/
function myaddcatsave() {
global $db, $HTTP_POST_VARS, $myts, $myconfig;

$pid    = intval($HTTP_POST_VARS["cid"]);
$title  = $myts->makeTboxData4Save($HTTP_POST_VARS["title"]);

$newid = $db->genId($db->prefix('ecal_cat')."_cid_seq");
$db->query("INSERT INTO ".$db->prefix('ecal_cat')." SET cid='$newid', pid='$pid', title='$title'") or $eh->show("0013");

if ($newid == 0) {
	$newid = $db->insert_id($query);
}

redirect_header("addcat.php?op=myeditcat&cid=$newid", 1, _CAL_NEWCATADDED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function myeditcat() {
global $db, $xoopsModule, $HTTP_POST_VARS, $HTTP_GET_VARS, $myts, $eh, $mytree, $myconfig;

$cid = !empty($HTTP_POST_VARS["cid"]) ? intval($HTTP_POST_VARS["cid"]) : intval($HTTP_GET_VARS["cid"]);

xoops_cp_header();
OpenTable();

echo "<h4><a href='index.php'>"._MAIN."</a>: "._CAL_MODCAT."</h4><br />";

global $desc;
$result = $db->query("SELECT pid, title, imgurl, description FROM ".$db->prefix('ecal_cat')." WHERE cid=$cid");
list($pid, $title, $imgurl, $description) = $db->fetch_row($result);
$title  = $myts->makeTboxData4Edit($title);
$imgurl = $myts->makeTboxData4Edit($imgurl);
$desc   = $myts->makeTboxData4Edit($description);

?>
<form action="./addcat.php" method="post" enctype="multipart/form-data">

<?php echo _SUB;?><br />
<input type="text" class="text" name="title" value="<?php echo $title;?>" size="51" maxlength="50">

<br /><br />
<input type="text" class="text" name="imgurl" value="<?php echo $imgurl;?>" size="51" maxlength="255"><br />
<?php
$upload = new fileupload();
$upload->set_basename($cid, 'image');
$upload->render(1, 'image');
echo "<br />".sprintf(_CAL_IMGLOCATION, "modules/".$xoopsModule->dirname()."/cache/logos/");
?>

<br /><br />
<?php echo _DESC;?>:<br />
<?php
$desc = new XoopsFormDhtmlTextArea('', 'desc', $desc, 10, 50);
echo $desc->render();
?>

<br /><br />
<?php echo _CAL_CATEGORY;?><br />
<?php $mytree->makeMySelBox("title", "title", $pid, 1, "pid");?>

<br /><br />
<input type="hidden" name="cid" value="<?php echo $cid;?>">
<input type="hidden" name="op" value="myeditcatsave"><br />
<input type="submit" class="button" value="<?php echo _SAVE;?>">
<input type="button" class="button" value="<?php echo _DELETE;?>" onclick="location='addcat.php?pid=<?php echo $pid;?>&cid=<?php echo $cid;?>&op=mydelcat';">
<input type="button" class="button" value="<?php echo _CANCEL;?>" onclick="location='addcat.php';">
</form>
<?php

CloseTable();
xoops_cp_footer();
}

//---------------------------------------------------------------------------------------//
/**
* Description
* Update Kategorie und Subkategirie
* @param type $var description
* @return type description
*/
function myeditcatsave() {
global $db, $myts, $HTTP_POST_VARS, $HTTP_POST_FILES, $myconfig;
$cid         = intval($HTTP_POST_VARS['cid']);
$pid         = intval($HTTP_POST_VARS['pid']);
$title       = $myts->makeTboxData4Save($HTTP_POST_VARS['title']);
$imgurl      = $myts->makeTboxData4Save($HTTP_POST_VARS['imgurl']);
$description = $myts->makeTboxData4Save($HTTP_POST_VARS['desc']);

if ( !empty($HTTP_POST_FILES['image']['name']) ) {
	$upload = new fileupload();
	$upload->set_upload_dir('../cache/logos/', 'image');
	$upload->set_accepted('gif|jpg|png', 'image');
	$upload->set_overwrite(2, 'image');
	$result = $upload->upload();
	if ($result['image']['filename']) {
		$imgurl = $result['image']['filename'];
		} else {
			redirect_header("addcat.php?op=myeditcat&cid=$cid", 3, $upload->errors());
			exit();
		}
}

$db->query("UPDATE ".$db->prefix('ecal_cat')." SET pid='$pid', title='$title', imgurl='$imgurl', description='$description' WHERE cid=$cid");

redirect_header("index.php", 1, _UPDATED);
exit();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function mydelcat() {
global $db, $HTTP_GET_VARS, $mytree, $myconfig;
$cid = intval($HTTP_GET_VARS['cid']);

if ($HTTP_GET_VARS['ok'] == 1) {
	//get all subcategories under the specified category
	$arr  = $mytree->getAllChildId($cid);

	$size = count($arr);
	for ($i=0; $i<$size; $i++) {
		//get all links in each subcategory
		$result=$db->query("SELECT id  FROM ".$db->prefix('ecal')." WHERE cid=".$arr[$i]."");

		//now for each link, delete the text data and vote data associated with the link
		while (list($id) = $db->fetch_row($result)) {
			$db->query("DELETE FROM ".$db->prefix('ecal_cat')." WHERE id=$id");
		}

		//all links for each subcategory is deleted, now delete the subcategory data
		$result = $db->query("SELECT imgurl FROM ".$db->prefix("ecal_cat")." WHERE cid=".$arr[$i]."");
		list($imgurl) = $db->fetch_row($result);
		@unlink("../cache/logos/" . basename($imgurl));
		$db->query("DELETE FROM ".$db->prefix('ecal_cat')." WHERE cid=".$arr[$i]."");
	}

	//all subcategory and associated data are deleted, now delete category data and its associated data
	$result = $db->query("SELECT id from ".$db->prefix('ecal')." WHERE cid=$cid");
	while (list($id) = $db->fetch_row($result)) {
		$db->query("DELETE FROM ".$db->prefix('ecal')." WHERE id=$id");
	}

	$result = $db->query("SELECT imgurl FROM ".$db->prefix("ecal_cat")." WHERE cid=$cid");
	list($imgurl) = $db->fetch_row($result);
	@unlink("../cache/logos/" . basename($imgurl));
	$db->query("DELETE FROM ".$db->prefix('ecal_cat')." WHERE cid=$cid");

	redirect_header("addcat.php", 1, _CAL_CATDELETED);
	exit();
	} else {
		xoops_cp_header();
		OpenTable();
		echo "<center><h4>"._CAL_WARNING."</h4><table><tr><td>";
		echo myTextForm("addcat.php?op=mydelcat&cid=$cid&ok=1", _YES);
		echo "</td><td>";
		echo myTextForm("addcat.php", _NO);
		echo "</td></tr></table>";
		CloseTable();
		xoops_cp_footer();
	}
}



//---------------------------------------------------------------------------------------//
$op = !empty($HTTP_POST_VARS['op']) ? $HTTP_POST_VARS['op'] : $HTTP_GET_VARS['op'];

switch ($op) {

case "myaddcatsave":
	myaddcatsave();
	break;

case "mydelcat":
	mydelcat();
	break;

case "myeditcat":
	myeditcat();
	break;

case "myeditcatsave":
	myeditcatsave();
	break;

case "myaddcat":
	myaddcat();
	break;

default:
	myaddcat();
	break;
}
?>
