<?php
// $Id: functions.php,v 1.1 2004/07/11 10:27:44 Farsus Exp $
// -------------------------------------------------------------------------//
//			                 RUNCMS                                         //
//                                                                          //
//	 reliable - Unique - Nocost &  Simplicity & ease off use                //
//                       < http://www.runcms.org >                          //
// -------------------------------------------------------------------------//
// Original Author: Kazumi Ono
// Author Website : http://www.mywebaddons.com/ , http://www.myweb.ne.jp
// License Type   : GPL: See /manual/LICENSES/GPL.txt
// ------------------------------------------------------------------------- //

if (!defined("EXOOPS_FUNCTIONS_INCLUDED")) {
	define("EXOOPS_FUNCTIONS_INCLUDED", 1);

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function xoops_header($closehead=true) {
global $db, $meta, $xoopsUser;

if ( !headers_sent() ) {
	if ( !empty($meta['p3p']) ) {
		header("P3P: CP='".$meta['p3p']."'");
	}
	if ( $xoopsUser || ($meta['pragma'] == 1) ) {
		header('Expires: Sat, 18 Aug 2002 05:30:00 GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header('Cache-Control: no-store, no-cache, max-age=1, s-maxage=1, must-revalidate, post-check=0, pre-check=0');
	}
}

// We only generate keywords if in debug mode, or if it's really a search engine.
if ($meta['extractor']) {
	if (!$meta['cloaking']) {
		include_once(XOOPS_ROOT_PATH . "/modules/system/admin/meta-generator/include/functions.php");
		} elseif ( $meta['cloaking'] && !preg_match("/(".$meta['user_agents'].")/i", _HTTP_USER_AGENT) ) {
			include_once(XOOPS_ROOT_PATH . "/modules/system/admin/meta-generator/include/functions.php");
		}
}
?>
<html>
<head>
<title><?php echo $meta['title'];?></title>
<meta http-equiv="content-type" content="text/html; charset=<?php echo _CHARSET;?>">
<meta http-equiv="content-language" content="<?php echo _LANGCODE;?>">
<meta name="rating" content="<?php echo $meta['rating'];?>">
<meta name="robots" content="<?php echo $meta['index'];?>, <?php echo $meta['follow'];?>">
<meta name="generator" content="<?php echo XOOPS_VERSION;?>">
<meta name="keywords" content="<?php echo $meta['keywords'];?>">
<meta name="description" content="<?php echo $meta['description'];?>">
<meta name="author" content="<?php echo $meta['author'];?>">
<meta name="copyright" content="<?php echo $meta['copyright'];?>">
<?php readfile(XOOPS_ROOT_PATH . "/modules/system/cache/header.php");?>
<link rel="shortcut icon" href="<?php echo $meta['icon'];?>">
<?php include_once(XOOPS_ROOT_PATH ."/include/xoopsjs.php");?>
<link href="<?php echo XOOPS_URL;?>/include/style.css" rel="stylesheet" type="text/css" />
<?php

$themecss = getcss(getTheme());
if ($themecss) {
	echo "
	<style type='text/css' media='all'>
	<!-- @import url($themecss); -->
	</style>";
}

if ( $closehead ) {
	echo "</head><body>";
}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function xoops_footer($debug=1) {
global $xoopsConfig;

if ($xoopsConfig['display_loading_img'] == 1) {
	CloseWaitBox();
}

site_cache("cache");

if ( !empty($xoopsConfig['debug_mode']) && !empty($debug) ) {
	debug_info($xoopsConfig['debug_mode']);
}

echo "</body></html>";
ob_end_flush();
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function site_cache($option) {
global $xoopsOption, $xoopsConfig, $xoopsUser, $meta;

$cache_time      = $xoopsConfig['cache_time'];
$browser_pattern = 'mozilla\/[0-9]|netscape|opera|konqueror|msie [0-9]|iweng|ncsa mosaic|lynx';
$r_uri           = _REQUEST_URI;
$u_agent         = _HTTP_USER_AGENT;
$r_method        = _REQUEST_METHOD;

if (
    $xoopsOption['nocache'] != 1
    && !empty($cache_time)
    && empty($xoopsUser)
    && $r_method == 'GET'
    && !empty($r_uri)
    && preg_match("/($browser_pattern)/i", $u_agent)
   ) {

$curr_time   = time();
$path        = XOOPS_ROOT_PATH.'/cache/system/';

$tmp_name    = preg_replace('/[^a-z0-9_-]/i', '', $r_uri);
$cache_file  = $path.'.'.$tmp_name.'.cache';

$last_cached = @filemtime($cache_file);
$last_cached ? $last_cached = $last_cached : $last_cached = 0;

$cached_size = @filesize($cache_file);
$cached_size ? $cached_size = $cached_size : $cached_size = 0;

if ( ($option == 'cache') && (($last_cached+$cache_time) < $curr_time) ) {
	$content = ob_get_contents();

	// Cleanup stale files that might have been generated by search engines, etc.
	if ( $handle = @opendir($path) ) {
		while (false !== ($file = @readdir($handle))) {
			if ( @is_file($path.$file) ) {
			$timestamp = @filemtime($path.$file);
				if ( (($timestamp+$cache_time) < $curr_time) ) {
					@unlink($path.$file);
				}
			}
		}
		closedir($handle);
	} // END Cleanup

	if ($fp = fopen($cache_file, 'w')) {
		fwrite($fp, $content.'</body></html>');
		fclose($fp);
		}
		} elseif ( ($option == 'read') && (($last_cached+$cache_time) > $curr_time) && ($cached_size > 5120) ) {
			if ( !headers_sent() ) {
				header('Last-Modified: '.gmdate("D, d M Y H:i:s", $last_cached).' GMT');
				header("Cache-Control: max-age=$cache_time, s-maxage=$cache_time, proxy-revalidate, post-check=$cache_time, pre-check=$cache_time");
				if ( !empty($meta['p3p']) ) {
					header("P3P: CP='".$meta['p3p']."'");
				}
			}
			readfile($cache_file);
			if ( !empty($xoopsConfig['debug_mode']) ) {
				debug_info($xoopsConfig['debug_mode']);
			}
			if (!headers_sent()) {
				header('ETag: '.md5(ob_get_length()));
			}
			ob_end_flush();
			exit();
		}
	} elseif (!headers_sent()) {
		header('ETag: '.md5(uniqid(ex_srand())));
		header('Expires: Sat, 18 Aug 2002 05:30:00 GMT');
		header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
		header('Cache-Control: no-store, no-cache, max-age=1, s-maxage=1, must-revalidate, post-check=0, pre-check=0');
	} // END CACHE
}

//----------------------------------------------------------------------------------------//
/**
* Function to display formatted times in user timezone
*/
function formatTimestamp($time, $format="l", $timeoffset="") {
global $xoopsConfig, $xoopsUser;

if ($timeoffset == "") {
	if ($xoopsUser) {
		$timeoffset = $xoopsUser->getVar("timezone_offset");
		} else {
			$timeoffset = $xoopsConfig['default_TZ'];
		}
	}

if ( $format == "s" ) {
	$datestring = _SHORTDATESTRING;
	} elseif ( $format == "m" ) {
		$datestring = _MEDIUMDATESTRING;
		} elseif ( $format == "l" ) {
			$datestring = _DATESTRING;
			} elseif ( $format == "mysql" ) {
				$datestring = "Y-m-d H:i:s";
				} elseif ( $format != "" ) {
					$datestring = $format;
					} else {
						$datestring = _DATESTRING;
					}

$usertimestamp = ($time + (($timeoffset - ($xoopsConfig['server_TZ'] - date('I'))) * 3600));
$datetime = date($datestring, $usertimestamp);
$datetime = ucfirst($datetime);

return $datetime;
}

//----------------------------------------------------------------------------------------//
/**
* Function to calculate server timestamp from user entered time (timestamp)
*/
function userTimeToServerTime($timestamp, $userTZ=NULL) {
global $xoopsConfig;

if ( !isset($userTZ) ) {
	$userTZ = $xoopsConfig['default_TZ'];
}

$offset    = $userTZ - $xoopsConfig['server_TZ'];
$timestamp = $timestamp - ($offset * 3600);

return $timestamp;
}

// --------------------------------------------------------------------------------------//
/**
* Functions to display dhtml loading image box
*/
function OpenWaitBox() {
global $xoopsConfig;

if ($xoopsConfig['display_loading_img'] == 1) {
?>
	<div id="waitDiv" style="position:absolute; left:40%; top:50%; visibility:hidden; text-align:center;">
	<?php theme_waitbox();?>
	</div>
	<script type='text/javascript'>
	<!--
	toggle_visibility('waitDiv', 1);
	//-->
	</script>
<?php
}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function CloseWaitBox()  {
?>
	<script type='text/javascript'>
	<!--
	toggle_visibility('waitDiv', 0);
	//-->
	</script>
<?php
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function ex_srand() {
	$seed = hexdec(substr(md5(microtime()), -8)) & 0x7fffffff;
	mt_srand($seed);
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function makepass() {

$consonents = "bcdfghjklmnpqrstvwxyz";
$voyelles   = "aeiou";

ex_srand();

for ($i=0; $i<4; $i++) {
	$makepass .= substr($consonents, mt_rand(0, strlen($consonents)-1), 1);
	$makepass .= substr($voyelles  , mt_rand(0, strlen($voyelles)-1)  , 1);
}

return ($makepass);
}


//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param array  $input An array of regular expressions
* @param string $match The string we are matching
* @return bool True/False based on matches
*/
function hasMatch($input=array(), $match=0) {

if ( !empty($input) && !empty($match) ) {
	foreach ($input as $entry) {
		$entry = trim($entry);
		if ( !empty($entry) && preg_match($entry, trim($match), $matches) ) {
			return $matches;
		}
	}
}

return false;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function checkIp($ip=0) {
global $xoopsBadIps;
return hasMatch($xoopsBadIps, $ip);
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function checkEmail($email) {

if ( empty($email) || !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+([\.][a-z0-9-]+)+$/i", $email) ) {
	return false;
	}

return true;
}

//---------------------------------------------------------------------------------------//
/**
* NOT DONE DONT USE
* Returns the GMT timestamp for now or a given offset
*
* @param type $var description
* @return type description
*/
function gmtime($time=0, $offset=0) {

if ( empty($offset) ) {
	return gmmktime();
	} else {
		return gmmktime(0, 0, 0, 0, 0, 0, intval($offset));
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function formatURL($url='', $file='') {

if ( ($url != '') && !preg_match("'^((http|https|ftp|ftps|ed2k|ajsfp)://{1})$'i", $url) ) {
	if ($file != '') {
		if ( preg_match("'^((http|https|ftp|ftps|ed2k|ajsfp)://{1}.{3,})'i", $file) ) {
			return $file;
			} elseif (substr($url, -1) != '/') {
				$file = '/'.$file;
			}
	}
	if ( preg_match("'^((http|https|ftp|ftps|ed2k|ajsfp)://{1}.{3,})'i", $url) ) {
		return $url.$file;
		} else {
			return "http://".$url.$file;
		}
}
return NULL;
}

//----------------------------------------------------------------------------------------//
/**
* Prints allowed html tags on this site
*/
function get_allowed_html() {
global $xoopsUser, $xoopsModule, $xoopsConfig;

if ($xoopsUser) {
	$mid = $xoopsModule ? $xoopsModule->mid() : 0;
	if ($xoopsUser->isAdmin($mid)) {
		$html = $xoopsConfig['admin_html'];
		} else {
			$html = $xoopsConfig['user_html'];
		}
	$allowed = str_replace("|", "> <", "<".$html.">");
	$allowed = htmlspecialchars($allowed);
}

return $allowed;
}

//----------------------------------------------------------------------------------------//
/**
* DEPRACTED ..use getMailer()
*/
function xoops_mail($to, $subject, $message, $headers='') {
global $xoopsConfig, $meta;

$mail =& getMailer();
$mail->useMail();

$mail->setFromName($meta['title']);
$mail->setFromEmail($xoopsConfig['adminmail']);
$mail->setToEmails($to);
$mail->setSubject($subject);
$mail->setBody($message);

$mail->send();

echo $mail->getSuccess();
echo $mail->getErrors();
}

//----------------------------------------------------------------------------------------//
/**
* Function to display banners in all pages
*/
function showbanner($display="N") {

if ( file_exists(XOOPS_ROOT_PATH .'/modules/banners/include/functions.php') ) {
	include_once(XOOPS_ROOT_PATH .'/modules/banners/include/functions.php');
	if ( function_exists('show_banner') ) {
		show_banner($display);
	}
}
}

//----------------------------------------------------------------------------------------//
/**
* Function to redirect a user to certain pages
*/
function redirect_header($url, $time=4, $message=_TAKINGBACK) {
global $xoopsConfig, $meta;
?>

<html><head>
<title><?php echo $meta['title'];?></title>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo _CHARSET;?>" />
<meta http-equiv="Refresh" content="<?php echo $time;?>; url=<?php echo $url;?>" />
<style type="text/css">
	.redirect {
		width: 70%;
		margin: 50px;
		text-align: center;
		padding: 15px;
		border: 1px dashed;
	}
</style>
<?php
$themecss = getcss(getTheme());
if ($themecss) {
	echo "<link href='$themecss' rel='stylesheet' type='text/css' />";
}
?>
</head><body>
<div align="center">

<div class="redirect">
<h4><?php echo $message;?></h4>
<hr size="1" noshade="noshade" />
<b>
<?php
printf(_IFNOTRELOAD, $url);
?>
</b>
</div>

</div>
</body></html>

<?php
}

//----------------------------------------------------------------------------------------//
/**
* Function to get a user selected theme file
*/
function getTheme() {
global $xoopsConfig, $xoopsUser;

if (!$xoopsUser) {
	return $xoopsConfig['default_theme'];
	}

$themedir = XOOPS_ROOT_PATH . "/themes";
$theme    = $xoopsUser->getVar("theme");

if ( @file_exists("$themedir/$theme/theme.php") ) {
	return $theme;
	} else {
	return $xoopsConfig['default_theme'];
	}
}

//----------------------------------------------------------------------------------------//
/**
* Function to get css file for a certain theme
*/
function getcss($theme) {
global $xoopsModule;

$theme_dir = XOOPS_ROOT_PATH.'/themes/'.$theme.'/style';
$theme_url = XOOPS_URL.'/themes/'.$theme.'/style';
$mod_dir   = $xoopsModule ? $xoopsModule->dirname() : FALSE;

if ( preg_match('/(MSIE)|(Opera)/i', _HTTP_USER_AGENT) ) {

	if ( $mod_dir && @file_exists($theme_dir.'/'.$mod_dir.'_style.css') ) {
		return ($theme_url.'/'.$mod_dir.'_style.css');

		} elseif ( @file_exists($theme_dir.'/style.css') ) {
			return ($theme_url.'/style.css');
		}

	} else {

	if ( $mod_dir && @file_exists($theme_dir.'/'.$mod_dir.'_styleNN.css') ) {
		return ($theme_url.'/'.$mod_dir.'_styleNN.css');

		} elseif ( @file_exists($theme_dir.'/styleNN.css') ) {
			return ($theme_url.'/styleNN.css');

			} elseif ( $mod_dir && @file_exists($theme_dir.'/'.$mod_dir.'_style.css') ) {
				return ($theme_url.'/'.$mod_dir.'_style.css');

				} elseif ( @file_exists($theme_dir.'/style.css') ) {
					return ($theme_url.'/style.css');
		}

	}
}

//---------------------------------------------------------------------------------------//
/**
* Returns resized dimension values for a given image
* Copy this function if ya like, but dont use it ..will prolly be moved.
*
* Example:
* if ( $size = resizedImage("/images/image.gif", 50, "h") ) {
* 	$size = " height='$size[h]' width='$size[w]'";
* 	}
* echo "<img src='".XOOPS_URL."/images/image.gif' border='0'$size>";
*
* @param string $image File or URL path to image in question
* @param integer $maxsize Maximum size of image
* @param string $orientation What $maxsize applies to: height or width
* @return array An array containing the height/width values
*/
function resizedImage($image, $maxsize=150, $orientation="w" ) {

if ( $maxsize == 0 || !is_numeric($maxsize) ) {
	$maxsize = 150;
	}

if ( $orientation != "w" && $orientation != "h" ) {
	$orientation = "w";
	}

$size = @getimagesize($image);

if ( is_numeric($size[0]) && is_numeric($size[1]) ) {
	$img['w'] = $size[0];
	$img['h'] = $size[1];

	switch($orientation) {
	case "w":
		if ( $img['w'] > $maxsize ) {
			$img['h'] = round( ( $img['h'] / ($img['w'] / $maxsize) ) );
			$img['w'] = $maxsize;
		}
		break;

	case "h":
		if ( $img['h'] > $maxsize ) {
			$img['w'] = round( ( $img['w'] / ($img['h'] / $maxsize) ) );
			$img['h'] = $maxsize;
		}
		break;
	}
	return $img;
	} else {
		return(FALSE);
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function avatarExists($uid) {
global $xoopsConfig;

// recommend not to change this
$allowed_ext = array("gif", "jpeg", "jpg", "png");

foreach($allowed_ext as $ext) {
	if ( @file_exists(XOOPS_ROOT_PATH."/images/avatar/users/".$uid.".".$ext ) ) {
		return "users/".$uid.".".$ext;
		}
	}

return false;
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function &getMailer() {
global $xoopsConfig;

if ( class_exists("xoopsmailer") ) {
	return new XoopsMailer();
	} else {
		include_once(XOOPS_ROOT_PATH."/class/xoopsmailer.php");
		return new XoopsMailer();
	}
}

//--------------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function cookie($name, $value='', $time=0, $path='/') {

$expire = gmdate("D, d-M-Y H:i:s", time()+$time);
$time ? header("Set-Cookie: $name=$value; expires=$expire GMT; path=$path") : header("Set-Cookie: $name=$value; path=$path");
}


// #################### Block functions from here ##################

//----------------------------------------------------------------------------------------//
/**
* Purpose : Builds the blocks on both sides
* Input   : $side = On wich side should the block are displayed?
* 0, l, left : On the left side
* 1, r, right: On the right side
*  other:   Only on one side (
* Call from theme.php makes all blocks on the left side
* and from theme.php for the right site)
*/
function make_sidebar($side) {
global $xoopsUser, $xoopsModule, $xoopsOption;

$xoopsblock = new XoopsBlock();
$arr        = array();
$mid        = $xoopsModule ? $xoopsModule->mid() : 0;
$page_style = intval($xoopsOption['page_style']);
$page_style = empty($page_style) ? 4 : $page_style;

/*
$page_style
1 = start
2 = index
4 = other
8 = special
*/

if ($side == "left") {
	$side = XOOPS_SIDEBLOCK_LEFT;
	} elseif ( $side == "right" ) {
		$side = XOOPS_SIDEBLOCK_RIGHT;
		} else {
			$side = XOOPS_SIDEBLOCK_BOTH;
		}

if ($xoopsUser) {
	$arr =& $xoopsblock->getAllBlocksByGroup($xoopsUser->groups(), true, $side, XOOPS_BLOCK_VISIBLE, "b.weight, b.bid", 1, $mid, $page_style);
	} else {
		$arr =& $xoopsblock->getAllBlocksByGroup(XoopsGroup::getByType("Anonymous"), true, $side, XOOPS_BLOCK_VISIBLE, "b.weight, b.bid", 1, $mid, $page_style);
	}

foreach ( $arr as $myblock ) {
	$block = array();
	$block =& $myblock->buildBlock();

	if ($block) {
		if ($side == XOOPS_SIDEBLOCK_LEFT) {
			themesidebox_left($block['title'], $block['content']);
			} else {
				themesidebox_right($block['title'], $block['content']);
			}
	}
unset($myblock);
unset($block);
} // END FOREACH
}

//----------------------------------------------------------------------------------------//
/**
* Function to display center block
*/
function make_cblock($side=XOOPS_CENTERBLOCK_TOPALL) {
global $xoopsUser, $xoopsModule, $xoopsOption;

// Backwards compatibility with old modules
if (!defined('CENTERBLOCKS_'.$side.'_INCLUDED')) {
	define('CENTERBLOCKS_'.$side.'_INCLUDED', 1);
	} else {
		return;
	}

$xoopsblock = new XoopsBlock();
$cc_block   = $cl_block = $cr_block = "";
$arr        = array();
$side       = ($side == XOOPS_CENTERBLOCK_TOPALL) ? XOOPS_CENTERBLOCK_TOPALL : XOOPS_CENTERBLOCK_BOTTOMALL;
$mid        = $xoopsModule ? $xoopsModule->mid() : 0;

$page_style = intval($xoopsOption['page_style']);
$page_style = empty($page_style) ? 4 : $page_style;   //

/*
$page_style
1 = start
2 = index
4 = other
8 = special
*/

if ($xoopsUser) {
	$arr =& $xoopsblock->getAllBlocksByGroup($xoopsUser->groups(), true, $side, XOOPS_BLOCK_VISIBLE, "b.weight, b.bid", 1, $mid, $page_style);
	} else {
		$arr =& $xoopsblock->getAllBlocksByGroup(XoopsGroup::getByType("Anonymous"), true, $side, XOOPS_BLOCK_VISIBLE, "b.weight, b.bid", 1, $mid, $page_style);
	}

if (!empty($arr)) {

if ($side == XOOPS_CENTERBLOCK_BOTTOMALL) {
	echo '<br />';
}

OpenTable();

foreach ($arr as $myblock) {
	$block = array();
	$block =& $myblock->buildBlock();

	$nextblock++;
	$prevblock = ($nextblock-2);

	if ($prevblock >= 0) {
		$prev = $arr[$prevblock]->getVar("side");
		} else {
			$prev = '';
		}

	if ( $nextblock < count($arr) ) {
		$curr = $myblock->getVar("side");
		$next = $arr[$nextblock]->getVar("side");
		} else {
			$curr = $myblock->getVar("side");
			$next = '';
		}

if ($block) {

if (($myblock->getVar("side") == XOOPS_CENTERBLOCK_TOPLEFT) || ($myblock->getVar("side") == XOOPS_CENTERBLOCK_BOTTOMLEFT)) {

	if (($next == XOOPS_CENTERBLOCK_TOPRIGHT) || ($next == XOOPS_CENTERBLOCK_BOTTOMRIGHT)) {
		echo "
		<table align='center' valign='top' width='100%' cellpadding='0' cellspacing='0' border='0'>
		<tr><td align='center' valign='top' width='50%'>";
		themecenterbox_left($block['title'], $block['content']);
		echo "</td>";
		} else {
			echo "
			<table align='center' valign='top' width='100%' cellpadding='0' cellspacing='0' border='0'>
			<tr><td align='center' valign='top' width='50%'>";
			themecenterbox_right($block['title'], $block['content']);
			echo "</td><td width='50%'>&nbsp;</td></tr></table>";
		}

} elseif (($myblock->getVar("side") == XOOPS_CENTERBLOCK_TOPRIGHT) || ($myblock->getVar("side") == XOOPS_CENTERBLOCK_BOTTOMRIGHT)) {

	if (($prev == XOOPS_CENTERBLOCK_TOPLEFT) || ($prev == XOOPS_CENTERBLOCK_BOTTOMLEFT)) {
		echo "<td align='center' valign='top' width='50%'>";
		themecenterbox_right($block['title'], $block['content']);
		echo "</td></tr></table>";
		} else {
			echo "
			<table align='center' valign='top' width='100%' cellpadding='0' cellspacing='0' border='0'>
			<tr><td width='50%'>&nbsp;</td><td align='center' valign='top' width='50%'>";
			themecenterbox_left($block['title'], $block['content']);
			echo "</td></tr></table>";
		}

} elseif (($myblock->getVar("side") == XOOPS_CENTERBLOCK_TOPCENTER) || ($myblock->getVar("side") == XOOPS_CENTERBLOCK_BOTTOMCENTER)) {
	themecenterbox_center($block['title'], $block['content']);
}


} // END $block
unset($myblock);
unset($block);
} // END FOREACH

CloseTable();
} // END count($arr)
}

//---------------------------------------------------------------------------------------//
/**
* Depracted
*/
function openThread($width="100%") {
}
//---------------------------------------------------------------------------------------//
/**
* Depracted
*/
function closeThread() {
}

//---------------------------------------------------------------------------------------//
/**
* Depracted & moved to theme :: use theme_post()
* Shows thread content for forum/comments
*/
function showThread($color_number, $subject_image, $subject, $text, $post_date, $ip_image, $reply_image, $edit_image, $delete_image, $username="", $rank_title="", $rank_image="", $avatar_image="", $reg_date="", $posts="", $user_from="", $online_image="", $profile_image="", $pm_image="", $email_image="", $www_image="", $icq_image="", $aim_image="", $yim_image="", $msnm_image="") {

if ( function_exists('theme_post') ) {
	theme_post($subject, $text, $color_number, $subject_image, $post_date, $ip_image, $reply_image, $edit_image, $delete_image, $username, $rank_title, $rank_image, $avatar_image, $reg_date, $posts, $user_from, $online_image, $profile_image, $pm_image, $email_image, $www_image, $icq_image, $aim_image, $yim_image, $msnm_image);
	} else {
		if ($color_number == 1) {
			$bg1 = 'bg1';
			$bg2 = 'bg3';
			} else {
				$bg1 = 'bg3';
				$bg2 = 'bg1';
			}
		?>
		<!-- HTML CODE -->
		<br />
		<table border="0" cellpadding="0" cellspacing="0" align="center" valign="top" width="100%"><tr>
		<td class="bg2">

		<table border="0" cellpadding="4" cellspacing="1" width="100%"><tr class="<?php echo $bg2;?>" align="left">

		<td width="110" valign="absmiddle"><b><?php echo $username;?></b></td>
		<td valign="absmiddle"><?php echo $subject_image;?> <b><?php echo $subject;?></b></td>
		</tr><tr class="<?php echo $bg1;?>" align="left">

		<td width="110" valign="top">
		<?php echo $rank_image;?><br />
		<?php echo $rank_title;?><br /><br />
		<div align="center"><?php echo $avatar_image;?></div><br />

		<div style="border: 1px solid; padding: 2px 2px 2px 2px;" class="<?php echo $bg2;?>">
		<?php echo $reg_date;?><br />
		<?php echo $posts;?><br />
		<?php echo $user_from;?>
		</div>

		<br /><br />
		<?php echo $online_image;?>

		<!-- SPACER IMAGE -->
		<img width="110" height="1" src="<?php echo XOOPS_URL."/themes/".XOOPS_THEME;?>/images/pixel.gif">
		</td>

		<td valign="top">
		<table width="100%" border="0"><tr>
		<td align="right" valign="absmiddle"><?php echo $ip_image;?> <?php echo $delete_image;?> <?php echo $edit_image;?> <?php echo $reply_image;?></td>
		</tr><tr>
		<td><?php echo $text;?></td>
		</tr></table>
		</td>

		</tr><tr class="<?php echo $bg2;?>" align="left">
		<td width="110" nowrap><b>&raquo;</b><?php echo $post_date;?></td>
		<td valign="absmiddle"><?php echo $profile_image;?> <?php echo $pm_image;?> <?php echo $email_image;?> <?php echo $www_image;?> <?php echo $icq_image;?> <?php echo $aim_image;?> <?php echo $yim_image;?> <?php echo $msnm_image;?></td>
		</tr></table></td>
		</tr></table>
		<!-- HTML CODE -->
		<?php
	}
}

//---------------------------------------------------------------------------------------//
/**
* Description
*
* @param type $var description
* @return type description
*/
function ex_error_handler($errno='', $errstr='', $errfile='', $errline='') {
global $xoopsConfig;

$errortype = array (
			1    => _ERR_ERROR,
			2    => _ERR_WARNING,
			4    => _ERR_PARSE,
			8    => _ERR_NOTICE,
			16   => _ERR_CORE_ERROR,
			32   => _ERR_CORE_WARNING,
			64   => _ERR_COMPILE_ERROR,
			128  => _ERR_COMPILE_WARNING,
			256  => _ERR_USER_ERROR,
			512  => _ERR_USER_WARNING,
			1024 => _ERR_USER_NOTICE
			);

if (($xoopsConfig['debug_mode'] & 1) && (error_reporting() & $errno)) {
	$output .= '
		<div class="errhandler">
		'._ERR_NUMBER.': '.$errno.' ['.$errortype[$errno].']<br />
		'._ERR_MESSAGE.': <b>'.$errstr.'</b><br />
		'._ERR_FILE.': <a href="'.XOOPS_URL.'/class/debug/highlight.php?file='.$errfile.'&line='.$errline.'#'.$errline.'" title="'._ERR_SHOW.'" target="errcode">'.$errfile.'</a><br />
		'._ERR_LINE.': '.$errline.'
		</div><br />';
	echo $output;
}
}
//---------------------------------------------------------------------------------------//
}
?>
