# --------------------------------------------------------

#
# Table structure for table `comments`
#

CREATE TABLE comments (
  comment_id mediumint(8) unsigned NOT NULL auto_increment,
  pid mediumint(8) unsigned NOT NULL default '0',
  item_id mediumint(8) unsigned NOT NULL default '0',
  date int(10) unsigned NOT NULL default '0',
  user_id mediumint(8) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  comment text NOT NULL,
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '0',
  type enum('admin','user') NOT NULL default 'user',
  icon varchar(255) NOT NULL default '',
  attachsig tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (comment_id),
  KEY idx (item_id)
) TYPE=MyISAM;

#
# Dumping data for table `comments`
#

# --------------------------------------------------------

#
# Table structure for table `groups`
#

CREATE TABLE groups (
  groupid mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(30) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  type enum('Admin','User','Anonymous','Custom') NOT NULL default 'Custom',
  PRIMARY KEY  (groupid),
  KEY idx (type)
) TYPE=MyISAM;

#
# Dumping data for table `groups`
#

INSERT INTO groups VALUES (1, 'webmaster', 'webmasters of this site', 'Admin');
INSERT INTO groups VALUES (2, 'Registered Users', 'Registered Users Group', 'User');
INSERT INTO groups VALUES (3, 'Anonymous Users', 'Anonymous Users Group', 'Anonymous');
# --------------------------------------------------------

#
# Table structure for table `groups_blocks_link`
#

CREATE TABLE groups_blocks_link (
  groupid mediumint(8) unsigned NOT NULL default '0',
  block_id mediumint(8) unsigned NOT NULL default '0',
  type char(1) NOT NULL default ''
) TYPE=MyISAM;

#
# Dumping data for table `groups_blocks_link`
#

INSERT INTO groups_blocks_link VALUES (1, 9, 'R');
INSERT INTO groups_blocks_link VALUES (1, 8, 'R');
INSERT INTO groups_blocks_link VALUES (1, 7, 'R');
INSERT INTO groups_blocks_link VALUES (1, 6, 'R');
INSERT INTO groups_blocks_link VALUES (1, 5, 'R');
INSERT INTO groups_blocks_link VALUES (2, 9, 'R');
INSERT INTO groups_blocks_link VALUES (2, 8, 'R');
INSERT INTO groups_blocks_link VALUES (2, 7, 'R');
INSERT INTO groups_blocks_link VALUES (2, 6, 'R');
INSERT INTO groups_blocks_link VALUES (3, 9, 'R');
INSERT INTO groups_blocks_link VALUES (3, 8, 'R');
INSERT INTO groups_blocks_link VALUES (3, 7, 'R');
INSERT INTO groups_blocks_link VALUES (3, 6, 'R');
INSERT INTO groups_blocks_link VALUES (1, 4, 'R');
INSERT INTO groups_blocks_link VALUES (1, 3, 'R');
INSERT INTO groups_blocks_link VALUES (1, 2, 'R');
INSERT INTO groups_blocks_link VALUES (1, 1, 'R');
INSERT INTO groups_blocks_link VALUES (2, 5, 'R');
INSERT INTO groups_blocks_link VALUES (2, 3, 'R');
INSERT INTO groups_blocks_link VALUES (2, 2, 'R');
INSERT INTO groups_blocks_link VALUES (2, 1, 'R');
INSERT INTO groups_blocks_link VALUES (3, 5, 'R');
INSERT INTO groups_blocks_link VALUES (3, 3, 'R');
INSERT INTO groups_blocks_link VALUES (3, 2, 'R');
INSERT INTO groups_blocks_link VALUES (3, 1, 'R');
INSERT INTO groups_blocks_link VALUES (1, 10, 'R');
INSERT INTO groups_blocks_link VALUES (2, 10, 'R');
INSERT INTO groups_blocks_link VALUES (3, 10, 'R');
# --------------------------------------------------------

#
# Table structure for table `groups_modules_link`
#

CREATE TABLE groups_modules_link (
  groupid mediumint(8) unsigned NOT NULL default '0',
  mid mediumint(8) unsigned NOT NULL default '0',
  type char(1) NOT NULL default ''
) TYPE=MyISAM;

#
# Dumping data for table `groups_modules_link`
#

INSERT INTO groups_modules_link VALUES (1, 2, 'R');
INSERT INTO groups_modules_link VALUES (1, 2, 'A');
INSERT INTO groups_modules_link VALUES (1, 1, 'R');
INSERT INTO groups_modules_link VALUES (1, 1, 'A');
INSERT INTO groups_modules_link VALUES (2, 2, 'R');
INSERT INTO groups_modules_link VALUES (2, 1, 'R');
INSERT INTO groups_modules_link VALUES (3, 2, 'R');
INSERT INTO groups_modules_link VALUES (3, 1, 'R');
# --------------------------------------------------------

#
# Table structure for table `groups_users_link`
#

CREATE TABLE groups_users_link (
  groupid mediumint(8) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0'
) TYPE=MyISAM;

#
# Dumping data for table `groups_users_link`
#

INSERT INTO groups_users_link VALUES (1, 1);
INSERT INTO groups_users_link VALUES (2, 1);
# --------------------------------------------------------

#
# Table structure for table `modules`
#

CREATE TABLE modules (
  mid mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(60) NOT NULL default '',
  version float(3,2) unsigned NOT NULL default '1.00',
  last_update int(10) unsigned NOT NULL default '0',
  weight smallint(3) NOT NULL default '0',
  isactive tinyint(1) unsigned NOT NULL default '0',
  dirname varchar(30) NOT NULL default '',
  config text,
  hasmain tinyint(1) unsigned NOT NULL default '0',
  hasadmin tinyint(1) unsigned NOT NULL default '0',
  hassearch tinyint(1) unsigned NOT NULL default '0',
  haswaiting tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (mid),
  KEY idx (dirname,isactive)
) TYPE=MyISAM;

#
# Dumping data for table `modules`
#

INSERT INTO modules VALUES (1, 'System Admin', '1.01', 1045648920, 0, 1, 'system', '', 0, 1, 0, 0);
INSERT INTO modules VALUES (2, 'News', '1.10', 1030908717, 1, 1, 'news', '', 1, 1, 1, 1);
# --------------------------------------------------------

#
# Table structure for table `newblocks`
#

CREATE TABLE newblocks (
  bid mediumint(8) unsigned NOT NULL auto_increment,
  mid mediumint(8) unsigned NOT NULL default '0',
  func_num tinyint(3) unsigned NOT NULL default '0',
  options varchar(255) NOT NULL default '',
  name varchar(60) NOT NULL default '',
  position tinyint(1) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  content text,
  side tinyint(3) unsigned NOT NULL default '0',
  weight smallint(3) NOT NULL default '0',
  visible tinyint(1) unsigned NOT NULL default '0',
  type char(1) NOT NULL default 'C',
  c_type char(1) NOT NULL default '',
  isactive tinyint(1) unsigned NOT NULL default '0',
  iscopy tinyint(1) unsigned NOT NULL default '0',
  dirname varchar(30) NOT NULL default '',
  func_file varchar(30) NOT NULL default '',
  show_func varchar(30) NOT NULL default '',
  show_mid mediumint(8) unsigned NOT NULL default '0',
  page_style tinyint(2) unsigned NOT NULL default '3',
  edit_func varchar(30) NOT NULL default '',
  PRIMARY KEY  (bid),
  KEY idx (mid,isactive,side,visible)
) TYPE=MyISAM;

#
# Dumping data for table `newblocks`
#

INSERT INTO newblocks VALUES (1, 1, 1, '', 'User Block', 1, '', '', 0, 0, 1, 'S', '', 1, 0, 'system', 'system_user.php', 'b_system_user_show', 0, 3, '');
INSERT INTO newblocks VALUES (2, 1, 2, '', 'Login Block', 1, '', '', 1, 1, 1, 'S', '', 1, 0, 'system', 'system_login.php', 'b_system_login_show', 0, 3, '');
INSERT INTO newblocks VALUES (3, 1, 3, '', 'Search Block', 1, '', '', 0, 0, 0, 'S', '', 1, 0, 'system', 'system_search.php', 'b_system_search_show', 0, 3, '');
INSERT INTO newblocks VALUES (4, 1, 4, '', 'Waiting Contents Block', 1, '', '', 0, 1, 1, 'S', '', 1, 0, 'system', 'system_waiting.php', 'b_system_waiting_show', 0, 3, '');
INSERT INTO newblocks VALUES (5, 1, 5, '', 'Dynamic Main Menu', 0, '', '', 0, 2, 1, 'S', '', 1, 0, 'system', 'system_menu.php', 'b_system_main_dynshow', 0, 3, '');
INSERT INTO newblocks VALUES (6, 1, 6, '320|250|button.gif|1', 'Site Info Block', 0, '', '', 0, 3, 1, 'S', 'H', 1, 0, 'system', 'system_info.php', 'b_system_info_show', 0, 3, 'b_system_info_edit');
INSERT INTO newblocks VALUES (7, 2, 1, '', 'News Topics Block', 0, '', '', 0, 0, 0, 'M', '', 1, 0, 'news', 'news_topics.php', 'b_news_topics_show', 0, 3, '');
INSERT INTO newblocks VALUES (8, 2, 2, '', 'Big Story Block', 0, '', '', 1, 0, 0, 'M', '', 1, 0, 'news', 'news_bigstory.php', 'b_news_bigstory_show', 0, 3, '');
INSERT INTO newblocks VALUES (9, 2, 3, 'counter|0|19|5', 'Top News Block', 0, '', '', 4, 1, 1, 'M', 'H', 1, 0, 'news', 'news_top.php', 'b_news_top_show', 0, 3, 'b_news_top_edit');
INSERT INTO newblocks VALUES (10, 2, 4, 'published|0|19|5', 'Recent News Block', 0, '', '', 3, 0, 1, 'M', 'H', 1, 0, 'news', 'news_top.php', 'b_news_top_show', 0, 3, 'b_news_top_edit');
# --------------------------------------------------------

#
# Table structure for table `priv_msgs`
#

CREATE TABLE priv_msgs (
  msg_id mediumint(8) unsigned NOT NULL auto_increment,
  msg_image varchar(255) NOT NULL default '',
  subject varchar(60) NOT NULL default '',
  from_userid mediumint(8) unsigned NOT NULL default '0',
  to_userid mediumint(8) unsigned NOT NULL default '0',
  msg_time int(10) unsigned NOT NULL default '0',
  msg_text text NOT NULL,
  read_msg tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (msg_id),
  KEY idx (to_userid)
) TYPE=MyISAM;

#
# Dumping data for table `priv_msgs`
#

# --------------------------------------------------------

#
# Table structure for table `ranks`
#

CREATE TABLE ranks (
  rank_id mediumint(8) unsigned NOT NULL auto_increment,
  rank_title varchar(60) NOT NULL default '',
  rank_min int(10) NOT NULL default '0',
  rank_max int(10) NOT NULL default '0',
  rank_special tinyint(1) unsigned NOT NULL default '0',
  rank_image varchar(255) NOT NULL default '',
  PRIMARY KEY  (rank_id)
) TYPE=MyISAM;

#
# Dumping data for table `ranks`
#

INSERT INTO ranks VALUES (2, 'Just popping in', 0, 20, 0, '');
INSERT INTO ranks VALUES (3, 'Not too shy to talk', 21, 40, 0, 'rank1.gif');
INSERT INTO ranks VALUES (4, 'Quite a regular', 41, 70, 0, 'rank2.gif');
INSERT INTO ranks VALUES (5, 'Just can\'t stay away', 71, 150, 0, 'rank3.gif');
INSERT INTO ranks VALUES (6, 'Home away from home', 151, 10000, 0, 'rank4.gif');
INSERT INTO ranks VALUES (7, 'Webmaster', -1, -1, 1, 'webmaster.gif');
INSERT INTO ranks VALUES (8, 'Moderator', -1, -1, 1, 'moderator.gif');
# --------------------------------------------------------

#
# Table structure for table `session`
#

CREATE TABLE session (
  uid mediumint(8) unsigned NOT NULL default '0',
  uname varchar(30) NOT NULL default '',
  time int(10) unsigned NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  mid mediumint(8) unsigned NOT NULL default '0',
  hash varchar(32) NOT NULL default '',
  KEY idx (uid,hash)
) TYPE=MyISAM;

#
# Dumping data for table `session`
#

# --------------------------------------------------------

#
# Table structure for table `smiles`
#

CREATE TABLE smiles (
  id mediumint(8) unsigned NOT NULL auto_increment,
  code varchar(30) NOT NULL default '',
  smile_url varchar(255) NOT NULL default '',
  emotion varchar(60) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

#
# Dumping data for table `smiles`
#

INSERT INTO smiles VALUES (1, ':-D', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO smiles VALUES (2, ':-)', 'icon_smile.gif', 'Smile');
INSERT INTO smiles VALUES (3, ':-(', 'icon_frown.gif', 'Sad');
INSERT INTO smiles VALUES (4, ':-o', 'icon_eek.gif', 'Surprised');
INSERT INTO smiles VALUES (5, ':-?', 'icon_confused.gif', 'Confused');
INSERT INTO smiles VALUES (6, '8-)', 'icon_cool.gif', 'Cool');
INSERT INTO smiles VALUES (7, ':lol:', 'icon_lol.gif', 'Laughing');
INSERT INTO smiles VALUES (8, ':-x', 'icon_mad.gif', 'Mad');
INSERT INTO smiles VALUES (9, ':-P', 'icon_razz.gif', 'Razz');
INSERT INTO smiles VALUES (10, ':oops:', 'icon_redface.gif', 'Embaressed');
INSERT INTO smiles VALUES (11, ':cry:', 'icon_cry.gif', 'Crying (very sad)');
INSERT INTO smiles VALUES (12, ':evil:', 'icon_evil.gif', 'Evil or Very Mad');
INSERT INTO smiles VALUES (13, ':roll:', 'icon_rolleyes.gif', 'Rolling Eyes');
INSERT INTO smiles VALUES (14, ';-)', 'icon_wink.gif', 'Wink');
INSERT INTO smiles VALUES (15, ':pint:', 'icon_drink.gif', 'Another pint of beer');
INSERT INTO smiles VALUES (16, ':hammer:', 'icon_hammer.gif', 'ToolTimes at work');
INSERT INTO smiles VALUES (17, ':idea:', 'icon_idea.gif', 'I have an idea');
# --------------------------------------------------------

#
# Table structure for table `stories`
#

CREATE TABLE stories (
  storyid mediumint(8) unsigned NOT NULL auto_increment,
  uid mediumint(8) unsigned NOT NULL default '0',
  title varchar(60) NOT NULL default '',
  created int(10) unsigned NOT NULL default '0',
  published int(10) unsigned NOT NULL default '0',
  hostname varchar(15) NOT NULL default '',
  allow_html tinyint(1) unsigned NOT NULL default '0',
  allow_smileys tinyint(1) unsigned NOT NULL default '0',
  allow_bbcode tinyint(1) unsigned NOT NULL default '1',
  hometext text NOT NULL,
  bodytext text,
  counter mediumint(8) unsigned NOT NULL default '0',
  topicid mediumint(8) unsigned NOT NULL default '1',
  ihome tinyint(1) unsigned NOT NULL default '0',
  notifypub tinyint(1) unsigned NOT NULL default '0',
  type enum('admin','user') NOT NULL default 'user',
  topicdisplay tinyint(1) unsigned NOT NULL default '0',
  topicalign enum('R','L','0') NOT NULL default '0',
  PRIMARY KEY  (storyid),
  KEY idx (topicid,published,ihome,created)
) TYPE=MyISAM;

#
# Dumping data for table `stories`
#

INSERT INTO stories VALUES (1, 1, 'Welcome to your new site', 1030894461, 1030894461, '150.0.0.0', 0, 1, 1, 'To login, simply use the UserName/Password you provided during the setup process.\r\n\r\nIf you did a SQL dump, then simply login with Admin/admin (case sensitive), and be sure to change your login information!\r\n\r\nAlso remember change file permissions on mainfile.php back to read-only (0444 unix), and be sure to delete the entire /_install folder from your server for security reasons.\r\n\r\n[b][size=xx-small]REMEMBER:[/size][/b]\r\nTo be able to save your configuration data, you need to make all /cache folders world writable (0777), and any files in them (0666).', '', 1, 1, 0, 0, 'admin', 1, 'R');
# --------------------------------------------------------

#
# Table structure for table `topics`
#

CREATE TABLE topics (
  topic_id mediumint(8) unsigned NOT NULL auto_increment,
  topic_pid mediumint(8) unsigned NOT NULL default '0',
  topic_imgurl varchar(255) NOT NULL default '',
  topic_title varchar(60) NOT NULL default '',
  PRIMARY KEY  (topic_id),
  KEY idx (topic_pid)
) TYPE=MyISAM;

#
# Dumping data for table `topics`
#

INSERT INTO topics VALUES (1, 0, 'runcms.gif', 'RUNCMS');
# --------------------------------------------------------

#
# Table structure for table `users`
#

CREATE TABLE users (
  uid mediumint(8) unsigned NOT NULL auto_increment,
  name varchar(30) NOT NULL default '',
  uname varchar(30) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  user_avatar varchar(255) NOT NULL default '',
  user_regdate int(10) unsigned NOT NULL default '0',
  user_icq varchar(15) NOT NULL default '',
  user_from varchar(60) NOT NULL default '',
  user_sig varchar(255) NOT NULL default '',
  user_viewemail tinyint(1) unsigned NOT NULL default '0',
  actkey varchar(8) NOT NULL default '',
  user_aim varchar(60) NOT NULL default '',
  user_yim varchar(60) NOT NULL default '',
  user_msnm varchar(60) NOT NULL default '',
  pass varchar(32) NOT NULL default '',
  posts smallint(5) unsigned NOT NULL default '0',
  attachsig tinyint(1) unsigned NOT NULL default '0',
  rank int(5) NOT NULL default '0',
  level int(5) NOT NULL default '1',
  theme varchar(30) NOT NULL default '',
  timezone_offset tinyint(2) NOT NULL default '0',
  last_login int(10) unsigned NOT NULL default '0',
  umode enum('flat','thread','0') NOT NULL default 'flat',
  uorder tinyint(1) unsigned NOT NULL default '0',
  user_occ varchar(60) NOT NULL default '',
  bio varchar(255) NOT NULL default '',
  user_intrest varchar(255) NOT NULL default '',
  user_mailok tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (uid),
  UNIQUE KEY email (email),
  UNIQUE KEY uname (uname),
  KEY idx (uname)
) TYPE=MyISAM;

#
# Dumping data for table `users`
#

INSERT INTO users VALUES (1, '', 'Admin', 'admin@mysite.com', '', '001.gif', 1030894461, '', '', '', 1, '', '', '', '', '21232f297a57a5a743894a0e4a801fc3', 0, 0, 7, 5, 'runcms', '0.0', 1030908625, 'flat', 0, '', '', '', 1);

