# encoding: utf-8

require 'win32/registry'

module Rumix
	class Registry
		PRIMARY_KEY = Win32::Registry::HKEY_LOCAL_MACHINE
		SUB_KEY = 'Software\\Rumix-RSP'
		
		attr_accessor :install_path
	
		def self.load(sub_key = SUB_KEY)
			self.new(sub_key).load
		end
		
		def initialize(sub_key = SUB_KEY)
			@sub_key = sub_key
			clear
		end
		
		def clear
			@install_path = nil
			return self
		end
		
		# Try to load registry. If fail, clear itself.
		# Return: self
		def load
			begin
				PRIMARY_KEY.open(@sub_key) do |reg|
					@install_path = reg['InstallPath']
				end
			rescue Win32::Registry::Error
				clear
			end
			
			return self
		end
		
		# Return: success
		def store
			if @install_path.kind_of?(String) then
				PRIMARY_KEY.create(@sub_key) do |reg|
					reg['InstallPath'] = @install_path
				end
				return true
			else
				return false
			end
		end
		
		alias save store
	
		
	end
	
end
