require 'gtk2'

include GetText
bindtextdomain("ruggregator")
GetText.charset = "UTF-8"

class RSSNewDialog < Gtk::Dialog

  @url_entry
  @check_create_filter

  def initialize
    super _("New RSS"), nil, Gtk::Dialog::MODAL,
      [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT],
      [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT]

    hbox = Gtk::HBox.new
    label = Gtk::Label.new(_("URL") + ": ")
    hbox.pack_start(label,false,false,0)
    @url_entry = Gtk::Entry.new
    hbox.pack_start(@url_entry,true,true,0)
    vbox.pack_start(hbox,true,true,3)

    hbox = Gtk::HBox.new
    @check_create_filter = Gtk::CheckButton.new
    @check_create_filter.active = true
    hbox.pack_start(@check_create_filter,false,false,0)
    label = Gtk::Label.new(_("Create this RSS's filter automatically") )
    hbox.pack_start(label,false,false,0)
    vbox.pack_start(hbox,true,true,3)

    show_all
  end

  def url
    return @url_entry.text
  end

  def create_filter?
    return @check_create_filter.active?
  end
end
