
--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with ada.numerics.generic_elementary_functions;
with matutils;  use matutils;




with gl, gl.binding, gl.pointers;  use gl;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
use  type interfaces.c.c_float;
with Interfaces.C.Pointers;
with interfaces.c.strings;

use interfaces.c;
use interfaces.c.strings;

---------------------------------------------------------

with text_io; use text_io;

----------------------------------------------------------------





package gametypes is




	type vec3 is array(1..3) of float;

	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;



  onepi : constant float     := 3.14159_26535_89793;
  halfpi : constant float    := onepi/2.0;
  fourthpi : constant float  := onepi/4.0;
  twopi : constant float     := onepi*2.0;
  deg2rad : constant float   := onepi/180.0;
  rad2deg : constant float   := 180.0/onepi;









	vertexbuff, colorbuff, vertexarrayid : aliased gluint;






-- begin string pointers for getUniformLocation:

	pmvp : chars_ptr := new_string("MVP"&ascii.nul);
	pmyts : chars_ptr := new_string("myTextureSampler"&ascii.nul);

-- end string pointers for getUniformLocation:








	winwidth, winheight : interfaces.c.int := 500;


	mv,mvp, pm, vm, mm :  mat44 := identity;


	xaxis : constant vec3 := (1.0,0.0,0.0);
	yaxis : constant vec3 := (0.0,1.0,0.0);
	zaxis : constant vec3 := (0.0,0.0,1.0);
	--axis : vec3 := ( others => 0.0 );


	rotx,roty,rotz : float := 0.0;







----------------------- begin stuff from main -----------------------------


Nwid,Nhit, Fwid, Fhit : aliased interfaces.c.int;

ret : interfaces.c.int;
numkeys : aliased glint;

  error : interfaces.c.int;






  package myint_io is new text_io.integer_io(integer);

	major, minor, profile, flags, mtu :  glint;




	programid : gluint;
	matrixid, uniftex : glint;

	whoosh, fanfare: glint;

end gametypes;

