#!/usr/bin/ruby
=begin
Export Win32 Certificate Store to pem format

Copyright (c) 2007 Kazuhiro NISHIYAMA

== License

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

== to exe
 ruby -r exerb/mkexy *.rb
 exerb *.exy
=end

require 'dl/win32'
require 'openssl'

crypt32 = DL.dlopen("crypt32")
p crypt32 if $DEBUG

CertOpenSystemStore = crypt32['CertOpenSystemStore', 'PPP']
CertEnumCertificatesInStore = crypt32['CertEnumCertificatesInStore', 'PPP']
CertCloseStore = crypt32['CertCloseStore', 'IPL']
p CertOpenSystemStore if $DEBUG
p CertCloseStore if $DEBUG

store = ARGV.shift || "ROOT" # "CA" or "ROOT" (or "MY")
cert_store, = CertOpenSystemStore.call(nil, store)
p cert_store if $DEBUG

cert_context = nil
begin
  cert_context, = CertEnumCertificatesInStore.call(cert_store, cert_context)
  p cert_context if $DEBUG
  if cert_context
    cert_context.struct!('LPLPP', :dwCertEncodingType, :pbCertEncoded, :cbCertEncoded, :pCertInfo, :hCertStore)
    der = cert_context[:pbCertEncoded].to_s(cert_context[:cbCertEncoded])
    p der.size if $DEBUG
    cert = OpenSSL::X509::Certificate.new(der)
    p cert if $DEBUG
    puts cert.to_pem
  end
end while cert_context

if cert_store
  if CertCloseStore.call(cert_store, 0)[0] == 0
    raise "CertCloseStore failed"
  end
end
