/*
 * $Id: punycode4r.c,v 1.1 2003/02/23 15:19:02 znz Exp $
 * copyright (c) 2001-2002 Kazuhiro NISHIYAMA <zn@mbf.nifty.com>
 *
 * You can redistribute it and/or modify it under the same term as Ruby.
 *
 */

#include "punycode.h"
#include "ruby.h"

/* StringValue macro from stringio */
/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif

enum {
  unicode_max_length = 256,
  ace_max_length = 256
};

static void
punycode4r_status_check(status)
  enum punycode_status status;
{
	switch (status) {
	  case punycode_bad_input:
		rb_raise(rb_eStandardError, "invalid input");
	  case punycode_big_output:
		rb_raise(rb_eStandardError, "too big");
	  case punycode_overflow:
		rb_raise(rb_eStandardError, "overflow");
	  default:
		rb_bug("unknown punycode_status %d", status); /* not reached */
	  case punycode_success:
		break;
	}
}

static VALUE
punycode4r_encode(self, string)
	VALUE self, string;
{
	punycode_uint input_length, output_length = ace_max_length;
    const punycode_uint *input;
	char output[ace_max_length+1];

	StringValue(string);
	input = (const punycode_uint*)RSTRING(string)->ptr;
	input_length = RSTRING(string)->len / sizeof(punycode_uint);

	punycode4r_status_check(punycode_encode(input_length, input, NULL, &output_length, output));

	return rb_str_new(output, output_length);
}

static VALUE
punycode4r_decode(self, string)
	VALUE self, string;
{
	unsigned int output_length = unicode_max_length;
	punycode_uint output[unicode_max_length];

	StringValue(string);

	punycode4r_status_check(punycode_decode(RSTRING(string)->len, RSTRING(string)->ptr, &output_length, output, NULL));

	return rb_str_new((const char*)output, output_length*sizeof(punycode_uint));
}

void
Init_punycode4r()
{
	VALUE punycode4r = rb_define_module("Punycode");
	rb_define_module_function(punycode4r, "encode", punycode4r_encode, 1);
	rb_define_module_function(punycode4r, "decode", punycode4r_decode, 1);
}
