require 'punycode4r.so'
require 'iconv'
module Punycode
  Kcode2Encoding = {
    'NONE' => 'US-ASCII',
    'EUC' => 'EUC-JP',
    'SJIS' => 'Shift_JIS',
    'UTF-8' => 'UTF-8',
  }
  module_function
  def kcode2punycode(str)
    encode Iconv.iconv('UCS-4LE', Kcode2Encoding[$KCODE], str)[0]
  end
  def punycode2kcode(str)
    Iconv.iconv(Kcode2Encoding[$KCODE], 'UCS-4LE', Punycode.decode(str))[0]
  end
end
