#!/usr/local/bin/ruby
# $Id: test_wpm_loader.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $
# test of class loader

require 'rubyunit'
require 'wpm'

module TestWebPageMaker
  class TestLoader < RUNIT::TestCase
    def setup
      @filename = 'loader_test.rb'
    end

    def teardown
      if (File.exist? @filename) then
	File.unlink(@filename)
      end
    end

    def test_load
      File.open(@filename, 'w') { |output|
	output.print "class Hello\n"
	output.print "end\n"
      }
      loader = WPM::Loader.new(@filename)
      assert_instance_of(Class, loader.const_get('Hello'))
    end
  end
end
