#!/usr/local/bin/ruby
# $Id: test_wpm_check_util.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'wpm'

module TestWebPageMaker
  class TestCheckUtil < RUNIT::TestCase
    include WPM::CheckUtil

    def test_check_number
      check_number('0')
      check_number('1')
      check_number('+1')
      check_number('-1')
      assert_exception(RuntimeError) { check_number('foo') }
      check_number('1') { |n| n > 0 }
      assert_exception(RuntimeError) { check_number('0') { |n| n > 0 } }
      assert_exception(RuntimeError) { check_number('-1') { |n| n > 0 } }
    end

    def test_check_not_empty
      check_not_empty('foo')
      check_not_empty(' ')
      assert_exception(RuntimeError) { check_not_empty('') }
      assert_exception(RuntimeError) { check_not_empty(nil) }
      check_not_empty('foo', true)
      assert_exception(RuntimeError) { check_not_empty(' ', true) }
      assert_exception(RuntimeError) { check_not_empty('', true) }
      assert_exception(RuntimeError) { check_not_empty(nil, true) }
    end

    def test_empty_string?
      assert(! (empty_string? 'foo'))
      assert(! (empty_string? ' '))
      assert((empty_string? ''))
      assert((empty_string? nil))
      assert(! (empty_string? 'foo', true))
      assert((empty_string? ' ', true))
      assert((empty_string? '', true))
      assert((empty_string? nil, true))
    end
  end
end
