#!/usr/local/bin/ruby
# $Id: test_logger.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'rucy/logger'

module TestRucy
  class TestLogger < RUNIT::TestCase
    def setup
      @logger = Rucy::Logger.new(self)
      @write_messg = ''
      @flush_call = 0
    end

    def write(messg)
      @write_messg << messg << "\n"
      nil
    end

    def flush
      @flush_call += 1
      nil
    end

    def test_default_mask
      assert(@logger.log_emerg)
      assert(@logger.log_alert)
      assert(@logger.log_crit)
      assert(@logger.log_err)
      assert(@logger.log_warning)
      assert(@logger.log_notice)
      assert(@logger.log_info)
      assert(! @logger.log_debug)
    end

    def test_emerg
      assert_equal(false, @logger.log_emerg = false)
      @logger.emerg('HALO')
      assert_not_match(@write_messg, /HALO/)
      assert_equal(1, @flush_call)
      assert_equal(true, @logger.log_emerg = true)
      @logger.emerg('HALO')
      assert_match(@write_messg, /HALO/)
      assert_equal(2, @flush_call)
    end

    def test_alert
      assert_equal(false, @logger.log_alert = false)
      @logger.alert('HALO')
      assert_not_match(@write_messg, /HALO/)
      assert_equal(1, @flush_call)
      assert_equal(true, @logger.log_alert = true)
      @logger.alert('HALO')
      assert_match(@write_messg, /HALO/)
      assert_equal(2, @flush_call)
    end

    def test_crit
      assert_equal(false, @logger.log_crit = false)
      @logger.crit('HALO')
      assert_not_match(@write_messg, /HALO/)
      assert_equal(1, @flush_call)
      assert_equal(true, @logger.log_crit = true)
      @logger.crit('HALO')
      assert_match(@write_messg, /HALO/)
      assert_equal(2, @flush_call)
    end

    def test_err
      assert_equal(false, @logger.log_err = false)
      @logger.err('HALO')
      assert_not_match(@write_messg, /HALO/)
      assert_equal(1, @flush_call)
      assert_equal(true, @logger.log_err = true)
      @logger.err('HALO')
      assert_match(@write_messg, /HALO/)
      assert_equal(2, @flush_call)
    end

    def test_warning
      assert_equal(false, @logger.log_warning = false)
      @logger.warning('HALO')
      assert_not_match(@write_messg, /HALO/)
      assert_equal(1, @flush_call)
      assert_equal(true, @logger.log_warning = true)
      @logger.warning('HALO')
      assert_match(@write_messg, /HALO/)
      assert_equal(2, @flush_call)
    end

    def test_notice
      assert_equal(false, @logger.log_notice = false)
      @logger.notice('HALO')
      assert_not_match(@write_messg, /HALO/)
      assert_equal(1, @flush_call)
      assert_equal(true, @logger.log_notice = true)
      @logger.notice('HALO')
      assert_match(@write_messg, /HALO/)
      assert_equal(2, @flush_call)
    end

    def test_info
      assert_equal(false, @logger.log_info = false)
      @logger.info('HALO')
      assert_not_match(@write_messg, /HALO/)
      assert_equal(1, @flush_call)
      assert_equal(true, @logger.log_info = true)
      @logger.info('HALO')
      assert_match(@write_messg, /HALO/)
      assert_equal(2, @flush_call)
    end

    def test_debug
      assert_equal(false, @logger.log_debug = false)
      @logger.debug('HALO')
      assert_not_match(@write_messg, /HALO/)
      assert_equal(1, @flush_call)
      assert_equal(true, @logger.log_debug = true)
      @logger.debug('HALO')
      assert_match(@write_messg, /HALO/)
      assert_equal(2, @flush_call)
    end
  end

  class TestMultiLogger < RUNIT::TestCase
    class DummyOutput
      def initialize(parent, name)
	@write = parent.method("#{name}_write")
	@flush = parent.method("#{name}_flush")
      end

      def write(messg)
	@write.call(messg)
	nil
      end

      def flush
	@flush.call
	nil
      end
    end

    def setup
      @logger1_write_messg = ''
      @logger1_flush_call = 0
      @logger1 = Rucy::Logger.new(DummyOutput.new(self, 'logger1'))
      @logger2_write_messg = ''
      @logger2_flush_call = 0
      @logger2 = Rucy::Logger.new(DummyOutput.new(self, 'logger2'))
      @multi_logger = Rucy::MultiLogger.new
      @multi_logger.add(@logger1)
      @multi_logger.add(@logger2)
    end

    def logger1_write(messg)
      @logger1_write_messg << messg << "\n"
    end

    def logger1_flush
      @logger1_flush_call += 1
      nil
    end

    def logger2_write(messg)
      @logger2_write_messg << messg << "\n"
    end

    def logger2_flush
      @logger2_flush_call += 1
      nil
    end

    def test_multi_logger
      @multi_logger.info('HALO')
      assert_match(@logger1_write_messg, /HALO/)
      assert_equal(1, @logger1_flush_call)
      assert_match(@logger2_write_messg, /HALO/)
      assert_equal(1, @logger2_flush_call)
    end
  end

  class TestSyncLogger < RUNIT::TestCase
    NUM_OF_THREAD = 2
    NUM_OF_CALL = 1000

    def setup
      @emerg_call = 0
      @alert_call = 0
      @crit_call = 0
      @err_call = 0
      @warning_call = 0
      @notice_call = 0
      @info_call = 0
      @debug_call = 0
      @th_grp = ThreadGroup.new
      @logger = Rucy::SyncLogger.new(self)
    end

    def emerg(messg)
      @emerg_call += 1
      nil
    end

    def alert(messg)
      @alert_call += 1
      nil
    end

    def crit(messg)
      @crit_call += 1
      nil
    end

    def err(messg)
      @err_call += 1
      nil
    end

    def warning(messg)
      @warning_call += 1
      nil
    end

    def notice(messg)
      @notice_call += 1
      nil
    end

    def info(messg)
      @info_call += 1
      nil
    end

    def debug(messg)
      @debug_call += 1
      nil
    end

    def test_emerg
      spin_lock = true
      NUM_OF_THREAD.times do
	@th_grp.add Thread.new{
	  while (spin_lock)
	    # ready to start.
	  end
	  NUM_OF_CALL.times do
	    @logger.emerg("HALO\n")
	  end
	}
      end
      spin_lock = false
      for thread in @th_grp.list
	thread.join
      end
      assert_equal(NUM_OF_THREAD * NUM_OF_CALL, @emerg_call)
    end

    def test_alert
      spin_lock = true
      NUM_OF_THREAD.times do
	@th_grp.add Thread.new{
	  while (spin_lock)
	    # ready to start.
	  end
	  NUM_OF_CALL.times do
	    @logger.alert("HALO\n")
	  end
	}
      end
      spin_lock = false
      for thread in @th_grp.list
	thread.join
      end
      assert_equal(NUM_OF_THREAD * NUM_OF_CALL, @alert_call)
    end

    def test_crit
      spin_lock = true
      NUM_OF_THREAD.times do
	@th_grp.add Thread.new{
	  while (spin_lock)
	    # ready to start.
	  end
	  NUM_OF_CALL.times do
	    @logger.crit("HALO\n")
	  end
	}
      end
      spin_lock = false
      for thread in @th_grp.list
	thread.join
      end
      assert_equal(NUM_OF_THREAD * NUM_OF_CALL, @crit_call)
    end

    def test_err
      spin_lock = true
      NUM_OF_THREAD.times do
	@th_grp.add Thread.new{
	  while (spin_lock)
	    # ready to start.
	  end
	  NUM_OF_CALL.times do
	    @logger.err("HALO\n")
	  end
	}
      end
      spin_lock = false
      for thread in @th_grp.list
	thread.join
      end
      assert_equal(NUM_OF_THREAD * NUM_OF_CALL, @err_call)
    end

    def test_warning
      spin_lock = true
      NUM_OF_THREAD.times do
	@th_grp.add Thread.new{
	  while (spin_lock)
	    # ready to start.
	  end
	  NUM_OF_CALL.times do
	    @logger.warning("HALO\n")
	  end
	}
      end
      spin_lock = false
      for thread in @th_grp.list
	thread.join
      end
      assert_equal(NUM_OF_THREAD * NUM_OF_CALL, @warning_call)
    end

    def test_notice
      spin_lock = true
      NUM_OF_THREAD.times do
	@th_grp.add Thread.new{
	  while (spin_lock)
	    # ready to start.
	  end
	  NUM_OF_CALL.times do
	    @logger.notice("HALO\n")
	  end
	}
      end
      spin_lock = false
      for thread in @th_grp.list
	thread.join
      end
      assert_equal(NUM_OF_THREAD * NUM_OF_CALL, @notice_call)
    end

    def test_info
      spin_lock = true
      NUM_OF_THREAD.times do
	@th_grp.add Thread.new{
	  while (spin_lock)
	    # ready to start.
	  end
	  NUM_OF_CALL.times do
	    @logger.info("HALO\n")
	  end
	}
      end
      spin_lock = false
      for thread in @th_grp.list
	thread.join
      end
      assert_equal(NUM_OF_THREAD * NUM_OF_CALL, @info_call)
    end

    def test_debug
      spin_lock = true
      NUM_OF_THREAD.times do
	@th_grp.add Thread.new{
	  while (spin_lock)
	    # ready to start.
	  end
	  NUM_OF_CALL.times do
	    @logger.debug("HALO\n")
	  end
	}
      end
      spin_lock = false
      for thread in @th_grp.list
	thread.join
      end
      assert_equal(NUM_OF_THREAD * NUM_OF_CALL, @debug_call)
    end
  end
end
