#!/usr/local/bin/ruby
# $Id: test_erb.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'pseudo_req_res'
require 'rucy/erb'

module TestRucy
  class TestERBFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super

      @erb = Rucy::ERBFilter.new
      @doc = Rucy::FilterDocument.new(self, @erb)
    end

    def test_erb
      @publish_messg_body = '<%= "foo" %>'.taint
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_erb_script_name
      @publish_messg_body = '<%= ENV["SCRIPT_NAME"] + "," + ENV["PATH_INFO"] %>'.taint
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      @doc.publish('/foo', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('/foo', @publish_script_name)
      assert_equal('/foo/bar', @publish_request_path)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('/foo,/bar', @messg_body)
    end

    def test_erb_doc_path
      @publish_doc_path = '/foo/bar'
      @publish_messg_body = '<%= ENV["SCRIPT_NAME"] + "," + ENV["PATH_INFO"] %>'.taint
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      @doc.publish('/foo', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('/foo', @publish_script_name)
      assert_equal('/foo/bar', @publish_request_path)
      assert_equal('/foo/bar', @messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('/foo/bar,', @messg_body)
    end

    def test_erb_local_path
      @publish_local_path = File.join(File.expand_path('.'), 'test.rhtml')
      @publish_messg_body = '<%= ENV["SCRIPT_FILENAME"] %>'.taint
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_nil(@messg_head.doc_path)
      assert_equal(File.join(File.expand_path('.'), 'test.rhtml'), @messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_match(@messg_body, /test\.rhtml$/)
    end

    def test_erb_request
      @publish_messg_body = '<%= __request__.header("Accept-Language") %>'.taint
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Accept-Language', 'ja')
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('ja', @messg_body)
    end

    def test_erb_response
      @publish_messg_body = '<%
__response__.set_header("Cache-Control", "no-cache")
%><%= "foo" %>'.taint
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('no-cache', @messg_head.header('Cache-Control'))
      assert_equal('foo', @messg_body)
    end

    def test_erb_logger
      @publish_messg_body = '<%
__logger__.debug("Hello world.")
%><%= "foo" %>'.taint
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_nil(@messg_head.doc_path)
      assert_nil(@messg_head.local_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
      assert_match(@log_debug, /Hello world\.$/)
    end
  end
end
