#!/usr/local/bin/ruby
# $Id: test_auth.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'pseudo_req_res'
require 'rucy/auth'

module TestRucy
  class TestBasicAuth < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super

      # for Rucy::PasswordVerifier class
      @verify_call = 0
      @verify_last_user = nil
      @verify_last_password = nil

      @auth = Rucy::BasicAuth.new(self, 'TestAuth')
      @doc = Rucy::FilterDocument.new(self, @auth)
    end

    def verify(user, password)
      @verify_call += 1
      @verify_last_user = user
      @verify_last_password = password
      user == 'alice' && password == 'himitsu'
    end

    def test_allow
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Authorization', 'Basic ' + [ 'alice:himitsu' ].pack('m'))
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @verify_call)
      assert_equal('alice', @verify_last_user)
      assert_equal('himitsu', @verify_last_password)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny_user
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Authorization', 'Basic ' + [ 'bob:himitsu' ].pack('m'))
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(401, $!.status)
	assert_equal('Basic realm="TestAuth"', $!.header('WWW-Authenticate'))
	assert_equal(1, @verify_call)
	assert_equal('bob', @verify_last_user)
	assert_equal('himitsu', @verify_last_password)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_deny_password
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Authorization', 'Basic ' + [ 'alice:detarame' ].pack('m'))
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(401, $!.status)
	assert_equal('Basic realm="TestAuth"', $!.header('WWW-Authenticate'))
	assert_equal(1, @verify_call)
	assert_equal('alice', @verify_last_user)
	assert_equal('detarame', @verify_last_password)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_deny_no_auth
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(401, $!.status)
	assert_equal('Basic realm="TestAuth"', $!.header('WWW-Authenticate'))
	assert_equal(0, @verify_call)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end
end
