#!/usr/local/bin/ruby
# $Id: test_access.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'pseudo_req_res'
require 'rucy/access'

module TestRucy
  class TestRemoteAddressAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @access = Rucy::RemoteAddressAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_address('127.0.0.1')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_address('127.0.0.1')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRemoteAddressDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @access = Rucy::RemoteAddressDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_address('192.168.0.3')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_address('192.168.0.3')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRemoteHostAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @access = Rucy::RemoteHostAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_name('localhost')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_name('localhost')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRemoteHostDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @access = Rucy::RemoteHostDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_name('foo')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_name('foo')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRequestPathAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @access = Rucy::RequestPathAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_path(/foo/)
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/foo/bar', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_path(/baz/)
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRequestPathDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @access = Rucy::RequestPathDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(self, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_path(/foo/)
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_path(/foo/)
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/baz'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/baz', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end
end
