#!/usr/local/bin/ruby
# $Id: test_SetupAlias.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'wpm'

module TestRucy
  class TestSetupAlias < RUNIT::TestCase
    def setup
      # for WPM::Driver class
      @driver_call = 0
      @params_call = 0
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      # for Rucy::Control
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_last_value = nil
      @aliases_call = 0
      @set_aliases_call = 0
      @alias_list = [
	{ 'alias_path' => '/bar',
	  'orig_path' => '/foo',
	  'virtual_host' => nil
	},
	{ 'alias_path' => '/fuge',
	  'orig_path' => '/hoge',
	  'virtual_host' => 'www2'
	}
      ]

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/SetupAlias/SetupAlias.rb')
      @SetupAlias = loader.const_get('SetupAlias').new(self, :control => self)
      assert((@SetupAlias.is_a? WPM::PageContext))
      @SetupAlias.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def params
      @params_call += 1
      { 'pos' => '1' }
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_last_value = modified_count
    end

    def aliases
      @aliases_call += 1
      alias_list = @alias_list.dup
      def alias_list.setup(parent)
	@parent = parent
	self
      end
      def alias_list.modified_count
	@parent.modified_count
      end
      def alias_list.modified_count=(modified_count)
	@parent.modified_count = modified_count
      end
      alias_list.setup(self)
    end

    def set_aliases(alias_list)
      @set_aliases_call += 1
      @alias_list = alias_list
      nil
    end

    def test_modified_count
      assert_equal('0', @SetupAlias.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal('1', @SetupAlias.modified_count = '1')
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_last_value)
    end

    def test_position
      assert_equal(1, @aliases_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal('1', @SetupAlias.position)
      assert_equal('2', @SetupAlias.alias_index)
    end

    def test_reload_query
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal({ 'pos' => '1' }, @SetupAlias.reload_query)
    end

    def test_cancel
      @SetupAlias.cancel
      assert_equal(0, @set_aliases_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AliasMap', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_alias_path
      assert_equal(1, @aliases_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal('/fuge', @SetupAlias.alias_path)
      @SetupAlias.alias_path = '/foo'
      assert_equal('/foo', @SetupAlias.alias_path)
      @SetupAlias.write
      assert_equal(1, @set_aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/foo',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[1])
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AliasMap', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_orig_path
      assert_equal(1, @aliases_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal('/hoge', @SetupAlias.orig_path)
      @SetupAlias.orig_path = '/bar'
      assert_equal('/bar', @SetupAlias.orig_path)
      @SetupAlias.write
      assert_equal(1, @set_aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/bar',
		     'virtual_host' => 'www2'
		   }, @alias_list[1])
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AliasMap', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_virtual_host
      assert_equal(1, @aliases_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal('www2', @SetupAlias.virtual_host)
      @SetupAlias.virtual_host = 'www3'
      assert_equal('www3', @SetupAlias.virtual_host)
      @SetupAlias.write
      assert_equal(1, @set_aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www3'
		   }, @alias_list[1])
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AliasMap', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_virtual_host_nil
      assert_equal(1, @aliases_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal('www2', @SetupAlias.virtual_host)
      @SetupAlias.virtual_host = nil
      assert_nil(@SetupAlias.virtual_host)
      @SetupAlias.virtual_host = ''
      assert_nil(@SetupAlias.virtual_host)
      @SetupAlias.write
      assert_equal(1, @set_aliases_call)
      assert_equal(2, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => nil
		   }, @alias_list[1])
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AliasMap', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_alias_default
      assert_equal(1, @aliases_call)
      @SetupAlias.position = '2'
      assert_nil(@SetupAlias.alias_path)
      assert_nil(@SetupAlias.orig_path)
      assert_nil(@SetupAlias.virtual_host)
      @SetupAlias.alias_path = '/anna'
      @SetupAlias.orig_path = '/alice'
      @SetupAlias.virtual_host = 'web'
      assert_equal('/anna', @SetupAlias.alias_path)
      assert_equal('/alice', @SetupAlias.orig_path)
      assert_equal('web', @SetupAlias.virtual_host)
      @SetupAlias.write
      assert_equal(1, @set_aliases_call)
      assert_equal(3, @alias_list.length)
      assert_equal({ 'alias_path' => '/bar',
		     'orig_path' => '/foo',
		     'virtual_host' => nil
		   }, @alias_list[0])
      assert_equal({ 'alias_path' => '/fuge',
		     'orig_path' => '/hoge',
		     'virtual_host' => 'www2'
		   }, @alias_list[1])
      assert_equal({ 'alias_path' => '/anna',
		     'orig_path' => '/alice',
		     'virtual_host' => 'web'
		   }, @alias_list[2])
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AliasMap', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end
  end
end

