#!/usr/local/bin/ruby
# $Id: test_MountMap.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'wpm'
require 'rucy/document'

module TestRucy
  class TestMountMap < RUNIT::TestCase
    def setup
      # for WPM::Driver class
      @driver_call = 0
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      # for Rucy::DocumentFactory class
      @factory = Rucy::DocumentFactory.new
      page = Object.new
      def page.doc_name
	'Page'
      end
      def page.doc_args
	[ [ 'content', :text, nil ],
	  [ 'content-type', :string, 'text/html' ]
	]
      end
      @factory.add_document(page)
      local = Object.new
      def local.doc_name
	'LocalFile'
      end
      def local.doc_args
	[ [ 'local path', :string, nil ] ]
      end
      @factory.add_document(local)
      @doc_args_call = 0
      @doc_args_last_name = nil
      @doc_names_call = 0

      # for Rucy::Control class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @document_list = [
	{ 'document' => 'Page',
	  'arguments' => [
	    "Hello world.\n",
	    'text/plain'
	  ],
	  'mount_path' => '/hello',
	  'mount_mask' => nil,
	  'virtual_host' => nil,
	  'comment' => 'test of Page'
	},
	{ 'document' => 'LocalFile',
	  'arguments' => [
	    '/home/alice/public_html'
	  ],
	  'mount_path' => '/~alice',
	  'mount_mask' => nil,
	  'virtual_host' => 'foo',
	  'comment' => 'test of LocalFile'
	}
      ]
      @documents_call = 0
      @set_documents_call = 0

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/MountMap/MountMap.rb')
      @MountMap = loader.const_get('MountMap').new(self, :control => self, :factory => self)
      assert((@MountMap.is_a? WPM::PageContext))
      @MountMap.init_context
      assert_equal(1, @documents_call)
    end

    def driver
      @driver_call += 1
      self
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    def doc_args(doc_name)
      @doc_args_call += 1
      @doc_args_last_name = doc_name
      @factory.doc_args(doc_name)
    end

    def doc_names
      @doc_names_call += 1
      @factory.doc_names
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def documents
      @documents_call += 1
      document_list = @document_list.dup
      def document_list.setup(parent)
	@parent = parent
	self
      end
      def document_list.modified_count
	@parent.modified_count
      end
      def document_list.modified_count=(modified_count)
	@parent.modified_count = modified_count
      end
      document_list.setup(self)
    end

    def set_documents(document_list)
      @set_documents_call += 1
      @document_list = document_list
      nil
    end

    def test_modified_count
      assert_equal(0, @MountMap.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal(1, @MountMap.modified_count = 1)
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_document_list
      document_list = @MountMap.document_list
      assert(! document_list.empty?)
      assert_equal(2, document_list.length)
      assert_equal('Page', document_list[0]['document'])
      assert_equal(2, document_list[0]['arguments'].length)
      assert_equal("Hello world.\n", document_list[0]['arguments'][0])
      assert_equal('text/plain', document_list[0]['arguments'][1])
      assert_equal('/hello', document_list[0]['mount_path'])
      assert_nil(document_list[0]['mount_mask'])
      assert_nil(document_list[0]['virtual_host'])
      assert_equal('test of Page', document_list[0]['comment'])
      assert_equal('LocalFile', document_list[1]['document'])
      assert_equal(1, document_list[1]['arguments'].length)
      assert_equal('/home/alice/public_html', document_list[1]['arguments'][0])
      assert_equal('/~alice', document_list[1]['mount_path'])
      assert_nil(document_list[1]['mount_mask'])
      assert_equal('foo', document_list[1]['virtual_host'])
      assert_equal('test of LocalFile', document_list[1]['comment'])
    end

    def test_document_factory
      assert_equal([ [ 'content', :text, nil ],
		     [ 'content-type', :string, 'text/html' ]
		   ], @MountMap.doc_args('Page'))
      assert_equal(1, @doc_args_call)
      assert_equal('Page', @doc_args_last_name)
      assert_equal([ 'LocalFile', 'Page' ], @MountMap.doc_names)
      assert_equal(1, @doc_names_call)
    end

    def test_document_attributes
      assert_equal('document', @MountMap.doc_tag)
      assert_equal('document', @MountMap.doc_label)
      assert_equal('mount_path', @MountMap.path_tag)
      assert_equal('mount path', @MountMap.path_label)
      assert_equal('mount_mask', @MountMap.mask_tag)
      assert_equal('mount mask', @MountMap.mask_label)
    end

    def test_write_document_list
      @MountMap.write_document_list
      assert_equal(1, @set_documents_call)
    end

    def test_setup_document
      @MountMap.setup_document('Page', 2)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('SetupDocument', @redirect_last_page_name)
      assert_equal({ 'doc' => 'Page',
		     'pos' => '2'
		   }, @redirect_last_query_params)
    end
  end
end
