#!/usr/local/bin/ruby
# $Id: test_Logging.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'wpm'

module TestRucy
  class TestLogging < RUNIT::TestCase
    def setup
      # for Rucy::Control class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @logging_params_call = 0
      @set_logging_params_call = 0
      @logging_params = {
	'stdout_emerg' => true,
	'stdout_alert' => true,
	'stdout_crit' => true,
	'stdout_err' => true,
	'stdout_warning' => true,
	'stdout_notice' => true,
	'stdout_info' => true,
	'stdout_debug' => false,
	'logfiles' => [
	  { 'path' => 'server.log',
	    'log_emerg' => true,
	    'log_alert' => true,
	    'log_crit' => true,
	    'log_err' => true,
	    'log_warning' => true,
	    'log_notice' => true,
	    'log_info' => false,
	    'log_debug' => false
	  },
	  { 'path' => 'access.log',
	    'log_emerg' => false,
	    'log_alert' => false,
	    'log_crit' => false,
	    'log_err' => false,
	    'log_warning' => false,
	    'log_notice' => false,
	    'log_info' => true,
	    'log_debug' => false
	  },
	  { 'path' => 'debug.log',
	    'log_emerg' => false,
	    'log_alert' => false,
	    'log_crit' => false,
	    'log_err' => false,
	    'log_warning' => false,
	    'log_notice' => false,
	    'log_info' => false,
	    'log_debug' => true
	  }
	]
      }

      # setup WPM::PageMaker class
      loader = WPM::Loader.new('../control/Logging/Logging.rb')
      @Logging = loader.const_get('Logging').new(self, :control => self)
      assert((@Logging.is_a? WPM::PageContext))
      @Logging.init_context
    end

    def modified_count
      @modified_count_call += 1
      '0'
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def test_modified_count
      assert_equal('0', @Logging.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal('1', @Logging.modified_count = '1')
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def logging_params
      @logging_params_call += 1
      params = @logging_params.dup
      def params.setup(parent)
	@parent = parent
	self
      end
      def params.modified_count
	@parent.modified_count
      end
      def params.modified_count=(modified_count)
	@parent.modified_count = modified_count
      end
      params.setup(self)
    end

    def set_logging_params(params)
      @set_logging_params_call += 1
      @logging_params = params
      nil
    end

    def test_stdout_logging_level
      assert_equal(1, @logging_params_call)
      assert_equal(true, @Logging.stdout_emerg)
      assert_equal(true, @Logging.stdout_alert)
      assert_equal(true, @Logging.stdout_crit)
      assert_equal(true, @Logging.stdout_err)
      assert_equal(true, @Logging.stdout_warning)
      assert_equal(true, @Logging.stdout_notice)
      assert_equal(true, @Logging.stdout_info)
      assert_equal(false, @Logging.stdout_debug)

      @Logging.stdout_emerg = false
      @Logging.stdout_alert = false
      @Logging.stdout_crit = false
      @Logging.stdout_err = false
      @Logging.stdout_warning = false
      @Logging.stdout_notice = false
      @Logging.stdout_info = true
      @Logging.stdout_debug = false
      assert_equal(false, @Logging.stdout_emerg)
      assert_equal(false, @Logging.stdout_alert)
      assert_equal(false, @Logging.stdout_crit)
      assert_equal(false, @Logging.stdout_err)
      assert_equal(false, @Logging.stdout_warning)
      assert_equal(false, @Logging.stdout_notice)
      assert_equal(true, @Logging.stdout_info)
      assert_equal(false, @Logging.stdout_debug)

      @Logging.write_logging_parameter
      assert_equal(1, @set_logging_params_call)
      assert_equal(false, @logging_params['stdout_emerg'])
      assert_equal(false, @logging_params['stdout_alert'])
      assert_equal(false, @logging_params['stdout_crit'])
      assert_equal(false, @logging_params['stdout_err'])
      assert_equal(false, @logging_params['stdout_warning'])
      assert_equal(false, @logging_params['stdout_notice'])
      assert_equal(true, @logging_params['stdout_info'])
      assert_equal(false, @logging_params['stdout_debug'])
    end

    def test_has_logfiles
      assert_equal(1, @logging_params_call)
      assert(@Logging.has_logfiles?)
    end

    def test_logfile_count
      assert_equal(1, @logging_params_call)
      assert_equal(3, @Logging.logfile_count)
    end

    def test_log_index
      @Logging.log_index = 1
      assert_equal(1, @Logging.log_index)
    end

    def test_logfile
      assert_equal(1, @logging_params_call)
      @Logging.log_path_call_index = 1
      @Logging.log_emerg_call_index = 1
      @Logging.log_alert_call_index = 1
      @Logging.log_crit_call_index = 1
      @Logging.log_err_call_index = 1
      @Logging.log_warning_call_index = 1
      @Logging.log_notice_call_index = 1
      @Logging.log_info_call_index = 1
      @Logging.log_debug_call_index = 1
      assert_equal('access.log', @Logging.log_path)
      assert_equal(false, @Logging.log_emerg)
      assert_equal(false, @Logging.log_alert)
      assert_equal(false, @Logging.log_crit)
      assert_equal(false, @Logging.log_err)
      assert_equal(false, @Logging.log_warning)
      assert_equal(false, @Logging.log_notice)
      assert_equal(true, @Logging.log_info)
      assert_equal(false, @Logging.log_debug)
      @Logging.log_path = 'server.debug.log'
      @Logging.log_emerg = true
      @Logging.log_alert = true
      @Logging.log_crit = true
      @Logging.log_err = true
      @Logging.log_warning = true
      @Logging.log_notice = true
      @Logging.log_info = false
      @Logging.log_debug = true
      assert_equal('server.debug.log', @Logging.log_path)
      assert_equal(true, @Logging.log_emerg)
      assert_equal(true, @Logging.log_alert)
      assert_equal(true, @Logging.log_crit)
      assert_equal(true, @Logging.log_err)
      assert_equal(true, @Logging.log_warning)
      assert_equal(true, @Logging.log_notice)
      assert_equal(false, @Logging.log_info)
      assert_equal(true, @Logging.log_debug)
      @Logging.log_path_call_index = 2
      @Logging.log_emerg_call_index = 2
      @Logging.log_alert_call_index = 2
      @Logging.log_crit_call_index = 2
      @Logging.log_err_call_index = 2
      @Logging.log_warning_call_index = 2
      @Logging.log_notice_call_index = 2
      @Logging.log_info_call_index = 2
      @Logging.log_debug_call_index = 2
      assert_equal('debug.log', @Logging.log_path)
      assert_equal(false, @Logging.log_emerg)
      assert_equal(false, @Logging.log_alert)
      assert_equal(false, @Logging.log_crit)
      assert_equal(false, @Logging.log_err)
      assert_equal(false, @Logging.log_warning)
      assert_equal(false, @Logging.log_notice)
      assert_equal(false, @Logging.log_info)
      assert_equal(true, @Logging.log_debug)

      @Logging.write_logging_parameter
      assert_equal(1, @set_logging_params_call)
      assert_equal(3, @logging_params['logfiles'].length)
      assert_equal('server.log', @logging_params['logfiles'][0]['path'])
      assert_equal(true, @logging_params['logfiles'][0]['log_emerg'])
      assert_equal(true, @logging_params['logfiles'][0]['log_alert'])
      assert_equal(true, @logging_params['logfiles'][0]['log_crit'])
      assert_equal(true, @logging_params['logfiles'][0]['log_err'])
      assert_equal(true, @logging_params['logfiles'][0]['log_warning'])
      assert_equal(true, @logging_params['logfiles'][0]['log_notice'])
      assert_equal(false, @logging_params['logfiles'][0]['log_info'])
      assert_equal(false, @logging_params['logfiles'][0]['log_debug'])
      assert_equal('server.debug.log', @logging_params['logfiles'][1]['path'])
      assert_equal(true, @logging_params['logfiles'][1]['log_emerg'])
      assert_equal(true, @logging_params['logfiles'][1]['log_alert'])
      assert_equal(true, @logging_params['logfiles'][1]['log_crit'])
      assert_equal(true, @logging_params['logfiles'][1]['log_err'])
      assert_equal(true, @logging_params['logfiles'][1]['log_warning'])
      assert_equal(true, @logging_params['logfiles'][1]['log_notice'])
      assert_equal(false, @logging_params['logfiles'][1]['log_info'])
      assert_equal(true, @logging_params['logfiles'][1]['log_debug'])
      assert_equal('debug.log', @logging_params['logfiles'][2]['path'])
      assert_equal(false, @logging_params['logfiles'][2]['log_emerg'])
      assert_equal(false, @logging_params['logfiles'][2]['log_alert'])
      assert_equal(false, @logging_params['logfiles'][2]['log_crit'])
      assert_equal(false, @logging_params['logfiles'][2]['log_err'])
      assert_equal(false, @logging_params['logfiles'][2]['log_warning'])
      assert_equal(false, @logging_params['logfiles'][2]['log_notice'])
      assert_equal(false, @logging_params['logfiles'][2]['log_info'])
      assert_equal(true, @logging_params['logfiles'][2]['log_debug'])
    end

    def test_log_delete
      assert_equal(1, @logging_params_call)
      @Logging.log_delete_call_index = 2
      @Logging.log_delete
      assert_equal(1, @set_logging_params_call)
      assert_equal(2, @logging_params['logfiles'].length)
      assert_equal('server.log', @logging_params['logfiles'][0]['path'])
      assert_equal(true, @logging_params['logfiles'][0]['log_emerg'])
      assert_equal(true, @logging_params['logfiles'][0]['log_alert'])
      assert_equal(true, @logging_params['logfiles'][0]['log_crit'])
      assert_equal(true, @logging_params['logfiles'][0]['log_err'])
      assert_equal(true, @logging_params['logfiles'][0]['log_warning'])
      assert_equal(true, @logging_params['logfiles'][0]['log_notice'])
      assert_equal(false, @logging_params['logfiles'][0]['log_info'])
      assert_equal(false, @logging_params['logfiles'][0]['log_debug'])
      assert_equal('access.log', @logging_params['logfiles'][1]['path'])
      assert_equal(false, @logging_params['logfiles'][1]['log_emerg'])
      assert_equal(false, @logging_params['logfiles'][1]['log_alert'])
      assert_equal(false, @logging_params['logfiles'][1]['log_crit'])
      assert_equal(false, @logging_params['logfiles'][1]['log_err'])
      assert_equal(false, @logging_params['logfiles'][1]['log_warning'])
      assert_equal(false, @logging_params['logfiles'][1]['log_notice'])
      assert_equal(true, @logging_params['logfiles'][1]['log_info'])
      assert_equal(false, @logging_params['logfiles'][1]['log_debug'])
    end
  end
end
