#!/usr/local/bin/ruby
# $Id: test_ControlPanel.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'wpm'

module TestRucy
  class TestControlPanel < RUNIT::TestCase
    def setup
      # for Rucy::Control class
      @server_params_call = 0
      @set_server_params_call = 0
      @set_server_params_value = nil
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/ControlPanel/ControlPanel.rb')
      @ControlPanel = loader.const_get('ControlPanel').new(self, :control => self)
      assert((@ControlPanel.is_a? WPM::PageContext))
      @ControlPanel.init_context
      assert_equal(1, @server_params_call)
    end

    def server_params
      @server_params_call += 1
      params = {
	'server_type' => 'multithread',
	'port' => 8888,
	'logfiles' => [],
	'timeout' => 300,
	'keep_alive' => 8,
	'max_requests' => 32,
	'queue_length' => 16,
	'messengers' => 8,
	'messenger_threads' => 4,
	'messenger_queue_length' => 4,
	'subprocess_user' => 'nobody',
	'subprocess_group' => 'nobody'
      }

      def params.setup(parent)
	@parent = parent
	nil
      end
      def params.modified_count
	@parent.modified_count
      end
      def params.modified_count=(modified_count)
	@parent.modified_count = modified_count
      end
      params.setup(self)

      params
    end

    def set_server_params(params)
      @set_server_params_call += 1
      @set_server_params_value = params
      nil
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def test_server_type
      assert_equal('multithread', @ControlPanel.server_type)
      assert_equal('multiprocess', @ControlPanel.server_type = 'multiprocess')
      assert_equal('multiprocess', @ControlPanel.server_type)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal('multiprocess', @set_server_params_value['server_type'])
    end

    def test_unavailable_server_type
      assert_exception(RuntimeError) {
	@ControlPanel.server_type = 'detarame'
      }
    end

    def test_port
      assert_equal('8888', @ControlPanel.port)
      assert_equal('80', @ControlPanel.port = '80')
      assert_equal('80', @ControlPanel.port)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(80, @set_server_params_value['port'])
    end

    def test_unavailable_port
      assert_exception(RuntimeError) {
	@ControlPanel.port = 'detarame'
      }
      @ControlPanel.port = '0'	# allowd
    end

    def test_timeout
      assert_equal('300', @ControlPanel.timeout)
      assert_equal('60', @ControlPanel.timeout = '60')
      assert_equal('60', @ControlPanel.timeout)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(60, @set_server_params_value['timeout'])
    end

    def test_unavailable_timeout
      assert_exception(RuntimeError) {
	@ControlPanel.timeout = 'detarame'
      }
      assert_exception(RuntimeError) {
	@ControlPanel.timeout = '0'
      }
    end

    def test_keep_alive
      assert_equal('8', @ControlPanel.keep_alive)
      assert_equal('4', @ControlPanel.keep_alive = '4')
      assert_equal('4', @ControlPanel.keep_alive)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(4, @set_server_params_value['keep_alive'])
    end

    def test_unavailable_keep_alive
      assert_exception(RuntimeError) {
	@ControlPanel.keep_alive = 'detarame'
      }
      @ControlPanel.keep_alive = '0' # allowed
    end

    def test_max_requests
      assert_equal('32', @ControlPanel.max_requests)
      assert_equal('24', @ControlPanel.max_requests = '24')
      assert_equal('24', @ControlPanel.max_requests)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(24, @set_server_params_value['max_requests'])
    end

    def test_unavailable_max_requests
      assert_exception(RuntimeError) {
	@ControlPanel.max_requests = 'detarame'
      }
      @ControlPanel.max_requests = '0' # allowed
    end

    def test_queue_length
      assert_equal('16', @ControlPanel.queue_length)
      assert_equal('32', @ControlPanel.queue_length = '32')
      assert_equal('32', @ControlPanel.queue_length)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(32, @set_server_params_value['queue_length'])
    end

    def test_unavailable_queue_length
      assert_exception(RuntimeError) {
	@ControlPanel.queue_length = 'detarame'
      }
      assert_exception(RuntimeError) {
	@ControlPanel.queue_length = '0'
      }
    end

    def test_messengers
      assert_equal('8', @ControlPanel.messengers)
      assert_equal('16', @ControlPanel.messengers = '16')
      assert_equal('16', @ControlPanel.messengers)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(16, @set_server_params_value['messengers'])
    end

    def test_unavailable_messengers
      assert_exception(RuntimeError) {
	@ControlPanel.messengers = 'detarame'
      }
      assert_exception(RuntimeError) {
	@ControlPanel.messengers = '0'
      }
    end

    def test_messenger_threads
      assert_equal('4', @ControlPanel.messenger_threads)
      assert_equal('8', @ControlPanel.messenger_threads = '8')
      assert_equal('8', @ControlPanel.messenger_threads)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(8, @set_server_params_value['messenger_threads'])
    end

    def test_unavailable_messenger_threads
      assert_exception(RuntimeError) {
	@ControlPanel.messenger_threads = 'detarame'
      }
      assert_exception(RuntimeError) {
	@ControlPanel.messenger_threads = '0'
      }
    end

    def test_messenger_queue_length
      assert_equal('4', @ControlPanel.messenger_queue_length)
      assert_equal('8', @ControlPanel.messenger_queue_length = '8')
      assert_equal('8', @ControlPanel.messenger_queue_length)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(8, @set_server_params_value['messenger_queue_length'])
    end

    def test_subprocess_user
      assert_equal('nobody', @ControlPanel.subprocess_user)
      assert_equal('httpd', @ControlPanel.subprocess_user = 'httpd')
      assert_equal('httpd', @ControlPanel.subprocess_user)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal('httpd', @set_server_params_value['subprocess_user'])
    end

    def test_subprocess_group
      assert_equal('nobody', @ControlPanel.subprocess_group)
      assert_equal('httpd', @ControlPanel.subprocess_group = 'httpd')
      assert_equal('httpd', @ControlPanel.subprocess_group)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal('httpd', @set_server_params_value['subprocess_group'])
    end

    def test_subprocess_uid
      assert_equal('nobody', @ControlPanel.subprocess_user)
      assert_equal('80', @ControlPanel.subprocess_user = '80')
      assert_equal('80', @ControlPanel.subprocess_user)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(80, @set_server_params_value['subprocess_user'])
    end

    def test_subprocess_gid
      assert_equal('nobody', @ControlPanel.subprocess_group)
      assert_equal('80', @ControlPanel.subprocess_group = '80')
      assert_equal('80', @ControlPanel.subprocess_group)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(80, @set_server_params_value['subprocess_group'])
    end

    def test_modified_count
      assert_equal('0', @ControlPanel.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal('1', @ControlPanel.modified_count = '1')
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end
  end
end
