#!/usr/local/bin/ruby
# $Id: test_Administrator.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'wpm'

module TestRucy
  class TestAdministrator < RUNIT::TestCase
    def setup
      # for WPM::Driver class
      @driver_call = 0
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      # for Rucy::Control class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @admin_params = {
	'admin_user' => 'admin',
	'admin_password' => 'nazo',
	'localhost_only' => true,
	'japanese_handling' => false
      }
      @admin_params_call = 0
      @set_admin_params_call = 0

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/Administrator/Administrator.rb')
      @Administrator = loader.const_get('Administrator').new(self, :control => self)
      assert((@Administrator.is_a? WPM::PageContext))
      @Administrator.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def admin_params
      @admin_params_call += 1
      admin_params = @admin_params.dup
      def admin_params.setup(parent)
	@parent = parent
	self
      end
      def admin_params.modified_count
	@parent.modified_count
      end
      def admin_params.modified_count=(modified_count)
	@parent.modified_count = modified_count
      end
      admin_params.setup(self)
    end

    def set_admin_params(params)
      @set_admin_params_call += 1
      @admin_params = params
    end

    def test_modified_count
      assert_equal(1, @admin_params_call)
      assert_equal('0', @Administrator.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal('1', @Administrator.modified_count = '1')
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_username
      assert_equal(1, @admin_params_call)
      assert_equal('admin', @Administrator.username)
    end

    def test_password
      assert_equal(1, @admin_params_call)
      assert_equal('nazo', @Administrator.password)
    end

    def test_empty_password?
      assert_equal(1, @admin_params_call)
      assert(! @Administrator.empty_password?)
    end

    def test_edit_user
      @Administrator.edit_user
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AdminPassword', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_localhost_only
      assert_equal(1, @admin_params_call)
      assert_equal(true, @Administrator.localhost_only)
      @Administrator.localhost_only = false
      assert_equal(false, @Administrator.localhost_only)
      assert_equal(0, @set_admin_params_call)
      assert_equal(true, @admin_params['localhost_only'])

      @Administrator.commit
      assert_equal(1, @set_admin_params_call)
      assert_equal(false, @admin_params['localhost_only'])
    end

    def test_japanese_handling
      assert_equal(1, @admin_params_call)
      assert_equal(false, @Administrator.japanese_handling)
      @Administrator.japanese_handling = true
      assert_equal(true, @Administrator.japanese_handling)
      assert_equal(0, @set_admin_params_call)
      assert_equal(false, @admin_params['japanese_handling'])

      @Administrator.commit
      assert_equal(1, @set_admin_params_call)
      assert_equal(true, @admin_params['japanese_handling'])
    end
  end
end
