#!/usr/local/bin/ruby
# $Id: test_AddLogFile.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'wpm'

module TestRucy
  class TestAddLogFile < RUNIT::TestCase
    def setup
      # for WPM::Driver class
      @driver_call = 0
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      # for Rucy::Control class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @logging_params_call = 0
      @set_logging_params_call = 0
      @logging_params = {
	'logfiles' => [
	  { 'path' => 'server.log',
	    'log_emerg' => true,
	    'log_alert' => true,
	    'log_crit' => true,
	    'log_err' => true,
	    'log_warning' => true,
	    'log_notice' => true,
	    'log_info' => false,
	    'log_debug' => false
	  },
	  { 'path' => 'access.log',
	    'log_emerg' => false,
	    'log_alert' => false,
	    'log_crit' => false,
	    'log_err' => false,
	    'log_warning' => false,
	    'log_notice' => false,
	    'log_info' => true,
	    'log_debug' => false
	  }
	]
      }

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/AddLogFile/AddLogFile.rb')
      @AddLogFile = loader.const_get('AddLogFile').new(self, :control => self)
      assert((@AddLogFile.is_a? WPM::PageContext))
      @AddLogFile.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    def modified_count
      @modified_count_call += 1
      '0'
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def test_modified_count
      assert_equal('0', @Logging.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal('1', @Logging.modified_count = '1')
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def logging_params
      @logging_params_call += 1
      params = @logging_params.dup
      def params.setup(parent)
	@parent = parent
	self
      end
      def params.modified_count
	@parent.modified_count
      end
      def params.modified_count=(modified_count)
	@parent.modified_count = modified_count
      end
      params.setup(self)
    end

    def set_logging_params(params)
      @set_logging_params_call += 1
      @logging_params = params
      nil
    end

    def test_modified_count
      assert_equal('0', @AddLogFile.modified_count)
      assert_equal(1, @modified_count_call)
      assert_equal('1', @AddLogFile.modified_count = '1')
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_log_index
      assert_equal(3, @AddLogFile.log_index)
    end

    def test_logfile
      assert_equal(1, @logging_params_call)
      assert_nil(@AddLogFile.log_path)
      assert_equal(true, @AddLogFile.log_emerg)
      assert_equal(true, @AddLogFile.log_alert)
      assert_equal(true, @AddLogFile.log_crit)
      assert_equal(true, @AddLogFile.log_err)
      assert_equal(true, @AddLogFile.log_warning)
      assert_equal(true, @AddLogFile.log_notice)
      assert_equal(true, @AddLogFile.log_info)
      assert_equal(false, @AddLogFile.log_debug)

      @AddLogFile.log_path = 'debug.log'
      @AddLogFile.log_emerg = false
      @AddLogFile.log_alert = false
      @AddLogFile.log_crit = false
      @AddLogFile.log_err = false
      @AddLogFile.log_warning = false
      @AddLogFile.log_notice = false
      @AddLogFile.log_info = false
      @AddLogFile.log_debug = true
      assert_equal('debug.log', @AddLogFile.log_path)
      assert_equal(false, @AddLogFile.log_emerg)
      assert_equal(false, @AddLogFile.log_alert)
      assert_equal(false, @AddLogFile.log_crit)
      assert_equal(false, @AddLogFile.log_err)
      assert_equal(false, @AddLogFile.log_warning)
      assert_equal(false, @AddLogFile.log_notice)
      assert_equal(false, @AddLogFile.log_info)
      assert_equal(true, @AddLogFile.log_debug)

      @AddLogFile.write_logging_parameter
      assert_equal(1, @set_logging_params_call)
      assert_equal(3, @logging_params['logfiles'].length)
      assert_equal('server.log', @logging_params['logfiles'][0]['path'])
      assert_equal(true, @logging_params['logfiles'][0]['log_emerg'])
      assert_equal(true, @logging_params['logfiles'][0]['log_alert'])
      assert_equal(true, @logging_params['logfiles'][0]['log_crit'])
      assert_equal(true, @logging_params['logfiles'][0]['log_err'])
      assert_equal(true, @logging_params['logfiles'][0]['log_warning'])
      assert_equal(true, @logging_params['logfiles'][0]['log_notice'])
      assert_equal(false, @logging_params['logfiles'][0]['log_info'])
      assert_equal(false, @logging_params['logfiles'][0]['log_debug'])
      assert_equal('access.log', @logging_params['logfiles'][1]['path'])
      assert_equal(false, @logging_params['logfiles'][1]['log_emerg'])
      assert_equal(false, @logging_params['logfiles'][1]['log_alert'])
      assert_equal(false, @logging_params['logfiles'][1]['log_crit'])
      assert_equal(false, @logging_params['logfiles'][1]['log_err'])
      assert_equal(false, @logging_params['logfiles'][1]['log_warning'])
      assert_equal(false, @logging_params['logfiles'][1]['log_notice'])
      assert_equal(true, @logging_params['logfiles'][1]['log_info'])
      assert_equal(false, @logging_params['logfiles'][1]['log_debug'])
      assert_equal('debug.log', @logging_params['logfiles'][2]['path'])
      assert_equal(false, @logging_params['logfiles'][2]['log_emerg'])
      assert_equal(false, @logging_params['logfiles'][2]['log_alert'])
      assert_equal(false, @logging_params['logfiles'][2]['log_crit'])
      assert_equal(false, @logging_params['logfiles'][2]['log_err'])
      assert_equal(false, @logging_params['logfiles'][2]['log_warning'])
      assert_equal(false, @logging_params['logfiles'][2]['log_notice'])
      assert_equal(false, @logging_params['logfiles'][2]['log_info'])
      assert_equal(true, @logging_params['logfiles'][2]['log_debug'])
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('Logging', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_return_Logging
      @AddLogFile.return_Logging
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('Logging', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end
  end
end
