# $Id: sockutils.rb,v 1.2 2004/04/07 08:16:23 toki Exp $

require 'socket'

module TestRucy
  module SocketUtils
    def setsockopt(socket)
      socket.sync = true
      socket.setsockopt(Socket::IPPROTO_TCP, Socket::TCP_NODELAY, 1) if (socket.kind_of? TCPSocket)
      nil
    end
    module_function :setsockopt

    def unix_socketpair
      s1, s2 = UNIXSocket.socketpair
      setsockopt(s1)
      setsockopt(s2)
      return s1, s2
    end
    module_function :unix_socketpair

    def tcp_socketpair
      socket = TCPServer.open('localhost', 0)
      begin
	family, port, host, addr = socket.addr
	cli_sock = TCPSocket.open('localhost', port)
	svr_sock = socket.accept
	setsockopt(cli_sock)
	setsockopt(svr_sock)
	return cli_sock, svr_sock
      ensure
	socket.close if socket
      end
    end
    module_function :tcp_socketpair
  end
end
