#!/usr/local/bin/ruby
# $Id: rucy.rb,v 1.4 2004/04/22 08:41:32 toki Exp $

require 'getoptlong'

getoptlong = GetoptLong.new([ '--help', '-h', GetoptLong::NO_ARGUMENT ],
			    [ '--version', '-v', GetoptLong::NO_ARGUMENT ],
			    [ '--daemon', '-d', GetoptLong::NO_ARGUMENT ],
			    [ '--store-path', GetoptLong::REQUIRED_ARGUMENT ])

usage = <<EOF
usage: ruby #{File.basename($0)} [options]
options:
  --help, -h           show this message.
  --version, -v        show version.
  --daemon, -d         start as background daemon process.
  --store-path=[db]    change database path to store server parameters.
Start and see `http://localhost:8888/control' (default control panel).
EOF

show_help = false
show_version = false
$RUCY_DAEMON = false

base_dir = File.expand_path(File.dirname($0))
lib_core = File.join(base_dir, 'lib_core')
lib_doc = File.join(base_dir, 'lib_doc')
lib_ctrl = File.join(base_dir, 'lib_ctrl')
lib_wpm = File.join(base_dir, 'lib_wpm')
store_db = File.join(base_dir, 'control.db')
page_path = File.join(base_dir, 'control')

for opt_name, opt_arg in getoptlong
  case (opt_name)
  when '--help', '-h'
    show_help = true
  when '--version', '-v'
    show_version = true
  when '--daemon', '-d'
    $RUCY_DAEMON = true
  when '--store-path'
    store_db = opt_arg
  end
end

$:.push(lib_core)
$:.push(lib_doc)
$:.push(lib_ctrl)
$:.push(lib_wpm)

require 'rucy/version'

print Rucy::RUCY_TOKEN, "\n" if show_version
print usage if show_help
exit 1 if (show_help || show_version)

require 'rucy/loadlib'
require 'rucy/logger'
require 'rucy/server'
require 'rucy/document'
require 'rucy/control'
require 'rucy/properties'

server = Rucy::Server.new
server.open_hook{ |s|
  loader = Rucy::LibraryLoader.new
  loader.add_load_path(lib_doc)
  control = Rucy::Control.new
  control.lib_loader = loader
  control.doc_factory = Rucy::DOC_FACTORY
  control.properties = Rucy::Properties.new(store_db)
  control.page_path = page_path
  control.server_setup(s)
}
trap('USR1') { server.close }
if ($RUCY_DAEMON) then
  Rucy::Server.daemon
  trap('HUP') { server.restart }
end
server.accept
