# $Id: sample.rb,v 1.3 2004/04/11 00:24:06 toki Exp $

require 'rucy/error'
require 'rucy/document'

module Rucy
  class ParameterSampleDocument < Document
    def self.doc_name
      'ParameterSample'
    end

    def self.doc_args
      [ [ 'string',  :string, 'hi' ],
	[ 'password', :password, nil ],
	[ 'text',    :text,   '<html>Hello world.</html>' ],
	[ 'number',  :number, 0 ],
	[ 'regexp',  :regexp, /foo/ ],
	[ 'boolean', :bool,   true ],
	[ 'select',  :select, %w[ foo bar baz ] ],
	[ 'radio',   :radio,  %w[ foo bar baz ] ],
	[ 'checkset', :checkset,
	  [ [ 'foo', true  ],
	    [ 'bar', false ],
	    [ 'baz', false ]
	  ]
	]
      ]
    end

    def initialize(string, password, text, number, regexp, bool, select, radio, checkset)
      @string = string
      @password = password
      @text = text
      @number = number
      @regexp = regexp
      @bool = bool
      @select = select
      @radio = radio
      @checkset = checkset
    end

    def publish(script_name, request, response, logger)
      logger.debug("[#{Time.now.httpdate}] enter document: #{self.class}")
      case (request.method)
      when 'GET', 'HEAD'
	response.status = 200	# OK
	response.set_header('Content-Type', 'text/html')
	response.start_body
	if (request.method != 'HEAD') then
	  response << "<html>\n"
	  response << "<head><title>Document Parameter Sample</title></head>\n"
	  response << "<body>\n"
	  response << "<h1>Document Parameter Sample</h1>\n"
	  response << "<h2>1. string</h2>\n"
	  response << "<pre>#{escapeHTML(@string)}</pre>\n"
	  response << "<h2>2. password</h2>\n"
	  response << "<pre>#{escapeHTML(@password.inspect)}</pre>\n"
	  response << "<h2>3. text</h2>\n"
	  response << "<pre>#{escapeHTML(@text)}</pre>\n"
	  response << "<h2>4. number</h2>\n"
	  response << "<pre>#{escapeHTML(@number.to_s)}</pre>\n"
	  response << "<h2>5. regexp</h2>\n"
	  response << "<pre>#{escapeHTML(@regexp.inspect)}</pre>\n"
	  response << "<h2>6. boolean</h2>\n"
	  response << "<pre>#{escapeHTML(@bool.to_s)}</pre>\n"
	  response << "<h2>7. select</h2>\n"
	  response << "<pre>#{escapeHTML(@select)}</pre>\n"
	  response << "<h2>8. radio</h2>\n"
	  response << "<pre>#{escapeHTML(@radio)}</pre>\n"
	  response << "<h2>9. checkset</h2>\n"
	  response << "<pre>#{escapeHTML(@checkset.inspect)}</pre>\n"
	  response << "</body>\n"
	  response << "</html>\n"
	end
      else
	http_error = HTTPError.new(405) # Method Not Allowed
	http_error.set_header('Allow', 'GET, HEAD')
	raise http_error
      end
      nil
    end
  end
  DOC_FACTORY.add_document(ParameterSampleDocument)

  class ParameterSampleFilter < Filter
    def self.filter_name
      'ParameterSample'
    end

    def self.filter_args
      [ [ 'string',  :string, 'hi' ],
	[ 'password', :password, nil ],
	[ 'text',    :text,   '<html>Hello world.</html>' ],
	[ 'number',  :number, 0 ],
	[ 'regexp',  :regexp, /foo/ ],
	[ 'boolean', :bool,   true ],
	[ 'select',  :select, %w[ foo bar baz ] ],
	[ 'radio',   :radio,  %w[ foo bar baz ] ],
	[ 'checkset', :checkset,
	  [ [ 'foo', true  ],
	    [ 'bar', false ],
	    [ 'baz', false ]
	  ]
	],
      ]
    end

    def initialize(string, password, text, number, regexp, bool, select, radio, checkset)
      # nothing to do.
    end

    def filter_open(context, script_name, request, response, logger)
      logger.debug("[#{Time.now.httpdate}] filter open: #{self.class}")
      super
    end

    def filter_head(context, script_name, request, response, logger)
      logger.debug("[#{Time.now.httpdate}] filter head: #{self.class}")
      super
    end

    def filter_body(context, script_name, request, response, logger, messg_body)
      logger.debug("[#{Time.now.httpdate}] filter body: #{self.class}")
      super
    end

    def filter_close(context, script_name, request, response, logger)
      logger.debug("[#{Time.now.httpdate}] filter close: #{self.class}")
      super
    end
  end
  DOC_FACTORY.add_filter(ParameterSampleFilter)
end
