# $Id: erb.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

require 'erb'
require 'singleton'
require 'rucy/document'

module Rucy
  class ERBFilter < Filter
    def initialize(safe_level=1, pass_auth=false)
      @safe_level = safe_level
      @pass_auth = pass_auth
    end

    def make_binding(__request__, __response__, __logger__, __env__)
      __module__ = Module.new
      __module__.const_set(:RQUEST,     __request__)
      __module__.const_set(:RESPNSE,    __response__)
      __module__.const_set(:LOGGER,     __logger__)
      __module__.const_set(:ENV,        __env__)

      class << __module__
	def include(mod)
	  extend(mod)
	  super(mod)
	end
	private :include
      end

      __module__.module_eval %q{ binding }
    end
    private :make_binding

    def filter_open(context, script_name, request, response, logger)
      request.delete_header('If-Match')
      request.delete_header('If-None-Match')
      request.delete_header('If-Modified-Since')
      request.delete_header('If-Unmodified-Since')
      request.delete_header('If-Range')
      nil
    end

    def filter_head(context, script_name, request, response, logger)
      if (response.status == 200) then
	context[:erb_enabled] = true
	context[:erb_src] = ''
      else
	context[:erb_enabled] = false
	context[:erb_src] = nil
	response.start_body
      end
      nil
    end

    def filter_body(context, script_name, request, response, logger, messg_body)
      if (context[:erb_enabled]) then
	context[:erb_src] << messg_body
      else
	response.write(messg_body)
      end
      nil
    end

    def filter_close(context, script_name, request, response, logger)
      if (context[:erb_enabled]) then
	context[:erb_src].untaint
	erb = ERB.new(context[:erb_src], @safe_level)
	erb_script_name = response.doc_path || script_name
	env = request.cgi_env(erb_script_name, @pass_auth)
	env['SCRIPT_FILENAME'] = response.local_path if response.local_path
	binding = make_binding(request, response, logger, env)
	erb_result = erb.result(binding)
	response.set_header('Content-Length', erb_result.length.to_s)
	response.start_body
	response.write(erb_result)
      end
      nil
    end
  end

  class ERBFilterFactory
    include Singleton

    def filter_name
      'ERB'
    end

    def filter_args
      [ [ 'safe level', :select, %w[ 1 2 3 4 0 ] ],
	[ 'pass auth', :bool, false ]
      ]
    end

    def new(safe_level, pass_auth)
      case (safe_level)
      when '1', '2', '3', '4', '0'
	s = safe_level.to_i
      else
	raise "unknown safe level: #{safe_level.inspect}"
      end
      ERBFilter.new(s, pass_auth)
    end
  end
  DOC_FACTORY.add_filter(ERBFilterFactory.instance)
end
