# $Id: auth.rb,v 1.3 2004/04/06 22:11:32 toki Exp $

require 'singleton'
require 'digest/md5'
require 'rucy/error'
require 'rucy/passwd'
require 'rucy/document'

module Rucy
  class BasicAuth < Filter
    def initialize(passwd, realm)
      @passwd = passwd
      @realm = '"' + realm.gsub(/[\\"]/) { |special| "\\" + special } + '"'
    end

    def filter_open(context, script_name, request, response, logger)
      if (credentials = request.header('Authorization')) then
	if (credentials =~ /^Basic\s+/) then
	  base64_user_pass = $'
	  user_pass = base64_user_pass.unpack('m').first
	  userid, password = user_pass.split(/:/, 2)
	  if (@passwd.verify(userid, password)) then
	    return
	  end
	end
      end
      ex = HTTPError.new(401)
      ex.set_header('WWW-Authenticate', "Basic realm=#{@realm}")
      raise ex
    end
  end

  class BasicAuthFactory
    include Singleton

    NARGS = 5

    def initialize
      @pw_enc = PasswordEncryptor.new
    end

    def set_filter_option(name, value)
      case (name)
      when :pw_enc
	@pw_enc = value
      else
	raise "unknown option: #{name.inspect}"
      end
      nil
    end

    def filter_name
      'BasicAuth'
    end

    def filter_args
      args = [ [ 'realm', :string, nil ] ]
      for i in 1..NARGS
	args.push([ "user #{i}", :string, nil ])
	args.push([ "password #{i}", :password, nil ])
      end
      args
    end

    def new(realm, *args)
      passwd = PasswordVerifier.new(@pw_enc)
      NARGS.times do
	username = args.shift
	password = args.shift
	if (username && ! username.strip.empty?) then
	  passwd.add_encrypted_user(username, password)
	end
      end
      BasicAuth.new(passwd, realm)
    end
  end
  DOC_FACTORY.add_filter(BasicAuthFactory.instance)
end
