# $Id: writer.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

require 'time'

module Rucy
  class HTTPWriter
    BUFFERING_THRESHOLD = 1024 * 32

    def initialize(socket, logger, request)
      @socket = socket
      @logger = logger
      @request = request
      @response = nil
      @buffer = ''
      @writing = false
      @send_size = 0
      @content_length = nil
    end

    def writing?
      @writing
    end

    def set_content_length
      if (content_length = @response.header('Content-Length')) then
	@content_length = content_length.to_i
      end

      nil
    end
    private :set_content_length

    def make_head
      if (@response.version != 'HTTP/0.9') then
	messg_head = "#{@response.version} #{@response.status} #{@response.reason}\r\n"
	@response.each_header do |name, value|
	  messg_head << "#{name}: #{value}\r\n"
	end
	messg_head << "\r\n"
	return messg_head
      end

      nil
    end
    private :make_head

    def buffering(messg)
      if (@buffer.length + messg.length < BUFFERING_THRESHOLD) then
	@buffer << messg
      else
	@writing = true
	@socket.write(@buffer)
	if (messg.length < BUFFERING_THRESHOLD) then
	  @buffer = messg.dup
	else
	  @socket.write(messg)
	  @buffer = ''
	end
      end

      nil
    end
    private :buffering

    def commit_log
      log_messg = "#{@request.client_name}"
      log_messg << " -"		# identity
      log_messg << " -"		# authenticated username
      log_messg << " [#{Time.now.httpdate}]"
      log_messg << " #{@request.line}"
      log_messg << " #{@response.status}"
      if (@send_size > 0) then
	log_messg << " #{@send_size}"
      else
	log_messg << " -"
      end
      if (@request.has_header? 'Referer') then
	log_messg << " \"#{@request.header('Referer')}\""
      else
	log_messg << " -"
      end
      if (@request.has_header? 'User-Agenet') then
	log_messg << " \"#{@request.header('User-Agent')}\""
      else
	log_messg << " -"
      end
      @logger.info(log_messg)

      case (@request.method)
      when 'HEAD'
	if (@send_size != 0) then
	  @logger.warning("[#{Time.now.httpdate}] none zero respnose body length: #{@request.line}")
	  raise "none zero message body length: #{@request.line}"
	end
      else
	if (@content_length) then
	  if (@send_size != @content_length) then
	    @logger.warning("[#{Time.now.httpdate}] mismatch response body length: #{@request.line}")
	    raise "mismatch respnose body length: #{@request.line}"
	  end
	end
      end

      nil
    end
    private :commit_log
  end

  class HTTPThroughWriter < HTTPWriter
    def write_head(response)
      @response = response
      set_content_length
      buffering(make_head)
      nil
    end

    def write(messg)
      @send_size += messg.length
      buffering(messg)
      nil
    end

    def close
      unless (@buffer.empty?) then
	@socket.write(@buffer)
      end
      @socket.flush
      commit_log

      nil
    end
  end

  class HTTPSpoolWriter < HTTPWriter
    def write_head(response)
      @response = response
      @spooling = true
      set_content_length
      nil
    end

    def write(messg)
      @send_size += messg.length
      if (@spooling) then
	if (@buffer.length + messg.length < BUFFERING_THRESHOLD) then
	  @buffer << messg
	else
	  @spooling = false
	  if (! @request.conn_closed? && ! @response.conn_closed? && (@response.has_header? 'Content-Length')) then
	    @response.conn_keep_alive(@request.version)
	  else
	    @response.conn_close
	  end
	  @socket.write(make_head)
	  buffering(messg)
	end
      else
	buffering(messg)
      end

      nil
    end

    def close
      if (@spooling) then
	@response.set_header('Content-Length', @buffer.length.to_s)
	if (! @request.conn_closed? && ! @response.conn_closed?) then
	  @response.conn_keep_alive(@request.version)
	end
	messg_head = make_head
	if (messg_head.length + @buffer.length < BUFFERING_THRESHOLD) then
	  @socket.write(messg_head + @buffer)
	else
	  @socket.write(make_head)
	  @socket.write(@buffer)
	end
	@socket.flush
      else
	unless (@buffer.empty?) then
	  @socket.write(@buffer)
	end
	@socket.flush
      end
      commit_log

      nil
    end
  end
end
