# $Id: wait.rb,v 1.3 2004/04/27 06:33:13 toki Exp $

module Rucy
  module Wait
    def wait_by_io(input, timeout)
      input.wait(timeout)
    end
    module_function :wait_by_io

    def wait_by_timeout(input, timeout)
      begin
	Timeout.timeout(timeout) {
	  begin
	    ch = input.getc
	  ensure
	    input.ungetc(ch) if ch
	  end
	}
	return input
      rescue Timeout::Error
	return nil
      end
    end
    module_function :wait_by_timeout
  end
end

begin
  require 'io/wait'

  module Rucy
    module Wait
      def wait(input, timeout)
	wait_by_io(input, timeout)
      end
      module_function :wait
    end
  end
rescue LoadError
  require 'timeout'

  module Rucy
    module Wait
      def wait(input, timeout)
	wait_by_timeout(input, timeout)
      end
      module_function :wait
    end
  end
end
