# $Id: passwd.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

require 'digest/md5'

module Rucy
  class PasswordEncryptor
    SALT_LEN = 12

    def salt
      src = Array.new
      SALT_LEN.times do
	src << rand(64)
      end
      src.pack("C*").tr("\x00-\x3f","A-Za-z0-9./")
    end

    def crypt(password, salt=self.salt)
      if (salt.length < SALT_LEN) then
	raise 'mismatch salt length.'
      end
      salt = salt[0, SALT_LEN]
      salt + Digest::MD5.hexdigest(salt + password)
    end
  end

  class PasswordVerifier
    def initialize(pw_enc=PasswordEncryptor.new)
      @pw_enc = pw_enc
      @pw_db = Hash.new
    end

    def add_user(user, password)
      if (! user || user.strip.empty?) then
	raise 'not allowed empty user.'
      end
      if (! password || password.empty?) then
	raise 'not allowd empty password.'
      end
      @pw_db[user] = @pw_enc.crypt(password)
      nil
    end

    def add_encrypted_user(user, encrypted_password)
      if (! user || user.strip.empty?) then
	raise 'not allowd empty user'
      end
      if (! encrypted_password || encrypted_password.empty?) then
	raise 'not allowd empty password.'
      end
      @pw_db[user] = encrypted_password
      nil
    end

    def verify(user, password)
      if (@pw_db.include? user) then
	return @pw_db[user] == @pw_enc.crypt(password, @pw_db[user])
      else
	return nil
      end
    end
  end
end
