# $Id: logger.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

require 'thread'

module Rucy
  class Logger
    def initialize(output)
      @output = output
      @log_emerg = true
      @log_alert = true
      @log_crit = true
      @log_err = true
      @log_warning = true
      @log_notice = true
      @log_info = true
      @log_debug = false
    end

    attr_accessor :log_emerg
    attr_accessor :log_alert
    attr_accessor :log_crit
    attr_accessor :log_err
    attr_accessor :log_warning
    attr_accessor :log_notice
    attr_accessor :log_info
    attr_accessor :log_debug

    def emerg(messg)
      @output.write("#{messg}\n") if @log_emerg
      @output.flush
      nil
    end

    def alert(messg)
      @output.write("#{messg}\n") if @log_alert
      @output.flush
      nil
    end

    def crit(messg)
      @output.write("#{messg}\n") if @log_crit
      @output.flush
      nil
    end

    def err(messg)
      @output.write("#{messg}\n") if @log_err
      @output.flush
      nil
    end

    def warning(messg)
      @output.write("#{messg}\n") if @log_warning
      @output.flush
      nil
    end

    def notice(messg)
      @output.write("#{messg}\n") if @log_notice
      @output.flush
      nil
    end

    def info(messg)
      @output.write("#{messg}\n") if @log_info
      @output.flush
      nil
    end

    def debug(messg)
      @output.write("#{messg}\n") if @log_debug
      @output.flush
      nil
    end
  end

  class MultiLogger
    def initialize
      @logger_list = Array.new
    end

    def add(logger)
      @logger_list.push(logger)
      nil
    end

    def emerg(messg)
      for logger in @logger_list
	logger.emerg(messg)
      end
      nil
    end

    def alert(messg)
      for logger in @logger_list
	logger.alert(messg)
      end
      nil
    end

    def crit(messg)
      for logger in @logger_list
	logger.crit(messg)
      end
      nil
    end

    def err(messg)
      for logger in @logger_list
	logger.err(messg)
      end
      nil
    end

    def warning(messg)
      for logger in @logger_list
	logger.warning(messg)
      end
      nil
    end

    def notice(messg)
      for logger in @logger_list
	logger.notice(messg)
      end
      nil
    end

    def info(messg)
      for logger in @logger_list
	logger.info(messg)
      end
      nil
    end

    def debug(messg)
      for logger in @logger_list
	logger.debug(messg)
      end
      nil
    end
  end

  class SyncLogger
    def initialize(logger)
      @lock = Mutex.new
      @logger = logger
    end

    def emerg(messg)
      @lock.synchronize{
	@logger.emerg(messg)
      }
      nil
    end

    def alert(messg)
      @lock.synchronize{
	@logger.alert(messg)
      }
      nil
    end

    def crit(messg)
      @lock.synchronize{
	@logger.crit(messg)
      }
      nil
    end

    def err(messg)
      @lock.synchronize{
	@logger.err(messg)
      }
      nil
    end

    def warning(messg)
      @lock.synchronize{
	@logger.warning(messg)
      }
      nil
    end

    def notice(messg)
      @lock.synchronize{
	@logger.notice(messg)
      }
      nil
    end

    def info(messg)
      @lock.synchronize{
	@logger.info(messg)
      }
      nil
    end

    def debug(messg)
      @lock.synchronize{
	@logger.debug(messg)
      }
      nil
    end
  end
end
