# $Id: loadlib.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

require 'find'

module Rucy
  module LoadLib
    LOAD_ERROR = Array.new

    def load_lib(path)
      unless (File.directory? path) then
	raise "not a directory: #{path.inspect}"
      end
      unless ($:.include? path) then
	$:.push(path)
      end
      Find.find(path) do |lib|
	if (lib =~ /\.rb$/ && (File.file? lib)) then
	  name = lib[(path.length + 1)..-1]
	  begin
	    require(name)
	  rescue StandardError, ScriptError
	    LOAD_ERROR.push([ name, $! ])
	  end
	end
      end
      nil
    end
    module_function :load_lib

    def load_errors
      LOAD_ERROR
    end
    module_function :load_errors
  end

  class LibraryLoader
    def initialize(loader=LoadLib)
      @loader = loader
      @load_path_list = Array.new
    end

    def add_load_path(new_path)
      @load_path_list.push(new_path)
      nil
    end

    def load_lib
      for path in @load_path_list
	@loader.load_lib(path)
      end
      nil
    end

    def load_errors
      @loader.load_errors
    end
  end
end
