# $Id: Logging.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

class Logging < WPM::PageContext
  def init_context
    @control = page_option(:control)
    @logging_params = @control.logging_params
    @log_index = nil
    @log_path_call_index = nil
    @log_emerg_call_index = nil
    @log_alert_call_index = nil
    @log_crit_call_index = nil
    @log_err_call_index = nil
    @log_warning_call_index = nil
    @log_notice_call_index = nil
    @log_info_call_index = nil
    @log_debug_call_index = nil
    @log_delete_call_index = nil
  end

  def modified_count
    @logging_params.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) {|n| n >= 0 }
    @logging_params.modified_count = modified_count.to_i
    modified_count
  end

  def stdout_emerg
    @logging_params['stdout_emerg']
  end

  def stdout_emerg=(flag)
    @logging_params['stdout_emerg'] = flag
  end

  def stdout_alert
    @logging_params['stdout_alert']
  end

  def stdout_alert=(flag)
    @logging_params['stdout_alert'] = flag
  end

  def stdout_crit
    @logging_params['stdout_crit']
  end

  def stdout_crit=(flag)
    @logging_params['stdout_crit'] = flag
  end

  def stdout_err
    @logging_params['stdout_err']
  end

  def stdout_err=(flag)
    @logging_params['stdout_err'] = flag
  end

  def stdout_warning
    @logging_params['stdout_warning']
  end

  def stdout_warning=(flag)
    @logging_params['stdout_warning'] = (flag)
  end

  def stdout_notice
    @logging_params['stdout_notice']
  end

  def stdout_notice=(flag)
    @logging_params['stdout_notice'] = flag
  end

  def stdout_info
    @logging_params['stdout_info']
  end

  def stdout_info=(flag)
    @logging_params['stdout_info'] = flag
  end

  def stdout_debug
    @logging_params['stdout_debug']
  end

  def stdout_debug=(flag)
    @logging_params['stdout_debug'] = flag
  end

  def has_logfiles?
    ! @logging_params['logfiles'].empty?
  end

  def logfile_count
    @logging_params['logfiles'].length
  end

  attr_accessor :log_index
  attr_writer :log_path_call_index

  def log_path
    @logging_params['logfiles'][@log_path_call_index]['path']
  end

  def log_path=(log_path)
    @logging_params['logfiles'][@log_path_call_index]['path'] = log_path
  end

  attr_writer :log_emerg_call_index

  def log_emerg
    @logging_params['logfiles'][@log_emerg_call_index]['log_emerg']
  end

  def log_emerg=(boolean)
    @logging_params['logfiles'][@log_emerg_call_index]['log_emerg'] = boolean
  end

  attr_writer :log_alert_call_index

  def log_alert
    @logging_params['logfiles'][@log_alert_call_index]['log_alert']
  end

  def log_alert=(boolean)
    @logging_params['logfiles'][@log_alert_call_index]['log_alert'] = boolean
  end

  attr_writer :log_crit_call_index

  def log_crit
    @logging_params['logfiles'][@log_crit_call_index]['log_crit']
  end

  def log_crit=(boolean)
    @logging_params['logfiles'][@log_crit_call_index]['log_crit'] = boolean
  end

  attr_writer :log_err_call_index

  def log_err
    @logging_params['logfiles'][@log_err_call_index]['log_err']
  end

  def log_err=(boolean)
    @logging_params['logfiles'][@log_err_call_index]['log_err'] = boolean
  end

  attr_writer :log_warning_call_index

  def log_warning
    @logging_params['logfiles'][@log_warning_call_index]['log_warning']
  end

  def log_warning=(boolean)
    @logging_params['logfiles'][@log_warning_call_index]['log_warning'] = boolean
  end

  attr_writer :log_notice_call_index

  def log_notice
    @logging_params['logfiles'][@log_notice_call_index]['log_notice']
  end

  def log_notice=(boolean)
    @logging_params['logfiles'][@log_notice_call_index]['log_notice'] = boolean
  end

  attr_writer :log_info_call_index

  def log_info
    @logging_params['logfiles'][@log_info_call_index]['log_info']
  end

  def log_info=(boolean)
    @logging_params['logfiles'][@log_info_call_index]['log_info'] = boolean
  end

  attr_writer :log_debug_call_index

  def log_debug
    @logging_params['logfiles'][@log_debug_call_index]['log_debug']
  end

  def log_debug=(boolean)
    @logging_params['logfiles'][@log_debug_call_index]['log_debug'] = boolean
  end

  attr_writer :log_delete_call_index

  def log_delete
    @logging_params['logfiles'].delete_at(@log_delete_call_index)
    write_logging_parameter
    nil
  end

  def write_logging_parameter
    for logfile in @logging_params['logfiles']
      check_not_empty(logfile['path'])
    end
    @control.set_logging_params(@logging_params)
    nil
  end
end
