# $Id: DocumentTable.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

class DocumentTable < WPM::PageContext
  include WPM::Escape
  include WPM::CheckUtil

  def init_context
    @driver = driver
    @control = page_option(:control)
    @factory = page_option(:factory)
    @src = nil
    @document_list = nil
    @doc_opt_list = nil
    @document = nil
    @doc_index = nil
    @show_args_toggle = nil
    @show_args_call_index = nil
    @show_args_value_call_index = nil
    @argument = nil
    @arg_index = nil
    @new_document_type_selected = nil
    @modify_document_type_selected = Array.new
    @modify_document_type_call_index = nil
    @doc_edit_call_index = nil
    @doc_up_call_index = nil
    @doc_down_call_index = nil
    @doc_delete_call_index = nil
    @add_filter_type_selected = Array.new
    @add_filter_type_call_index = nil
    @add_filter_call_index = nil
  end

  def table_source=(src)
    @src = src
    @document_list = @src.document_list
    @doc_opt_list = Array.new
    @document_list.length.times do
      @doc_opt_list.push({ 'show_args' => false })
    end
    src
  end

  def modified_count
    @src.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) {|n| n >= 0 }
    @src.modified_count = modified_count.to_i
    modified_count
  end

  def has_documents?
    ! @document_list.empty?
  end

  def document_list
    doc_list = Array.new
    @document_list.each_with_index do |doc_info, i|
      doc_info2 = Hash.new
      doc_info2.update(doc_info)
      doc_info2.update(@doc_opt_list[i])
      doc_list.push(doc_info2)
    end
    doc_list
  end

  def doc_label
    @src.doc_label
  end

  def path_label
    @src.path_label
  end

  def mask_label
    @src.mask_label
  end

  attr_writer :document
  attr_accessor :doc_index

  def doc_name
    @document[@src.doc_tag]
  end

  def doc_path
    @document[@src.path_tag]
  end

  def doc_mask
    @document[@src.mask_tag]
  end

  def virtual_host
    @document['virtual_host']
  end

  def comment
    @document['comment']
  end

  def has_comment?
    ! (empty_string? @document['comment'])
  end

  def show_args?
    @document['show_args']
  end

  def show_args_toggle
    i = @show_args_call_index
    @doc_opt_list[i]['show_args'] = ! @doc_opt_list[i]['show_args']
    nil
  end

  def show_args_label
    i = @show_args_call_index
    @doc_opt_list[i]['show_args'] ? 'Hide arguments' : 'Show arguments'
  end

  attr_writer :show_args_call_index

  def show_args_count
    @doc_opt_list.length
  end

  def show_args_value
    i = @show_args_value_call_index
    @doc_opt_list[i]['show_args'] ? 'true' : 'false'
  end

  def show_args_value=(show_args_value)
    i = @show_args_value_call_index
    case (show_args_value)
    when 'true'
      @doc_opt_list[i]['show_args'] = true
    when 'false'
      @doc_opt_list[i]['show_args'] = false
    else
      raise "unknown: #{show_args_value.inspect}"
    end
    show_args_value
  end

  attr_writer :show_args_value_call_index

  def has_args?
    ! @document['arguments'].empty?
  end

  def doc_arg_alist
    arg_alist = Array.new
    doc_args = @src.doc_args(doc_name)
    @document['arguments'].each_with_index do |arg, i|
      arg_alist.push([ doc_args[i][0], arg ])
    end
    arg_alist
  end

  attr_writer :argument
  attr_accessor :arg_index

  def arg_name
    @argument[0]
  end

  def arg_value
    @argument[1]
  end

  def document_type_list
    @src.doc_names
  end

  attr_accessor :new_document_type_selected

  def modify_document_type_selected
    i = @modify_document_type_call_index
    @modify_document_type_selected[i] || @document_list[i][@src.doc_tag]
  end

  def modify_document_type_selected=(document_type)
    i = @modify_document_type_call_index
    @modify_document_type_selected[i] = document_type
  end

  attr_writer :modify_document_type_call_index

  def doc_add
    @src.setup_document(@new_document_type_selected, @document_list.length)
    nil
  end

  def doc_edit
    doc_pos = @doc_edit_call_index
    doc_type = @modify_document_type_selected[doc_pos]
    @src.setup_document(doc_type, doc_pos)
    nil
  end

  attr_writer :doc_edit_call_index

  def doc_up
    unless (doc_up_disabled?) then
      i = @doc_up_call_index
      j = @doc_up_call_index - 1
      @document_list[i], @document_list[j] = @document_list[j], @document_list[i]
      @doc_opt_list[i], @doc_opt_list[j] = @doc_opt_list[j], @doc_opt_list[i]
      @src.write_document_list
    end
    nil
  end

  def doc_up_disabled?
    @doc_up_call_index == 0
  end

  attr_writer :doc_up_call_index

  def doc_down
    unless (doc_down_disabled?) then
      i = @doc_down_call_index
      j = @doc_down_call_index + 1
      @document_list[i], @document_list[j] = @document_list[j], @document_list[i]
      @doc_opt_list[i], @doc_opt_list[j] = @doc_opt_list[j], @doc_opt_list[i]
      @src.write_document_list
    end
    nil
  end

  def doc_down_disabled?
    @doc_down_call_index == @document_list.length - 1
  end

  attr_accessor :doc_down_call_index

  def doc_delete
    @document_list.delete_at(@doc_delete_call_index)
    @doc_opt_list.delete_at(@doc_delete_call_index)
    @src.write_document_list
    nil
  end

  attr_writer :doc_delete_call_index

  def filter_type_list
    @factory.filter_names
  end

  def add_filter_type_selected
    i = @add_filter_type_call_index
    @add_filter_type_selected[i]
  end

  def add_filter_type_selected=(filter_type)
    i = @add_filter_type_call_index
    @add_filter_type_selected[i] = filter_type
  end

  attr_writer :add_filter_type_call_index

  def add_filter
    i = @add_filter_call_index
    query_params = Hash.new
    query_params['filter'] = @add_filter_type_selected[i]
    query_params['pos'] = @control.filters.length.to_s

    path = @document_list[i][@src.path_tag]
    mask = @document_list[i][@src.mask_tag]
    vhost = @document_list[i]['virtual_host']
    if (path) then
      query_params['path'] = path
    end
    case (mask)
    when NilClass
      query_params['mask'] = 'nil'
    when Regexp
      re_src = mask.source.dup
      re_src.sub!(%r"\(", '')
      re_src.sub!(%r"\)\(\\?/\|\$\)", '')
      query_params['mask'] = 'regexp:' + re_src
    when ::String
      query_params['mask'] = 'string:' + mask
    else
      raise "unknown mask type: #{mask.inspect} (mask.class)"
    end
    if (vhost) then
      query_params['vhost'] = vhost
    end

    @driver.redirect('SetupFilter', query_params)
    nil
  end

  attr_writer :add_filter_call_index
end
