# $Id: ControlPanel.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

class ControlPanel < WPM::PageContext
  def init_context
    @control = page_option(:control)
    @server_params = @control.server_params
  end

  def server_type
    @server_params['server_type']
  end

  def server_type=(server_type)
    case (server_type)
    when 'multithread', 'multiprocess'
      @server_params['server_type'] = server_type
    else
      raise "unknown server type: #{server_type.inspect}"
    end
    server_type
  end

  def port
    @server_params['port'].to_s
  end

  def port=(port)
    check_number(port) {|n| n >= 0 }
    @server_params['port'] = port.to_i
    port
  end

  def timeout
    @server_params['timeout'].to_s
  end

  def timeout=(timeout)
    check_number(timeout) {|n| n > 0 }
    @server_params['timeout'] = timeout.to_i
    timeout
  end

  def keep_alive
    @server_params['keep_alive'].to_s
  end

  def keep_alive=(keep_alive)
    check_number(keep_alive) {|n| n >= 0 }
    @server_params['keep_alive'] = keep_alive.to_i
    keep_alive
  end

  def max_requests
    @server_params['max_requests'].to_s
  end

  def max_requests=(max_requests)
    check_number(max_requests) {|n| n >= 0 }
    @server_params['max_requests'] = max_requests.to_i
    max_requests
  end

  def queue_length
    @server_params['queue_length'].to_s
  end

  def queue_length=(queue_length)
    check_number(queue_length) {|n| n > 0 }
    @server_params['queue_length'] = queue_length.to_i
    queue_length
  end

  def messengers
    @server_params['messengers'].to_s
  end

  def messengers=(messengers)
    check_number(messengers) {|n| n > 0 }
    @server_params['messengers'] = messengers.to_i
    messengers
  end

  def messenger_threads
    @server_params['messenger_threads'].to_s
  end

  def messenger_threads=(messenger_threads)
    check_number(messenger_threads) {|n| n > 0 }
    @server_params['messenger_threads'] = messenger_threads.to_i
    messenger_threads
  end

  def messenger_queue_length
    @server_params['messenger_queue_length'].to_s
  end

  def messenger_queue_length=(messenger_queue_length)
    check_number(messenger_queue_length) {|n| n > 0 }
    @server_params['messenger_queue_length'] = messenger_queue_length.to_i
    messenger_queue_length
  end

  def subprocess_user
    @server_params['subprocess_user'].to_s
  end

  def subprocess_user=(subprocess_user)
    check_not_empty(subprocess_user, true)
    user = subprocess_user.strip
    @server_params['subprocess_user'] = (user =~ /^\d+$/) ? user.to_i : user
    subprocess_user
  end

  def subprocess_group
    @server_params['subprocess_group'].to_s
  end

  def subprocess_group=(subprocess_group)
    check_not_empty(subprocess_group, true)
    group = subprocess_group.strip
    @server_params['subprocess_group'] = (group =~ /^\d+$/) ? group.to_i : group
    subprocess_group
  end

  def write_server_params
    @control.set_server_params(@server_params)
    nil
  end

  def modified_count
    @server_params.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) {|n| n >= 0 }
    @server_params.modified_count = modified_count.to_i
    modified_count
  end
end
